# -*- coding:utf-8 -*-

import utils.common.log as logger
from utils.common.ssh_util2 import Ssh


class API(object):
    SSH_UTIL = Ssh()

    @classmethod
    def get_ssh_client(cls, ssh_client_info, port=22, timeout=20, pub_key=None, status=True):
        return cls.SSH_UTIL.ssh_create_client(
            ssh_client_info.host_ip, ssh_client_info.ssh_user, ssh_client_info.ssh_pwd, port, timeout, pub_key, status)

    @classmethod
    def get_sudo_ssh_client(cls, auth_provider, port=22, timeout=20, pub_key=None, status=True):
        ssh_client = cls.SSH_UTIL.ssh_create_client(auth_provider.host, auth_provider.ssh_user, auth_provider.ssh_pwd,
                                                    port, timeout, pub_key,
                                                    status)
        cls.SSH_UTIL.ssh_send_command(ssh_client, f"su - {auth_provider.sudo_user}", "Password", timeout)
        cls.SSH_UTIL.ssh_send_command(ssh_client, auth_provider.sudo_pwd, "#", timeout)
        cls.SSH_UTIL.ssh_send_command(ssh_client, "TMOUT=0", "#", timeout)
        return ssh_client

    @classmethod
    def send_command(cls, ssh_client, cmd, expect="#", timeout=60):
        """仅限执行交互式命令的场景使用, 非普通用户使用"""
        return cls.SSH_UTIL.ssh_send_command(ssh_client, cmd, expect, timeout)

    @classmethod
    def execute_command(cls, ssh_client, cmd, timeout=60):
        """执行非交互式命令，返回stdout, stderr, 普通用户使用"""
        return cls.SSH_UTIL.execute_command(ssh_client, cmd, timeout)

    @classmethod
    def exec_command_return_list(cls, ssh_client, cmd, timeout=1, retry_times=0):
        """执行非交互式命令，返回stdout和stderr的结合体，按返回顺序切分成list，注意：timeout：单位分钟"""
        return cls.SSH_UTIL.ssh_exec_command_return_list(
            ssh_client, cmd, timeout=timeout, retry_times=retry_times)

    @classmethod
    def put_file(cls, host, user, passwd, source, destination='.', port=22):
        """将本地文件上传到linux服务器， 目标目录不存在时以上传用户为属主创建目录
        :param host:
        :param user:
        :param passwd:
        :param source: 需上传文件，包含路径与文件名
        :param destination: 目的地地址目录
        :param port:
        :return:
        """
        return cls.SSH_UTIL.put_file(
            host, user, passwd, source, destination=destination, port=port)

    @classmethod
    def get_file(cls, auth_ftp, source, destination='.', port=22):
        """将linux服务器上的文件下载到本地
        :param auth_ftp:
        :param source: 需下载的文件，包含路径与文件名
        :param destination: 目的地地址，包含路径与文件名
        :param port:
        :return:
        """
        return cls.SSH_UTIL.get_file(
            auth_ftp.host, auth_ftp.ftp_user, auth_ftp.ftp_pwd, source, destination=destination, port=port)

    @classmethod
    def close_ssh(cls, ssh_client):
        try:
            if ssh_client:
                cls.SSH_UTIL.ssh_close(ssh_client)
        except Exception as err:
            logger.warning(f"Close ssh client failed: {err}.")
