# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.common.check_result import CheckResult

from plugins.eReplication.common.lib.model import DmkInfo
from plugins.eReplication.common.lib.model import DmkAccountInfo
from plugins.eReplication.common.dr_api import API as DR_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.conditions import Condition
from plugins.eReplication.common.lib.decorator import handle_task_check_result
from plugins.eReplication.common.lib.params import Nodes, Params

logger.init("eReplication")


class PresetDMKUser(BaseSubJob):
    """初始化DMK账户"""

    @handle_task_check_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：执行安装前预检查&安装&配置

        :param project_id:
        :param pod_id:
        :return:Message类对象
        """

        # 初始化源站点DMK帐号
        nodes = Nodes(self.project_id, self.pod_id)
        params = Params(self.project_id, self.pod_id)
        if Condition(self.project_id).is_primary:
            team_id = DR_API.create_dmk_login_user(DmkInfo(params.source_dmk_float_ip, params.source_dmk_sys_user,
                                                       params.source_dmk_sys_user_pwd, params.dmk_deploy_user,
                                                       params.dmk_user_preset_pwd, params.dmk_user_new_pwd,
                                                       params.dmk_deploy_group))
            DR_API.create_remote_account(
                team_id, nodes.source_all_hosts, DmkAccountInfo(params.dmk_deploy_user,
                                                            nodes.ssh_user, nodes.source_ssh_pwd, nodes.source_sudo_pwd,
                                                            params.dmk_deploy_group))
        # 初始化目标站点DMK帐号
        team_id = DR_API.create_dmk_login_user(DmkInfo(params.target_dmk_float_ip, params.target_dmk_sys_user,
                                                       params.target_dmk_sys_user_pwd, params.dmk_deploy_user,
                                                       params.dmk_user_preset_pwd, params.dmk_user_new_pwd,
                                                       params.dmk_deploy_group))
        DR_API.create_remote_account(
            team_id, nodes.target_all_hosts, DmkAccountInfo(params.dmk_deploy_user,
                                                            nodes.ssh_user, nodes.target_ssh_pwd, nodes.target_sudo_pwd,
                                                            params.dmk_deploy_group))
        check = CheckResult(
            itemname_ch="迁移前初始化DMK帐户",
            itemname_en="Initialize Dmk Account Before Migrate",
            status="success", error_msg_cn="")
        return [check]
