# -*- coding:utf-8 -*-

import utils.common.log as logger
from utils.common.check_result import CheckResult
from utils.common.exception import HCCIException

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_check_result
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.utils import check_host_connection
from plugins.eReplication.common.upgrade_api import API as UPGRADE_API

logger.init("eReplication")


class CheckEnv(BaseSubJob):

    @handle_task_check_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :return:
        """
        results = list()
        nodes = Nodes(self.project_id, self.pod_id)
        for host in nodes.all_hosts:
            if not check_host_connection(host):
                # 网络通的情况下再进行后续检查
                msg = {"IP": host}
                logger.error(f"Check host connected failed, {msg}.")
                ex = HCCIException('665001', msg)
                results.append(CheckResult(
                    itemname_ch="检查网络连接",
                    itemname_en="Check network connection", status="failure",
                    error_msg_cn=ex))
        if results:
            return results
        upgrade_api = UPGRADE_API(self.project_id, self.pod_id, self.region_id)
        upgrade_api.store_origin_adapter_version()
        check_results = upgrade_api.check_env()
        for check_result in check_results:
            results.extend(check_result)
        # check_env返回值中有失败状态，则终止
        check_env_results = [check_result for check_result in check_results if check_result[0].status == 'failure']
        if check_env_results:
            return results
        check_cipher_results = upgrade_api.check_cipher_consistency()
        if check_cipher_results:
            return check_cipher_results
        check_server_results = upgrade_api.check_server_status_before_upgrade()
        if check_server_results:
            return check_server_results
        check_recovery_plan_results = upgrade_api.check_recovery_plan()
        results.extend(check_recovery_plan_results)
        if not results:
            result = CheckResult(
                itemname_ch=f"检查运行环境[{nodes.all_hosts}]",
                itemname_en=f"Check runtime environment[{nodes.all_hosts}]",
                status="success")
            results.append(result)
        return results
