# -*- coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import utils.common.log as logger

from utils.common.check_result import CheckResult

from plugins.eReplication.common.lib.decorator import handle_task_check_result
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.upgrade_os_api import API as UPGRADE_OS_API

logger.init("eReplication OSPreCheck")


class OSPreCheck(BaseSubJob):

    @handle_task_check_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：升级前检查OS升级

        :param project_id:
        :param pod_id:
        :return:
        """
        results = list()
        try:
            # 检查节点OS版本
            UPGRADE_OS_API(self.project_id, self.pod_id, self.region_id).check_os_version()
            # 检查EulerOS卷组空闲空间是否足够: euleros
            UPGRADE_OS_API(self.project_id, self.pod_id, self.region_id).check_vg_free_space()
            results.append(CheckResult(
                itemname_ch=f"OS升级前预检查",
                itemname_en=f"OSPreCheck",
                status="success"))
        except Exception as ex:
            results.append(CheckResult(
                itemname_ch=f"OS升级前预检查",
                itemname_en=f"OSPreCheck",
                status="failure",
                error_msg_cn=ex))
        return results
