# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.upgrade_api import API as UPGRADE_API

logger.init("RegisterNotifications")


class RegisterNotifications(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """

        UPGRADE_API(self.project_id, self.pod_id, self.region_id). \
            register_notifications()
