# -*- coding:utf-8 -*-
import utils.common.log as logger
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.upgrade_api import API as UPGRADE_API

logger.info("UnregisterAdaptationPackage")


class UnregisterAdaptationPackage(BaseSubJob):
    """
        eReplication Server回退十统一适配包
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        UPGRADE_API(self.project_id, self.pod_id, self.region_id).unregister_adaptation_package()
