#!/bin/bash
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

function main() {
  echo "Begin stop icruntime"
  local -r agent_pid=$(su -s /bin/bash - monitor -c "ps --noheaders -ux" | grep -v grep | grep icruntime.py | awk '{print $2}' | tr "\n" " ")
  local -r watchdog_pid=$(su -s /bin/bash - monitor -c "ps --noheaders -ux" | grep -v grep | grep icwatchdog.py | grep -v DNFW=icwatchdog | awk '{print $2}' | tr "\n" " ")
  if [[ "$agent_pid"x != x || "$watchdog_pid"x != x ]]; then
    echo "will stop process. agent_pid ${agent_pid} watchdog_pid ${watchdog_pid}"
    su -s /bin/bash - monitor -c "kill -9 ${agent_pid} ${watchdog_pid}" > /dev/null 2>&1
    echo "stop process complete."
  fi
  local -r str_time=$(date "+%Y-%m-%d %T")
  echo "[$str_time] The icruntime service is been stopped!"
  echo "Stop icruntime service success."
}

main
exit $?