@echo off    
setlocal EnableDelayedExpansion

set AGENT_ROOT=%~1
set PID=%~2
cd /d %~dp0

set AGENT_BIN_PATH=%AGENT_ROOT%\bin\
set AGENT_LOG_PATH=%AGENT_ROOT%\log\
set AGENT_TMP_PATH=%AGENT_ROOT%\tmp\
set COMMONFUNC="%AGENT_BIN_PATH%oraclefunc.bat"
set CMD_GETVALUE=getvalue
set CMD_EXECSQL_SILE=execsqls
set NEED_LOG=1
set LOGFILE=exchange.log
set LOGFILE_PATH="%AGENT_LOG_PATH%%LOGFILE%"
set RESULT_FILE="%AGENT_TMP_PATH%result_tmp%PID%"

set ERR_CODE=1
set ERR_SCRIPT_EXEC_FAILED = 5
set ERR_SCRIPT_NOT_EXIST=255
set ERR_RESULT_FILE_NOT_EXIST=6
set ERR_INPUT_TEMP_NOT_EXSIT=7
set ERR_FILE_IS_EMPTY=8
set ERR_RECOVERY_DB_FAILED=132
set ERR_REMOVE_FAILED=130

set CMD_GETINPUTPARAM_BYKEY=getInputValueByKey
set /p INPUT_PARAM=
for /f "tokens=* delims=" %%i in ("!INPUT_PARAM!") do (
    set "line=%%i"
    set RESULT_PARAM=!RESULT_PARAM!;!line!
)

rem #############################################################
rem OPERTYPE, 2 -- get exchange info, 0 -- mount exchange db,  1 -- remove exchange db, 3 -- dismouny exchange
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "OperType" OPERTYPE
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "Version" VERSION
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "NewStorageGroupName" NEWSTORAGEGROUPNAME
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "NewMailBoxDBName" NEWMAILBOXDBNAME
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "HostName" HOSTNAME
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "EdbFilePath" EDBFILEPATH
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "LogFilePath" LOGDIRPATH
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "SysFilePath" SYSFILEPATH
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "OldStorageGroupName" OLDSTORAGEGROUPNAME
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "OldMailBoxDBName" OLDMAILBOXDBNAME
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "RecoveryType" RECOVERYTYPE
call :log "Operate type %OPERTYPE%."
call :log "Data base version %VERSION%, new storage group name %NEWSTORAGEGROUPNAME%, new mailbox db name %NEWMAILBOXDBNAME%, hostname %HOSTNAME%."
call :log "Log dir path %LOGDIRPATH%, edb file path %EDBFILEPATH%, sys dir path %SYSFILEPATH%, old storage group name %OLDSTORAGEGROUPNAME%, old mailbox db name %OLDMAILBOXDBNAME%, recovery type %RECOVERYTYPE%."

rem Get server name
call :log "Begin to get server name."
for /f "tokens=1,2,* " %%i in ('reg query "HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\ComputerName\ComputerName" /v "ComputerName"') do set "SERVER_NAME=%%k"
if "!SERVER_NAME!"=="" (
    call :log "Get server name failed."
    set ERR_CODE=%ERR_FILE_IS_EMPTY%
    goto error
)
call :log "Get server name succ, server name !SERVER_NAME!."

rem Get powershell path
call :log "Begin to get powershell path."
for /f "tokens=1,2,* " %%i in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\PowerShell\1\PowerShellEngine" /v "ApplicationBase"') do set "POWERSHELL_PATH=%%k" 
if "!POWERSHELL_PATH!"=="" (
    call :log "Get powershell path faild."
    set ERR_CODE=%ERR_FILE_IS_EMPTY%
    goto error
)
call :log "Get powershell path succ, powershell path %POWERSHELL_PATH%."

rem Get exchange install path for 2007 and 2010
call :log "Begin to get exchange path."
for /f "tokens=1,2,* " %%i in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Exchange\MSFTESQLInstMap\51" /v "Path"') do set "EXCHANGE_PATH=%%k"
if "!EXCHANGE_PATH!"=="" (
    call :log "Exchange install path for 2007 or 2010 is empty."

    rem Get exchange install path for 2013
    for /f "tokens=1,2,* " %%i in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\ExchangeServer\v15\setup" /v "MsiInstallPath"') do set "EXCHANGE_PATH=%%k"
    if "!EXCHANGE_PATH!"=="" (
        call :log "Get exchange install path failed."
        set ERR_CODE=%ERR_FILE_IS_EMPTY%
        goto error
    ) else (
        set EXCHANGE_PATH=!EXCHANGE_PATH!bin\
    )
)
call :log "Get exchange path succ, exchange path %EXCHANGE_PATH%."

if "%OPERTYPE%"=="2" (
    call :QueryExchangeList
) else if "%OPERTYPE%"=="0" (
    call :MountExchange
) else if "%OPERTYPE%"=="1" (
    rem clear exchange
    call :ClearExchange
) else if "%OPERTYPE%"=="3" (
    rem dismount exchange
    call :ClearExchange
) else (
    call :log "invalid opertype %OPERTYPE%."
    goto error
)

goto :end

:QueryExchangeList
    rem Excute powershell script to get exchange info
    if not exist "%AGENT_BIN_PATH%queryexchangeinfo.ps1" (
        set ERR_CODE=%ERR_SCRIPT_NOT_EXIST%
        call :log "Script queryexchangeinfo.ps1 is not exist, exit code %ERR_CODE%"
        goto error
    )
    
    call :log "Begin to execute query powershell, server name %SERVER_NAME%, result file result_tmp%PID%."
    "%POWERSHELL_PATH%\powershell.exe" -PSConsoleFile "%EXCHANGE_PATH%exshell.psc1" -command ".\queryexchangeinfo.ps1 '%SERVER_NAME%' '%RESULT_FILE%'"; exit $LASTEXITCODE
    
    if %errorlevel% neq 0 (
        call :log "Execute query powershell[queryexchangeinfo.ps1] failed, errorlevel is not 0."
        set ERR_CODE=%ERR_SCRIPT_EXEC_FAILED%
        goto error
    ) else (      
        if not exist %RESULT_FILE% (
            set ERR_CODE=%ERR_RESULT_FILE_NOT_EXIST%
            call :log "Execute query powershell[queryexchangeinfo.ps1] failed, result file is not exist, exit code !ERR_CODE!"
            goto error
        )
        call :log "Execute query powershell[queryexchangeinfo.ps1] succ."
        goto end
    )
goto :EOF

:MountExchange
    rem Excute powershell script to recover exchange db
    if not exist "%AGENT_BIN_PATH%operexchangedb.ps1" (
        set ERR_CODE=%ERR_SCRIPT_NOT_EXIST%
        call :log "Script operexchangedb.ps1 is not exist, exit code !ERR_CODE!"
        goto error
    )
    
    call :log "Begin to execute recover powershell, server name %SERVER_NAME%."
    "%POWERSHELL_PATH%\powershell.exe" -PSConsoleFile "%EXCHANGE_PATH%exshell.psc1" -command ".\operexchangedb.ps1 %OPERTYPE% %VERSION% '%OLDSTORAGEGROUPNAME%' '%OLDMAILBOXDBNAME%' '%NEWSTORAGEGROUPNAME%' '%NEWMAILBOXDBNAME%' '%SERVER_NAME%' '%EDBFILEPATH%' '%LOGDIRPATH%' '%SYSFILEPATH%' '%RECOVERYTYPE%' '%RESULT_FILE%'"; exit $LASTEXITCODE
    
    if %errorlevel% neq 0 (
        if exist %RESULT_FILE% (
            
            for /f "delims=" %%i in ('type %RESULT_FILE%') do (
                if not "%%i" == "" (
                    set ERR_CODE=%%i
                )
            )
            del /f /q %RESULT_FILE%
            call :log "Execute recover powershell[operexchangedb.ps1] failed, exit code !ERR_CODE!."
            goto error
        )
        
        set ERR_CODE=%ERR_RECOVERY_DB_FAILED%
        call :log "Execute recover powershell[operexchangedb.ps1] failed, mount db failed, exit code !ERR_CODE!."
        goto error    
    ) else (
        call :log "Execute recover powershell[operexchangedb.ps1] succ."
        goto end
    )
goto :EOF

:ClearExchange
    if not exist "%AGENT_BIN_PATH%operexchangedb.ps1" (
        set ERR_CODE=%ERR_SCRIPT_NOT_EXIST%
        call :log "Script operexchangedb.ps1 is not exist, exit code !ERR_CODE!"
        goto error
    )
    
    rem Excute powershell script to remove exchange db
    call :log "Begin to execute remove powershell, server name %SERVER_NAME%."
    "%POWERSHELL_PATH%\powershell.exe" -PSConsoleFile "%EXCHANGE_PATH%exshell.psc1" -command ".\operexchangedb.ps1 %OPERTYPE% %VERSION% '%NEWSTORAGEGROUPNAME%' '%NEWMAILBOXDBNAME%' '%SERVER_NAME%' '%RESULT_FILE%'"; exit $LASTEXITCODE

    if %errorlevel% neq 0 (
        if exist %RESULT_FILE% (
            
            for /f "delims=" %%i in ('type %RESULT_FILE%') do (
                if not "%%i" == "" (
                    set ERR_CODE=%%i
                )
            )
            del /f /q "%RESULT_FILE%" 
            call :log "Execute remove powershell[operexchangedb.ps1] failed, exit code !ERR_CODE!."
            goto error
        )
        
        set ERR_CODE=%ERR_REMOVE_FAILED%
        call :log "Execute remove powershell[operexchangedb.ps1] failed, remove db failed, exit code !ERR_CODE!."
        goto error    
    ) else (
        call :log "Execute remove powershell[operexchangedb.ps1] succ."
        goto end
    )
goto :EOF
    
:DeleteFile
    set FileName=%1
    if exist %FileName% (del /f /q %FileName%)
    
goto :EOF
    
:Log
    if %NEED_LOG% EQU 1 (
        echo %date:~0,10% %time:~0,8% [%username%] "%~1" >> %LOGFILE_PATH%
    )
    call "%AGENT_BIN_PATH%agent_func.bat" %LOGFILE_PATH%
goto :EOF

:error
    call :log "Exchange MailBox db Operater failed."
    exit %ERR_CODE%
    
:end
    endlocal
    
