@echo off    
setlocal EnableDelayedExpansion

set AGENT_ROOT=%~1
set PID=%~2
cd /d %~dp0

set AGENT_BIN_PATH=%AGENT_ROOT%\bin\
set AGENT_LOG_PATH=%AGENT_ROOT%\log\
set AGENT_TMP_PATH=%AGENT_ROOT%\tmp\
set COMMONFUNC="%AGENT_BIN_PATH%oraclefunc.bat"
set CMD_GETVALUE=getvalue
set LOGFILE=exchangedag.log
set LOGFILEPATH="%AGENT_LOG_PATH%%LOGFILE%"
set NEED_LOG=1
set ERR_CODE=1
set RESULT_FILE="%AGENT_TMP_PATH%result_tmp%PID%"

set CMD_GETINPUTPARAM_BYKEY=getInputValueByKey
set /p INPUT_PARAM=
for /f "tokens=* delims=" %%i in ("!INPUT_PARAM!") do (
    set "line=%%i"
    set RESULT_PARAM=!RESULT_PARAM!;!line!
)

rem #############################################################
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "OperType" OPERTYPE
call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOGFILE% "%RESULT_PARAM%" "dbName" dbName
call :log "Operate type %OPERTYPE%.dbName=%dbName%"

rem Get server name
call :log "Begin to get server name."
for /f "tokens=1,2,* " %%i in ('reg query "HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\ComputerName\ComputerName" /v "ComputerName"') do set "SERVER_NAME=%%k"
if "!SERVER_NAME!"=="" (
    call :log "Get server name failed."
    set ERR_CODE=%ERR_FILE_IS_EMPTY%
    goto error
)
call :log "Get server name succ, server name !SERVER_NAME!."

rem Get powershell path
call :log "Begin to get powershell path."
for /f "tokens=1,2,* " %%i in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\PowerShell\1\PowerShellEngine" /v "ApplicationBase"') do set "POWERSHELL_PATH=%%k" 
if "!POWERSHELL_PATH!"=="" (
    call :log "Get powershell path faild."
    set ERR_CODE=%ERR_FILE_IS_EMPTY%
    goto error
)
call :log "Get powershell path succ, powershell path %POWERSHELL_PATH%."

rem Get exchange install path for 2007 and 2010
call :log "Begin to get exchange path."
for /f "tokens=1,2,* " %%i in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Exchange\MSFTESQLInstMap\51" /v "Path"') do set "EXCHANGE_PATH=%%k"
if "!EXCHANGE_PATH!"=="" (
    call :log "Exchange install path for 2007 or 2010 is empty."

    rem Get exchange install path for 2013
    for /f "tokens=1,2,* " %%i in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\ExchangeServer\v15\setup" /v "MsiInstallPath"') do set "EXCHANGE_PATH=%%k"
    if "!EXCHANGE_PATH!"=="" (
        call :log "Get exchange install path failed."
        set ERR_CODE=%ERR_FILE_IS_EMPTY%
        goto error
    ) else (
        set EXCHANGE_PATH=!EXCHANGE_PATH!bin\
    )
)
call :log "Get exchange path succ, exchange path %EXCHANGE_PATH%."

if "%OPERTYPE%"=="0" (
    rem OperType 0 : 获取DB的DAG NAME
    call :GetDAGInfo
) else if "%OPERTYPE%"=="1" (
    rem OperType 1 : 获取DB的active host
    call :GetDAGActiveHost
) else (
    call :log "invalid opertype %OPERTYPE%."
    goto error
)

goto :end

:GetDAGInfo
    call :log "Begin to execute get dag info by powershell."
    "%POWERSHELL_PATH%\powershell.exe" -PSConsoleFile "%EXCHANGE_PATH%exshell.psc1" -command ".\operexchangedag.ps1 %OPERTYPE% '!SERVER_NAME!' '%dbName%' '%RESULT_FILE%'"; exit $LASTEXITCODE

    if %errorlevel% neq 0 (
        if exist %RESULT_FILE% (
            for /f "delims=" %%i in ('type %RESULT_FILE%') do (
                if not "%%i" == "" (
                    set ERR_CODE=%%i
                )
            )
            del /f /q "%RESULT_FILE%" 
            call :log "Execute powershell[operexchangedag.ps1] failed, get dag information failed, exit code !ERR_CODE!."
            goto error
        )
        
        set ERR_CODE=%ERR_REMOVE_FAILED%
        call :log "Execute powershell[operexchangedag.ps1] failed, get dag information failed, exit code !ERR_CODE!."
        goto error    
    ) else (
        call :log "Execute powershell[operexchangedag.ps1] succ, get dag information succ."
        goto end
    )
    goto :EOF

:GetDAGActiveHost
    call :log "Begin to execute get dag active host by powershell."
    "%POWERSHELL_PATH%\powershell.exe" -PSConsoleFile "%EXCHANGE_PATH%exshell.psc1" -command ".\operexchangedag.ps1 %OPERTYPE% '!SERVER_NAME!' '%dbName%' '%RESULT_FILE%'"; exit $LASTEXITCODE

    if %errorlevel% neq 0 (
        if exist %RESULT_FILE% (
            for /f "delims=" %%i in ('type %RESULT_FILE%') do (
                if not "%%i" == "" (
                    set ERR_CODE=%%i
                )
            )
            del /f /q "%RESULT_FILE%" 
            call :log "Execute powershell[operexchangedag.ps1] failed, get DAG active host failed, exit code !ERR_CODE!."
            goto error
        )
        
        set ERR_CODE=%ERR_REMOVE_FAILED%
        call :log "Execute powershell[operexchangedag.ps1] failed, get DAG active host failed, exit code !ERR_CODE!."
        goto error    
    ) else (
        call :log "Execute powershell[operexchangedag.ps1] succ, get DAG active host succ."
        goto end
    )
    goto :EOF

:StartDAGResource

    goto :EOF

:MountDAGMailDB

    goto :EOF

:DismountDAGMailDB

    goto :EOF

:DeleteFile
    set FileName=%1
    if exist %FileName% (del /f /q %FileName%)
    
    goto :EOF
    
:Log
    if %NEED_LOG% EQU 1 (
        echo %date:~0,10% %time:~0,8% [%username%] "%~1" >> %LOGFILEPATH%
    )
    call "%AGENT_BIN_PATH%agent_func.bat" %LOGFILEPATH%
    goto :EOF

:error
    call :log "Exchange MailBox db Operater failed."
    exit %ERR_CODE%
    
:end
    endlocal
