<# Copyright (c) Huawei Corporation. All rights reserved.
#######################################################################################################################
Recovery Exchange DB:
#######################################################################################################################
Input params : 
    OperType        : 
        0 : Get dag information by database name
        1 : Get dag active host by database name
        2 : start DAG resource group
        3 : mount dag exchange database
        4 : dismount dag exchange database
#######################################################################################################################

#>

$gOperType
$gServerName
$gMailboxDBName
$gResultFile

$NeedLog = 1
#dag from 2010
$Exchange2016VersionMajor = 15
$Exchange2016VersionMinor = 1

$OperTypeGetInfo = 0
$OperTypeGetActiveHost = 1

#error code
$ERR_CODE = 5
$ERR_SCRIPT_EXEC_FAILED = 5
$ERR_FILE_IS_EMPTY = 8
#parameter wrong
$ERR_REMOVE_FAILED = 100

$CurrentDir = Split-Path $MyInvocation.MyCommand.Definition
$CurrentPath = Split-Path -Parent $MyInvocation.MyCommand.Definition
$AgentRoot = Split-Path -Parent $CurrentPath
$AgentLogPath = join-path -path $AgentRoot -childpath log
$LogFilePath = join-path -path $AgentLogPath -childpath operexchangedag.log

function DeleteFile($fileName)
{
	$bExists = Test-Path "$fileName"
	if ($bExists){
		Remove-Item -Path "$fileName" -Recurse -ErrorAction Stop
	}
}

function Log($InputLog) 
{
    if (1 -eq $NeedLog) {
        "[$(Get-Date)] [$env:username] $InputLog" | Out-File $LogFilePath -Encoding UTF8 -Append
    }
    . "$CurrentDir\agent_func.ps1" $LogFilePath
}

function ParseInputParams($InputParams) 
{
    Set-Variable gOperType $InputParams[0] -scope 1
    Set-Variable gServerName $InputParams[1] -scope 1
    Set-Variable gMailboxDBName $InputParams[2] -scope 1
    Set-Variable gResultFile $InputParams[3] -scope 1
    $ResultFileName = Split-Path $gResultFile -leaf
    Log "Parse parasm succ, Oper type $gOperType, Mailbox db name $gMailBoxDBName, result file $ResultFileName."
	
	DeleteFile $gResultFile
}

function CheckVersion($exchangeVersion, $mailDBName) 
{
    $ExchangeServer = Get-ExchangeServer -identity $gServerName -ErrorAction Stop
    $MajorVersion = $ExchangeServer.admindisplayversion.major
    $MinorVersion = $ExchangeServer.admindisplayversion.minor

    # now only support 2016
    if ($MajorVersion -lt $Exchange2016VersionMajor -Or $MinorVersion -lt $Exchange2016VersionMinor) {
        Log "Ivalid exchangedag version $MajorVersion $MinorVersion."
        exit(1)
    }

    if ($mailDBName -eq "") {
        Log "Invalid exchangedag mail database name."
        exit(1)
    }
}

function GetDAGInfoByDBName($exchangeVersion, $mailDBName) 
{
    $dagName
    $dagData = @(Get-MailboxDatabase -identity $mailDBName -Status)
    foreach ($item in $dagData) {
        $dagName = $item.MasterServerOrAvailabilityGroup.Name
    }

    if ($dagName -eq "") {
        Log "Ivalid exchangedag dag resource name."
        exit(1)
    }

    # output result
    $dagName | Out-File $gResultFile -Encoding ASCII -Append

    # get copy list
    $cpData = @(Get-MailboxDatabaseCopyStatus -identity $mailDBName)
    foreach ($item in $cpData) {
        $cpName = $item.Name
        $cpStatus = $item.Status
        $boxServer = $item.MailboxServer
        $isActive = ($item.ActiveDatabaseCopy -eq $item.MailboxServer)        
        "$cpName,$cpStatus,$boxServer,$isActive" | Out-File $gResultFile -Encoding ASCII -Append
    }
}

function GetActiveHostByDBName($exchangeVersion, $mailDBName) 
{
    $activeHost
    $isActive
    $cpList = @(Get-MailboxDatabaseCopyStatus -identity $mailDBName -local)
    foreach ($item in $cpList) {
        $isActive = ($item.ActiveDatabaseCopy -eq $item.MailboxServer)
        $activeHost = $item.ActiveDatabaseCopy
    }

    "$isActive,$activeHost" | Out-File $gResultFile -Encoding ASCII -Append
}

function ExchangeOper($OperType, $ExhcangeVersion) 
{
    try {
        if ($OperType -eq $OperTypeGetInfo) {
            GetDAGInfoByDBName $ExhcangeVersion $gMailboxDBName
        } elseif ($OperType -eq $OperTypeGetActiveHost) {
            GetActiveHostByDBName $ExhcangeVersion $gMailboxDBName
        } else {
            Log "Ivalid exchangedag oper type $OperType."
            exit(1)
        }
    }
    catch {
        $lineNumber = $Error[0].InvocationInfo.scriptlinenumber
        $ErrorInfos = $Error[0]
        Log "ERROR LINE NUMBER $lineNumber, DESCRIPTION $ErrorInfos"
        "$ERR_CODE" | Out-File "$gResultFile" -Encoding ASCII -Append
        exit($ERR_CODE)
    }
}

ParseInputParams $args
CheckVersion $gVersion $gMailboxDBName
ExchangeOper $gOperType $gVersion

exit(0)

