@echo off

set AGENT_ROOT=%~1
set PID=%~2

set AGENT_BIN_PATH=%AGENT_ROOT%\bin\
set AGENT_LOG_PATH=%AGENT_ROOT%\log\
set AGENT_TMP_PATH=%AGENT_ROOT%\tmp\
set NGINX_LOG_PATH=%AGENT_BIN_PATH%\nginx\logs\
set ZIP_TOOL=%AGENT_BIN_PATH%\7z.exe
set INPUT_TMP_FILE=%AGENT_TMP_PATH%input_tmp%PID%
set LOG_FILE=packlog.log
set LOG_FILE_NAME="%AGENT_LOG_PATH%packlog.log"

setlocal EnableDelayedExpansion
set COMMONFUNC="%AGENT_BIN_PATH%oraclefunc.bat"
set CMD_GETINPUTPARAM_BYKEY=getInputValueByKey
set /p INPUT_PARAM=
for /f "tokens=* delims=" %%i in ("!INPUT_PARAM!") do (
    set "line=%%i"
    set RESULT_PARAM=!RESULT_PARAM!;!line!
)

call %COMMONFUNC% "%AGENT_ROOT%" %CMD_GETINPUTPARAM_BYKEY% %PID% %LOG_FILE% "%RESULT_PARAM%" "LogName" LOG_FOLDER
call :Log "Begin to package log, LogName: %LOG_FOLDER%."

SET PACKAGE_LOG=%AGENT_TMP_PATH%%LOG_FOLDER%

del /f /q "%INPUT_TMP_FILE%"

mkdir "%PACKAGE_LOG%"
mkdir "%PACKAGE_LOG%\nginx_log"
mkdir "%PACKAGE_LOG%\agent_log"

if exist "%NGINX_LOG_PATH%"    copy /y  "%NGINX_LOG_PATH%"*.log*   "%PACKAGE_LOG%\nginx_log\"  >Nul
if exist "%AGENT_LOG_PATH%"    copy /y  "%AGENT_LOG_PATH%"*.log*   "%PACKAGE_LOG%\agent_log\"  >Nul

call :Log "Compress agent log."
"%ZIP_TOOL%"  a -tzip "%PACKAGE_LOG%.zip"  "%PACKAGE_LOG%" -mx=9 >Nul

rmdir  /s/q   "%PACKAGE_LOG%"
call :Log "Finish packaging log."
exit /b 0

rem ************************************************************************
rem function name: Log
rem aim:           Print log function, controled by "NEEDLOGFLG"
rem input:         the recorded log
rem output:        LOGFILENAME
rem ************************************************************************
:Log
    echo %date:~0,10% %time:~0,8% [%username%] "%~1" >> %LOG_FILE_NAME%
    call "%AGENT_BIN_PATH%agent_func.bat" %LOG_FILE_NAME%
    goto :EOF