#!/usr/bin/env python
#coding: utf-8
import sys
import os
import re
import ssl
import httplib
import json
import inspect
import datetime
def config():
    if sys.version_info < (2,7,9):
        return {"errorCode": 1, "errorMessage": "python version should greater or equal to 2.7.9"}
    base=os.path.dirname(sys.argv[0])
    conf=os.path.join(base, '..', 'nginx','conf', 'nginx.conf')
    if not os.path.exists(conf):
        return {"errorCode": 2, "errorMessage": "%s is not exits" % conf}
    if not os.path.isfile(conf):
        return {"errorCode": 3, "errorMessage": "%s is not file" % conf}
    hanle = open(conf,'r')
    with open(conf,'r') as file:
        for line in file:
            matches=re.match(r'.*listen\s*((\d+\.){3}\d+):(\d+).*', line)
            if matches is None:
                continue
            return matches.group(1,3)
    return {"errorCode": 4, "errorMessage": "not found listen config in %s" % conf}

def log(message, debug=False):
    if message is None:
        return
    if debug and "debug" not in __options:
        return
    base=os.path.dirname(sys.argv[0])
    path=os.path.join(base, '..', '..','log', 'rest.log')
    timestamp = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    message = "[%s] %s" % (timestamp, message)
    f = open(path, 'a')
    f.write("%s\n" % message)
    f.close()
    if "verbose" in __options:
        print message

def ret(data, cmd=None):
    if data is None:
        return
    if not data.has_key('errorCode'):
        log("Success=[Data: %s], CMD=%s" % (json.dumps(data), cmd))
    else:
        code = int(data['errorCode'])
        log("Failure=[Code: %s, Message: %s], CMD=%s" % (code, data['errorMessage'], cmd))
        sys.exit(code)

def main(username, password):
    if __name__ != '__main__':
        return
    if len(sys.argv) == 1:
        ret({"errorCode": 5, "errorMessage": "Method parameter are not provided"})
    cmd = sys.argv[1:]
    name = sys.argv[1]
    if not name in Agent.__dict__:
        ret({"errorCode": 6, "errorMessage": "'%s' is not supported method" % name}, cmd)
    method = Agent.__dict__[name]
    notes = pick(method.__doc__)
    if "rest" not in notes:
        ret({"errorCode": 7, "errorMessage": "'%s' is not supported rest method" % name}, cmd)
    posi = None
    if "domain" in notes:
        if len(notes["domain"]) > 0:
            varnames = method.__code__.co_varnames
            arg = notes["domain"][0]
            if arg not in varnames:
                ret({"errorCode": 8, "errorMessage": "'%s' is not variable name" % arg}, cmd)
            posi = varnames.index(arg)
            posi = posi - 1 if posi > 0 else None

    agent = Agent(username, password)
    domain = None
    args = []
    for arg in sys.argv[2:]:
        matches = re.match(r'^--([^=]+)(=(.*))?', arg)
        if matches is not None:
            key = matches.group(1)
            val = matches.group(3)
            __options[key] = val if val is not None else True
            continue
        matches = re.match(r'^-([^=]+)=(.*)', arg)
        if matches is not None:
            args.append(matches.group(1, 2))
        else:
            if posi is not None and len(args) == posi:
                if arg in __domains:
                    domain = __domains[arg](agent)
                    args.append(domain)
                else:
                    ret({"errorCode": 9, "errorMessage": "'%s' is not supported domain" % arg}, cmd)
            else:
                args.append(arg)

    params = {}
    for arg in args:
        if isinstance(arg, tuple):
            done = False
            if domain is not None:
                done = domain.cast(name, arg, params)
            if not done:
                done = agent.cast(name, arg, params)
            if not done:
                params[arg[0]] = arg[1]
    args = [arg for arg in args if not isinstance(arg, tuple)]
    args.append(params)
    try:
        data = getattr(agent, name)(*args)
    except Exception, e:
        ret({"errorCode": 10, "errorMessage": e}, cmd)
    finally:
        del agent
    if not isinstance(data, dict):
        ret({"errorCode": 11, "errorMessage": "unkown-error"}, cmd)
    ret(data, cmd)

def domains():
    items = {}
    for k,v in sys.modules[__name__].__dict__.items():
        if not inspect.isclass(v):
            continue
        notes = pick(v.__doc__)
        if "domain" not in notes:
            continue
        for note in notes["domain"]:
            items[note] = v
    return items

def trim(text):
    return re.compile(r'^\s*|\s*$').sub('', text)

def pick(text):
    pattern=r'^\s*(@([^@()]+)(\(([^()]*)\))?)\s*$'
    notes = {}
    text = text if text is not None else ''
    for note in [re.match(pattern, line) for line in text.split('\n') if re.match(pattern, line) is not None]:
        args = note.group(4)
        args = trim(args) if args is not None else ''
        args = [trim(arg) for arg in args.split(',')] if len(args) > 0 else []
        key = note.group(2)
        if re.match(r'^\*', key) is None:
            notes[key] = args
        else:
            key = re.compile(r'^\*').sub('', key)
            if key not in notes:
                notes[key] = []
            notes[key].append(args)
    return notes

def cast(rules, source, target):
    if rules is None:
        return False
    for rule in rules:
        if cmp(rule[0], source[0]) == 0:
            k = rule[2] if len(rule) > 2 else rule[0]
            if rule[1] in ["str", 'int']:
                target[k] = eval(rule[1])(source[1])
                return True
            else:
                matches = re.match(r'^(\w+)(<(str|int)>)?$', rule[1])
                if matches is None:
                    continue
                t = matches.group(1)
                if cmp(t, 'set') == 0:
                    if k not in target:
                        target[k] = []
                    t = matches.group(2)
                    if t is None:
                        target[k].append(source[1])
                    elif t in ["str", 'int']:
                        target[k].append(eval(t)(source[1]))
                    return True
    return False

class Object:
    def __init__(this):
        pass

    def cast(this, method, source, target):
        if method not in this.__class__.__dict__:
            return False
        notes = pick(this.__class__.__dict__[method].__doc__)
        if "param" in notes:
            return cast(notes["param"], source, target)
        return False

class Domain(Object):
    __agent = None
    def __init__(this, agent):
        this.__agent = agent

    def kind(this):
        notes = pick(this.__class__.__doc__)
        if "domain" in notes and len(notes["domain"]) > 0:
            return notes["domain"][0]

    def subType(this):
        notes = pick(this.__class__.__doc__)
        if "subType" in notes and len(notes["subType"]) > 0:
            return notes["subType"][0]

    def paramIsArray(this):
        notes = pick(this.__class__.__doc__)
        if "paramIsArray" in notes and len(notes["paramIsArray"]) > 0:
            return notes["paramIsArray"][0]
    
    def request(this, *args, **kwargs):
        args = [arg for arg in args]
        args[1] = "/agent/%s/%s/%s" % (this.kind(), this.subType(), re.compile("^/").sub('', args[1]))
        return this.__agent.request(*args, **kwargs)
        
class SQLServer(Domain):
    """
@domain(sqlserver)
@subType(databases)
@paramIsArray(1)
"""
    def __init__(this, agent):
        Domain.__init__(this, agent)
        
    def freeze(this, params=None):
        """
@*param(name, str, dbName)
@*param(disk, set, diskNames)
"""
        pass

    def freezestate(this, domain, params=None):
        """
@*param(inst, str, instName)
@*param(db, str, dbName)
"""

    def unfreeze(this, params=None):
        """
@*param(name, str, dbName)
@*param(disk, set, diskNames)
"""
        pass

class FileSystem(Domain):
    """
@domain(device)
@subType(filesystems)
@paramIsArray(0)
"""
    def __init__(this, agent):
        Domain.__init__(this, agent)
        
    def freeze(this, params=None):
        """
@*param(disk, set, diskNames)
"""
        pass

    def freezestate(this, domain, params=None):
        """
@*param(disk, set, diskNames)
"""

    def unfreeze(this, params=None):
        """
@*param(disk, set, diskNames)
"""
        pass

class Agent(Object):
    __username = None
    __password = None
    __config = None
    __context = None
    __connection = None

    def __init__(this, username, password):
        this.__username = username
        this.__password = password
        this.__config = config()
        if isinstance(this.__config, tuple):
            this.__context = ssl._create_unverified_context()
            addr = '127.0.0.1' if cmp(this.__config[0], '0.0.0.0')  == 0 else this.__config[0]
            this.__connection = httplib.HTTPSConnection(addr, this.__config[1], context=this.__context)

    def __del__(this):
        if this.__connection is not None:
            this.__connection.close()

    def request(this, *args, **kwargs):
        global __options
        if this.__connection is None:
            return this.__config if isinstance(this.__config, dict) else {'errorCode':11, "errorMessage": "unkown error"}
        headers = this.__auth(args[3] if len(args) > 3 else None) or this.__auth(kwargs['headers'] if kwargs.has_key('headers') else None)
        if headers is None:
            kwargs['headers'] = this.__auth({})
        log("request=[*args: %s, **kwargs: %s]" % (args, kwargs), True)
        print this.__config
        this.__connection.request(*args, **kwargs)
        response = this.__connection.getresponse()
        data = response.read()
        if response.status != 200:
            return {"errorCode": 12, "errorMessage": "http-error: %s, data: %s" % (response.status, data)}
        if trim(data) in ['', 'null']:
            return {}
        return json.loads(data)

    def domain(this, name):
        if name in __domains:
            return __domains[name](this)
        
    def detail(this, params=None):
        """@rest"""
        return this.request('GET', '/agent/host')

    def freeze(this, domain, params=None):
        """
@rest
@domain(domain)
"""
        if isinstance(domain, str):
            domain = this.domain(domain)
        if domain.paramIsArray() == "1":
            params = [params] if params is not None else []

        return domain.request('PUT', "/action/freeze", json.dumps(params))

    def freezestate(this, domain, params=None):
        """
@rest
@domain(domain)
"""
        if isinstance(domain, str):
            domain = this.domain(domain)
        if domain.paramIsArray() == "1":
            params = [params] if params is not None else []

        return domain.request('GET', "/freezestate", json.dumps(params))

    def unfreeze(this, domain, params=None):
        """
@rest
@domain(domain)
"""
        if isinstance(domain, str):
            domain = this.domain(domain)
        if domain.paramIsArray() == "1":
            params = [params] if params is not None else []
            
        return domain.request('PUT', "/action/unfreeze", json.dumps(params))
    
    def __auth(this, headers):
        if headers is not None:
            headers['Content-type'] = 'application/json'
            headers['Accept'] = 'application/json'
            headers['charset'] = 'UTF-8'
            headers['x-auth-user'] = this.__username
            headers['x-auth-key'] = this.__password
        return headers

__options = {}
__domains = domains()

# please modify real user name and password of eReplication Agent
main('xxxx', 'xxxxx')
