# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.client.mo_client import API as MO_API
from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.conditions import Condition
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.params import Params

logger.init("RegisterConsole")


class RegisterConsole(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        params = Params(self.project_id, self.pod_id)
        nodes = Nodes(self.project_id, self.pod_id)
        region_id = params.project_region_id
        console_home = params.console_home_address
        server_port = nodes.service_port
        if not Condition(self.project_id).is_hcs_global:
            # Step2: 注册endpoint
            MO_API.register_endpoint(
                self.project_id, self.pod_id, region_id, console_home,
                Component.VHA_L)
            # Step3: 注册Links信息
            MO_API.register_links(
                self.project_id, self.pod_id, region_id, console_home,
                Component.VHA_L)
        # Step4: 注册Region对应的EndPoint信息
        MO_API.register_region(
            self.project_id, self.pod_id, region_id, server_port,
            Component.VHA_L)
