# -*- coding:utf-8 -*-

import utils.common.log as logger
from utils.business.install_csp_agent import CSPAgent

from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Nodes

logger.init("DeployCSPAgent")


class DeployCSPAgent(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        self._deploy_agent()

    def _deploy_agent(self):
        nodes = Nodes(self.project_id, self.pod_id)
        node_lst = []
        for host in nodes.hosts:
            node_info = {
                "node_ip": host,
                "process_username": nodes.ssh_user,
                "user_password": nodes.ssh_pwd,
                "sudo_cmd": "su",
                "root_password": nodes.sudo_pwd
            }
            node_lst.append(node_info)
        csp_tool = CSPAgent(self.pod_id)
        return_data = csp_tool.install_csp_agent(
            service_name=Component.REPLICATION, node_list=node_lst)
        result_code = return_data.get('result_code')
        result_msg = return_data.get('result_msg')
        if result_code != "0" or result_msg != "success":
            logger.error(
                f"Install csp agent on {nodes.hosts} failed: {result_msg}")
            raise Exception(
                f"Install csp agent on {nodes.hosts} failed: {result_msg}")
        logger.info("Install csp agent task success.")
