# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.client.mo_client import API as MO_API
from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.conditions import Condition
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Nodes

logger.init("RegisterReplicationSSO")


class RegisterReplicationSSO(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        nodes = Nodes(self.project_id, self.pod_id)
        white_list = nodes.all_hosts
        white_list.append(nodes.float_ip)
        if Condition(project_id).is_sub:
            white_list.append(nodes.service_ip)
        white_list = ",".join(white_list)
        MO_API(project_id, pod_id).add_sso_white_list(white_list)
        if Condition(project_id).is_service_installed:
            logger.info("Not install dr service in first Region, skip register eReplication SSO.")
        else:
            om_info = {
                "id": Component.REPLICATION,
                "name": {
                    "zh-cn": Component.REPLICATION,
                    "en-us": Component.REPLICATION,
                },
                # global部署
                "region_id": '',
                "url": f"https://{nodes.service_ip}:{nodes.service_port}",
                "operations": []
            }
            MO_API(project_id, pod_id).register_sso(om_info)
