# -*- coding:utf-8 -*-
import utils.common.log as logger
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.dr_api import API as DR_API
from plugins.eReplication.common.lib.params import Params

logger.init("RegisterAdaptationPackage")


class RegisterAdaptationPackage(BaseSubJob):
    """
        eReplication Server注册十统一适配包
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        region_id = Params(self.project_id, self.pod_id).project_region_id
        DR_API.register_adaptation_package(project_id, pod_id, region_id)
