# -*- coding:utf-8 -*-
from utils.business.dmk_util import DMK_ROLE
from utils.business.dmk_util import DmkApi
from utils.Logic.dmk.dmk_data import DMKChannel

from plugins.eReplication.common.constant import Action
from plugins.eReplication.common.constant import Component


class API(object):
    DMK = DmkApi()

    @classmethod
    def create_dmk_user(cls, username, password, role, team_name):
        return cls.DMK.create_dmk_user(username, password, role, team_name)

    @classmethod
    def update_user_to_team(cls, user_id, role_id, team_lst):
        return cls.DMK.update_user_to_multi_team(user_id, role_id, team_lst)

    @classmethod
    def update_account_to_team(
            cls, user_name, account_name, team_lst, passwd, sudo_passwd):
        return cls.DMK.update_account_to_multi_team(
            user_name, account_name, team_lst, passwd, sudo_passwd)

    @classmethod
    def add_account_to_dmk(
            cls, account, team_id, password, sudo_passwd):
        return cls.DMK.add_account_to_dmk(
            account, team_id, password, sudo_passwd)

    @classmethod
    def change_dmk_user_passwd(
            cls, user_id, old_password, new_password):
        return cls.DMK.change_dmk_user_passwd(
            user_id, old_password, new_password)

    @classmethod
    def execute_dmk_deployment(cls, dmk_deployment_info, channel: DMKChannel = DMKChannel.SSH):
        return cls.DMK.execute_dmk_deployment(
            dmk_deployment_info.app_name, dmk_deployment_info.to_run, dmk_deployment_info.app_version,
            dmk_deployment_info.deploy_action, dmk_deployment_info.hosts_content,
            dmk_deployment_info.vars_content, dmk_deployment_info.account_id, channel=channel)

    @classmethod
    def install_maglev_agent(cls, node_list):
        return cls.DMK.install_agent(node_list)

    @classmethod
    def upload_pkg_to_dmk(cls, file_path):
        return cls.DMK.upload_package(file_path)

    @classmethod
    def upload_oversize_pkg_to_dmk(cls, file_path, dmk_float_ip, dmk_os_business_username,
                                   dmk_os_business_user_password):
        return cls.DMK.upload_pkg_to_dmk(dmk_float_ip, dmk_os_business_username, dmk_os_business_user_password,
                                         file_path)

    @classmethod
    def delete_pkg_from_dmk(cls, pkg_name, pkg_version):
        return cls.DMK.delete_pkg_from_dmk(pkg_name, pkg_version)

    @classmethod
    def get_dmk_account_id(cls, user_name, account_name):
        return cls.DMK.get_dmk_account_id(user_name, account_name)

    @classmethod
    def get_dmk_new_deploy_config(
            cls, component=Component.REPLICATION,
            action=Action.INSTALL_SERVER):
        return cls.DMK.get_dmk_new_deploy_config(component, action)

    @classmethod
    def login_dmk(cls, dmk_ip, user_name, password, dmk_port='8443'):
        return cls.DMK.login_dmk(dmk_ip, user_name, password, dmk_port)

    @classmethod
    def get_dmk_info(cls, pod_id):
        return cls.DMK.get_dmk_info(pod_id)

    @classmethod
    def validate_account(
            cls, account_name, account_id, ips, switch_mode='su'):
        return cls.DMK.validate_account(
            account_name, account_id, ips, switch_mode)

    @classmethod
    def delete_dmk_account(cls, account_id):
        return cls.DMK.delete_dmk_account(account_id)

    @classmethod
    def reset_first_login(cls):
        return cls.DMK.reset_first_login()

    @classmethod
    def dmk_role(cls):
        return DMK_ROLE.GROUP_MANAGER

    @classmethod
    def get_dmk_team_id(cls, team_name):
        return cls.DMK.get_dmk_team_id(team_name)
