# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.dr_api import API as DR_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.conditions import Condition
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.model import DmkInfo, DmkAccountInfo
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.params import Params

logger.init("eReplication")


class PresetDMKUser(BaseSubJob):
    """初始化DMK账户"""

    def __init__(self, project_id, pod_id):
        super(PresetDMKUser, self).__init__(project_id, pod_id)
        self.nodes = Nodes(self.project_id, self.pod_id)
        self.params = Params(self.project_id, self.pod_id)
        self.condition = Condition(self.project_id)

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：执行安装前预检查&安装&配置

        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        if not self.condition.is_primary:
            self._preset_dmk_user(self.params.dmk_float_ip, self.params.dmk_sys_user_pwd, self.nodes.primary_hosts)
            return
        if self.nodes.standby_hosts:
            self._preset_dmk_user_by_region(False)
        self._preset_dmk_user_by_region(True)

    def _preset_dmk_user_by_region(self, is_primary_region):
        current_region_dmk_float_ip = self.params.primary_region_dmk_float_ip \
            if is_primary_region else self.params.standby_region_dmk_float_ip
        current_region_dmk_sys_user_pwd = self.params.primary_region_dmk_sys_user_pwd \
            if is_primary_region else self.params.standby_region_dmk_sys_user_pwd
        current_host_info = self.nodes.primary_hosts if is_primary_region else self.nodes.standby_hosts
        self._preset_dmk_user(current_region_dmk_float_ip, current_region_dmk_sys_user_pwd, current_host_info)

    def _preset_dmk_user(self, dmk_float_ip, dmk_sys_user_pwd, host_info):
        logger.info(f"Begin preset dmk user, dmk_float_ip: {dmk_float_ip}, host_info: {host_info}.")
        dmk_sys_user = self.params.dmk_sys_user
        dmk_deploy_user = self.params.dmk_deploy_user
        dmk_user_preset_pwd = self.params.dmk_user_preset_pwd
        dmk_user_new_pwd = self.params.dmk_user_new_pwd
        dmk_deploy_group = self.params.dmk_deploy_group
        ssh_user = self.nodes.ssh_user
        ssh_pwd = self.nodes.ssh_pwd
        sudo_pwd = self.nodes.sudo_pwd
        team_id = DR_API.create_dmk_login_user(
            DmkInfo(dmk_float_ip, dmk_sys_user, dmk_sys_user_pwd, dmk_deploy_user, dmk_user_preset_pwd,
                    dmk_user_new_pwd, dmk_deploy_group))
        DR_API.create_remote_account(team_id, host_info,
                                     DmkAccountInfo(dmk_deploy_user, ssh_user, ssh_pwd, sudo_pwd, dmk_deploy_group))
