import paramiko
import json
import os
import sys
import time
import requests
import re
import traceback
from functools import wraps
from urllib.parse import quote
from collections import namedtuple, defaultdict
from datetime import datetime, timedelta

import utils.common.log as logger
from plugins.CSBS_VBS.common.scripts.cbs_params import Params
from plugins.CSBS_VBS.common.scripts import cbs_karborclient as karbor_client
from utils.business.param_util import ParamUtil
from utils.security.crypt import decrypt
from platforms.param.ParamManager import ParamService
from plugins.AcceptanceTest.basic_mo_test.common.login_sc import LoginSC

sys.path.append(os.path.realpath(__file__ + '/../../../../..'))
logger.init("VBSLOGS")

VBS_PROVIDER_ID = '1dc03359-1301-467b-9972-1a7599ae791d'
KARBOR_USER = 'djmanager'
KARBOR_USER_PASSWD = 'wd4V/YyIpD+ykbz42ngl2JPvHq1duoLlz5MOhMwyLqYrh7+SaozWF03MSolZiDP2'


def get_region_info(project_id):
    RegionInfo = namedtuple('RegionInfo', ['region_id', 'region_type', 'region_name'])
    db_obj = ParamService()
    project_info = db_obj.get_project_info(project_id)
    region_id = project_info.get('region_id')
    region_type = project_info.get('region_type')
    region_name = LoginSC(project_id, region_id, region_type).get_region_name_and_az_name()[0]
    return RegionInfo(region_id, region_type, region_name)


def get_az_id(project_id, region_info):
    region_id = region_info.region_id
    region_type = region_info.region_type
    az_id = LoginSC(project_id, region_id, region_type).get_az_id()
    return az_id


def remove_sensitive_info(info):
    pattern = r'([a-zA-Z]{3}\d{6})|([a-zA-z]\d{8})'
    return re.sub(pattern, '****', str(info))


def retry(retry_nums=3):
    def decorator(fn):
        @wraps(fn)
        def iner_func(*args, **kwargs):
            retry_count = 0
            while retry_count <= retry_nums:
                try:
                    return fn(*args, **kwargs)
                except Exception as e:
                    retry_count += 1
                    time.sleep(5)
                    logger.error('Failed to run {}, errMsg:{},'
                                 ' start to retry: {}'.format(fn.__name__, str(e), retry_count))
                    continue
            else:
                raise Exception('Over retry error')

        return iner_func

    return decorator


class Login_SC(object):
    def __init__(self, project_id, region_id, region_type="type1"):
        # SC首页的headers，包括cftk,agencid,jsessionid等，在登录过程中更新
        self.bak_global_headers = {"Accept": "*/*",
                                   "X-Language": "zh-cn",
                                   "X-Requested-With": "XMLHttpRequest",
                                   "Connection": "keep-alive",
                                   "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 "
                                                 "(KHTML, like Gecko) Chrome/59.0.3071.104 Safari/537.36",
                                   "Content-Type": "application/json; charset=UTF-8"
                                   }
        # VPC服务的headers，包括cftk,agencid,jsessionid等，在登录过程中更新
        self.global_headers = {
            "Accept": "*/*",
            "X-Language": "zh-cn",
            "X-Requested-With": "XMLHttpRequest",
            "Connection": "keep-alive",
            "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) "
                          "Chrome/59.0.3071.104 Safari/537.36",
            "Content-Type": "application/json; charset=UTF-8"
        }
        self.pro_id = project_id
        self.region_id = region_id
        self.type = region_type
        self.get_test_params(project_id, region_id, region_type)

    def get_test_params(self, project_id, region_id, region_type):
        params = ParamUtil()
        self.console_host = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                              '%s_console_host'
                                                              % region_type, region_id)
        self.iam_host = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                          '%s_iam_host'
                                                          % region_type, region_id)
        self.manage_console_host = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                                     '%s_manage_console_host'
                                                                     % region_type, region_id)
        self.manage_iam_host = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                                 '%s_manage_iam_host'
                                                                 % region_type, region_id)

        self.is_b2b = False
        if self.manage_console_host != self.console_host:
            self.is_b2b = True

    @retry(retry_nums=3)
    def login_sc_on_web(self, console_host, iam_host, user, pwd, region_name):
        try:
            if self.is_b2b and 'bss_admin' in user:
                self.access_url = 'moserviceaccesswebsite'
                user_id, project_id, region_id, \
                self.bak_global_headers, self.global_headers = self.b2bAdmin_login_sc_on_web(console_host, iam_host,
                                                                                             user, pwd, region_name)
            else:
                self.access_url = 'motenantconsolehomewebsite'
                user_id, project_id, region_id, \
                self.bak_global_headers, self.global_headers = self.nonb2b_login_sc_on_web(console_host, iam_host,
                                                                                           user, pwd, region_name)
            return user_id, project_id, region_id, self.bak_global_headers, self.global_headers
        except Exception as e:
            logger.error('Login SC failed!')
            raise e

    def nonb2b_login_sc_on_web(self, console_host, iam_host, user, pwd, region_name):
        try:
            # tenantAuth接口
            tenantAuth_url = "https://{host}/rest/mologin/v3.0/tenantAuth".format(host=iam_host)
            basic_header = {
                "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
                "Accept": "*/*"
            }
            quote_pwd = quote(pwd)
            request_body = "userName={username}&password={password}" \
                           "&verifyCode=&locale=zh-cn&service=https%253A%252F%252F{host}" \
                           "%252Fmotenantconsolehomewebsite%252F".format(username=user, password=quote_pwd,
                                                                         host=console_host)
            resp = requests.post(tenantAuth_url, data=request_body, verify=False, headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            logger.info(response_body)
            if statu_code == 200:
                user = response_body.get("user")
                logger.info(user)
                id = user.get("id")
                logger.info(id)
                thirdLoginurl = response_body.get("url")
                logger.info(thirdLoginurl)
            else:
                raise Exception("login sc failed,/tenantAuth/ response is %s" % response_body)
            logger.info("***** /tenantAuth/ finish *****")
            # thirdLoginurl接口
            basic_header.update(
                {"Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8"})
            resp = requests.get(thirdLoginurl, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                thirdLogin_setcookie = resp.headers.get('set-cookie')
                ticket_location = resp.headers.get('Location')
            else:
                raise Exception("login sc failed,/thirdLoginurl/ statu_code is %s ,expect 302" % (statu_code))
            logger.info("***** /thirdLoginurl/ finish *****")
            # ticket接口
            resp = requests.get(ticket_location, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                ticket_setcookie = resp.headers.get('set-cookie')
            else:
                raise Exception("login sc failed,/ticket/ statu_code is %s ,expect 302" % (statu_code))
            logger.info("***** /ticket/ finish *****")
            # motenantconsolehomewebsite接口
            basic_header.update({"Cookie": ticket_setcookie})
            motenantconsolehomewebsite = "https://{host}/motenantconsolehomewebsite/".format(host=console_host)
            resp = requests.get(motenantconsolehomewebsite, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code != 200:
                raise Exception(
                    "login sc failed,/motenantconsolehomewebsite/ statu_code is %s ,expect 200" % (statu_code))
            # console me接口
            basic_header.update({
                "Cookie": ticket_setcookie,
                "Accept": "*/*",
                "X-Language": "zh-cn",
                "X-Requested-With": "XMLHttpRequest",
                "Content-Type": "application/json; charset=UTF-8",
                "Connection": "keep-alive",
                "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) "
                              "Chrome/59.0.3071.104 Safari/537.36",
            })
            me_url = "https://{host}/motenantconsolehomewebsite/rest/me?salt=0.4070987459363351".format(
                host=console_host)
            resp = requests.get(me_url, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            logger.info(response_body)
            if statu_code == 200:
                me_cftk = response_body.get('cftk')
                project_id = response_body.get('projectId')
                user_id = response_body.get('userId')
                region = response_body.get('region')
                aggencyID = response_body.get('id')
            else:
                raise Exception("login sc failed,/rest/me response is %s" % response_body)
            logger.info("***** /rest/me finish *****")
            basic_header.update({"cftk": me_cftk})
            self.bak_global_headers[
                "Cookie"] = ticket_setcookie
            self.bak_global_headers["cftk"] = me_cftk
            self.bak_global_headers["ProjectName"] = region
            logger.info(self.bak_global_headers)
            cloud_infras = self.get_cloud_infra_and_regionid_by_regionname(console_host, region_name)
            logger.info(cloud_infras)
            self.bak_global_headers["region"] = cloud_infras[0][0]
            region_id = cloud_infras[0][0]
            logger.info(self.bak_global_headers)
            # project CSDR切换project
            projects_url = "https://{host}/motenantconsolehomewebsite/rest/vdc/v3.1/" \
                           "users/{agencyid}/projects?start=0&limit=100&rel_projects=true".format(host=console_host,
                                                                                                  agencyid=aggencyID)
            resp = requests.get(projects_url, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 200 and resp.content:
                response_body = json.loads(resp.content)
                logger.info(response_body)
                projects = response_body.get('projects')
                for project in projects:
                    region_temp = project.get('regions')
                    region_temp_id = region_temp[0].get('region_id')
                    if region_temp_id == region_id:
                        project_id = project.get('id')
                        region = project.get('name')
                        logger.info("***** reset project_id and project_name success")
            # vpc login接口：
            vpc_login_url = "https://{host1}/authui/login?service=https" \
                            "%3A%2F%2F{host}%2Fvpc%2F%3FagencyId%3D{agencyid}" \
                            "%26region%3D{Region}%26locale%3Dzh-cn".format(host1=iam_host, host=console_host,
                                                                           agencyid=aggencyID, Region=region)
            basic_header.update({"Cookie": thirdLogin_setcookie})
            resp = requests.get(vpc_login_url, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            logger.info(resp.headers)
            if statu_code == 302:
                vpc_location = resp.headers.get('Location')
            else:
                raise Exception("login sc failed,/vpc authui/login/ statu_code is %s ,expect 302" % (statu_code))
            logger.info("***** /vpc authui/login/ finish *****")
            # vpc_Jsession获取
            basic_header.update({"Cookie": ticket_setcookie})
            resp = requests.get(vpc_location, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            logger.info(statu_code)
            if statu_code == 302:
                vpc_setcookie = resp.headers.get('set-cookie')
                vpc_J_SESSION_ID_temp1 = vpc_setcookie.split('J_SESSION_ID=')
                vpc_J_SESSION_ID_temp2 = vpc_J_SESSION_ID_temp1[1].split('; Version=1; Path=/; Secure;')
                vpc_J_SESSION_ID = vpc_J_SESSION_ID_temp2[0]
            else:
                raise Exception("login sc failed,/vpc_Jsession/ statu_code is %s ,expect 302" % (statu_code))
            logger.info("***** /vpc_Jsession/ finish *****")
            # vpc me接口
            vpc_me_cookie = ticket_setcookie + ';J_SESSION_ID=' + vpc_J_SESSION_ID
            basic_header.update({
                "Cookie": vpc_me_cookie,
                "AgencyId": aggencyID})
            vpc_me_url = "https://{host}/vpc/rest/me?salt=0.8809960674639905".format(
                host=console_host)
            resp = requests.get(vpc_me_url, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            logger.info(response_body)
            if statu_code == 200:
                vpc_me_cftk = response_body.get('cftk')
            else:
                raise Exception("login sc failed,/vpc/rest/me response is %s" % response_body)
            logger.info("***** /vpc/rest/me finish *****")
            self.global_headers[
                "Cookie"] = vpc_me_cookie
            self.global_headers["cftk"] = vpc_me_cftk
            self.global_headers["AgencyId"] = aggencyID
            self.global_headers["ProjectName"] = region
            self.global_headers["region"] = region_id
            logger.info(self.global_headers)
            logger.info("***** login sc finish *****")
            return user_id, project_id, region_id, self.bak_global_headers, self.global_headers
        except Exception as e:
            logger.error('Login SC failed!')
            raise e

    def b2bAdmin_login_sc_on_web(self, console_host, iam_host, user, pwd, region_name):
        try:
            # tenantAuth接口
            tenantAuth_url = "https://{host}/rest/mologin/v3.0/tenantAuth".format(host=iam_host)
            basic_header = {
                "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
                "Accept": "*/*"
            }
            quote_pwd = quote(pwd)
            request_body = "userName={username}&password={password}" \
                           "&verifyCode=&locale=zh-cn&service=https%253A%252F%252F{host}" \
                           "%252Fmoserviceaccesswebsite%252F".format(username=user,
                                                                     password=quote_pwd,
                                                                     host=console_host)
            resp = requests.post(tenantAuth_url, data=request_body, verify=False, headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            logger.info(response_body)
            if statu_code == 200:
                user = response_body.get("user")
                logger.info(user)
                id = user.get("id")
                logger.info(id)
                thirdLoginurl = response_body.get("url")
                logger.info(thirdLoginurl)
            else:
                raise Exception("login sc failed,/tenantAuth/ response is %s" % response_body)
            logger.info("***** /tenantAuth/ finish *****")
            # thirdLoginurl接口
            basic_header.update(
                {"Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8"})
            resp = requests.get(thirdLoginurl, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                thirdLogin_setcookie = resp.headers.get('set-cookie')
                ticket_location = resp.headers.get('Location')
            else:
                raise Exception("login sc failed,/thirdLoginurl/ statu_code is %s ,expect 302" % (statu_code))
            logger.info("***** /thirdLoginurl/ finish *****")
            # ticket接口
            resp = requests.get(ticket_location, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                ticket_setcookie = resp.headers.get('set-cookie')
                aggencyID_temp1 = ticket_setcookie.split('agencyID=')
                aggencyID_temp2 = aggencyID_temp1[1].split(';Path=/;Secure, J_SESSION_ID=')
                aggencyID = aggencyID_temp2[0]
                J_SESSION_ID_temp1 = aggencyID_temp2[1].split(';Path=/;Secure;HttpOnly')
                J_SESSION_ID = J_SESSION_ID_temp1[0]
            else:
                raise Exception("login sc failed,/ticket/ statu_code is %s ,expect 302" % (statu_code))
            logger.info("***** /ticket/ finish *****")
            # console me接口
            basic_header.update({
                "Cookie": "theme=default; SID=Set2; agencyID={agencyid}; J_SESSION_ID={j_session_id}; "
                          "locale=zh-cn; browserCheckResult=A".format(agencyid=aggencyID, j_session_id=J_SESSION_ID),
                "Accept": "*/*",
                "X-Language": "zh-cn",
                "X-Requested-With": "XMLHttpRequest",
                "Connection": "keep-alive",
                "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) "
                              "Chrome/59.0.3071.104 Safari/537.36",
            })
            me_url = "https://{host}/moserviceaccesswebsite/rest/me?salt=0.4070987459363351".format(
                host=console_host)
            resp = requests.get(me_url, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            logger.info(response_body)
            if statu_code == 200:
                me_cftk = response_body.get('cftk')
                project_id = response_body.get('projectId')
                user_id = response_body.get('userId')
                region = response_body.get('region')
            else:
                raise Exception("login sc failed,/rest/me response is %s" % response_body)
            logger.info("***** /rest/me finish *****")
            basic_header.update({"cftk": me_cftk})
            self.bak_global_headers[
                "Cookie"] = "theme=default; SID=Set2; agencyID={agencyid}; J_SESSION_ID={j_session_id}; " \
                            "locale=zh-cn; browserCheckResult=A".format(agencyid=aggencyID, j_session_id=J_SESSION_ID)
            self.bak_global_headers["cftk"] = me_cftk
            self.bak_global_headers["AgencyId"] = aggencyID
            self.bak_global_headers["ProjectName"] = region
            logger.info(self.bak_global_headers)
            cloud_infras = self.get_cloud_infra_and_regionid_by_regionname(console_host, region_name)
            logger.info(cloud_infras)
            self.bak_global_headers["region"] = cloud_infras[0][0]
            region_id = cloud_infras[0][0]
            logger.info(self.bak_global_headers)
            # vpc login接口：
            vpc_login_url = "https://{host1}/authui/login?service=https%3A%2F%2F{host}" \
                            "%2Fvpc%2F%3FagencyId%3D{agencyid}" \
                            "%26region%3D{Region}%26locale%3Dzh-cn".format(host1=iam_host, host=console_host,
                                                                           agencyid=aggencyID, Region=region)
            basic_header.update({"Cookie": thirdLogin_setcookie})
            resp = requests.get(vpc_login_url, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            logger.info(resp.headers)
            if statu_code == 302:
                vpc_location = resp.headers.get('Location')
            else:
                raise Exception("login sc failed,/vpc authui/login/ statu_code is %s ,expect 302" % (statu_code))
            logger.info("***** /vpc authui/login/ finish *****")
            # vpc_Jsession获取
            resp = requests.get(vpc_location, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            logger.info(statu_code)
            if statu_code == 302:
                vpc_setcookie = resp.headers.get('set-cookie')
                vpc_J_SESSION_ID_temp1 = vpc_setcookie.split('Path=/; Secure, J_SESSION_ID="')
                vpc_J_SESSION_ID_temp2 = vpc_J_SESSION_ID_temp1[1].split(';Path=/;Secure;HttpOnly')
                vpc_J_SESSION_ID = vpc_J_SESSION_ID_temp2[0]
            else:
                raise Exception("login sc failed,/vpc_Jsession/ statu_code is %s ,expect 302" % (statu_code))
            logger.info("***** /vpc_Jsession/ finish *****")
            # vpc me接口
            # vpc 接口的jsessionid需要加双引号
            vpc_J_SESSION_ID_format = '"' + vpc_J_SESSION_ID + '"'
            basic_header.update({
                "Cookie": "theme=default; SID=Set2; agencyID={agencyid}; J_SESSION_ID={j_session_id}; "
                          "locale=zh-cn; browserCheckResult=A".format(agencyid=aggencyID,
                                                                      j_session_id=vpc_J_SESSION_ID_format),
                "AgencyId": aggencyID})
            vpc_me_url = "https://{host}/vpc/rest/me?salt=0.8809960674639905".format(host=console_host)
            resp = requests.get(vpc_me_url, verify=False, allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            logger.info(response_body)
            if statu_code == 200:
                vpc_me_cftk = response_body.get('cftk')
            else:
                raise Exception("login sc failed,/vpc/rest/me response is %s" % response_body)
            logger.info("***** /vpc/rest/me finish *****")
            self.global_headers[
                "Cookie"] = "theme=default; SID=Set2; agencyID={agencyid}; J_SESSION_ID={j_session_id}; " \
                            "locale=zh-cn; browserCheckResult=A".format(agencyid=aggencyID,
                                                                        j_session_id=vpc_J_SESSION_ID_format)
            self.global_headers["cftk"] = vpc_me_cftk
            self.global_headers["AgencyId"] = aggencyID
            self.global_headers["ProjectName"] = region
            self.global_headers["region"] = region_id
            logger.info(self.global_headers)
            logger.info("***** login sc finish *****")
            return user_id, project_id, region_id, self.bak_global_headers, self.global_headers
        except Exception as e:
            logger.error('Login SC failed!')
            raise e

    def get_cloud_infra_and_regionid_by_regionname(self, console_host, region_name="ALL"):
        # 根据region名称获取region_id,cloud_infra_id,cloud_infra_name
        try:
            region_name_filed = "" if region_name == "ALL" else region_name
            url = "https://{host}/{access_url}/goku/rest/" \
                  "serviceaccess/v3.0/regions?name={region}".format(host=console_host,
                                                                    access_url=self.access_url,
                                                                    region=region_name_filed)
            resp = requests.get(url, verify=False, allow_redirects=False, headers=self.bak_global_headers)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            logger.info(response_body)
            if statu_code == 200:
                records = response_body.get("records")
                cloud_infra_list = []
                for region_info in records:
                    name = region_info["name"]
                    if region_name == name:
                        cloud_infras = region_info["cloud_infras"]
                        for cloud_infra in cloud_infras:
                            cloud_infra_temp = []
                            if cloud_infra["type"] == "FUSION_CLOUD":
                                region_id = cloud_infra["region_id"]
                                cloud_infra_id = cloud_infra["id"]
                                cloud_infra_name = cloud_infra["name"]
                                cloud_infra_temp.append(region_id)
                                cloud_infra_temp.append(cloud_infra_id)
                                cloud_infra_temp.append(cloud_infra_name)
                                cloud_infra_list.append(cloud_infra_temp)
                                return cloud_infra_list
                        else:
                            return None
                    elif region_name == "ALL":
                        cloud_infras = region_info["cloud_infras"]
                        for cloud_infra in cloud_infras:
                            cloud_infra_temp = []
                            if cloud_infra["type"] == "FUSION_CLOUD":
                                region_id = cloud_infra["region_id"]
                                cloud_infra_id = cloud_infra["id"]
                                cloud_infra_name = cloud_infra["name"]
                                cloud_infra_temp.append(region_id)
                                cloud_infra_temp.append(cloud_infra_id)
                                cloud_infra_temp.append(cloud_infra_name)
                                cloud_infra_list.append(cloud_infra_temp)
                return cloud_infra_list
            else:
                raise Exception("get cloud infra list failed! response is %s" % response_body)
        except Exception as e:
            logger.error('Get cloud infra list failed!')
            raise e


class VBSBaseAWAdapter(object):
    """
    VBS 基础AW
    """

    def __init__(self, project_id):
        console = VBSBaseConsoleAdapter(project_id)
        console.login_sc()
        self.region_type = console.region_type
        self.region_id = console.region
        self.az = console.az_id
        self.region_name = console.region_name
        self.project_id = console.project_id
        self.product_id = console.product_id
        self.project_id_evs = console.product_id_evs
        self.project_name = console.project_name
        self.volume_type_list = console.volume_type_list
        self.console = console
        params = ParamUtil()
        self.volume_type = None
        self.headers = {"Content-Type": "application/json;charset=UTF-8"}
        self.openstack_api_version = "v2"
        self.iam_version = "v3"
        self.session = requests.Session()
        self.session.trust_env = False
        self.session.proxies = None
        self.session.verify = False
        self.token = None
        self.karbor_user = params.get_value_from_cloud_param(project_id, 'CSBS-VBS',
                                                             'karbor_djmanager_username',
                                                             self.region_id) or KARBOR_USER
        self.karbor_user_passwd = params.get_value_from_cloud_param(project_id,
                                                                    'CSBS-VBS',
                                                                    'karbor_djmanager_pwd',
                                                                    self.region_id) or decrypt(KARBOR_USER_PASSWD)
        self.karbor_root_passwd = params.get_value_from_cloud_param(project_id,
                                                                    'CSBS-VBS',
                                                                    'karbor_root_pwd',
                                                                    self.region_id)
        self.set_karbor_ips(project_id)
        self.auth_domain = "https://" + params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                                          '%s_iam_host' % self.region_type,
                                                                          self.region_id)
        self.port = "8799"
        self.userName = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                          '%s_vdc1_vsm_user1' % self.region_type,
                                                          self.region_id)
        self.userPwd = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                         '%s_sc_user_new_password' % self.region_type,
                                                         self.region_id)
        self.tenantName = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                            '%s_vdc1_name' % self.region_type,
                                                            self.region_id)
        self.cascading_region = params.get_value_from_cloud_param(project_id, "OpenStack",
                                                                  "openstack_region",
                                                                  self.region_id)
        self.cascading_domain = params.get_value_from_cloud_param(project_id, "OpenStack",
                                                                  "openstack_domain",
                                                                  self.region_id)
        self.nova_url = "https://compute." + self.cascading_region + "." + self.cascading_domain + ":443"
        self.cinder_url = "https://volume." + self.cascading_region + "." + self.cascading_domain + ":443"
        temp_host = '[' + self.host + ']' if self.host.__contains__(':') else self.host
        self.base_url = "https://{host}:{port}".format(host=temp_host, port=self.port)
        self.provider_id = params.get_value_from_cloud_param(project_id,
                                                             'CSBS-VBS',
                                                             'vbs_provider_id',
                                                             self.region_id) or VBS_PROVIDER_ID

        self.KarBor_Info = [self.karbor_host_ip, self.karbor_user, self.karbor_user_passwd]
        self.volume1_name = 'vbs_disk'
        self.volume1_id = None
        self.volume_size = 1
        self.karbor_timezone = None

    def set_karbor_ips(self, project_id):
        params = Params(project_id, project_id, 'CSBS-VBS', self.region_id)
        karbor1_ip = params.get_vm_ips()['karbor_host0']
        logger.info('Ssh to karbor node: {}'.format(karbor1_ip))
        node = karbor_client.CBSNode(karbor1_ip, self.karbor_user,
                                     self.karbor_user_passwd, self.karbor_root_passwd)
        ssh_client = karbor_client.get_sshclient_user_su_root(node)
        cmds = 'get_info.py --tenant_float_ip'
        logger.info('Cmd: {}'.format(cmds))
        result = karbor_client.ssh_exec_command_return(ssh_client, cmds)
        if not karbor_client.is_ssh_cmd_executed(result):
            msg = "Failed to execute cmd: {}".format(cmds)
            logger.error(msg)
            raise Exception(msg)
        logger.info('Get karbor float ip info: {}'.format(result))
        karbor_float_ip = result[0].strip()
        self.host = karbor_float_ip
        self.karbor_host_ip = karbor1_ip

    def close_session(self):
        """关闭session

        返 回 值:None。
        """
        if self.session is None:
            logger.info("Currently no Session can be closed")
        else:
            self.session.close()
            logger.info("Currently Session has successfully closed")

    def _pre_process(self, kwargs):
        """HTTP请求提交之前的预处理，主要是设置headers"""
        if self.headers is None:
            raise Exception("Please Login first.")
        return kwargs.update({"headers": self.headers})

    @staticmethod
    def _post_process(response):
        """对HTTP响应进行处理"""
        if response.ok:
            if len(response.text) > 0:
                ret = json.loads(response.text)
            else:
                ret = response.text
            return ret
        else:
            if "errorCode" in response.text:
                text_dict = json.loads(response.text)
                error_code = text_dict.get('errorCode')
                logger.info(error_code)
                raise Exception("Failed requesting, error code:{i};response:{j}".format(i=error_code, j=text_dict))
            else:
                error_msg = response.text
                logger.info(error_msg)
                raise Exception("Failed requesting, response: {j}".format(j=error_msg))

    def _get(self, url, **kwargs):
        self._pre_process(kwargs)
        response = self.session.get(url, **kwargs)
        resp_body = self._post_process(response)
        return resp_body

    def _post(self, url, data=None, json=None, **kwargs):
        """submit a request with POST method."""
        self._pre_process(kwargs)
        response = self.session.post(url, data=data, json=json, **kwargs)
        return self._post_process(response)

    def _put(self, url, data, **kwargs):
        """submit a request with PUT method."""
        self._pre_process(kwargs)
        response = self.session.put(url, data, **kwargs)
        return self._post_process(response)

    def _delete(self, url, **kwargs):
        """submit a request with DELETE method."""
        self._pre_process(kwargs)
        response = self.session.delete(url, **kwargs)
        return self._post_process(response)

    def login_iam(self):
        """
        :return:
        """
        iam_url = "%s/%s/auth/tokens" % (self.auth_domain, self.iam_version)
        params = '{"auth": { "identity": { "methods": [ "password" ], "password": {  "user": {'
        params = params + '"name":"' + self.userName + '",'
        params = params + '"password":"' + self.userPwd + '",'
        params = params + '"domain":{' + '"name":"' + self.tenantName + '"}}}}' + ","
        if self.project_name is not None:
            # 不推荐project Name来认证是因为传参的project Name并不是SC界面上显示的，而是“STD_{region ID}_名称”.
            projectName = self.project_name
            params = params + '"scope":{' + '"project":{' + '"name":"' + projectName + '"}}' + ","
        elif self.project_id is not None:
            # 推荐方式
            params = params + '"scope":{' + '"project":{' + '"id":"' + self.project_id + '"}}' + ","
        else:
            # 某些接口需要指定project的权限的token才可以调用（VDC）
            params = params + '"scope":{' + '"domain":{' + '"name":"' + self.tenantName + '"}}' + ","
        params = params.rstrip(',')
        params = params + '}}'
        ret = self.session.request(method="post", url=iam_url, headers=self.headers, data=params)
        self.token = ret.headers['X-Subject-Token']
        logger.info(self.token)
        self.headers['X-Auth-Token'] = ret.headers['X-Subject-Token']
        res = json.loads(ret.text)
        return ret.status_code, res

    def create_volume_by_backup(self, backup_id, vol_name, count=1):
        """通过备份副本创建云硬盘
            tenant_id:租户id
            backup_id：备份副本id
            availability_zone：可用分区
            vol_name：卷名
            volume_type：卷类型
            count：创建卷数量
        """
        url = "%s/v2/{tenant_id}/cloudvolumes".format(tenant_id=self.project_id) % self.cinder_url
        body_dict = {
            "volume": {
                "backup_id": backup_id,
                "count": count,
                "availability_zone": self.az,
                "name": vol_name,
                "volume_type": self.volume_type
            }
        }
        return self._post(url, json=body_dict)

    def list_all_volumes_by_volName(self, volname):
        """获取租户下所有卷
        """
        url = "%s/v2/{tenant_id}/volumes?name={name}".format(tenant_id=self.project_id, name=volname) % self.cinder_url
        return self._get(url)

    def list_servers(self):
        """查询当前租户的所有虚拟机
        """
        url = "%s/v2/{tenant_id}/servers".format(tenant_id=self.project_id) % self.nova_url
        return self._get(url)

    def get_volume_info_by_volume_id(self, volume_id):
        url = '%s/v2/{project_id}/volumes/{volume_id}'. \
                  format(project_id=self.project_id, volume_id=volume_id) % self.cinder_url
        response = self._get(url)
        return response

    def get_all_volumes_info(self):
        url = '%s/v2/{project_id}/volumes'.format(project_id=self.project_id) % self.cinder_url
        response = self._get(url)
        return response

    def Structure_params_quota_vbs(self, type, number):

        dict = None
        if type == "volume_backup_capacity":
            dict = {"count": 1,
                    "param_items": [{"type": "volume_backup_capacity", "quota": number}],
                    "display": {"en_US": [{"label": "Backup", "type": "string", "value": "xx"}],
                                "zh_CN": [{"label": "备份", "type": "string", "value": "xx"}]}
                    }
        if type == "volume_copy_capacity":
            dict = {"count": 1,
                    "param_items": [{"type": "volume_copy_capacity", "quota": number}],
                    "display": {"en_US": [{"label": "Replication", "type": "string", "value": "xx"}],
                                "zh_CN": [{"label": "复制", "type": "string", "value": "xx"}]}
                    }

        dict = json.dumps(dict)
        return dict

    @retry(retry_nums=3)
    def modify_quota(self, service_type, params):
        """修改配额容量

        :param project_id:
        :param service_type:
        :param region_id:
        :param product_id:
        :return:
        """
        url = "%s/v1/{project_id}/products/{product_id}/action".format(project_id=self.project_id,
                                                                       product_id=self.product_id) % self.base_url
        body = {
            "apply": {
                "service_type": service_type,
                "region_id": self.region_id,
                "params": params
            }
        }

        return self._post(url, json=body)

    def ADD_QUOTA(self, quota_num):
        logger.info("Start increasing backup space")
        param = self.Structure_params_quota_vbs("volume_backup_capacity", quota_num)
        self.modify_quota("vbs", param)
        logger.info("Succeed increasing backup space")

    def Mu_QUOTA(self, quota_num):
        logger.info("Start decreasing backup space")
        param = self.Structure_params_quota_vbs("volume_backup_capacity", -quota_num)
        self.modify_quota("vbs", param)
        logger.info("Succeed decreasing backup space")

    def ADD_QUOTA_Copy(self, quota_num):
        logger.info("Start increasing replication space")
        param = self.Structure_params_quota_vbs("volume_copy_capacity", quota_num)
        self.modify_quota("vbs", param)
        logger.info("Succeed increasing replication space")

    def Mu_QUOTA_Copy(self, quota_num):
        logger.info("Start decreasing replication space")
        param = self.Structure_params_quota_vbs("volume_copy_capacity", -quota_num)
        self.modify_quota("vbs", param)
        logger.info("Succeed decreasing replication space")

    def create_data_volume(self, volume_name, multiattach=False, size=None, attach_status="detached"):
        """
            创建数据卷（共享或不共享）
            size：大小
            name：卷名
            volume_type：卷类型
            multiattach:共享卷标志位  Boolean类型
        """
        url = '%s/v2/{project_id}/volumes'.format(project_id=self.project_id) % self.cinder_url
        if multiattach is False:
            data = {"volume": {"multiattach": multiattach, "availability_zone": self.az,
                               "size": size, "name": volume_name, "volume_type": self.volume_type}}
            res = self._post(url, json=data)
            return res["volume"]["id"]
        elif multiattach is True:
            data = {"volume": {"multiattach": multiattach, "availability_zone": self.az,
                               "size": size, "name": volume_name, "volume_type": self.volume_type}}
            res = self._post(url, json=data)
            return res["volume"]["id"]

    def delete_volume_by_id(self, volume_id):
        url = "%s/v2/{project_id}/volumes/{volume_id}". \
                  format(project_id=self.project_id, volume_id=volume_id) % self.cinder_url
        return self._delete(url)

    def create_plan_include_backup_copy_fullbackup_auto(self, plan_name, resources, max_backups_backup=10,
                                                        max_backups_copy=10, max_backups_fullbackup=10,
                                                        Scheduling_name_backup="", Scheduling_name_copy="",
                                                        Scheduling_name_fullbackup="", is_exe_policy=False,
                                                        expired_time="", trigger_pattern_backup="",
                                                        trigger_pattern_copy="", trigger_pattern_fullbackup="",
                                                        is_enabled_backup=False, is_enabled_copy=False,
                                                        is_enabled_fullbackup=False):

        """创建包含增量备份、全量备份和复制策略的计划
        :param project_id:
        :param provider_id:
        :param plan_name:
        :param resources:
        :param max_backups_backup:
        :param max_backups_copy:
        :param Scheduling_name_backup:
        :param Scheduling_name_copy:
        :param is_exe_policy:
        :param expired_time:
        :param trigger_pattern_backup:
        :param trigger_pattern_copy:
        :param is_enabled_backup:
        :param is_enabled_copy:
        :return:

        """

        url = "%s/v1/{project_id}/policies".format(project_id=self.project_id) % self.base_url
        if is_exe_policy:
            body_dict = {
                "policy": {
                    "name": plan_name,
                    "description": "",
                    "provider_id": self.provider_id,
                    "parameters": {
                        "common": {
                            "az": self.az,
                            "expired_at": expired_time
                        }
                    },
                    "scheduled_operations": [
                        {
                            "name": Scheduling_name_backup,
                            "description": "",
                            "enabled": is_enabled_backup,
                            "operation_definition": {
                                "max_backups": max_backups_backup
                            },
                            "trigger": {
                                "properties": {
                                    "pattern": trigger_pattern_backup
                                }
                            },
                            "operation_type": "backup"
                        },
                        {
                            "name": Scheduling_name_fullbackup,
                            "description": "",
                            "enabled": is_enabled_fullbackup,
                            "operation_definition": {
                                "max_backups": max_backups_fullbackup
                            },
                            "trigger": {
                                "properties": {
                                    "pattern": trigger_pattern_fullbackup
                                }
                            },
                            "operation_type": "full_backup"
                        }
                    ],
                    "resources": resources
                }
            }
        else:
            body_dict = {
                "policy": {
                    "name": plan_name,
                    "description": "my plan",
                    "provider_id": self.provider_id,
                    "parameters": {},
                    "resources": resources
                }
            }
        return self._post(url, json=body_dict)

    def change_backupplan(self, policy_id, modify_body):
        """修改备份计划
        """
        url = "%s/v1/{project_id}/policies/{policy_id}".format(project_id=self.project_id,
                                                               policy_id=policy_id) % self.base_url
        body_dict = json.dumps(modify_body)
        return self._put(url, body_dict)

    def VBS_ChangeBackupPlan_ChangeBackupPlanNormal(self, service_id, az="az1.dc1", **kwargs):
        """修改备份计划，并检查修改后信息与预期一致

        输入参数:

        - dj_ip: 登录dj的IP地址
        - dj_user: 登录dj的用户名
        - dj_password: 登录dj的密码
        - tenant_id: 租户ID bn
        - service_id: 备份计划ID

        kwargs:可选参数对象,以键值对的形式输入“key=value”:
        - name:备份计划的名称
        - description:备份计划的描述信息
        - parameters:备份参数（备份计划过期时间）
        - resources:备份资源
        - maxbackups:自动备份的最大副本数，整数
        - duration:备份副本保留的天数，取值为1-99999整数
        - pattern:触发时间设置"BEGIN:VCALENDAR\r\nBEGIN:VEVENT\r\nRRULE:FREQ={FREQ};BYDAY={BYDAY};BYHOUR={BYHOUR};BYMINUTE={BYMINUTE}\r\nEND:VEVENT\r\nEND:VCALENDAR\r\n"，其中FREQ，BYDAY，BYHOUR，BYMINUTE是需要修改的项
        - operationtype:备份类型backup或者copy或者full_backup
        注意：
        选择修改对象取值:
        - 修改name或者description:传值方式"name=wf_plan"
        - 修改parameters:传值方式“expired_at=2017-04-12T14:20:02
        - 修改resources:需要修改的备份主机，可以通过self.common_get_server_type获取对应的值“resources=获取的值”
        - 修改scheduled_operation对象:可输入的参数值有:max_backups,pattern,retention_duration_days,operation_type
        | maxbackups=["id",20] | # id为调度策略的id，创建备份计划时返回
        | duration=[id,20] |
        | pattern=[id,"BEGIN:VCALENDAR\r\nBEGIN:VEVENT\r\nRRULE:FREQ={FREQ};BYDAY={BYDAY};BYHOUR={BYHOUR};BYMINUTE={BYMINUTE}\r\nEND:VEVENT\r\nEND:VCALENDAR\r\n"] |
        返 回 值:无
        异常描述:获取的信息与预期不符
        使用方法及范例:
        修改历史:
        """
        # 参数体构造
        modify_dict = {}
        key = None
        if kwargs:
            for key in kwargs:
                if key == "name":
                    modify_dict[key] = kwargs[key]
                elif key == "description":
                    modify_dict[key] = kwargs[key]
                elif key == "parameters":
                    parameters = {
                        "common": {
                            # "az":az,
                            "expired_at": kwargs[key]
                        }
                    }
                    modify_dict[key] = parameters
                elif key == "resources":
                    modify_dict[key] = kwargs[key]
                elif key == "maxbackups":
                    modify_dict = {"scheduled_operations": [
                        {
                            'enabled': True,
                            "operation_definition": {
                                "max_backups": kwargs[key][1],
                            },
                            "id": kwargs[key][0]
                        }
                    ]}

                elif key == "maxbackups_copy":
                    modify_dict = {"scheduled_operations": [
                        {
                            'enabled': True,
                            "operation_definition": {
                                "max_backups": kwargs[key][1],
                            },
                            "id": kwargs[key][0]
                        }
                    ]}

                elif key == "duration":
                    modify_dict = {
                        "parameters": {"common": {"az": az}},
                        "scheduled_operations": [
                            {'enabled': True,
                             "operation_definition": {"max_backups": -1, "retention_duration_days": kwargs[key][1]},
                             "id": kwargs[key][0]}
                        ]}
                elif key == "operationtype":
                    modify_dict = {"scheduled_operations": [{"operation_type": kwargs[key][1], "id": kwargs[key][0]}]}
                elif key == "pattern":
                    modify_dict = {
                        "scheduled_operations": [
                            {
                                'enabled': True,
                                "trigger": {
                                    "properties": {
                                        "pattern": kwargs[key][1]
                                    }
                                },
                                "id": kwargs[key][0]
                            }
                        ]
                    }
                else:
                    modify_dict[key] = kwargs[key]
        modify_body = {"policy": modify_dict}
        logger.info("The backup plan is modified to be: %s" % str(modify_body))
        # 1、修改备份
        try:
            logger.info("Start modifying the backup plan...")
            self.change_backupplan(service_id, modify_body)
            logger.info("Succeed modifying the backup plan")
        except RuntimeError as e:
            logger.info(e)
            self.close_session()
            raise Exception("Failed modifying the backup plan, errMsg:{}".format(e))
        # 查看备份计划是否修改成功
        try:
            logger.info("Start getting backup plan's details")
            plan_info = self.get_backupplan_detail(service_id)
            logger.info("Succeed getting backup plan's details")
        except RuntimeError as e:
            logger.info(e)
            self.close_session()
            raise Exception("Failed getting backup plan's details, errMsg:{}".format(e))

        return plan_info

    def get_backupplan_detail(self, policy_id):
        """获取备份计划详情

        输入参数:
        - project_id：
        - policy_id：备份计划ID

        返 回 值:
        | {
        |     "policy": {
        |         "created_at": "2017-03-07T09:31:08.265000",
        |         "description": "My plan",
        |         "id": "27b11f3f-578d-4464-89d1-7c6d5894f753",
        |         "name": "my-plan",
        |         "parameters": {
        |             "common": {
        |                 "expired_at": "2016-12-31T18:00:00"
        |             }
        |         },
        |         "project_id": "tenant",
        |         "provider_id": "c714180d-ea34-4b13-9a5e-577c7c416eec",
        |         "resources": [
        |             {
        |                 "id": "45baf976-c20a-4894-a7c3-c94b7376bf55",
        |                 "name": "resource1",
        |                 "type": "OS::Nova::Server"
        |             },
        |             {
        |                 "id": "5aa119a8-d25b-45a7-8d1b-88e127885635",
        |                 "name": "resource2",
        |                 "type": "OS::Nova::Server"
        |             }
        |         ],
        |         "scheduled_operations": [
        |             {
        |                 "description": "My backup policy",
        |                 "enabled": true,
        |                 "id": "3b2fdf8c-2cc2-4887-9605-a8443922f6f2",
        |                 "name": "my-backup-policy",
        |                 "operation_definition": {
        |                     "max_backups": "20",
        |                     "policy_id": "27b11f3f-578d-4464-89d1-7c6d5894f753",
        |                     "provider_id": "c714180d-ea34-4b13-9a5e-577c7c416eec"
        |                 },
        |                 "operation_type": "backup",
        |                 "trigger": {
        |                     "id": "f1246246-ec6a-4e9a-917e-d050dc2808c9",
        |                     "name": "default",
        |                     "properties": {
        |                         "pattern": "BEGIN:VCALENDAR\r\nBEGIN:VEVENT\r\nRRULE:FREQ=WEEKLY;BYDAY=TH;BYHOUR=12;BYMINUTE=27\r\nEND:VEVENT\r\nEND:VCALENDAR\r\n",
        |                         "start_time": "2017-03-07 09:31:08"
        |                     },
        |                     "type": "time"
        |                 },
        |                 "trigger_id": "f1246246-ec6a-4e9a-917e-d050dc2808c9"
        |             }
        |         ],
        |         "status": "suspended"
        |     }
        | }

        异常描述:返回错误码

        使用方法及范例:

        修改历史:

        """
        url = "%s/v1/{project_id}/policies/{policy_id}".format(project_id=self.project_id,
                                                               policy_id=policy_id) % self.base_url
        return self._get(url)

    def Check_polices_host(self, policy_id, vmid):
        """
       检查某个云硬盘是否存在策略中
        :return:
        """
        try:
            logger.info("Start getting backup plan's details")
            re = self.get_backupplan_detail(policy_id=policy_id)
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed getting backup plan's details, errMsg:{}".format(e))
        if vmid in str(re):
            logger.info("Volume is present in the policy")
        else:
            raise Exception("Volume is not present in the policy, please check!")

    def Check_deleteVolume(self, policy_id, vmid):
        """
        检查某个云硬盘是否从策略中删除
        :return:
        """
        try:
            logger.info("Start getting backup plan's details")
            re = self.get_backupplan_detail(policy_id=policy_id)
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed getting backup plan's details, errMsg:{}".format(e))
        if vmid not in str(re):
            logger.info("Volume is not present in the policy")
        else:
            raise Exception("Volume is present in the policy, please check!")

    def delete_image(self, checkpoint_id):
        """删除副本
        """
        url = "%s/v1/{project_id}/providers/{provider_id}" \
              "/checkpoints/{checkpoint_id}".format(project_id=self.project_id,
                                                    provider_id=self.provider_id,
                                                    checkpoint_id=checkpoint_id) % self.base_url
        return self._delete(url)

    def backup(self, policy_id, resources, auto_trigger=False, incremental=True):
        """执行备份
        """

        url = "%s/v1/{project_id}/providers/{provider_id}/checkpoints". \
                  format(project_id=self.project_id, provider_id=self.provider_id) % self.base_url
        body_dict = {
            "checkpoint": {
                "plan_id": policy_id,
                "parameters": {
                    "auto_trigger": auto_trigger,
                    "resources": resources,
                    "incremental": incremental
                }
            }
        }
        return self._post(url, json=body_dict)

    def copy_backupimage(self, policy_id, auto_trigger=False):
        """拷贝备份副本

        输入参数:
        - project_id:租户id
        - provider_id:提供商id
        - policy_id:备份计划id
        - auto_trigger:true or false
        异常描述:返回错误码

        使用方法及范例:

        修改历史:
        """
        url = "%s/v1/{project_id}/providers/{provider_id}/" \
              "checkpoints/action".format(project_id=self.project_id,
                                          provider_id=self.provider_id) % self.base_url

        body_dict = {
            "copy": {
                "policy_id": policy_id,
                "auto_trigger": auto_trigger
            }
        }

        return self._post(url, json=body_dict)

    def restore(self, checkpoint_id, checkpoint_item_id, targets):
        """恢复备份副本

        输入参数:

        - project_id：
        - provider_id：
        - checkpoint_id：
        - checkpoint_item_id：
        - server_id：
        - volume_list：恢复的卷列表
        | "volumes": [{
        |                     "backup_id": backup_id,
        |                     "volume_id": volume_id
        |                 }，……]

        返 回 值:返回成功

        异常描述:返回错误码

        使用方法及范例:

        修改历史:

        """
        url = "%s/v1/{project_id}/restores".format(project_id=self.project_id) % self.base_url

        body_dict = {
            "restore": {
                "provider_id": self.provider_id,
                "checkpoint_id": checkpoint_id,
                "parameters": {
                    "checkpoint_item_id": checkpoint_item_id,
                    "power_on": True,
                    "targets": targets
                }
            }
        }
        return self._post(url, json=body_dict)

    def delete_backupplan(self, policy_id):
        """删除备份计划

        输入参数:
        - poject_id:租户id
        - policy_id:备份计划id

        返 回 值:返回成功

        异常描述:返回错误码

        使用方法及范例:

        修改历史:

        """
        url = "%s/v1/{project_id}/policies/{policy_id}".format(project_id=self.project_id,
                                                               policy_id=policy_id) % self.base_url
        return self._delete(url)

    def get_image_detail(self, checkpoint_item_id):
        """获取拷贝副本信息

        输入参数:

        - project_id：
        - checkpoint_item_id:备份副本的id，可以从执行备份的返回值中获取

        异常描述:返回错误码

        使用方法及范例:

        修改历史:


        """
        url = "%s/v1/{project_id}/checkpoint_items/" \
              "{checkpoint_item_id}".format(project_id=self.project_id,
                                            checkpoint_item_id=checkpoint_item_id) % self.base_url
        return self._get(url)

    def get_image_list(self):
        """获取拷贝副本列表

        输入参数:

        - project_id:租户id
        异常描述:返回错误码

        使用方法及范例:

        修改历史:


        """
        url = "%s/v1/{project_id}/checkpoint_items?resource_type=OS::Cinder::Volume".format(
            project_id=self.project_id) % self.base_url
        return self._get(url)

    def wait_volume_until_status(self, volume_id, status="available"):
        try:
            sys_vol_info = self.get_volume_info_by_volume_id(volume_id)
            sys_volume_status = sys_vol_info["volume"]["status"]
            count = 0
            while sys_volume_status != status:
                time.sleep(15)
                sys_vol_info = self.get_volume_info_by_volume_id(volume_id)
                sys_volume_status = sys_vol_info["volume"]["status"]
                logger.info("The volume's state is:{i} ".format(i=sys_volume_status))
                count = count + 1
                if count > 60:
                    raise Exception("Time out to get volume's status, please check!")
                if sys_volume_status == "error":
                    raise Exception("The status of the volume is error, please check")
            else:
                logger.info("The volume's state is {i}".format(i=status))
                logger.info("volume_id = {i}".format(i=volume_id))
        except RuntimeError as e:
            raise Exception("Failed to get volume's status , errMsg: {i} ".format(i=e))

    def wait_volume_until_delete(self, volume_id):
        logger.info('start to get all volumes info')
        resp = self.get_all_volumes_info()
        if not resp['volumes']:
            logger.info('there is no volume of the tenant,succeed to delete the volume:%s' % volume_id)
            return True
        for volume_info in resp['volumes']:
            if volume_info['id'] == volume_id:
                try:
                    while True:
                        time.sleep(10)
                        volume_info = self.get_volume_info_by_volume_id(volume_id)
                        volume_status = volume_info["volume"]["status"]
                        if volume_status == 'error_deleting':
                            logger.info('failed to delete the volume, volume_id:%s' % volume_id)
                            raise Exception('failed to delete the volume,please check!')
                        if volume_status == 'deleting':
                            logger.info('the volume is deleting!')
                            continue
                except Exception as e:
                    if str(volume_id) + ' could not be found' in str(e):
                        logger.info('succeed to delete the volume:%s' % volume_id)
                        return True
                    logger.error('failed to delete the volume:%s' % volume_id)
                    raise e
        logger.info('can not find the volume:%s in the volumes, succeed to delete the volume' % volume_id)
        return True

    def create_volume_data(self):
        volume_id = None
        try:
            logger.info("Start creating a data volume")
            volume_id = self.create_data_volume(self.volume1_name, size=self.volume_size)
            logger.info("Creating a data volume task was issued successfully")
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed creating a data volume, errMsg:{}".format(e))
        logger.info("Wait for creating data volume to be complete")
        self.wait_volume_until_status(volume_id)
        return volume_id

    def delete_volume(self, volume_id):
        try:
            logger.info("Start deleting a volume")
            self.delete_volume_by_id(volume_id)
            time.sleep(5)
            logger.info("Succeed deleting a volume")
        except Exception as e:
            logger.info(e)

    def VBS_create_plan_include_backup_copy_fullbackup_auto(self, source_list, plan_name,
                                                            max_backups_backup=20, max_backups_copy=20,
                                                            max_backups_fullbackup=20,
                                                            Scheduling_name_backup="Scheduling_name_backup",
                                                            Scheduling_name_copy="Scheduling_name_copy",
                                                            Scheduling_name_fullbackup="Scheduling_name_fullbackup",
                                                            expired_time=5,
                                                            pattern_FREQ_backup="WEEKLY", pattern_FREQ_copy="WEEKLY",
                                                            pattern_FREQ_fullbackup="WEEKLY",
                                                            pattern_BYDAY_backup="MO", pattern_BYDAY_copy="MO",
                                                            pattern_BYDAY_fullbackup="MO",
                                                            pattern_BYHOUR_backup="10", pattern_BYHOUR_copy="10",
                                                            pattern_BYHOUR_fullbackup="10",
                                                            pattern_BYMINUT_backup="20", pattern_BYMINUT_copy="20",
                                                            pattern_BYMINUT_fullbackup="20",
                                                            is_enable_backup=True, is_enable_copy=True,
                                                            is_enable_fullbackup=True
                                                            ):

        """创建包含增量备份、全量备份策略和复制策略的计划

        :param tenant_id:租户ID
        :param provider_id:供应商ID
        :param vmname:虚拟机名称
        :param plan_name:计划名称
        :param max_backups_backup:备份策略最大副本数
        :param max_backups_copy:复制策略最大副本数
        :param Scheduling_name_backup:备份策略的名字
        :param Scheduling_name_copy:复制策略的名字
        :param expired_time:
        :param pattern_FREQ_backup:
        :param pattern_FREQ_copy:
        :param pattern_BYDAY_backup:
        :param pattern_BYDAY_copy:
        :param pattern_BYHOUR_backup:
        :param pattern_BYHOUR_copy:
        :param pattern_BYMINUT_backup:
        :param pattern_BYMINUT_copy:
        :param is_enable_backup:
        :param is_enable_copy:
        :param vmtype:
        :return:

        """
        # 构造计划的过期时间
        dt = datetime.now() + timedelta(expired_time)
        expired_time_str = dt.strftime("%Y-%m-%dT%H:%M:%S")
        # 构造备份执行侧策略：
        trigger_pattern_backup = "BEGIN:VCALENDAR\r\nBEGIN:VEVENT\r\nRRULE:FREQ={FREQ};" \
                                 "BYDAY={BYDAY};BYHOUR={BYHOUR};BYMINUTE={BYMINUTE}\r\n" \
                                 "END:VEVENT\r\nEND:VCALENDAR\r\n".format(FREQ=pattern_FREQ_backup,
                                                                          BYDAY=pattern_BYDAY_backup,
                                                                          BYHOUR=pattern_BYHOUR_backup,
                                                                          BYMINUTE=pattern_BYMINUT_backup)
        # 构造复制执行侧策略：
        trigger_pattern_copy = "BEGIN:VCALENDAR\r\nBEGIN:VEVENT\r\nRRULE:FREQ={FREQ};" \
                               "BYDAY={BYDAY};BYHOUR={BYHOUR};BYMINUTE={BYMINUTE}\r\n" \
                               "END:VEVENT\r\nEND:VCALENDAR\r\n".format(FREQ=pattern_FREQ_copy,
                                                                        BYDAY=pattern_BYDAY_copy,
                                                                        BYHOUR=pattern_BYHOUR_copy,
                                                                        BYMINUTE=pattern_BYMINUT_copy)
        trigger_pattern_fullbackup = "BEGIN:VCALENDAR\r\nBEGIN:VEVENT\r\nRRULE:FREQ={FREQ};" \
                                     "BYDAY={BYDAY};BYHOUR={BYHOUR};BYMINUTE={BYMINUTE}\r\n" \
                                     "END:VEVENT\r\nEND:VCALENDAR\r\n".format(FREQ=pattern_FREQ_backup,
                                                                              BYDAY=pattern_BYDAY_fullbackup,
                                                                              BYHOUR=pattern_BYHOUR_fullbackup,
                                                                              BYMINUTE=pattern_BYMINUT_fullbackup)
        # 判断构建计划的类型
        # 创建备份计划
        try:
            logger.info("Start creating a backup plan that sets up a scheduling policy...")
            ret = self.create_plan_include_backup_copy_fullbackup_auto(plan_name, source_list,
                                                                       max_backups_backup=max_backups_backup,
                                                                       max_backups_copy=max_backups_copy,
                                                                       max_backups_fullbackup=max_backups_fullbackup,
                                                                       Scheduling_name_backup=Scheduling_name_backup,
                                                                       Scheduling_name_copy=Scheduling_name_copy,
                                                                       Scheduling_name_fullbackup=Scheduling_name_fullbackup,
                                                                       expired_time=expired_time_str,
                                                                       trigger_pattern_backup=trigger_pattern_backup,
                                                                       trigger_pattern_copy=trigger_pattern_copy,
                                                                       trigger_pattern_fullbackup=trigger_pattern_fullbackup,
                                                                       is_enabled_backup=is_enable_backup,
                                                                       is_enabled_copy=is_enable_copy,
                                                                       is_enabled_fullbackup=is_enable_fullbackup,
                                                                       is_exe_policy=True)
            logger.info("Expected results: The backup plan was successfully created")
        except RuntimeError as e:
            logger.info(e)
            self.close_session()
            raise Exception("Failed to create the backup plan, errMsg:{}".format(e))
            # 校验备份计划的信息是否正确
        if ret["policy"]["name"] == plan_name and ret["policy"]["resources"] == source_list:
            logger.info("Backup plan creating results information is consistent with expectations, "
                        "the backup plan name is: {}, The name of the backeup's resource: {},"
                        "Backup schedule expiration time: {}".format(plan_name, source_list, expired_time_str))
        else:
            raise Exception("The backup plan created doesn't match the actual backup plan information, "
                            "please check!")
        # 获取计划id
        plan_id = ret["policy"]["id"]
        scheduled_id_list = []
        # schedule_id 按照 bakcup,fullbackup,copy的顺序排列，存入scheduled_id_list列表
        for scheduled_operations_info in ret["policy"]["scheduled_operations"]:
            if scheduled_operations_info["operation_type"] == "backup":
                scheduled_id_list.append(scheduled_operations_info["id"])
        for scheduled_operations_info in ret["policy"]["scheduled_operations"]:
            if scheduled_operations_info["operation_type"] == "full_backup":
                scheduled_id_list.append(scheduled_operations_info["id"])
        for scheduled_operations_info in ret["policy"]["scheduled_operations"]:
            if scheduled_operations_info["operation_type"] == "copy":
                scheduled_id_list.append(scheduled_operations_info["id"])
        created_time = ret["policy"]["created_at"]
        server_id_list = []
        for source in source_list:
            server_id_list.append(source["id"])
        return plan_id, server_id_list, expired_time_str, scheduled_id_list, created_time

    def common_delete_image_normal(self, checkpoint_item_id, checkpoint_id):
        """删除副本并且等待副本删除完成(包括备份副本和拷贝副本，具体是那一种根据你所传递的副本id来定)

        输入参数:
        - tenant_id: 租户id
        - provider_id:提供商，参数类型string
        - checkpoint_item_id:副本的itemid,参数类型string
        - checkpoint_id: 副本id，参数类型string

        返 回 值:无
        异常描述:描述可能抛出的各种异常，若无，则删除本行。
        使用方法及范例:

        """
        logger.info("Start deleting copies...")
        if isinstance(checkpoint_item_id, list):
            checkpoint_item_id1 = checkpoint_item_id[0]
        else:
            checkpoint_item_id1 = checkpoint_item_id
            # 查看副本状态
        try:
            logger.info(checkpoint_item_id1)
            ret1 = self.get_image_detail(checkpoint_item_id1)
            logger.info("succeed getting copy information:{}".format(checkpoint_item_id1))
        except Exception as err:
            logger.error(err)
            self.close_session()
            if "CSBS.3001" in str(err):
                logger.info("The backup copy does not exist, "
                            "deleting successfully.")
                return True
            raise Exception("Failed to get the information of copy {},"
                            " errMsg:{}".format(checkpoint_item_id1, err))
        if ret1["checkpoint_item"]["status"] not in ["error", "available"]:
            raise Exception("The copy status is {i},which can not to be deleted, "
                            "please check!".format(i=ret1["checkpoint_item"]["status"]))
        try:
            self.delete_image(checkpoint_id)
            logger.info(checkpoint_id)
            logger.info("Deleting copy task issued successfully")
        except Exception as e:
            logger.info(e)
            self.close_session()
            raise Exception("Failed deleting copy, errMsg:{}".format(e))
        logger.info("Waiting for the copy to be deleted successfully...")
        # 获取副本的状态值
        count = 0
        delete_result = False
        try:
            while count < 100:
                copy_list_info = self.get_image_list()
                copy_checkpoint_id_list = []
                for copy in copy_list_info["checkpoint_items"]:
                    copy_checkpoint_id_list.append(copy["checkpoint_id"])
                if checkpoint_id not in copy_checkpoint_id_list:
                    delete_result = True
                    logger.info("Succeed deleting the copy")
                    break
                time.sleep(30)
                count = count + 1
        except Exception as e:
            logger.error("Deleting item error:%s" % traceback.format_exc())
            self.close_session()
            raise Exception("There is a problem in waiting for deleting the copy, errMsg:{}".format(e))
        return delete_result

    def SBS_DelBackupPlan_DelNormal(self, service_id):
        """正常情况下删除备份计划
        输入参数:
        - tenant_id: 租户ID
        - service_id: 备份计划ID

        返 回 值:无

        异常描述:获取的信息与预期不符
        使用方法及范例:

        """
        # 2、删除备份任务
        try:
            logger.info("Start deleting the backup plan")
            self.delete_backupplan(service_id)
            logger.info("Succeed deleting the backup plan")
        except RuntimeError as e:
            logger.info(e)
            self.close_session()
            raise Exception("Failed deleting the backup plan, errMsg:{}".format(e))

    def SBS_ChangeBackupPlan_ChangeBackupPlanNormal(self, service_id, **kwargs):
        """修改备份计划

        输入参数:

        - dj_ip: 登录dj的IP地址
        - dj_user: 登录dj的用户名
        - dj_password: 登录dj的密码
        - tenant_id: 租户ID bn
        - service_id: 备份计划ID

        kwargs:可选参数对象,以键值对的形式输入“key=value”:
        - name:备份计划的名称
        - description:备份计划的描述信息
        - parameters:备份参数（备份计划过期时间）
        - resources:备份资源
        - maxbackups:自动备份的最大副本数，整数
        - duration:备份副本保留的天数，取值为1-99999整数
        - pattern:触发时间设置"BEGIN:VCALENDAR\r\nBEGIN:VEVENT\r\nRRULE:FREQ={FREQ};BYDAY={BYDAY};BYHOUR={BYHOUR};BYMINUTE={BYMINUTE}\r\nEND:VEVENT\r\nEND:VCALENDAR\r\n"，其中FREQ，BYDAY，BYHOUR，BYMINUTE是需要修改的项
        - operationtype:备份类型backup或者copy或者full_backup
        注意：
        选择修改对象取值:
        - 修改name或者description:传值方式"name=wf_plan"
        - 修改parameters:传值方式“expired_at=2017-04-12T14:20:02
        - 修改resources:需要修改的备份主机，可以通过self.common_get_server_type获取对应的值“resources=获取的值”
        - 修改scheduled_operation对象:可输入的参数值有:max_backups,pattern,retention_duration_days,operation_type
        | maxbackups=["id",20] | # id为调度策略的id，创建备份计划时返回
        | duration=[id,20] |
        | pattern=[id,"BEGIN:VCALENDAR\r\nBEGIN:VEVENT\r\nRRULE:FREQ={FREQ};BYDAY={BYDAY};BYHOUR={BYHOUR};BYMINUTE={BYMINUTE}\r\nEND:VEVENT\r\nEND:VCALENDAR\r\n"] |
        返 回 值:无
        异常描述:获取的信息与预期不符
        使用方法及范例:
        修改历史:

        """
        # 参数体构造
        modify_dict = {}
        if kwargs:
            for key in kwargs:
                if key == "parameters":
                    parameters = {
                        "common": {
                            "az": self.az,
                            "expired_at": kwargs[key]
                        }
                    }
                    modify_dict[key] = parameters
                elif key == "resources":
                    modify_dict[key] = kwargs[key]
                elif key == "maxbackups":
                    modify_dict = {"scheduled_operations": [
                        {
                            'enabled': True,
                            "operation_definition": {
                                "max_backups": kwargs[key][1],
                            },
                            "id": kwargs[key][0]
                        }
                    ]}
                elif key == "duration":
                    modify_dict = {
                        "parameters": {
                            "common": {
                                "az": self.az,
                            }
                        },
                        "scheduled_operations": [
                            {
                                'enabled': True,
                                "operation_definition": {
                                    "retention_duration_days": kwargs[key][1],
                                },
                                "id": kwargs[key][0]
                            }
                        ]}
                elif key == "operationtype":
                    modify_dict = {"scheduled_operations": [
                        {'enabled': True, "operation_type": kwargs[key][1], "id": kwargs[key][0]}]}
                elif key == "pattern":
                    modify_dict = {
                        "scheduled_operations": [
                            {
                                'enabled': True,
                                "trigger": {
                                    "properties": {
                                        "pattern": kwargs[key][1]
                                    }
                                },
                                "id": kwargs[key][0]
                            }
                        ]
                    }
                else:
                    modify_dict[key] = kwargs[key]
        modify_body = {"policy": modify_dict}
        logger.info("The backup plan is modified to be: {i}".format(i=modify_body))
        # 1、修改备份
        try:
            logger.info("Start modifying the backup plan...")
            self.change_backupplan(service_id, modify_body)
            logger.info("Succeed modifying the backup plan")
        except RuntimeError as e:
            logger.info(e)
            self.close_session()
            raise Exception("Failed modifying the backup plan, errMsg:{}".format(e))

    def SBS_BackupManualorAuto_BackupManualorAuto(self, plan_id, plan_resource_id_list,
                                                  auto_trigger=False, except_status="available",
                                                  incremental=True, type=None):

        """云主机备份（手工执行）

        输入参数:
        - tenant_id：租户id
        - provider_id：
        - plan_id:备份计划id
        - plan_resource_id_list:备份计划中的资源id信息，创建备份计划时返回
        - auto_trigger:是否自动触发False或者True,当为False时表示手动备份，当为True时为自动备份
        - except_status:备份计划完成后的预期状态值

        返 回 值:checkpoint_id, checkpoint_item_id
        异常描述:备份不成功
        使用方法及范例:

        """
        time.sleep(15)
        # 执行备份
        try:
            logger.info("Start performing backup...")
            ret = self.backup(plan_id, plan_resource_id_list, auto_trigger, incremental=incremental)
            if ret["checkpoint"]["status"] == "protecting":
                logger.info("Expected result: Backup task issued successfully")
        except RuntimeError as e:
            logger.info(e)
            self.close_session()
            raise Exception("Failed performing backup, errMsg:{}".format(e))
        logger.info("Wait for the backup task to be complete...")
        time.sleep(10)
        checkpoint_id = ret["checkpoint"]["id"]
        if type is None:
            checkpoint_item_id = self.common_Wait_Image_Status_Except(checkpoint_id,
                                                                      except_status)
            return checkpoint_id, checkpoint_item_id
        else:
            checkpoint_item_id_list = self.common_Wait_Image_Status_Except_morehost(checkpoint_id,
                                                                                    except_status)
            return checkpoint_id, checkpoint_item_id_list

    def common_Wait_Image_Status_Except(self, checkpoint_id, except_status="available"):
        """等待副本状态为期望值并返回checkpoint_item_id
        输入参数:
        - tenant_id：租户ID
        - check_point_id: 执行备份时返回。
        - except_status: 副本状态，默认为available

        返 回 值:checkpoint_item_id。
        异常描述:描述可能抛出的各种异常，若无，则删除本行。
        使用方法及范例:

        """
        time.sleep(5)
        image_info = self.get_image_list()
        checkpoint_item_id = []
        for n in range(len(image_info["checkpoint_items"])):
            if image_info["checkpoint_items"][n]["checkpoint_id"] == checkpoint_id:
                checkpoint_item_id.append(image_info["checkpoint_items"][n]["id"])
        m = None  # 用来标记是否进入循环
        l = 0
        for i in range(len(checkpoint_item_id)):
            logger.info("The {x} copy, the firstly get copy id: {i}"
                        "(id will be going to change later)".format(x=i + 1, i=checkpoint_item_id))
            logger.info("Constantly use the old copy id to obtain copy "
                        "information until you get an error, or no error "
                        "occurs after getting it between 20 seconds in 20 "
                        "times,  both indicate that the copy id has changed")
            while m is not 1:
                try:
                    if l <= 20:
                        logger.info("The {x} copy, the {i} time to determine "
                                    "whether the copy id has changed".format(x=i + 1, i=l + 1))
                        self.get_image_detail(checkpoint_item_id[i])
                        time.sleep(20)
                        l = l + 1
                    else:
                        m = 1
                except:
                    m = 1
                    time.sleep(5)
            logger.info("The copy id has changed and a new id is obtained")
            image_info = self.get_image_list()
            checkpoint_item_id = []
            for n in range(len(image_info["checkpoint_items"])):
                if image_info["checkpoint_items"][n]["checkpoint_id"] == checkpoint_id:
                    checkpoint_item_id.append(image_info["checkpoint_items"][n]["id"])
            logger.info("The {x} copy, the secondly get copy id:{i}"
                        "(id will be going to change later)".format(x=i + 1, i=checkpoint_item_id))
            # 获取副本ID发生改变后的副本信息
            image_info = self.get_image_detail(checkpoint_item_id[i])
            logger.info(image_info)
            ac_plan_status = image_info["checkpoint_item"]["status"]
            count = 0
            logger.info("Query the status of the {i} copy is: {j}".format(i=i + 1, j=ac_plan_status))
            try:
                while ac_plan_status != except_status:
                    image_info = self.get_image_detail(checkpoint_item_id[i])
                    logger.info(image_info)
                    ac_plan_status = image_info["checkpoint_item"]["status"]
                    if ac_plan_status in ["protecting", "restoring", "copying", "available"]:
                        logger.info("Current task progress value:{i}"
                                    .format(i=image_info["checkpoint_item"]["extend_info"]["progress"]))
                    logger.info("Current copy's status:{i}".format(i=ac_plan_status))
                    count = count + 1
                    if ac_plan_status == "error":
                        raise Exception("Copy's status is error, task failed, please check")
                    if ac_plan_status == except_status or count > 200:
                        logger.info("The state value of the copy is expected,"
                                    " and the end state value: {i}".format(i=ac_plan_status))
                        break
                    time.sleep(40)
            except RuntimeError as e:
                logger.info(e)
                self.close_session()
                raise Exception("Failed performing the volume's backup plan, errMsg:{}".format(e))

            if ac_plan_status != except_status:
                raise Exception("Failed performing the volume's backup plan,"
                                " errMsg: the state value of the copy is not expected")
        return checkpoint_item_id[0]

    def common_Wait_Image_Status_Except_morehost(self, checkpoint_id, except_status="available"):
        """等待副本状态为期望值并返回checkpoint_item_id
        输入参数:
        - tenant_id：租户ID
        - check_point_id: 执行备份时返回。
        - except_status: 副本状态，默认为available

        返 回 值:checkpoint_item_id。
        异常描述:描述可能抛出的各种异常，若无，则删除本行。
        使用方法及范例:

        """

        image_info = self.get_image_list()
        checkpoint_item_id = []
        for n in range(len(image_info["checkpoint_items"])):
            if image_info["checkpoint_items"][n]["checkpoint_id"] == checkpoint_id:
                checkpoint_item_id.append(image_info["checkpoint_items"][n]["id"])
        m = None  # 用来标记是否进入循环
        l = 0
        for i in range(len(checkpoint_item_id)):
            logger.info("The {x} copy, the firstly get copy id: {i}"
                        "(id will be going to change later)".format(x=i + 1, i=checkpoint_item_id))
            logger.info("Constantly use the old copy id to obtain copy "
                        "information until you get an error, or no error "
                        "occurs after getting it between 20 seconds in 20 "
                        "times, both indicate that the copy id has changed")
            while m is not 1:
                try:
                    if l <= 20:
                        logger.info("The {x} copy, the {i} time to determine "
                                    "whether the copy id has changed".format(x=i + 1, i=l + 1))
                        self.get_image_detail(checkpoint_item_id[i])
                        time.sleep(20)
                        l = l + 1
                    else:
                        m = 1
                except RuntimeError as e:
                    logger.info(e)
                    m = 1
                    time.sleep(5)
            logger.info("The copy id has changed and a new id is obtained")
            image_info = self.get_image_list()
            checkpoint_item_id = []
            for n in range(len(image_info["checkpoint_items"])):
                if image_info["checkpoint_items"][n]["checkpoint_id"] == checkpoint_id:
                    checkpoint_item_id.append(image_info["checkpoint_items"][n]["id"])
            logger.info("The {x} copy, the secondly get copy id:{i}"
                        "(id will be going to change later)".format(x=i + 1, i=checkpoint_item_id))
            # 获取副本ID发生改变后的副本信息
            image_info = self.get_image_detail(checkpoint_item_id[i])
            logger.info(image_info)
            ac_plan_status = image_info["checkpoint_item"]["status"]
            count = 0
            logger.info("Query the status of the {i} copy is: {j}".format(i=i + 1, j=ac_plan_status))
            try:
                while ac_plan_status != except_status:
                    image_info = self.get_image_detail(checkpoint_item_id[i])
                    logger.info(image_info)
                    ac_plan_status = image_info["checkpoint_item"]["status"]
                    if ac_plan_status in ["protecting", "restoring", "copying", "available"]:
                        logger.info("Current task progress value: {i}".
                                    format(i=image_info["checkpoint_item"]["extend_info"]["progress"]))
                    logger.info("Current copy's status:{i}".format(i=ac_plan_status))
                    count = count + 1
                    if ac_plan_status == "error":
                        raise Exception("Copy's status is error, task failed, please check")
                    if ac_plan_status == except_status or count > 200:
                        logger.info("The state value of the copy is expected,"
                                    " and the end state value: {i}".format(i=ac_plan_status))
                        break
                    time.sleep(30)

            except RuntimeError as e:
                logger.info(e)
                self.close_session()
                raise Exception("Failed performing the volume's backup plan, errMsg:{}".format(e))
            if ac_plan_status != except_status:
                raise Exception("Failed performing the volume's backup plan,"
                                " errMsg: the state value of the copy is not expected")
        return checkpoint_item_id

    def SBS_CopyBackupPlanImage_Manual(self, policy_id, auto_trigger=False,
                                       except_status="available", type=None):

        """手动执行拷贝

        输入参数:

        - dj_ip: dj服务地址
        - dj_user: 鉴权用户名
        - dj_password: 鉴权的密码
        - tenant_id: 租户ID
        - provider_id:
        - plan_id: 备份计划ID
        - auto_trigger:ture or false
        - except_status:拷贝副本的结果状态

        返 回 值:checkpoint_id，checkpoint_item_id
        异常描述:获取的信息与预期不符
        使用方法及范例:

        """
        if type is None:
            # 执行拷贝任务
            try:
                logger.info("Start Performing replicate")
                ret = self.copy_backupimage(policy_id, auto_trigger)
                logger.info("Performing replicate command was issued successfully")
                checkpoint_item_id = ret["checkpoint_items"][0]
            except RuntimeError as e:
                logger.info(e)
                self.close_session()
                raise Exception("Failed to issue performing replicate command, errMsg:{}".format(e))
            # 等待任务执行完成
            logger.info("Waiting for the replication task to be complete...")
            image_info = self.get_image_detail(checkpoint_item_id)
            ac_plan_status = image_info["checkpoint_item"]["status"]
            count = 0
            try:
                while ac_plan_status != except_status:
                    image_info = self.get_image_detail(checkpoint_item_id)
                    ac_plan_status = image_info["checkpoint_item"]["status"]
                    logger.info(ac_plan_status)
                    count = count + 1
                    if ac_plan_status == except_status or ac_plan_status == "error" or count > 31:
                        logger.info("The state value of the copy is expected,"
                                    " and the end state value: {i}".format(i=ac_plan_status))
                        break
                    time.sleep(60)
            except RuntimeError as e:
                logger.info(e)
                self.close_session()
                raise Exception("Failed performing the volume's backup plan, errMsg:{}".format(e))
            checkpoint_id = image_info["checkpoint_item"]["checkpoint_id"]
            return checkpoint_id, checkpoint_item_id
        else:
            # 执行拷贝任务
            try:
                logger.info("Start Performing replicate")
                ret = self.copy_backupimage(policy_id, auto_trigger)
                logger.info("Performing replicate command was issued successfully")
                checkpoint_item_id = ret["checkpoint_items"]
            except RuntimeError as e:
                logger.info(e)
                self.close_session()
                raise Exception("Failed to issue performing replicate command, errMsg:{}".format(e))
            # 等待任务执行完成
            logger.info("Waiting for the replication task to be complete...")
            for i in range(len(checkpoint_item_id)):
                image_info = self.get_image_detail(checkpoint_item_id[i])
                ac_plan_status = image_info["checkpoint_item"]["status"]
                count = 0
                try:
                    while ac_plan_status != except_status:
                        image_info = self.get_image_detail(checkpoint_item_id[i])
                        ac_plan_status = image_info["checkpoint_item"]["status"]
                        count = count + 1
                        if ac_plan_status == except_status or ac_plan_status == "error" or count > 31:
                            logger.info("The state value of the copy is expected,"
                                        " and the end state value: {i}".format(i=ac_plan_status))
                            break
                        time.sleep(60)
                except RuntimeError as e:
                    logger.info(e)
                    self.close_session()
                    raise Exception("Failed performing the cloud volume's backup plan, errMsg:{}".format(e))
                checkpoint_id = image_info["checkpoint_item"]["checkpoint_id"]
            return checkpoint_id, checkpoint_item_id

    def common_wait_autoplan_start_complete(self, plan_resource_id_list,
                                            operation_type="backup", time1=None):

        """等待自动触发备份任务开始，并执行结束（存在返回checkpoint_item_id，checkpoint_id）
        输入参数:
        - tenant_id:租户id
        - plan_resource_id:备份主机的的id
        - operation_type:任务类型backup或者copy
        :return:checkpoint_id,checkpoint_item_id
        """
        if time1 is not None:
            logger.info("Start waiting for {time} seconds....".format(time=time1))
            time.sleep(time1)
        else:
            pass
        plan_resource_id = plan_resource_id_list[0]
        logger.info("Checking if an auto-triggered backup task exists")
        count = 0
        checkpoint_item_id = None
        checkpoint_id = None
        try:
            while count < 100:
                copy_list_info = self.get_image_list()
                logger.info("Query the list of backup's copies %s times" % count)
                for copy in copy_list_info["checkpoint_items"]:
                    if copy["resource_id"] == plan_resource_id \
                            and copy["extend_info"]["image_type"] == operation_type \
                            and (copy["status"] == "waiting_protect"
                                 or copy["status"] == "protecting"):
                        checkpoint_item_id = copy["id"]
                        checkpoint_id = copy["checkpoint_id"]
                        logger.info("Succeed performing Auto-triggered backup task")
                        logger.info(
                            "checkpoint_item_id is: {i},"
                            "checkpoint_id is:{k}".format(i=checkpoint_item_id, k=checkpoint_id))
                        break
                if checkpoint_item_id:
                    break
                time.sleep(12)
                count = count + 1
            else:
                raise Exception("Failed to trigger Auto-backup task")
        except RuntimeError as e:
            logger.info(e)
            self.close_session()
            raise Exception("There was an error in querying of the copys list, errMsg:{}".format(e))

        checkpoint_item_id = self.common_Wait_Image_Status_Except(checkpoint_id, except_status="available")
        return checkpoint_id, checkpoint_item_id

    def VBS_RestoreToSomeHost(self, checkpoint_id, checkpoint_item_id, resource):
        """云硬盘恢复到某云硬盘【成功】

        - tenant_id：租户id
        - provider_id
        - service_id：备份计划id,一般由创建备份计划返回
        - resource_id:虚拟机ID，一般由创建备份计划返回
        - resource:目标主机的资源信息
        :return:

        """
        # 1、执行恢复
        self.common_Restore_new(checkpoint_id, checkpoint_item_id, resource)
        # 2、延时等待
        time.sleep(15)
        # 3、等待恢复任务完成
        self.common_Wait_Image_Status_Except(checkpoint_id)

    def common_Restore(self, checkpoint_item_id, original_volume="", replace_volume=""):
        """执行本地恢复

        输入参数:
        - tenant_id：租户ID
        - provider_id:
        - checkpoint_item_id：副本ID，一般由执行备份返回
        - original_volume 源卷id（适用于源主机删除一个卷后再添加卷并执行恢复操作)
        - replace_volume  替换卷id（适用于源主机删除一个卷后再添加卷并执行恢复操作)
        - power：是否启动虚拟机，默认为"on"

        返 回 值:无。
        异常描述:描述可能抛出的各种异常，若无，则删除本行。
        使用方法及范例:

        """
        checkpoint_id = None
        if isinstance(checkpoint_item_id, list):
            try:
                logger.info("Start getting copy information")
                retinfo = self.get_image_detail(checkpoint_item_id[0])
                resource_id = retinfo["checkpoint_item"]["resource_id"]
                checkpoint_id = retinfo["checkpoint_item"]["checkpoint_id"]
                volume_backups = retinfo["checkpoint_item"]["extend_info"]["volume_backups"]
                backup_id_list = []
                volume_id_list = []
                for volume_backup in volume_backups:
                    backup_id_list.append(volume_backup['id'])
                    volume_id_list.append(volume_backup['source_volume_id'])
                if original_volume and replace_volume:
                    volume_id_list[volume_id_list.index(original_volume)] = replace_volume
                target = self.make_targets(resource_id, backup_id_list, volume_id_list)
                logger.info("the information of volume that needs to be restored:{i}".format(i=target))
                logger.info("Perform restoring")
                ret = self.restore(checkpoint_id, checkpoint_item_id[0], target)
                logger.info("Succeed to issue performing restore, the response: {i}".format(i=ret))
            except RuntimeError as e:
                logger.info(e)
                raise Exception("Failed to issue performing restore, errMsg:{}".format(e))
        else:
            try:
                logger.info("Start getting copy information")
                retinfo = self.get_image_detail(checkpoint_item_id)
                resource_id = retinfo["checkpoint_item"]["resource_id"]
                checkpoint_id = retinfo["checkpoint_item"]["checkpoint_id"]
                volume_backups = retinfo["checkpoint_item"]["extend_info"]["volume_backups"]
                backup_id_list = []
                volume_id_list = []
                for volume_backup in volume_backups:
                    backup_id_list.append(volume_backup['id'])
                    volume_id_list.append(volume_backup['source_volume_id'])
                if original_volume and replace_volume:
                    volume_id_list[volume_id_list.index(original_volume)] = replace_volume
                target = self.make_targets(resource_id, backup_id_list, volume_id_list)
                logger.info("the information of volume that needs to be restored:{i}".format(i=target))
                logger.info("Perform restoring")
                ret = self.restore(checkpoint_id, checkpoint_item_id, target)
                logger.info("Succeed to issue performing restore, the response:{i}".format(i=ret))
            except RuntimeError as e:
                logger.info(e)
                raise Exception("Failed to issue performing restore, errMsg:{}".format(e))
        return checkpoint_id

    def make_targets(self, restore_server_id, backup_id_list, volume_id_list):
        """
        公共函数，来组织target的结构
        :param restore_server_id:
        :param backup_id_list:
        :param volume_id_list:
        :return:
        """
        targets = {"server_id": restore_server_id,
                   "volumes": []}
        for i in range(len(backup_id_list)):
            target = dict()
            target['backup_id'] = backup_id_list[i]
            target['volume_id'] = volume_id_list[i]
            targets['volumes'].append(target)
        logger.info('make targets result is: \n%s' % targets)
        return targets

    def common_Restore_new(self, checkpoint_id, checkpoint_item_id, resource):
        """云硬盘执行恢复

        :param tenant_id:
        :param provider_id:供应商ID
        :param checkpoint_id:备份执行记录ID
        :param checkpoint_item_id:备份副本ID（查询备份列表的接口返回值）
        :param resource:单个资源信息
        :return:
        """
        volume_id = resource[0]["id"]
        try:
            image_info = self.get_image_detail(checkpoint_item_id)
            logger.info("Succeed getting copy information！")
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed to issue performing restore, errMsg:{}".format(e))
        # 获取卷备份ID
        backup_id = image_info["checkpoint_item"]["extend_info"]["volume_backups"][0]["id"]
        targets = {"server_id": volume_id, "volumes": [{"backup_id": backup_id, "volume_id": volume_id}]}
        try:
            logger.info("Perform restoring")
            ret = self.restore(checkpoint_id, checkpoint_item_id, targets)
            logger.info("Succeed to issue performing restore, the response:{i}".format(i=ret))
        except RuntimeError as e:
            logger.info('Run Error, errMsg: {}'.format(e))
            raise Exception("Failed to issue performing restore, errMsg:{}".format(e))

    def wait_next_auto_run(self, plan_id, plan_resource_list, scheduled_id, operation_type="backup", **kwargs):
        """等待下一次自动调度任务执行（给定下一次调度的时间）

        :return:
        """
        time1 = None
        time_info1 = [None] * 3
        if "minutes" in kwargs:
            time_info1 = self.GetFutureTimeParameters(minutes=kwargs["minutes"])
            time1 = kwargs["minutes"] * 60
        elif "hours" in kwargs:
            time_info1 = self.GetFutureTimeParameters(hours=kwargs["hours"])
            time1 = kwargs["hours"] * 60 * 60
        dreq = "WEEKLY"
        pattern = "BEGIN:VEVENT\r\nRRULE:FREQ=" + dreq + ";" + "BYDAY=" \
                  + time_info1[0] + ";" + "BYHOUR=" + time_info1[1] + ";" \
                  + "BYMINUTE=" + time_info1[2] + "\r\nEND:VEVENT\r\n"
        trigger = [scheduled_id, pattern]
        self.SBS_ChangeBackupPlan_ChangeBackupPlanNormal(plan_id, pattern=trigger)
        re = self.common_wait_autoplan_start_complete(plan_resource_list, operation_type=operation_type, time1=time1)
        return re

    def Check_KW(self):
        time_info1 = self.GetFutureTimeParameters(minutes=15)
        logger.info(time_info1)

    def teardown(self, checkpoint_item_id=None, checkpoint_id=None, plan_id=None):
        """
        删除副本，再删除备份计划
        :param checkpoint_id: 副本ID
        :param checkpoint_item_id:副本ID列表
        :param plan_id: 备份计划ID
        :return:

        """
        """
        :param checkpoint_id:
        :param checkpoint_item_id:
        :param plan_id:
        :return:
        """
        # 检查是否有副本需要删除
        if checkpoint_id and checkpoint_item_id is not None:
            x = 0
            while x < 5:
                try:
                    # 删除副本
                    result = self.common_delete_image_normal(
                        checkpoint_item_id, checkpoint_id)
                    if result:
                        x = 6
                except Exception as err:
                    logger.error("Deleting checkpoint_item_id: %s, "
                                 "retry time: %s, err: %s"
                                 % (checkpoint_item_id, x, err))
                    x = x + 1
                    time.sleep(100)
            else:
                if x == 6:
                    pass
                else:
                    raise Exception("Failed deleting the copy, please check!")
        # 检查是否有计划需要删除
        if plan_id is not None:
            y = 0
            while y < 5:
                try:
                    try:
                        # 删除备份计划
                        self.SBS_DelBackupPlan_DelNormal(plan_id)
                        y = 6
                    except:
                        raise Exception("Failed deleting policy")
                except:
                    y = y + 1
                    time.sleep(150)
            else:
                if y == 6:
                    pass
                else:
                    raise Exception("Failed deleting policy, please check!")

    def change_current_time(self, now, type=None, days=None, hours=None, minutes=None, type1=None):
        """改变当前时间

        :param type:为空表示是减少时间，不为空表示增加时间
        :param days:以天为单位变化
        :param hours:以小时为单位变化
        :param minutes:以分钟为单位变化
        :return:返回一个修改后的当前时间

        """
        now1 = now - timedelta(hours=self.karbor_timezone)
        changetime = now1
        if type1 is None:
            if type is not None:
                if days is not None:
                    changetime = now + timedelta(days=days)
                elif hours is not None:
                    changetime = now + timedelta(hours=hours)
                elif minutes is not None:
                    changetime = now + timedelta(minutes=minutes)
            else:
                if days is not None:
                    changetime = now - timedelta(days=days)
                elif hours is not None:
                    changetime = now - timedelta(hours=hours)
                elif minutes is not None:
                    changetime = now - timedelta(minutes=minutes)
        return changetime

    def get_week_day(self, date):
        """
        获取当前日期是星期几，主要是为了给SCHEDLE_BYDAY参数赋值用。
        :param date:使用datetime.datetime.now()获取出来的当前时间
        :return: MO,TU,WE,TH,FR,SA,SU中的一个
        修改历史:

        """

        week_day_dict = {
            0: "MO",
            1: "TU",
            2: "WE",
            3: "TH",
            4: "FR",
            5: "SA",
            6: "SU"
        }
        day = date.weekday()
        return week_day_dict[day]

    def GetFutureTimeParameters(self, **kwargs):
        """构造，创建自动调度计划需要的byday,hour,minute3个参数
        【这里构造的时间参数，只是用于构造未来时间】
        kwargs 可以是 hours = ??  minutes = ?? days = ?? 分别表示 获取 多久 以后的时间参数byday hour minute
        :return:byday,hour,minute
        """
        nowtime = self.connect_to_karbor(self.KarBor_Info[0], self.KarBor_Info[1], self.KarBor_Info[2])
        byday_tmp1 = self.change_current_time(nowtime, type1=2)
        if "hours" in kwargs:
            futuretime = self.change_current_time(byday_tmp1, type=1, hours=kwargs["hours"])
            byday = self.get_week_day(futuretime)
            tmp0 = list(str(futuretime))
            hour = tmp0[11] + tmp0[12]
            minute = tmp0[14] + tmp0[15]
        elif "days" in kwargs:
            futuretime = self.change_current_time(byday_tmp1, type=1, days=kwargs["days"])
            byday = self.get_week_day(futuretime)
            tmp0 = list(str(futuretime))
            hour = tmp0[11] + tmp0[12]
            minute = tmp0[14] + tmp0[15]
        else:
            futuretime = self.change_current_time(byday_tmp1, type=1, minutes=kwargs["minutes"])
            byday = self.get_week_day(futuretime)
            tmp0 = list(str(futuretime))
            hour = tmp0[11] + tmp0[12]
            minute = tmp0[14] + tmp0[15]
        return byday, hour, minute

    def __handle_timezone(self, timezone):
        tz = 0
        if timezone.__contains__('+'):
            _, time_zone = timezone.rsplit('+', 1)
            tz = int(time_zone[:2])
        elif timezone.__contains__('-'):
            _, time_zone = timezone.rsplit('-', 1)
            tz = -int(time_zone[:2])
        return tz

    def connect_to_karbor(self, host, username, passwd, cmd="date +%Y-%m-%d%H:%M:%S", cmd1='date -R'):
        """获取KARBOR的系统时间

        :param host:
        :param username:
        :param passwd:
        :param cmd:
        :return:
        """
        conn = paramiko.SSHClient()
        conn.load_system_host_keys()
        conn.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        conn.connect(host, 22, username, passwd)
        stdin, stdout, stderr = conn.exec_command(cmd)
        stdin1, stdout1, stderr1 = conn.exec_command(cmd1)
        local_time = stdout.read()
        local_time1 = datetime.strptime(local_time, "%Y-%m-%d%H:%M:%S\n")
        timezone = stdout1.read()
        logger.info('Current time zone: %s' % timezone)
        self.karbor_timezone = self.__handle_timezone(timezone)
        conn.close()
        return local_time1

    def Query_quota(self):
        """获取配额信息

        :return:
        """
        url = "%s/v1/{project_id}/quotas".format(project_id=self.project_id) % self.base_url
        return self._get(url)

    def Check_quota_VBS(self):
        try:
            logger.info("Start getting VBS quota information...")
            quota_info = self.Query_quota()
            logger.info("Get successfully")
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed getting VBS quota information, errMsg:{}".format(e))
        backup = None
        backup_quota = 0
        for quota in quota_info["quotas"]["resources"]:
            if quota["type"] == "volume_backup_capacity":
                backup_quota = quota["quota"]
                if backup_quota < 102400:
                    logger.info("The VBS backup capacity is {}M, "
                                "less than the established capacity".format(backup_quota))
                    backup = 1
                else:
                    logger.info("The VBS backup capacity is {}M, "
                                "which can be used normally".format(backup_quota))

        if backup is not None:
            try:
                logger.info("Start applying for VBS backup space")
                self.ADD_QUOTA(102400 - backup_quota)
                logger.info("Succeed applying for VBS backup space")
            except Exception as e:
                raise Exception("Failed applying for VBS backup space, errMsg:{}".format(e))

    def Check_Teardown_quota_VBS(self):
        try:
            logger.info("Start getting VBS quota information...")
            quota_info = self.Query_quota()
            logger.info("Get successfully")
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed getting VBS quota information, errMsg:{}".format(e))
        backup = None
        backup_quota = 0
        for quota in quota_info["quotas"]["resources"]:
            if quota["type"] == "volume_backup_capacity":
                backup_quota = quota["quota"]
                if backup_quota != 0:
                    logger.info("The VBS backup capacity is {}M, ready to reduce space".format(backup_quota))
                    backup = 1
                else:
                    logger.info("The VBS backup capacity is {}M".format(backup_quota))

        if backup is not None:
            try:
                logger.info("Start requesting to reduce VBS backup space")
                self.Mu_QUOTA(backup_quota)
                logger.info("Succeed requesting to reduce VBS backup space")
            except Exception as e:
                raise Exception("Failed requesting to reduce VBS backup space, errMsg:{}".format(e))

    def Check_setup(self):
        """任务开始前的检查
        1. 检查租户下是否有策略存在，如果有，则提前删除
        2. 检查租户下备份复制空间是否有容量，如果没有，则自动申请
        :return:
        """
        logger.info('Check and delete images in the tenant')
        image_info_list = self.get_image_list()
        if not image_info_list['checkpoint_items']:
            logger.info('there are no images in the tenant')
        else:
            checkpoint_dict = defaultdict(list)
            for image_info in image_info_list['checkpoint_items']:
                # 一条备份记录对应多个副本
                checkpoint_dict[image_info['checkpoint_id']].append(image_info['id'])
            logger.info('Current image info: {}'.format(str(checkpoint_dict)))
            for checkpoint_id, checkpoint_item_ids in checkpoint_dict.items():
                self.teardown(checkpoint_item_id=checkpoint_item_ids, checkpoint_id=checkpoint_id)
            logger.info('Succeed to delete all images')

        logger.info('Check and delete volumes in the tenant')
        volumes_info = self.list_all_volumes_by_volName(self.volume1_name)
        if not volumes_info['volumes']:
            logger.info('there are no volumes in the tenant, volume name:[{}]'.format(self.volume1_name))
        else:
            for volume_info in volumes_info['volumes']:
                self.delete_volume_by_id_in_order(volume_info['id'])
            logger.info('Succeed to delete all volumes,volume name:[{}]'.format(self.volume1_name))

        logger.info("Start checking for policies under the tenant and delete them ahead of time")
        plan_info = self.Check_plan()
        if plan_info is None:
            pass
        else:
            logger.info("Start deleting the policy")
            for plan_id in plan_info:
                self.SBS_DelBackupPlan_DelNormal(plan_id)
        logger.info("Check if there is capacity in the backup space under the tenant,"
                    " and if not, automatically request")
        self.Check_quota_VBS()

        # 申请1个弹性云硬盘
        logger.info('Start to create a volume')
        self.volume1_id = self.create_volume_for_backup_in_polling_volume_types(backup_id=None)

    def Check_Teardown(self):
        """任务结束后的检查
        1. 检查租户下是否有策略存在，如果有，则提前删除
        2. 检查租户下备份复制空间是否有容量，如果没有，则自动申请
        :return:
        """
        logger.info("Start checking for policies under the tenant and delete them ahead of time")
        plan_info = self.Check_plan()
        if plan_info is None:
            pass
        else:
            logger.info("Start deleting the policy")
            for plan_id in plan_info:
                self.SBS_DelBackupPlan_DelNormal(plan_id)
        logger.info("Check if there is capacity in the backup space under the tenant,"
                    "and if so, automatically clear")
        self.Check_Teardown_quota_VBS()

    def Check_plan(self):
        """检查租户下是否有策略存在，如果存在的话，返回策略的ID列表

        :return:
        """
        try:
            logger.info("Get information of all policies under the tenant")
            re = self.get_plan_info()
            logger.info("Succeed getting information of all policies:{i}".format(i=re))
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed getting information of all policies, errMsg: {}".format(e))
        plan_id_list = []
        if not re["policies"]:
            logger.info("After checking, there is no policy under the tenant")
            plan_id_list = None
        else:
            logger.info("After checking, there is some policies under the tenant")
            for policies in re["policies"]:
                plan_id_list.append(policies["id"])
            logger.info("All policies' ids under tenant: %s" % plan_id_list)
        return plan_id_list

    def get_plan_info(self):
        """获取租户下所有策略的信息

        :return:
        """
        url = "%s/v1/{project_id}/policies?provider_id=1dc03359-1301-467b-9972-1a7599ae791d".format(
            project_id=self.project_id) % self.base_url
        return self._get(url)

    # 以下是走的订单接口

    def build_evs_order_params_str_for_create_volume(self, volume_type, volume_num=1, vbd_or_scsi="false",
                                                     multiattach="false", source_id=None):
        """
        构建创建云硬盘订单Restful接口body中的params参数字符串
        :param volume_num:int类型，如果为创建单个云硬盘，name为云硬盘名，最大支持255个字节。批量创云硬盘的个数。目前最多支持批量创建100个。从备份创建云硬盘时，不支持批量创建，数量只能为“1”。
        :param volume_name:int类型,云硬盘、云硬盘快照名称。如果为批量创建云磁盘，最大支持250个字节，为云硬盘名前缀，不同的云磁盘以“-”开头，以四位数字编号，如“shan-0001”。
        :param disk_size:int类型,云硬盘大小，单位为GB。 创建空白云硬盘和从镜像创建云硬盘时，size为必选，且云硬盘大小不能小于镜像大小。从备份创建云硬盘时，size为可选，不指定size时，云硬盘大小和备份大小一致。
        :param volume_type:str类型
        :param vbd_or_scsi:str类型，”false“表示vbd盘，”true“表示scsi盘
        :param multiattach:str类型，”false“表示独享盘，”true“表示共享盘
        :param availability_zone:str类型,指定要创建云硬盘的AZ。若指定的AZ不存在或指定的AZ和备份所在的AZ不同，则创建云硬盘失败。
        :return:str类型，如下所示：
        "{\"action\": \"create_volume\",\"count\": 1,\"region_id\":\"89dsid-dsdad\",\"volumes\": [{\"backup_id\": null,\"count\": 1,\"size\": 12,
            \"availability_zone\": \"az-sss\",\"name\": \"1\",\"description\": \"\",\"snapshot_id\": \"\",\"multiattach\": false,
            \"volume_type\": \"sla1\",\"imageRef\": null,\"metadata\": {\"hw:passthrough\"=\"false\"},\"OS-SCH-HNT:scheduler_hints\": {},
            \"tags\": [{\"key\": \"\",\"value\": \"\"}, {\"key\": \"\",\"value\": \"\"}]}]}"

        """
        if source_id is None:
            params = {
                "action": "create_volume",
                "count": int(volume_num),
                "region_id": self.region_id,
                "volumes": [{
                    "backup_id": "null",
                    "count": int(volume_num),
                    "size": int(self.volume_size),
                    "availability_zone": self.az,
                    "name": self.volume1_name,
                    "description": "",
                    "snapshot_id": "null",
                    "multiattach": multiattach,
                    "volume_type": volume_type,
                    "imageRef": "null",
                    "metadata": {
                        "hw:passthrough": vbd_or_scsi
                    },
                    "OS-SCH-HNT:scheduler_hints": {},
                    "tags": [{
                        "key": "",
                        "value": ""
                    }, {
                        "key": "",
                        "value": ""
                    }]
                }]
            }
        else:
            params = {
                "action": "create_volume",
                "count": int(volume_num),
                "region_id": self.region_id,
                "volumes": [{
                    "backup_id": source_id,
                    "count": int(volume_num),
                    "size": int(self.volume_size),
                    "availability_zone": self.az,
                    "name": self.volume1_name,
                    "description": "",
                    "snapshot_id": "null",
                    "multiattach": multiattach,
                    "volume_type": volume_type,
                    "imageRef": "null",
                    "metadata": {
                        "hw:passthrough": vbd_or_scsi
                    },
                    "OS-SCH-HNT:scheduler_hints": {},
                    "tags": [{
                        "key": "",
                        "value": ""
                    }, {
                        "key": "",
                        "value": ""
                    }]
                }]
            }
        return params

    def cloud_service_subscription_evs(self, innerparams, operate_type,
                                       service_type="evs", tenancy="0"):
        """创建弹性云硬盘接口

        :param innerparams:
        :param operate_type:
        :param service_type:
        :param tenancy:   "2018-04-19 15:59:59"
        :return:
        """

        # 云服务订单订购
        url = "%s/rest/subscription/v3.0/subscriptions" % self.auth_domain
        region_id = self.region_id
        project_id = self.project_id
        rate_params = [{
            "params": [{
                "region_id": region_id,
                "az_id": self.az,
                "cloud_service_type_code": "hws.service.type.ebs",
                "resource_type_code": "hws.resource.type.volume",
                "accumulate_factor_name": "Duration",
                "accumulate_factor_value": "3600",
                "extend_params": 0
            }],
            "unit": {
                "zh_CN": "小时",
                "en_US": "h"
            },
            "price": "0.00"
        }]
        params_data = {
            "subscriptions": [{
                "project_id": project_id,
                "region_id": region_id,
                "product_id": "",
                "comments": "",
                "operate_type": operate_type,
                "service_type": service_type,
                "time_zone": "GMT+08:00",
                "params": json.dumps(innerparams).replace("\"null\"", "null"),
                "rate_params": json.dumps(rate_params)
            }]
        }
        if operate_type == "apply":
            params_data["subscriptions"][0]["product_id"] = self.project_id_evs
            params_data["subscriptions"][0]["tenancy"] = tenancy
        if operate_type == "delay":
            params_data["subscriptions"][0]["tenancy"] = tenancy
        elif operate_type == "softdelete" or operate_type == "restore" \
                or operate_type == "modify" or operate_type == "delete":
            params_data = params_data

        params = json.dumps(params_data)
        ret = self._post(url=url, data=params)

        logger.info("subscription type:%s" % operate_type)
        logger.debug(params)
        return ret

    def delete_volume_by_id_in_order(self, volume_id):
        logger.info('start to delete a volume,volume_id:%s' % volume_id)
        try:
            url = "%s/rest/subscription/v3.0/subscriptions" % self.auth_domain
            region_id = self.region_id
            project_id = self.project_id
            params = {"action": "delete_volume",
                      "ids": [{"id": volume_id, "service_type": "evs", "name": self.volume1_name}],
                      "region_id": region_id,
                      "display": {}
                      }
            data = {"subscriptions":
                        [{"project_id": project_id,
                          "region_id": region_id,
                          "operate_type": "delete",
                          "service_type": "evs",
                          "params": json.dumps(params)}]}
            ret = self._post(url=url, data=json.dumps(data))
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Fail to create the order.")
        logger.info('succeed to send the order of delete volume,the volume_id:%s' % volume_id)
        order_id = self.get_order_id(ret)
        logger.info("Wait for the order's status dispayed entirely")
        self.check_order_status(order_id, "successed")
        logger.info("Get the list of order's resouce.")
        resource_ids_list = self.get_order_resource_ids_list(order_id)
        volume_id = resource_ids_list[0]
        logger.info("Wait for creating disk to succeed.")
        self.wait_volume_until_delete(volume_id)

    def get_order_id(self, ret):
        """处理订单回显

        :param ret:
        :return:
        """
        return ret["purchases"][0]["subscription_id"]

    def check_order_status(self, order_id, expect_status, time_out=1000):
        """
        循环检查订单状态，直到预期
        :param order_id:
        :param expect_status:
        :param time_out:
        :return:
        """
        status_no_list = ['partialSuccessed', 'failed', 'closed', 'timeout']
        sleep_time = 10
        count = time_out // sleep_time
        logger.info("Cycle to check order's status")
        cur_status = ""
        for i in range(0, count):
            cur_status = self.get_order_status(order_id)
            logger.info('current order status:%s' % cur_status)
            if cur_status == expect_status:
                break
            elif cur_status in status_no_list:
                break
            time.sleep(sleep_time)
        if cur_status != expect_status:
            logger.error('Order status expected:{}, actual status:{}'.format(expect_status, cur_status))
        return cur_status

    def get_order_status(self, order_id):
        """
        获取当前订单的状态
        :param order_id:
        :return:
        """
        ret = self.show_special_order_detail(order_id)
        return ret["status"]

    def show_special_order_detail(self, order_id):
        # 查询订单详情
        url = "%s/rest/order/v3.0/orders/{order_id}".format(order_id=order_id) % self.auth_domain
        ret = self._get(url)

        logger.info("Search order details")
        return ret

    def get_order_resource_ids_list(self, order_id):
        """
        获取订单资源类ID列表
        :return:
        """
        try:
            logger.info("Start getting a list of order resources")
            res = self.show_special_order_resources(order_id)
            logger.info("Get successfully")
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed getting a list of order resources")
        list_len = len(res)
        resource_ids_list = []
        for i in range(0, list_len):
            resource_ids_list.append(res[i]["resource_id"])
        return resource_ids_list

    def show_special_order_resources(self, order_id):
        """

        :param token:
        :param order_id:
        :return:
        """

        # 查询订单的资源类列表
        url = "%s/rest/order/v3.0/orders/{order_id}/resources".format(order_id=order_id) % self.auth_domain
        ret = self._get(url)

        logger.info("Start getting a list of order resources")
        return ret

    def create_volume_for_backup_in_polling_volume_types(self, backup_id):
        """根据备份副本创建云硬盘

        :param backup_id:
        :return:
        """
        order_status = 'failed'
        order_id = None
        for volume_type in self.volume_type_list:
            logger.info("Build creating cloud volume parameter body,"
                        "current volume's type:{}".format(volume_type))
            apply_inner_params = self.build_evs_order_params_str_for_create_volume(volume_type, source_id=backup_id)
            try:
                logger.info("Call to create a cloud volume by order interface")
                ret = self.cloud_service_subscription_evs(apply_inner_params, "apply", )
                logger.info("Order was created successfully")
            except RuntimeError as e:
                logger.info(e)
                raise Exception("Failed creating the order")
            order_id = self.get_order_id(ret)
            logger.info("Waiting for the order status to be displayed entirely")
            order_status = self.check_order_status(order_id, "successed")
            if order_status == 'successed':
                logger.info('The order status is successed')
                self.volume_type = volume_type
                break
            else:
                logger.error('The order status is {}, '
                             'use next volume type to create volume'.format(order_status))
                continue

        if order_status != 'successed':
            raise Exception('Failed creating volume with all volume types')
        logger.info("Get a list of order resource's ids")
        resource_ids_list = self.get_order_resource_ids_list(order_id)
        volume_id = resource_ids_list[0]
        logger.info("Waiting for the volume to be created successfully")
        self.wait_volume_until_status(volume_id=volume_id)
        return volume_id

    def create_volume_for_backup_in_available_volume_type(self, backup_id):
        """根据备份副本创建云硬盘

        :param backup_id:
        :return:
        """
        logger.info("Build creating cloud volume parameter body")
        apply_inner_params = self.build_evs_order_params_str_for_create_volume(self.volume_type, source_id=backup_id)
        try:
            logger.info("Call to create a cloud volume by order interface")
            ret = self.cloud_service_subscription_evs(apply_inner_params, "apply", )
            logger.info("Order was created successfully")
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed creating the order")
        order_id = self.get_order_id(ret)
        logger.info("Waiting for the order status to be displayed entirely")
        order_status = self.check_order_status(order_id, "successed")
        if order_status != 'successed':
            raise Exception('Failed creating volume with volume type:{}, the order status:{}'.
                            format(self.volume_type, order_status))
        logger.info("Get a list of order resource's ids")
        resource_ids_list = self.get_order_resource_ids_list(order_id)
        volume_id = resource_ids_list[0]
        logger.info("Waiting for the volume to be created successfully")
        self.wait_volume_until_status(volume_id=volume_id)
        return volume_id


class VBSBaseConsoleAdapter(object):
    def __init__(self, project_id):
        self.pro_id = project_id
        region_info = get_region_info(project_id)
        self.region_type = region_info.region_type
        self.region = region_info.region_id
        self.region_name = region_info.region_name
        self.az_id = get_az_id(project_id, region_info)
        params = ParamUtil()
        self.product_name = "云硬盘备份"
        self.project_evs_name = "弹性云硬盘"
        self.product_id = None
        self.project_name = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                              '%s_project1_name' % self.region_type,
                                                              self.region)
        self.provider_id = params.get_value_from_cloud_param(project_id,
                                                             'CSBS-VBS',
                                                             'vbs_provider_id',
                                                             self.region) or VBS_PROVIDER_ID
        self.user_name = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                           '%s_vdc1_vsm_user1' % self.region_type,
                                                           self.region)
        self.password = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                          '%s_sc_user_new_password' % self.region_type,
                                                          self.region)
        self.console_host = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                              '%s_console_host' % self.region_type,
                                                              self.region)
        self.console_port = "443"
        self.auth_port = "443"
        self.auth_host = params.get_value_from_cloud_param(project_id, 'Basic_MO_Test',
                                                           '%s_iam_host' % self.region_type,
                                                           self.region)
        self.volume_type_list = None
        self.project_id = None
        self.console_sc_headers = {
            "Accept": "*/*",
            "Accept-Encoding": "gzip, deflate, br",
            "Accept-Language": "zh-CN,zh;q=0.8",
            "AgencyId": None,
            "cftk": None,
            "Connection": "keep-alive",
            "Content-Type": "application/json; charset=UTF-8",
            "Cookie": None,
            "Host": self.console_host,
            "ProjectName": None,
            "Referer": None,
            "region": None,
            "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) "
                          "Chrome/59.0.3071.104 Safari/537.36",
            "X-Language": "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3",
            "X-Requested-With": "XMLHttpRequest"
        }
        self.session = requests.session()

    def login_sc(self):
        logion_obj = Login_SC(self.pro_id, self.region, self.region_type)
        user_id, self.project_id, self.region, \
        bak_global_headers, global_headers = logion_obj.login_sc_on_web(self.console_host,
                                                                        self.auth_host,
                                                                        self.user_name,
                                                                        self.password,
                                                                        self.region_name)
        self.console_sc_headers.update(global_headers)
        refer = "https://{console_host}/motenantconsolehomewebsite/".format(console_host=self.console_host)
        self.console_sc_headers['Referer'] = refer

        self.volume_type_list = self.get_volume_type_list_from_az(self.az_id)
        self.product_id = self.get_product_id_from_name(self.product_name)
        self.product_id_evs = self.get_product_id_from_name(self.project_evs_name, service_type="evs")
        self.Check_product_status()

    def get_cloud_infra_and_regionid_by_regionname(self, console_host, region_name="ALL"):
        # 根据region名称获取region_id,cloud_infra_id,cloud_infra_name
        try:
            region_name_filed = "" if region_name == "ALL" else region_name
            url = "https://{host}/motenantconsolehomewebsite/goku/" \
                  "rest/serviceaccess/v3.0/regions?name={region}".format(host=console_host,
                                                                         region=region_name_filed)
            resp = requests.get(url, verify=False, allow_redirects=False, headers=self.console_sc_headers)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            logger.info(response_body)
            if statu_code == 200:
                records = response_body.get("records")
                cloud_infra_list = []
                for region_info in records:
                    name = region_info["name"]
                    if region_name == name:
                        cloud_infras = region_info["cloud_infras"]
                        for cloud_infra in cloud_infras:
                            cloud_infra_temp = []
                            if cloud_infra["type"] == "FUSION_CLOUD":
                                region_id = cloud_infra["region_id"]
                                cloud_infra_id = cloud_infra["id"]
                                cloud_infra_name = cloud_infra["name"]
                                cloud_infra_temp.append(region_id)
                                cloud_infra_temp.append(cloud_infra_id)
                                cloud_infra_temp.append(cloud_infra_name)
                                cloud_infra_list.append(cloud_infra_temp)
                                return cloud_infra_list
                        else:
                            return None
                    elif region_name == "ALL":
                        cloud_infras = region_info["cloud_infras"]
                        for cloud_infra in cloud_infras:
                            cloud_infra_temp = []
                            if cloud_infra["type"] == "FUSION_CLOUD":
                                region_id = cloud_infra["region_id"]
                                cloud_infra_id = cloud_infra["id"]
                                cloud_infra_name = cloud_infra["name"]
                                cloud_infra_temp.append(region_id)
                                cloud_infra_temp.append(cloud_infra_id)
                                cloud_infra_temp.append(cloud_infra_name)
                                cloud_infra_list.append(cloud_infra_temp)
                return cloud_infra_list
            else:
                raise Exception("get cloud infra list failed! response is %s" % response_body)
        except Exception as e:
            logger.error('Get cloud infra list failed!')
            raise e

    def show_product_list(self, service_type="vbs"):
        """获取产品信息

        :param user_id:
        :param service_type:
        :return:
        """
        # 展示可申请的产品列表
        url = "https://{console_url}/moproductwebsite" \
              "/goku/rest/product/v3.0/products?service_type={service_type}" \
              "&start=1&limit=20&region_id={region_id}".format(console_url=self.console_host,
                                                               service_type=service_type,
                                                               region_id=self.region)
        ret = self.session.get(url=url, headers=self.console_sc_headers, verify=False)
        logger.info(ret.status_code)
        res = json.loads(ret.text)
        return ret.status_code, res

    def online_product(self, product_id):
        """租户侧对CSBS产品进行上线操作

        :return:
        """
        url = "https://{console_url}/moproductwebsite/" \
              "goku/rest/product/v3.0/products/{product_id}/action".format(console_url=self.console_host,
                                                                           product_id=product_id)
        body = {"action_type": "online", "process_ids": []}
        body1 = json.dumps(body)
        self._put(url, data=body1, verify=False)

    def get_product_info(self):
        """

        :return:
        """
        url = "https://{console_url}/moproductwebsite/goku/" \
              "rest/product/v3.0/products?service_type=vbs" \
              "&limit=20&start=1&region_id={region_id}".format(console_url=self.console_host,
                                                               region_id=self.region)
        return self._get(url)

    def Check_product_status(self):
        """租户侧检查CSBS产品是否上线，如果没有上线的话，进行上线操作

        :return:
        """
        try:
            logger.info("Get product information")
            res = self.get_product_info()
            logger.info("Succeed getting product information")
        except RuntimeError as e:
            logger.debug(e)
            raise Exception("Failed getting product information, "
                            "errMsg: {}".format(e))
        logger.info("Check that VBS products are on line or not, if not, "
                    "to carry out on-line operation")
        # 选择不需要审批的产品，如果产品没上线就执行上线操作
        product_list = res["products"]
        for_index = 0
        for pro_item in product_list:
            product_id = pro_item["product_id"]
            is_need_approval = pro_item["approval"]
            if is_need_approval is False:
                if pro_item["online_status"] == "offline":
                    try:
                        logger.info("The product is not on-line, carry "
                                    "out on-line operation")
                        self.online_product(product_id)
                        logger.info("The on-line operation was successful")
                        time.sleep(15)
                        break
                    except RuntimeError as e:
                        logger.debug(e)
                        raise Exception("Failed carrying out on-line "
                                        "operation, errMsg:{}".format(e))
                else:
                    logger.info("The product is online")
                    break
            for_index += 1

        if for_index == res["total"]:
            err_mess = "VBS not exist no approval or online product, " \
                       "product_list: %s" % product_list
            logger.info(err_mess)
            raise Exception(err_mess)

    def _pre_process(self, kwargs):
        """HTTP请求提交之前的预处理，主要是设置headers"""
        self.session.headers = self.console_sc_headers

    @staticmethod
    def _post_process(response):
        """对HTTP响应进行处理"""
        if response.ok:
            if len(response.text) > 0:
                ret = json.loads(response.text)
            else:
                ret = response.text
            return ret
        else:
            if "errorCode" in response.text:
                text_dict = json.loads(response.text)
                error_code = text_dict.get('errorCode')
                raise Exception("Request sent failed, error code:{i}, "
                                "response: {j}".format(i=error_code, j=text_dict))
            else:
                error_msg = response.text
                raise Exception("Request sent failed, response: {j}".format(j=error_msg))

    def _get(self, url, **kwargs):
        self._pre_process(kwargs)
        response = self.session.get(url, **kwargs)
        resp_body = self._post_process(response)
        return resp_body

    def _post(self, url, data=None, json=None, **kwargs):
        """submit a request with POST method."""
        self._pre_process(kwargs)
        response = self.session.post(url, data=data, json=json, **kwargs)
        return self._post_process(response)

    def _put(self, url, data, **kwargs):
        """submit a request with PUT method."""
        self._pre_process(kwargs)
        response = self.session.put(url, data, **kwargs)
        return self._post_process(response)

    def _delete(self, url, **kwargs):
        """submit a request with DELETE method."""
        self._pre_process(kwargs)
        response = self.session.delete(url, **kwargs)
        return self._post_process(response)

    def get_plan_info(self):
        """获取租户下所有策略信息

        :return:

        """
        url = "https://{console_url}/cbs/rest/karbor/v1/{project_id}/policies?provider_id={provider_id}" \
              "&sort=created_at+%3A+desc".format(console_url=self.console_host,
                                                 project_id=self.project_id,
                                                 provider_id=self.provider_id)
        return self._get(url, verify=False)

    def Query_quota(self):
        """查询配额信息
        :return:

        """
        url = "https://{console_url}/cbs/rest/karbor/v1/{project_id}/quotas".format(console_url=self.console_host,
                                                                                    project_id=self.project_id)
        return self._get(url, verify=False)

    def Add_quota_VBS(self):
        """固定增加100GB的VBS备份和复制空间

        :return:
        """
        url = "https://{console_url}/cbs/rest/karbor/v1/{project_id}" \
              "/products/{product_id}/action".format(console_url=self.console_host,
                                                     project_id=self.project_id,
                                                     product_id=self.product_id)
        body = {"apply": {"service_type": "vbs", "region_id": self.region,
                          "params": "{\"count\":1,\"display\":[{\"label\":\"备份\",\"type\":\"string\","
                                    "\"value\":\"100GB\"}],\"param_items\":[{\"type\":\"volume_backup_capacity\","
                                    "\"quota\":50000}]}"}}

        body1 = json.dumps(body)

        return self._post(url, data=body1, verify=False)

    def Delete_plan(self, plan_id):
        """删除策略

        :return:
        """
        url = "https://{console_url}/cbs/rest/karbor/v1/" \
              "{project_id}/policies/{plan_id}".format(console_url=self.console_host,
                                                       project_id=self.project_id,
                                                       plan_id=plan_id)
        self._delete(url, verify=False)

    def Check_quota_VBS(self):
        """检查VBS的备份和复制容量，是否为0，如果为0则申请100GB的容量

        :return:
        """
        try:
            logger.info("Start getting VBS quota information...")
            quota_info = self.Query_quota()
            logger.info("Get successfully")
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed getting VBS quota information, errMsg:{}".format(e))
        backup = None
        copy = None
        for quota in quota_info["quotas"]["resources"]:
            if quota["type"] == "volume_backup_capacity":
                if quota["quota"] == 0:
                    logger.info("The VBS backup capacity is 0 and cannot be used normally")
                    backup = 1
                else:
                    logger.info("the VBS backup capacity is {quota}M, "
                                "and can be used normally".format(quota=quota["quota"]))
                    pass
            if quota["type"] == "volume_copy_capacity":
                if quota["quota"] == 0:
                    logger.info("The VBS replication capacity is 0 and cannot be used normally")
                    copy = 1
                else:
                    logger.info("the VBS replication capacity is {quota}M, "
                                "and can be used normally".format(quota=quota["quota"]))
                    pass
        if backup is not None:
            m = VBSBaseAWAdapter(self.project_id)
            m.login_iam()

    def Delete_plan_VBS(self, plan_id):
        """删除策略

        :return:
        """
        i = 1
        while i < 7:
            try:
                logger.info("Delete policy {i} times".format(i=i))
                self.Delete_plan(plan_id)
                logger.info("Succeed deleting policy")
                time.sleep(5)
                i = 8
            except RuntimeError as e:
                logger.info(e)
                logger.info("Failed deleting policy")
                time.sleep(40)
                i = i + 1

    def Querying_policy_information(self):
        """获取某租户下所有VBS策略信息

        :return:
        """
        try:
            logger.info("Start getting all VBS policies' information under this tenant")
            info = self.get_plan_info()
            logger.info("Succeed getting all VBS policies' information:{i}".format(i=info))
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed getting VBS policies' information, errMsg:{}".format(e))
        return str(info)

    def Check_plan(self):
        """检查租户下是否有策略存在，如果存在的话，返回策略的ID列表

        :return:
        """
        try:
            logger.info("Get information of all policies under the tenant")
            re = self.get_plan_info()
            logger.info("Succeed getting information of all policies:{i}".format(i=re))
        except RuntimeError as e:
            logger.info(e)
            raise Exception("Failed getting information of all policies "
                            "under the tenant, errMsg:{}".format(e))
        plan_id_list = []
        if not re["policies"]:
            logger.info("After checking, there is no policy under the tenant")
            plan_id_list = None
        else:
            logger.info("After checking, there are some policies under the tenant")
            for policies in re["policies"]:
                plan_id_list.append(policies["id"])
            logger.info("All policies ids under tenant: %s" % plan_id_list)
        return plan_id_list

    def Check_setup(self):
        """任务开始前的检查
        1. 检查租户下是否有策略存在，如果有，则提前删除
        2. 检查租户下备份复制空间是否有容量，如果没有，则自动申请
        :return:
        """
        logger.info("Start checking for policies under the tenant and delete them ahead of time")
        plan_info = self.Check_plan()
        if plan_info is None:
            pass
        else:
            logger.info("Start deleting policy...")
            for plan_id in plan_info:
                self.Delete_plan_VBS(plan_id)
        logger.info("Check if there is capacity in the backup space under the tenant,"
                    " and if not, automatically request")
        self.Check_quota_VBS()

    def get_product_id_from_name(self, evs_product_name, service_type="vbs"):
        """根据product名字获取product_id

        :param region_name:
        :return:
        """
        code, res = self.show_product_list(service_type=service_type)
        total = res["total"]
        product_list = res["products"]
        for n in range(0, total):
            if evs_product_name in product_list[n]["name"]:
                logger.info(product_list[n]["product_id"])
                return product_list[n]["product_id"]
        else:
            logger.info("%s Product not exist", evs_product_name)
            raise Exception("%s Product not exist", evs_product_name)

    def show_azone_list_of_region(self):
        url = "https://%s/moserviceaccesswebsite/goku/rest/serviceaccess/v3.0/available-zones?region_id=%s" % \
              (self.console_host, self.region)
        ret = self.session.get(url=url, headers=self.console_sc_headers, allow_redirects=False, verify=False)
        logger.info("Search all available zones under region")
        logger.info('Current request Status:[{}]'.format(ret.status_code))
        res = json.loads(ret.text)
        return ret.status_code, res

    def get_volume_type_list_from_az(self, az_id):
        simple_vol_type_list = []
        try:
            url = 'https://{}/ecm/rest/v1/resource-tags/volume_type?' \
                  'availability_zone-any={}&not-hybrid_filter=false'.format(self.console_host, az_id)
            ret = self.session.get(url=url, headers=self.console_sc_headers, verify=False)
            logger.info('The current request status:[{}]'.format(str(ret.status_code)))
            if ret.status_code != 200:
                raise Exception('Fail to send request, errMsg:[{}]'.format(str(ret.text)))
            for vol_type_info in json.loads(ret.text)['resources']:
                vol_type_name_list = vol_type_info['tags']['name']
                if vol_type_name_list:
                    vol_type_name = vol_type_name_list[0]
                    simple_vol_type_list.append(vol_type_name)
            if not simple_vol_type_list:
                raise Exception('Fail to get volume type from az, detail info:[{}]'.format(str(ret.text)))
        except Exception as e:
            raise e
        return simple_vol_type_list
