import os
from configparser import ConfigParser

from utils.common.fic_base import StepBaseInterface
import utils.common.log as logger
from utils.common.message import Message
from utils.common.exception import FCUException
from utils.business.manageone_cmdb_util import ManageOneCmdbUtil

logger.init("CSBS-VBS")
conf_path = os.path.realpath(__file__ + '../../../conf/upgrade.ini')


class RollbackCMDB(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        conf = ConfigParser()
        conf.read(conf_path)
        self.target_version = conf.get('VERSION', 'target_version')
        self.cmdb_util = ManageOneCmdbUtil(project_id)

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        return Message(200)

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            logger.info('Start calling cmdb_util.remove_cloud_service_info to execute rollbackCMDB')
            self.cmdb_util.remove_cloud_service_info(self.regionid_list[0], 'CSBS-VBS', self.target_version)
            logger.info('Succeed executing rollbackCMDB')
        except FCUException as e:
            logger.error("Failed executing rollbackCMDB, ErrMsg: {}".format(str(e)))
            return Message(500, e)
        except Exception as e:
            logger.error("Failed executing rollbackCMDB, ErrMsg: {}".format(e))
            return Message(500, e)
        logger.info('Succeed executing rollbackCMDB')
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return: Message类对象
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：检查
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        return Message(200)
