from utils.common.fic_base import StepBaseInterface
import utils.common.log as logger
from utils.common.message import Message
from plugins.CSBS_VBS.common.scripts.cbs_params import Params
from plugins.CSBS_VBS.common.scripts import cbs_karborclient as karbor_client
from platforms.upgradecheck.check_result import CheckResult
from plugins.CSBS_VBS.common.scripts.cbs_params import is_csha_scene

logger.init("CSBS-VBS")


class TurnOffAutoBak(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.service_name = "CSBS-VBS"
        params = Params(project_id, pod_id, self.service_name,
                        self.regionid_list[0])
        self.db_param_dict = params.get_params()
        self.dmk_config_content = {}

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        return Message(200)

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        logger.info("Start to turn off Karbor Automatic Backup.")

        # stop karbor operation service
        check_results = []
        try:
            cbs_node0 = karbor_client.CBSNode(
                self.db_param_dict.get("karbor_host0"), "djmanager",
                self.db_param_dict.get("karbor_djmanager_pwd"),
                self.db_param_dict.get("karbor_root_pwd"))
            cbs_node1 = karbor_client.CBSNode(
                self.db_param_dict.get("karbor_host1"), "djmanager",
                self.db_param_dict.get("karbor_djmanager_pwd"),
                self.db_param_dict.get("karbor_root_pwd"))
            node_list = [cbs_node0, cbs_node1]
            if not is_csha_scene(self.project_id):
                cbs_node2 = karbor_client.CBSNode(
                    self.db_param_dict.get("karbor_host2"), "djmanager",
                    self.db_param_dict.get("karbor_djmanager_pwd"),
                    self.db_param_dict.get("karbor_root_pwd"))
                node_list.append(cbs_node2)
            self.delete_icagent_file(node_list)
            ssh_client = karbor_client.get_sshclient_user_su_root(cbs_node0)

            name_ch = "检查自动备份功能是否关闭"
            name_en = "CheckAutoBackupTurnedOff"

            if self.is_operation_service_on(ssh_client):
                cmds = "stop_service --service karbor-operation"
                result = karbor_client.ssh_exec_command_return(ssh_client,
                                                               cmds)
                ret = karbor_client.is_ssh_cmd_executed(result)
                if not ret:
                    logger.info("Failed to turn off automatic "
                                "backup function.")
                    result = CheckResult(
                        itemname_ch=name_ch,
                        itemname_en=name_en,
                        status="failure",
                        error_msg_cn="关闭自动备份功能失败",
                        error_msg_en="Failed to turn off automatic "
                                     "backup function",
                        suggestion_cn="请登录Karbor节点1，执行命令stop_service "
                                      "--s karbor-operation，关闭自动备份功能。",
                        suggestion_en="Login Karbor first node, and execute "
                                      "cmd stop_service --s karbor-operation t"
                                      "o turn off the automatic "
                                      "backup function.")
                else:
                    logger.info("Turn off automatic backup function success.")
                    result = CheckResult(itemname_ch=name_ch,
                                         itemname_en=name_en,
                                         status="success")
            else:
                logger.info("Karbor automatic backup function is off.")
                result = CheckResult(itemname_ch=name_ch,
                                     itemname_en=name_en,
                                     status="success")

            check_results.append(result)
            karbor_client.ssh_close(ssh_client)
            return Message(200, check_results=check_results)

        except Exception as e:
            logger.error("Failed to turn off Karbor Automatic Backup, "
                         "reason: %s", str(e))
            return Message(500, e, e)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return: Message类对象
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：检查
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        return Message(200)

    @staticmethod
    def is_operation_service_on(ssh_client):
        cmds = "show_service --service karbor-operation | sed 's/ //g'"
        ret = karbor_client.ssh_exec_command_return(ssh_client, cmds)
        if not karbor_client.is_ssh_cmd_executed(ret):
            msg = "Failed to execute cmd show-service."
            logger.error("Failed to execute cmd show-service.")
            raise Exception(msg)
        for item in ret:
            status = item.split("|")
            if len(status) == 6 and status[3] == "normal":
                return True
        return False

    @staticmethod
    def delete_icagent_file(node_list):
        logger.info("Begin to delete icagent file on karbor node.")
        agent_path = "/home/moicagent/tools/pyscript/plugins/extenal"
        # 执行拷贝和删除命令，有可能目录不存在，不判断返回
        for node in node_list:
            ssh_client = karbor_client.get_sshclient_user_su_root(node)
            backup_cmd = "/usr/bin/cp -rf %s/CBS/check_service_status.sh " \
                         "/home/djmanager/check_service_status.sh_bak" \
                         % agent_path
            karbor_client.ssh_exec_command_return(ssh_client, backup_cmd)
            delete_cmd = "rm -f %s/CBS/check_service_status.sh" % agent_path
            delete_cmd1 = "rm -f %s/6.5.0/CBS/check_service_status.sh" \
                          % agent_path
            delete_cmd2 = "rm -f %s/6.3/CBS/check_service_status.sh" \
                          % agent_path
            karbor_client.ssh_exec_command_return(ssh_client, delete_cmd)
            karbor_client.ssh_exec_command_return(ssh_client, delete_cmd1)
            karbor_client.ssh_exec_command_return(ssh_client, delete_cmd2)
            logger.info("Delete icagent file on karbor node:%s "
                        "success." % node.ip)
            delete_pyc = "find /usr/lib/python2.7/ -name *.pyc | xargs rm -f"
            karbor_client.ssh_exec_command_return(ssh_client, delete_pyc)
            logger.info("Delete pyc files on karbor node:%s "
                        "success." % node.ip)
            karbor_client.ssh_close(ssh_client)
