import os
from utils.common.fic_base import StepBaseInterface
import utils.common.log as logger
from utils.common.message import Message
from plugins.CSBS_VBS.common.scripts.cbs_params import Params
from plugins.CSBS_VBS.common.scripts.cbs_apiadapter import API
from utils.common.exception import FCUException

logger.init("CSBS-VBS")


class UploadPkgToDMK(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.service_name = "CSBS-VBS"
        params = Params(project_id, pod_id, self.service_name,
                        self.regionid_list[0])
        self.db_param_dict = params.get_params()

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        return Message(200)

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        # Upload Console upgrade package to DMK
        try:
            logger.info("CSBS: %s" % "upload upgrade packages start.")

            API.login_dmk(self.db_param_dict['DMK_dmk_floatIp'],
                          self.db_param_dict['dmk_account'],
                          self.db_param_dict['dmk_account_pwd'])

            pkg_path, file_name = API.find_file("OceanStor BCManager",
                                                "_CBS_Console.zip")
            if not file_name:
                msg = "can not find Console pkg."
                raise Exception(msg)
        except Exception as ex:
            logger.error(ex)
            return Message(500, FCUException(645000))

        try:
            pkg = os.path.join(pkg_path, file_name)
            API.uploadpkgtodmk(
                self.db_param_dict['DMK_dmk_floatIp'],
                self.db_param_dict['DMK_dmk_os_business_username'],
                self.db_param_dict['DMK_dmk_os_business_user_password'],
                pkg, pod_id)
        except Exception as ex:
            logger.error(ex)
            return Message(500, ex, ex)

        logger.info("Upload Console upgrade package to DMK successfully.")

        # Upload Karbor upgrade package to DMK
        try:
            pkg_path, file_name = API.find_file("OceanStor BCManager",
                                                "_CBS_Karbor_Upgrade_X86.zip")
            if not file_name:
                msg = "can not find Karbor pkg."
                raise Exception(msg)
        except Exception as ex:
            logger.error(ex)
            return Message(500, FCUException(645000))

        try:
            pkg = os.path.join(pkg_path, file_name)
            API.uploadpkgtodmk(
                self.db_param_dict['DMK_dmk_floatIp'],
                self.db_param_dict['DMK_dmk_os_business_username'],
                self.db_param_dict['DMK_dmk_os_business_user_password'],
                pkg, pod_id)
        except Exception as ex:
            logger.error(ex)
            return Message(500, ex, ex)

        logger.info("Upload Karbor upgrade package to DMK successfully.")

        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return: Message类对象
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：检查
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        return Message(200)
