import utils.common.log as logger
from plugins.CSBS_VBS.common.scripts.cbs_params import Params
from plugins.CSBS_VBS.common.scripts.cbs_apiadapter import API
import utils.business.dmk_util as DmkApi
from utils.common.exception import FCUException
from utils.business.param_util import ParamUtil

logger.init("CSBS-VBS")


class Accounts(object):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        params = Params(project_id, pod_id, "CSBS-VBS", self.regionid_list[0])
        self.db_param_dict = params.get_params()
        self.__accounts = {}
        self.role = '2'
        self.params = ParamUtil()

    def create_accounts(self):
        self.__create_dmk_user()

    def __create_dmk_user(self):
        dmk_user = self.db_param_dict['dmk_account']
        user_tmp_pwd = self.db_param_dict['tmp_dmk_account_pwd']
        user_pwd = self.db_param_dict['dmk_account_pwd']
        team_name = self.db_param_dict['dmk_account_group']

        # 创建登录DMK用的用户，使用dmk管理员账户
        API.login_dmk(self.db_param_dict['DMK_dmk_floatIp'],
                      self.db_param_dict['DMK_dmk_ui_username'],
                      self.db_param_dict['DMK_dmk_ui_password'])
        user_info = API.createdmkuser(dmk_user, user_tmp_pwd, self.role, team_name)
        user_id = user_info[1]
        team_id = user_info[0]

        # 初次登录DMK，修改用户密码
        API.login_dmk(self.db_param_dict['DMK_dmk_floatIp'], dmk_user, user_tmp_pwd)
        API.changedmkuserpasswd(user_id, user_tmp_pwd, user_pwd)

        # 创建升级用账号cbs_admin
        account_cbs_admin_name = "cbs_admin"
        account_cbs_admin_pwd = self.db_param_dict['console_cbs_admin_pwd']
        account_console_root = self.db_param_dict['console_root_pwd']
        API.login_dmk(self.db_param_dict['DMK_dmk_floatIp'], dmk_user, user_pwd)
        API.addaccounttodmk(account_cbs_admin_name, team_id,
                            account_cbs_admin_pwd, account_console_root)

        # 创建升级用账号djmanager
        account_djmanager_name = "djmanager"
        account_djmanager_pwd = self.db_param_dict['karbor_djmanager_pwd']
        account_karbor_root = self.db_param_dict['karbor_root_pwd']
        API.addaccounttodmk(account_djmanager_name, team_id,
                            account_djmanager_pwd, account_karbor_root)

        # 给登录DMK的用户扩展组，可以部署ICAgent服务
        team_list = [dmk_user, 'OTD']
        dmkObj = DmkApi.DmkApi()
        dmkObj.login_dmk(self.db_param_dict['DMK_dmk_floatIp'],
                         self.db_param_dict['DMK_dmk_ui_username'],
                         self.db_param_dict['DMK_dmk_ui_password'])
        result_dmk = dmkObj.update_user_to_multi_team(user_id, 2, team_list)
        if not result_dmk:
            logger.error("Failed to update user to multi_team for CBS_UPGRADE.")
            raise FCUException("640004")
