import os
import paramiko
import time

SSH_TIMEOUT = 60 * 60 * 2
KEEP_ALIVE = 30
CMD_TIMEOUT = 60 * 60 * 2


class CBSNode(object):
    def __init__(self, ip, user, userpwd, rootpwd, extra=None):
        self.ip = ip
        self.user = user
        self.userpwd = userpwd
        self.rootpwd = rootpwd
        self.extra = extra


class ARBNode(object):
    def __init__(self, ip, user, userpwd, rootpwd, extra=None):
        self.ip = ip
        self.user = user
        self.userpwd = userpwd
        self.rootpwd = rootpwd
        self.extra = extra


def get_prompt(ssh_client):
    # 内部方法,获取提示符
    ssh_client['channel'].send('\n')
    recvstr = ssh_client['channel'].recv(65535).decode('utf-8')
    while not recvstr.__contains__('\r\n'):
        recvstr = recvstr + ssh_client['channel'].recv(65535).decode('utf-8')
        time.sleep(1)
    listout = recvstr.split('\r\n')
    ssh_client['prompt'] = listout[-1]


def ssh_create_client(ip, username, passwd, port=22,
                      timeout=SSH_TIMEOUT, pub_key=None, status=True):
    # 创建一个SSH的客户端,可以保持连接,支持密匙登录，需要密匙登录时，传入需要的pub_key即
    sshclient = dict()
    trans = paramiko.Transport((ip, port))
    if not pub_key:
        trans.connect(username=username, password=passwd)
    else:
        with open(pub_key, encoding='utf-8') as _fp:
            key = paramiko.RSAKey.from_private_key(_fp)
            trans.connect(username=username, password=passwd, pkey=key)
    trans.set_keepalive(KEEP_ALIVE)
    channel = trans.open_session()
    channel.settimeout(timeout)
    channel.get_pty()
    channel.invoke_shell()
    stdout = channel.makefile('r', -1)
    sshclient['client'] = trans
    sshclient['channel'] = channel
    sshclient['stdout'] = stdout
    time.sleep(2)
    if status:
        get_prompt(sshclient)
    return sshclient


def ssh_exec_command(ssh_client, cmds):
    # 执行命令
    return ssh_client['channel'].send(cmds + "\n")


def is_expect_recv(expect_list, recvstr):
    # 查询返回值是否是期望之中的值
    for expect in expect_list:
        if recvstr.__contains__(expect):
            return True
    return False


def recv_str(recvstr, cmds):
    recvstr = recvstr.replace(' \r', '\r')
    recvstr = recvstr.replace(' \n', '\n')
    recvstr = recvstr.replace('\r', '')
    recvstr = recvstr.replace(cmds, '')
    return recvstr


def ssh_recv_output(ssh_client, cmds, expect_list, timeout=CMD_TIMEOUT):
    # 获取命令的后续输出，比较合适用来处理后台执行命令的
    recvstr = ""
    t = 0
    while not is_expect_recv(expect_list, recvstr):
        if timeout and t >= timeout:
            break
        time.sleep(1)
        if ssh_client['channel'].closed:
            recvstr = recvstr + ssh_client['channel'].recv(65535).decode('utf-8')
            recvstr = recv_str(recvstr, cmds)
            break
        if not ssh_client['channel'].recv_ready():
            continue
        recvstr = recvstr + ssh_client['channel'].recv(65535).decode('utf-8')
        recvstr = recv_str(recvstr, cmds)
        t += 1
    if not is_expect_recv(expect_list, recvstr):
        err = 'SshRecvOutput cannot find expect in ' \
              + str(timeout) \
              + ' seconds.' \
              + 'the recvd Str is:%s' % recvstr
        raise Exception(err)

    recvstr = recvstr.replace(ssh_client['prompt'], '')
    listout = recvstr.split('\n')
    listout = [x for x in listout if x]
    return listout


def ssh_exec_command_return(ssh_client, cmds):
    # 执行命令并长时间等待执行结果
    new_cmds = cmds + " ;echo last cmd result: $?"
    ssh_exec_command(ssh_client, new_cmds)
    return ssh_recv_output(ssh_client, new_cmds, ['last cmd result:'])


def ssh_send_command_expect(ssh_client, cmds,
                            expect_str="", timeout=CMD_TIMEOUT):
    # 执行一个命令,等待一段时间之后直接返回，用来处理交互式命令情况
    if not expect_str:
        expect_list = ["# ", "$ "]
    else:
        expect_list = expect_str.split(';')
    ssh_exec_command(ssh_client, cmds)
    return ssh_recv_output(ssh_client, cmds, expect_list, timeout)


def ssh_close(ssh_client):
    # 关闭ssh连接
    ssh_client['client'].close()


def is_ssh_cmd_executed(listout):
    # 判断命令是否被系统执行了;检查执行命令的结果：True：成功    False：失败
    for line in listout:
        if line.__contains__("last cmd result:"):
            lr = line.split(':')
            code = lr[1].strip()
            if 0 == int(code):
                return True
            else:
                return False
    return False


def is_file_exist(sftpclient, path):
    # 判断服务器上是否存在文件或者文件夹
    try:
        sftpclient.stat(path)
        return True
    except IOError:
        return False
    pass


def put_file(sftpclient, source, destdir):
    # 使用sftpclient上传文件到指定目录
    basename = os.path.basename(source)
    if os.path.isfile(source):
        sftpclient.put(source, destdir + '/' + basename)
    elif os.path.isdir(source):
        if not is_file_exist(sftpclient, destdir + '/' + basename):
            sftpclient.mkdir(destdir + '/' + basename)
        children = os.listdir(source)
        for child in children:
            put_file(sftpclient,
                     source + '/' + child,
                     destdir + '/' + basename)


def put(host, user, passwd, source, destdir, port=22):
    # 建立连接并上传文件到指定目录
    _transport = paramiko.Transport(sock=(host, port))
    _transport.connect(username=user, password=passwd)
    _sftpclient = paramiko.SFTPClient.from_transport(_transport)
    put_file(_sftpclient, source, destdir)
    _sftpclient.close()
    _transport.close()


def scp_file(ssh_client, cpfrom, cpto, password):
    # 使用scp传送文件到指定文件
    scp_cmd = "scp '%s' '%s'" % (cpfrom, cpto)
    listout = ssh_send_command_expect(ssh_client,
                                      scp_cmd,
                                      "(yes/no)?;password:")
    for list_out in listout:
        if is_expect_recv(['(yes/no)?'], list_out):
            listout = ssh_send_command_expect(ssh_client,
                                              "yes",
                                              "password:")
            break
    for list_out in listout:
        if is_expect_recv(['password:'], list_out):
            expect_str = "Permission denied;# ;$ "
            listout = ssh_send_command_expect(ssh_client, password, expect_str)
            break
    for list_out in listout:
        if is_expect_recv([' 100%'], list_out):
            return True
    return False


def get_sshclient_user_su_root_console(node):
    # 从user登录后切换到root
    ssh_client = ssh_create_client(node.ip, node.user, node.userpwd)
    ssh_exec_command_return(ssh_client, "TMOUT=0")
    ssh_send_command_expect(ssh_client, "sudo su root", "password for root:")
    expect_str = "Sorry, try again;Permission denied;# ;$ "
    result = ssh_send_command_expect(ssh_client, node.rootpwd, expect_str)
    if failed_to_return(result, "# ", ssh_client):
        raise Exception("sudo su root failed")
    ssh_exec_command_return(ssh_client, "TMOUT=0")
    return ssh_client


def get_sshclient_console(node):
    # noinspection PyBroadException
    try:
        ssh_client = ssh_create_client(node.ip, "root", node.rootpwd)
        ssh_exec_command_return(ssh_client, "TMOUT=0")
        return ssh_client
    except Exception:
        return get_sshclient_user_su_root_console(node)


def get_sshclient_user_su_root(node):
    # 从user登录后切换到root
    ssh_client = ssh_create_client(node.ip, node.user, node.userpwd)
    ssh_exec_command_return(ssh_client, "TMOUT=0")
    ssh_send_command_expect(ssh_client, "su root", "Password: ")
    expect_str = "Permission denied;# ;$ "
    result = ssh_send_command_expect(ssh_client, node.rootpwd, expect_str)
    if failed_to_return(result, "# ", ssh_client):
        raise Exception("sudo su root failed")
    ssh_exec_command_return(ssh_client, "TMOUT=0")
    return ssh_client


def get_sshclient(node):
    # noinspection PyBroadException
    try:
        ssh_client = ssh_create_client(node.ip, "root", node.rootpwd)
        ssh_exec_command_return(ssh_client, "TMOUT=0")
        return ssh_client
    except Exception:
        return get_sshclient_user_su_root(node)


def failed_to_return(result_list, expect_str, ssh_client):
    # 不是期望结果关闭ssh并返回
    for result in result_list:
        if is_expect_recv([expect_str], result):
            return False
    ssh_close(ssh_client)
    return True
