# -*- coding:utf-8 -*-
import plugins.CSDR_CSHA_VHA.common.CommonUtil as commutil
from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.CSDR_CSHA_VHA.common.ConsoleProcessor import ConsoleProcessor
from platforms.upgradecheck.check_result import CheckResult
import utils.common.log as logger

logger.init("CSDR")


class CheckConsoleEnv(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.CSDR_SERVICE_TYPE

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def init_params(self):
        console_params = commutil.get_console_params(self.project_id,
                                                     self.region,
                                                     self.service_name)
        self.console_ip1 = console_params["console_ip1"]
        self.console_ip2 = console_params["console_ip2"]
        self.console_business_user = console_params["console_business_user"]
        self.console_business_user_pwd = console_params["console_business_user_pwd"]
        self.console_root_pwd = console_params["console_root_pwd"]
        logger.info(
            "backup data: ip: [%s, %s]" % (self.console_ip1, self.console_ip2))

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        results = []
        logger.info("start check console env.")
        # 初始化参数信息
        self.init_params()
        # 检查环境能否ping通
        for ip in [self.console_ip1, self.console_ip2]:
            # 必须保证检查方法中不会抛出异常,而是返回具体的检查结果
            logger.info("start check %s" % ip)
            processor1 = ConsoleProcessor(ip, self.console_business_user,
                                          self.console_business_user_pwd,
                                          self.console_root_pwd)
            net_check_result = processor1.check_console_connection()
            if len(net_check_result) == 0:
                results.append(CheckResult(
                    itemname_ch="检查网络连接[%s]" % ip,
                    itemname_en="Check network connection[%s]" % ip,
                    status="success"))
                results.extend(processor1.check_console_env())
            else:
                results.extend(net_check_result)
        logger.info("check console env end.")
        return Message(200, check_results=results)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass
