# -*- coding:utf-8 -*-

import plugins.CSDR_CSHA_VHA.common.CommonUtil as commutil
from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCUException
from plugins.CSDR_CSHA_VHA.common.ServerProcessor import ServerProcessor
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_all_server_nodes
from platforms.upgradecheck.check_result import CheckResult
import utils.common.log as logger

logger.init("CSDR")


class CheckServerEnv(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.CSDR_SERVICE_TYPE

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def init_params(self):
        server_params = commutil.get_server_params(self.project_id,
                                            self.region,
                                            self.service_name)
        self.server_ip1 = server_params["server_ip1"]
        self.server_business_user = server_params["server_business_user"]
        self.server_business_user_pwd = server_params["server_business_user_pwd"]
        self.server_root_pwd = server_params["server_root_pwd"]

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        logger.info("start check process.")
        results = []
        # 初始化参数信息
        self.init_params()
        all_ips = get_all_server_nodes(self.server_ip1,
                                       self.server_business_user,
                                       self.server_business_user_pwd,
                                       self.server_root_pwd)
        if all_ips.__len__() < 1 or all_ips.__len__() > 2 \
                or all_ips.__contains__(self.server_ip1) is False:
            logger.error(
                "query eReplication ip from %s failed" % self.server_ip1)

            check = CheckResult(itemname_ch="获取对端节点IP",
                                itemname_en="Get the peer server ip",
                                status="failure",
                                error_msg_cn=FCUException(665006))
            results.append(check)
            return Message(200, check_results=results)
        for ip in all_ips:
            processor1 = ServerProcessor(ip, self.server_business_user,
                                         self.server_business_user_pwd,
                                         self.server_root_pwd)
            net_check_list = processor1.check_server_connection()
            if len(net_check_list) == 0:
                # 网络通的情况下再进行后续检查
                results.append(
                    CheckResult(itemname_ch="检查网络连接[%s]" % ip,
                                itemname_en="Check network connection[%s]" % ip,
                                status="success"))
                results.extend(processor1.check_env(project_id))
            else:
                results.extend(net_check_list)

        logger.info("check environment end.")
        return Message(200, check_results=results)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass
