# -*- coding:utf-8 -*-
import base64
import plugins.CSDR_CSHA_VHA.common.CommonUtil as commutil
import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCUException
from utils.business.manageone_cmdb_util import ManageOneCmdbUtil


logger.init("CSDR")


class RegisterCMDB(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.CSDR_SERVICE_TYPE

    def init_params(self):
        console_params = commutil.get_console_params(self.project_id,
                                                     self.region,
                                                     self.service_name)
        self.console_ip1 = console_params["console_ip1"]
        self.console_ip2 = console_params["console_ip2"]
        self.console_business_user = console_params["console_business_user"]
        self.console_business_user_pwd = \
            console_params["console_business_user_pwd"]
        self.console_root_pwd = console_params["console_root_pwd"]

        server_params = commutil.get_server_params(self.project_id,
                                            self.region,
                                            self.service_name)
        self.server_ip1 = server_params["server_ip1"]
        self.server_business_user = server_params["server_business_user"]
        self.server_business_user_pwd = server_params["server_business_user_pwd"]
        self.server_root_pwd = server_params["server_root_pwd"]

        logger.info("init params successfully. server ip1: [%s]"
                    % (self.server_ip1))

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        try:
            logger.info("start register params to cmdb")

            # 初始化参数信息
            self.init_params()

            deploy_node_infos = []
            deploy_server_node_info = \
                {
                    "name": "Service-eReplication",
                    "ipAddresses": [{ "ip": self.server_ip1}]
                }
            deploy_console_node1_info = \
                {
                    "name": "Console-eReplication01",
                    "ipAddresses": [{ "ip": self.console_ip1 }]
                }
            deploy_console_node2_info = \
                {
                    "name": "Console-eReplication02",
                    "ipAddresses": [{ "ip": self.console_ip2 }]
                }

            deploy_node_infos.append(deploy_server_node_info)
            deploy_node_infos.append(deploy_console_node1_info)
            deploy_node_infos.append(deploy_console_node2_info)

            # 从现有服务节点去查询当前版本号
            original_version = commutil.get_current_version(
                self.server_ip1,
                self.server_business_user,
                self.server_business_user_pwd,
                self.server_root_pwd)

            # 软件包的版本就是要升到的目的版本
            version = commutil.get_pkg_version(project_id)
            logger.info("get pkg version %s successful" % version)

            extend_infos = commutil.get_install_components(project_id, self.region)
            cloud_service_info = {"indexName": "eReplication",
                                  "version": version,
                                  "originalVersion": original_version,
                                  "deploy_node_infos": deploy_node_infos,
                                  "extendInfos": extend_infos}
            cmdb_util = ManageOneCmdbUtil(project_id)
            cmdb_util.set_cloud_service_info(self.region, cloud_service_info)


        except FCUException as fe:
            logger.error("Failed to register cmdb, errMsg=%s" % str(fe))
            return Message(500, fe)
        except Exception as e:
            logger.error("Failed to register cmdb, errMsg=%s" % str(e))
            return Message(500, FCUException(
                '665002', "Register information to cmdb failed"))
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

