# -*- coding:utf-8 -*-
from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.business.param_util import ParamUtil
from utils.common.exception import FCUException
from plugins.CSDR_CSHA_VHA.common.ConsoleProcessor import upload_console_package
import utils.common.log as logger

logger.init("CSDR")


class UploadPackage(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.CSDR_SERVICE_TYPE

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def init_params(self):
        params = ParamUtil()
        self.region = self.regionid_list[0]
        self.dmk_os_user = params.get_value_from_cloud_param(
            self.project_id,
            "DMK_public_params",
            "dmk_os_business_username",
            self.region)
        self.dmk_os_pwd = params.get_value_from_cloud_param(
            self.project_id,
            "DMK_public_params",
            "dmk_os_business_user_password",
            self.region)
        self.dmk_float_ip = params.get_value_from_cloud_param(
            self.project_id,
            "DMK_public_params",
            "dmk_floatIp",
            self.region)
        self.dmk_depoly_user = params.get_value_from_cloud_param(
            self.project_id, "CSDR", "dmk_deploy_user", self.region)
        self.dmk_deploy_new_pwd = params.get_value_from_cloud_param(
            self.project_id, "CSDR", "dmk_deploy_new_pwd", self.region)

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        try:
            logger.info("start upload process.")
            # 初始化参数信息
            self.init_params()

            upload_console_package(self.dmk_float_ip, self.dmk_depoly_user,
                                   self.dmk_deploy_new_pwd, self.dmk_os_user,
                                   self.dmk_os_pwd, self.pod_id, project_id)

            logger.info("upload package successfully.")
        except FCUException as fe:
            logger.error("upload package failed, errMsg=%s" % str(fe))
            return Message(500, fe)
        except Exception as e:
            logger.error("upload package failed, errMsg=%s" % str(e))
            return Message(500, FCUException('665002', str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass
