# -*- coding:utf-8 -*-

from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCUException
from plugins.CSDR_CSHA_VHA.common.ServerProcessor import UpgradeProcess
import utils.common.log as logger

logger.init("CSDR")


class UploadPackage(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.CSDR_SERVICE_TYPE

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        try:
            logger.info("start upload process.")

            uprocess = UpgradeProcess(self.pod_id, self.project_id,
                                      self.regionid_list[0], "CSDR")
            uprocess.upload_server_package(project_id)

            logger.info("upload package successfully.")
        except FCUException as fe:
            logger.error("upload package failed, errMsg=%s" % str(fe))
            return Message(500, fe)
        except Exception as e:
            logger.error("upload package failed, errMsg=%s" % str(e))
            return Message(500, FCUException('665002', str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass
