# --*-- coding: utf-8 --*--

from utils.common.fic_base import StepBaseInterface
from platforms.param.ParamManager import ParamService
from plugins.CSDR_CSHA_VHA.common.csdr_delete_flavor import DeleteFlavor
from plugins.CSDR_CSHA_VHA.common.CSDRTestBase import *
from plugins.AcceptanceTest.basic_mo_test.common.login_sc import LoginSC
import utils.common.log as logger

logger.init("CSDR")


class CleanEnv(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的参数预检查和获取，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行测试
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """


        try:
            db_obj = ParamService()
            project_info = db_obj.get_project_info(project_id)
            region_id = project_info.get('region_id')
            region_type = project_info.get('region_type')
            loginsc = LoginSC(project_id, region_id, region_type)
            sc_api = sc_tenant_api(project_id, regionid_list[0],
                                   CSDR_SERVICE_TYPE)


            # flavor name is FCU_2U2G20G_csdr
            flavor_name = sc_api.flavor_name + "_csdr"
            logger.info("start delete flavor %s" % flavor_name)
            fs_obj = DeleteFlavor(project_id)
            flavor_id = fs_obj.query_flavor(flavor_name)
            if flavor_id:
                fs_obj.delete_flavor_om_service(flavor_id)
            logger.info("delete flavor success")
            logger.info("flavor:%s id is %s:" % (flavor_name, flavor_id))
            logger.info("start to clean ccs tag of %s " % (flavor_name))
            fs_obj.delete_flavor_tag(flavor_name)
            logger.info("clean ccs tag of %s successfully" % (flavor_name))




            loginsc.login_sc()
            vdc_id = loginsc.search_vdc_by_name(sc_api.vdc1)
            loginsc.delete_vdc_user(vdc_id)
            isSuccess, error_msg = loginsc.delete_tenant(vdc_id)
            if isSuccess is False:
                return Message(500, "清理租户失败[%s]" % error_msg,
                               "Failed to delete tenant user[%s]" % error_msg,
                               "请检查", "Please check.")
            else:
                logger.info("delete tenant success.")


            return Message(200)
        except Exception as e:
            logger.error("Failed to create tenant user, errMsg=%s" % str(e))
            return Message(500, "清理租户失败[%s]" % str(e),
                           "Failed to delete tenant user[%s]" % str(e),
                           "请检查", "Please check.")

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
