# --*-- coding: utf-8 --*--
from platforms.param.ParamManager import ParamService
from plugins.AcceptanceTest.basic_mo_test.common.login_sc import LoginSC
from plugins.CSDR_CSHA_VHA.common.CSDRTestBase import *
from plugins.CSDR_CSHA_VHA.common.TestCaseUtil import *
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
import utils.common.log as logger

logger.init("CSDR")


class CreateAccount(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的参数预检查和获取，
        该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行测试
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """

        try:
            params = get_common_params(project_id, regionid_list[0],
                                       CSDR_SERVICE_TYPE)
            sc_api = sc_tenant_api(project_id, regionid_list[0],
                                   CSDR_SERVICE_TYPE)

            db_obj = ParamService()
            project_info = db_obj.get_project_info(project_id)
            region_id = project_info.get('region_id')
            region_type = project_info.get('region_type')
            loginsc = LoginSC(project_id, region_id, region_type)
            logger.info("Start to create tenant")
            vdcid, userid, sc_project_id = fcu_create_tenant(
                loginsc, sc_api.vdc1, sc_api.tenant_user,
                sc_api.tenant_user_pwd, sc_api.project1)

            logger.info("vdcid:%s, userid:%s, sc_project_id:%s" % (vdcid, userid, sc_project_id))
            if vdcid and userid and sc_project_id:
                logger.info('create a tenant FCU_csdr successfully')

                # 因为现在是在主Region创建租户，所以sc_api.current_region_type是主Region的type
                if sc_api.current_region_type in ["type1", "type2"]:
                    region_records = loginsc._get_region_records()
                    for region_record in region_records:
                        if sc_api.tool_region_id == region_record["id"]:
                            region_id, cloud_infra_id, cloud_infra_name = get_cloud_info(region_record)
                            networkid1 = loginsc.get_external_networks_id_by_name("dummy_external_network",
                                                                                  cloud_infra_id)
                            loginsc.distribute_external_networks(networkid1, vdcid,
                                                                 "dummy_external_network", cloud_infra_id)
                return Message(200)
            else:
                return Message(500, "创建租户失败[%s]" % sc_api.vdc1,
                           "Failed to create tenant user[%s]" % sc_api.vdc1,
                           "请检查", "Please check.")

        except Exception as e:
            logger.error("Failed to create tenant user, errMsg=%s" % str(e))
            return Message(500, "创建租户失败[%s]" % str(e),
                           "Failed to create tenant user[%s]" % str(e),
                           "请检查", "Please check.")

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
