# --*-- coding: utf-8 --*--

from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.CSDR_CSHA_VHA.common.CSDRTestBase import *
from plugins.CSDR_CSHA_VHA.common.TestCaseUtil import get_cloud_info
import utils.common.log as logger

logger.init("CSDR")


class CreateDrVM(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的参数预检查和获取，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行测试
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:

            logger.info("start distribute external network")
            db_obj = ParamService()
            project_info = db_obj.get_project_info(project_id)
            region_id = project_info.get('region_id')
            region_type = project_info.get('region_type')
            loginsc = LoginSC(project_id, region_id, region_type)
            loginsc.login_sc()
            sc_api = sc_tenant_api(project_id, regionid_list[0],
                                   CSDR_SERVICE_TYPE)


            if sc_api.current_region_type in ["type1", "type2"]:
                region_records = loginsc._get_region_records()
                for region_record in region_records:
                    # 因为租户是在主Region调测时候创建的，在创建的时候只给主Region分配了外部网络
                    # 在从Region调测的时候，创建虚拟机之前如果是type1，type2，也要单独
                    # 给从Region的租户分配外部网络才可以让后面的调测成功
                    if sc_api.tool_region_id == region_record["id"]:
                        region_id, cloud_infra_id, cloud_infra_name = get_cloud_info(
                            region_record)
                        networkid1 = loginsc.get_external_networks_id_by_name(
                            "dummy_external_network",
                            cloud_infra_id)
                        vdcid = loginsc.search_vdc_by_name(sc_api.vdc1)
                        loginsc.distribute_external_networks(networkid1, vdcid,
                                                             "dummy_external_network",
                                                             cloud_infra_id)

            logger.info("start create dr test vm.")
            params = get_common_params(project_id, regionid_list[0],
                                       CSDR_SERVICE_TYPE)

            # 创建从Region测试虚拟机
            vm_3 = {"az_name": params[STANDBY_AZ_NAME],
                    "vol_type": params[STANDBY_VOL_TYPE],
                    "name": params[DR_VM_NAME]}
            vm_4 = {"az_name": params[STANDBY_AZ_NAME],
                    "vol_type": params[STANDBY_VOL_TYPE],
                    "name": params[DR_VM_NAME] + "_01"}
            sc_api.create_vm(params[STANDBY_REGION_NAME], [vm_3, vm_4])
            logger.info("create all test vm successfully.")
            return Message(200)
        except Exception as e:
            logger.error("Failed to create test vm, errMsg=%s" % str(e))
            return Message(500, "创建测试虚拟机失败[%s]" % str(e),
                           "Failed to create vm[%s]" % str(e),
                           "请检查", "Please check.")

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
