# --*-- coding: utf-8 --*--

from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.CSDR_CSHA_VHA.common.CSDRTestBase import *
from plugins.CSDR_CSHA_VHA.common.TestCaseUtil import create_csdr_flavor
import utils.common.log as logger

logger.init("CSDR")


class CreateProductVM(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的参数预检查和获取，
        该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行测试
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:


            sc_api = sc_tenant_api(project_id, regionid_list[0],
                                   CSDR_SERVICE_TYPE)

            logger.info("start create flavor %s" % sc_api.flavor_name + "_csdr")
            message = create_csdr_flavor(sc_api.flavor_name + "_csdr", project_id)
            if message.status_code == 500:
                return message

            logger.info("start create product test vm.")
            params = get_common_params(project_id, regionid_list[0],
                                       CSDR_SERVICE_TYPE)
            # 创建主Region测试虚拟机
            vm_1 = {"az_name": params[PRIMARY_AZ_NAME],
                    "vol_type": params[PRIMARY_VOL_TYPE],
                    "name": params[PRODUCT_VM_NAME]}
            vm_2 = {"az_name": params[PRIMARY_AZ_NAME],
                    "vol_type": params[PRIMARY_VOL_TYPE],
                    "name": params[PRODUCT_VM_NAME] + "_01"}
            sc_api.create_vm(params[PRIMARY_REGION_NAME], [vm_1, vm_2],
                             params[FIRST_REGION_TYPE])

            logger.info("create all test vm successfully.")
            return Message(200)
        except Exception as e:
            logger.error("Failed to create test vm, errMsg=%s" % str(e))
            return Message(500, "创建测试虚拟机失败[%s]" % str(e),
                           "Failed to create vm[%s]" % str(e),
                           "请检查", "Please check.")

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
