# -*- coding:utf-8 -*-
from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCUException
from plugins.CSDR_CSHA_VHA.common.DnsAndEndPoint import DnsAndEndPoint
import utils.common.log as logger

logger.init("CSHA")

class Register(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.CSHA_SERVICE_TYPE

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        for i in range(1, 4):
            try:
                logger.info("start register dns and endpoint.")
                DnsAndEndPoint(pod_id, self.region, project_id,
                               self.service_name).config()
                return Message(200)
            except FCUException as fe:
                logger.error(
                    "Failed to register dns or endpoint for the %s times, "
                    "errMsg=%s" % (i, str(fe)))
                if i != 3:
                    continue
                return Message(500, fe)
            except Exception as e:
                logger.error(
                    "Failed to register dns or endpoint for the %s times, "
                    "errMsg=%s" % (i, str(e)))
                if i != 3:
                    continue
                return Message(500, FCUException('665002', str(e)))


    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass
