# -*- coding:utf-8 -*-
import plugins.CSDR_CSHA_VHA.common.CommonUtil as commutil
from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCUException
from plugins.CSDR_CSHA_VHA.common.ConsoleProcessor import ConsoleProcessor
import utils.common.log as logger

logger.init("CSHA")


class RollbackConsole(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.CSHA_SERVICE_TYPE

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def init_params(self):
        console_params = commutil.get_console_params(self.project_id,
                                                     self.region,
                                                     self.service_name)
        self.console_ip1 = console_params["console_ip1"]
        self.console_ip2 = console_params["console_ip2"]
        self.console_business_user = console_params["console_business_user"]
        self.console_business_user_pwd = \
            console_params["console_business_user_pwd"]
        self.console_root_pwd = console_params["console_root_pwd"]
        logger.info(
            "backup data: ip: [%s, %s]" % (self.console_ip1, self.console_ip2))

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        try:
            logger.info("start rollback console.")
            # 初始化参数信息
            self.init_params()

            processor1 = ConsoleProcessor(self.console_ip1,
                                          self.console_business_user,
                                          self.console_business_user_pwd,
                                          self.console_root_pwd)
            processor1.restore_console_runtime()

            processor2 = ConsoleProcessor(self.console_ip2,
                                          self.console_business_user,
                                          self.console_business_user_pwd,
                                          self.console_root_pwd)
            processor2.restore_console_runtime()

            logger.info("rollback console runtime successfully.")
        except FCUException as fe:
            logger.error("rollback console runtime failed, errMsg=%s" % str(fe))
            return Message(500, fe)
        except Exception as e:
            logger.error("rollback console runtime failed, errMsg=%s" % str(e))
            return Message(500, FCUException('665002', str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass
