# --*-- coding: utf-8 --*--

from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.CSDR_CSHA_VHA.common.CSDRTestBase import *
import utils.common.log as logger

logger.init("CSHA")


class CreateInstance(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的参数预检查和获取，
        该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行测试
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        sc_opt = None
        try:
            logger.info("start create instance test case...")
            sc_opt = SCBase(project_id, regionid_list[0], CSHA_SERVICE_TYPE)
            sc_opt.login_sc()
            sc_opt.apply_service_instance()
            logger.info("create instance test case complete!!!!")
            return Message(200)
        except Exception as e:
            logger.error("Failed to create instance, errMsg=%s" % str(e))
            return Message(500, "申请服务实例失败[%s]" % str(e),
                           "Failed to apply service instance[%s]" % str(e),
                           "请检查", "Please check.")
        finally:
            if sc_opt != None:
                sc_opt.close()

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
