# --*-- coding: utf-8 --*--

from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.CSDR_CSHA_VHA.common.CSDRTestBase import *
from .Sub_Job_TestCSHA_SwitchDRMode import SwitchDRMode
from .Sub_Job_TestCSHA_RecoverySwitchDRMode import RecoverySwitchDRMode
from utils.common.exception import FCUException
import utils.common.log as logger

logger.init("CSHA")


class PlanMotion(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的参数预检查和获取，
        该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行测试
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            logger.info("start execute SwitchDRMode")
            message = SwitchDRMode(project_id, pod_id, regionid_list).execute(
                project_id, pod_id, regionid_list)
            if message.status_code == 500:
                return message
            logger.info("start plan motion test case...")
            request_api = RequestApi(project_id, regionid_list[0],
                                     CSHA_SERVICE_TYPE)

            # 获取待测试的计划性迁移对象
            recovery_plan, message = request_api.get_dest_recovery_plan()
            if message.status_code != 200:
                return message

            plan_uuid = recovery_plan.__getitem__("uuid")
            logger.info("get dest recovery plan uuid is %s" % plan_uuid)

            # 对指定恢复计划下发计划性迁移请求
            message = request_api.recoveryplan_motion_test(plan_uuid,
                                                           CSHA_SERVICE_TYPE)
            if message.status_code != 200:
                return message

            logger.info("planmotion test case complete!!!!")

            message = RecoverySwitchDRMode(project_id, pod_id, regionid_list).execute(
                project_id, pod_id, regionid_list)
            return message
        except FCUException as e:
            logger.error("plan motion test case failed, errMsg=%s" % str(e))
            return Message(500, e)
        except Exception as e:
            logger.error("plan motion test case failed, errMsg=%s" % str(e))
            return Message(500, "计划性迁移测试失败[%s]" % str(e),
                           "Failed to test recovery plan motion[%s]" % str(e),
                           "请检查", "Please check.")

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
