# --*-- coding: utf-8 --*--

from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCUException
from utils.common.ssh_util import Ssh
import utils.common.log as logger
import plugins.CSDR_CSHA_VHA.common.CommonUtil as commutil

logger.init("CSHA")


class RecoverySwitchDRMode(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的参数预检查和获取，
        该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行测试
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        ssh_client = None
        try:
            logger.info("start recovery config dr switch mode...")
            server_params = commutil.get_server_params(
                project_id, regionid_list[0], "CSHA")
            server_ip = server_params["server_ip1"]
            business_user_pwd = server_params["server_business_user_pwd"]
            sudo_user_pwd = server_params["server_root_pwd"]


            listen_ip, service_ip = commutil.get_server_node(
                server_ip, "DRManager", business_user_pwd, sudo_user_pwd)
            logger.info("the listen ip is %s" % listen_ip)
            ssh_client = Ssh.ssh_create_client(listen_ip, "DRManager",
                                               business_user_pwd, port=22,
                                               timeout=60)
            Ssh.ssh_send_command(ssh_client, "su - root", "Password", 20)
            Ssh.ssh_send_command(ssh_client, sudo_user_pwd, "#", 20)

            tmp_file = "/opt/BCManager/Runtime/tmp/DRMODE"
            result = Ssh.ssh_exec_command_return(ssh_client,
                                                 "cat %s" % tmp_file)
            if str(result).__contains__("already_manual"):
                logger.info("the mode ia already manaual before change mode, "
                            "no need recovery mode config.")
                Ssh.ssh_exec_command_return(ssh_client, "rm -f %s" % tmp_file)
                return Message(200)

            Ssh.ssh_send_command(
                ssh_client,
                "cd /opt/BCManager/Runtime/bin;sh configFailoverMode.sh",
                "want to continue", 10)
            Ssh.ssh_send_command(ssh_client, "yes", "automatic switchover", 10)
            Ssh.ssh_send_command(ssh_client, "1", "Configuration succeeded", 30)
            logger.info("recovery config dr switch mode successfully!!!!")
            return Message(200)
        except FCUException as e:
            logger.error(
                "recovery config dr switch mode failed, errMsg=%s" % str(e))
            return Message(500, e)
        except Exception as e:
            logger.error(
                "recovery config dr switch mode failed, errMsg=%s" % str(e))
            return Message(500, "恢复故障切换配置失败[%s]" % str(e),
                           "Failed to recovery dr switch config[%s]" % str(e),
                           "请检查", "Please check.")
        finally:
            if ssh_client is not None:
                try:
                    Ssh.ssh_close(ssh_client)
                except Exception as e:
                    logger.error("close ssh client failed, errMsg=%s" % str(e))

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
