# -*- coding: utf-8 -*-
import utils.common.log as logger
from platforms.param.param_check_handler import HandleParamCheck
from platforms.param.param_service import ParamService
from utils.common.code2Msg import code2Msg
import plugins.CSDR_CSHA_VHA.common.CommonUtil as comfunc


def params_check(project_id):
    """
    插件参数校验接口函数
    :param: project_id
    :return: 成功：True, ''， 失败：False，错误信息，格式：{[region_id]key : err_msg1, [region_id]key : err_msg2}
    """
    # 待校验参数列表
    server_business_key = "eReplication_server_node_ssh_password"
    server_root_key = "eReplication_server_node_ssh_sudo_password"
    console_business_key = "eReplication_console_node_ssh_password"
    console_root_key = "eReplication_console_node_ssh_sudo_password"

    check_list = [server_business_key, server_root_key,
                  console_business_key, console_root_key]
    # 记录非空且存在的key
    trueKeys = []

    # 获取待校验参数值
    params_list = ParamService().get_user_input_cloud_params_by_service(
        project_id, "CSHA")
    check_result = HandleParamCheck()

    vm_info = ParamService().get_vm_info_by_vm_name(project_id,
                                                    "Service-eReplication01")
    if not vm_info:
        check_result.set_check_result(param_keys=["Service-eReplication01"], status=500,
                                      error_msg=code2Msg(675011))
        return check_result
    server_ip1 = vm_info[0].get('ip')

    vm_info = ParamService().get_vm_info_by_vm_name(project_id,
                                                    "Service-eReplication02")
    if not vm_info:
        check_result.set_check_result(param_keys=["Service-eReplication02"], status=500,
                                      error_msg=code2Msg(675011))
        return check_result
    server_ip2 = vm_info[0].get('ip')

    vm_info = ParamService().get_vm_info_by_vm_name(project_id,
                                                    "Console-eReplication01")
    if not vm_info:
        check_result.set_check_result(param_keys=["Console-eReplication01"], status=500,
                                      error_msg=code2Msg(675011))
        return check_result
    console_ip1 = vm_info[0].get('ip')

    vm_info = ParamService().get_vm_info_by_vm_name(project_id,
                                                    "Console-eReplication02")
    if not vm_info:
        check_result.set_check_result(param_keys=["Console-eReplication02"], status=500,
                                      error_msg=code2Msg(675011))
        return check_result
    console_ip2 = vm_info[0].get('ip')
    params = {}
    for i in range(len(params_list)):
        params[params_list[i]["param_key"]] = params_list[i]["param_value"]

    # 校验所有参数值是否为空
    for key in check_list:
        if not key in list(params.keys()):
            logger.error("can not find the param key: %s" % key)
            check_result.set_check_result(param_keys=[key], status=500,
                                          error_msg=code2Msg(665004))
        elif comfunc.check_value_null(params.get(key)):
            logger.error("the key value is None: %s" % key)
            check_result.set_check_result(param_keys=[key], status=500,
                                          error_msg=code2Msg(665005))
        else:
            trueKeys.append(key)

    # 校验外部参数值的正确性, 目前需要的是server与console的系统密码是否正确
    # 校验server的密码, 能连通且不为空才校验
    comfunc.check_system_pwd(server_ip1, "DRManager", server_business_key,
                             server_root_key, check_result, params, trueKeys)
    comfunc.check_system_pwd(server_ip2, "DRManager", server_business_key,
                             server_root_key, check_result, params, trueKeys)

    # 检查Console的密码,能连通且不为空才校验
    comfunc.check_system_pwd(console_ip1, "csdr_admin", console_business_key,
                             console_root_key, check_result, params, trueKeys)
    comfunc.check_system_pwd(console_ip2, "csdr_admin", console_business_key,
                             console_root_key, check_result, params, trueKeys)

    if check_result.check_list.__len__() == 0:
        check_result.set_check_result(param_keys=check_list, status=200,
                                      error_msg='')
    return check_result
