# -*- coding: utf-8 -*-
import utils.common.log as logger
from platforms.param.param_service import ParamService
from platforms.param.param_check_handler import HandleParamCheck
from utils.common.code2Msg import code2Msg
import plugins.CSDR_CSHA_VHA.common.CommonUtil as comfunc


def params_check(project_id):
    """
    插件参数校验接口函数
    :param: project_id
    :return: 成功：True, ''， 失败：False，错误信息，格式：
    {[region_id]key : err_msg1, [region_id]key : err_msg2}
    """
    # 待校验参数列表
    logger.info("start VHA params_check")
    server_business_key = "eReplication_server_node_ssh_password"
    server_root_key = "eReplication_server_node_ssh_sudo_password"
    console_business_key = "eReplication_console_node_ssh_password"
    console_root_key = "eReplication_console_node_ssh_sudo_password"

    tc_az_key1 = "tc_vha_first_az_display_name"
    tc_region_key1 = "tc_vha_first_region_name"
    tc_volume_key1 = "tc_vha_first_volume_type"
    tc_volume_key2 = "tc_vha_second_volume_type"
    tc_key_list = [tc_az_key1, tc_region_key1, tc_volume_key1, tc_volume_key2]

    check_list = [server_business_key, server_root_key, console_business_key,
                  console_root_key]
    check_list.extend(tc_key_list)

    # 记录非空且存在的key
    trueKeys = []

    # 获取待校验参数值
    params_list = ParamService().get_user_input_cloud_params_by_service(
        project_id, "VHA")
    check_result = HandleParamCheck()

    # 因为对于VHA，存在环境中只有VHA和环境中同时包含CSDR和VHA的情况，如果是后一种，则
    # 虚拟机名称是Service-eReplication，只有VHA的话，则名称是Service-eReplication01
    vm_info = ParamService().get_vm_info_by_vm_name(project_id,
                                                    "Service-eReplication")
    if not vm_info:
        logger.info("Service-eReplication is not existed")
        vm_info = ParamService().get_vm_info_by_vm_name(project_id,
                                                        "Service-eReplication01")
        if not vm_info:
            logger.info("Service-eReplication01 is not existed")
            # param_keys里面的key值必须是前台要校验的key值，否则返回给框架会被丢弃
            check_result.set_check_result(param_keys=[server_business_key], status=500,
                                      error_msg=code2Msg(675011))
            return check_result
    server_ip1 = vm_info[0].get('ip')

    vm_info = ParamService().get_vm_info_by_vm_name(project_id,
                                                    "Console-eReplication01")
    if not vm_info:
        logger.info("Console-eReplication01 is not existed")
        check_result.set_check_result(param_keys=[console_business_key], status=500,
                                      error_msg=code2Msg(675011))
        return check_result
    console_ip1 = vm_info[0].get('ip')

    vm_info = ParamService().get_vm_info_by_vm_name(project_id,
                                                    "Console-eReplication02")
    if not vm_info:
        logger.info("Console-eReplication02 is not existed")
        check_result.set_check_result(param_keys=[console_business_key], status=500,
                                      error_msg=code2Msg(675011))
        return check_result
    console_ip2 = vm_info[0].get('ip')
    logger.info("success get all nodes' ip")
    
    params = {}
    for i in range(len(params_list)):
        params[params_list[i]["param_key"]] = params_list[i]["param_value"]

    # 校验所有参数值是否为空
    for key in check_list:
        if not key in list(params.keys()):
            logger.error("can not find the param key: %s" % key)
            check_result.set_check_result(param_keys=[key], status=500,
                                          error_msg=code2Msg(665004))
        elif comfunc.check_value_null(params.get(key)):
            logger.error("the key value is None: %s" % key)
            check_result.set_check_result(param_keys=[key], status=500,
                                          error_msg=code2Msg(665005))
        else:
            if key in tc_key_list:
                check_result.set_check_result(param_keys=[key], status=200)
            trueKeys.append(key)

    # 校验外部参数值的正确性, 目前需要的是server与console的系统密码是否正确
    # 校验server的密码, 能连通且不为空才校验，
    check_ok = comfunc.check_system_pwd(server_ip1, "DRManager",
                                        server_business_key, server_root_key,
                                        check_result, params, trueKeys)

    # 对于VHA来讲, 部署形态不固定, 可能是部署在同一个Region中的, 也可能是部署在两个
    # region中,因此先要通过第一个节点来查询出所有eReplication Server节点的IP地址,
    # 然后判断当前传入的第二个节点的IP地址是否有使用,没有使用则不校验
    if check_ok:
        all_ips = comfunc.get_all_server_nodes(
            server_ip1,
            "DRManager", comfunc.decryp_pwd(server_business_key, params),
            comfunc.decryp_pwd(server_root_key, params))
        if all_ips.__len__() <= 0 or all_ips.__len__() > 2 \
                or all_ips.__contains__(server_ip1) is False:
            logger.info("query peer server node failed from %s" % server_ip1)
            check_result.set_check_result(param_keys=[server_business_key],
                                          status=500,
                                          error_msg=code2Msg(665006))
        else:
            all_ips.remove(server_ip1)
            for ip in all_ips:
                comfunc.check_system_pwd(ip, "DRManager",
                                         server_business_key, server_root_key,
                                         check_result, params, trueKeys)

    # 检查Console的密码,能连通且不为空才校验
    comfunc.check_system_pwd(console_ip1, "csdr_admin", console_business_key,
                             console_root_key, check_result, params, trueKeys)
    comfunc.check_system_pwd(console_ip2, "csdr_admin", console_business_key,
                             console_root_key, check_result, params, trueKeys)

    if check_result.check_list.__len__() == 0:
        check_result.set_check_result(param_keys=check_list, status=200,
                                      error_msg="")
    return check_result


