# -*- coding:utf-8 -*-
import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCUException
from utils.business.dmk_util import DmkApi
from utils.business.dmk_util import DMK_ROLE
from utils.business.vm_util import *
from utils.business.param_util import ParamUtil

logger.init("VHA")


class InitDmkUser(StepBaseInterface):
    """
    """

    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.VHA_SERVICE_TYPE

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        try:
            logger.info("start check all host is connected.")
            __msg__ = {}
            if can_vm_pinged_to(self.dmk_float_ip) is False:
                logger.error("ping [%s] failed." % self.dmk_float_ip)
                __msg__.__setitem__("DMK Address", self.dmk_float_ip)
            if __msg__.__len__() != 0:
                logger.error("check host connected failed[%s]" % __msg__)
                raise FCUException('665001', __msg__)
            return Message(200)
        except FCUException as e1:
            raise e1
        except Exception as e:
            logger.error("check host connected failed, errMsg=%s" % str(e))
            raise e

    def init_params(self):
        """
        初始化当前步骤依赖的所有参数
        :return:
        """
        # DMK超级管理员账号和密码,用于创建部署Console服务的业务账号
        params = ParamUtil()
        self.region = self.regionid_list[0]
        self.dmk_float_ip = params.get_value_from_cloud_param(
            self.project_id, "DMK_public_params", "dmk_floatIp", self.region)
        self.dmk_sys_user = params.get_value_from_cloud_param(
            self.project_id, "DMK_public_params", "dmk_ui_username",
            self.region)
        self.dmk_sys_user_pwd = params.get_value_from_cloud_param(
            self.project_id, "DMK_public_params", "dmk_ui_password",
            self.region)
        self.dmk_depoly_user = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_deploy_user", self.region)
        self.dmk_depoly_pwd = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_deploy_user_pwd", self.region)
        self.dmk_depoly_group = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_deploy_group", self.region)
        self.dmk_deploy_new_pwd = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_deploy_new_pwd", self.region)
        self.vm_ssh_user = params.get_value_from_cloud_param(
            self.project_id, "VHA", "console_business_user", self.region)
        self.vm_ssh_pwd = params.get_value_from_cloud_param(
            self.project_id, "VHA", "console_business_user_pwd",
            self.region)
        self.vm_ssh_sudo_pwd = params.get_value_from_cloud_param(
            self.project_id, "VHA", "console_root_pwd", self.region)

        self.dmk_server_depoly_user = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_server_deploy_user", self.region)
        self.dmk_server_depoly_pwd = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_deploy_user_pwd", self.region)
        self.dmk_server_depoly_group = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_user_group_server", self.region)
        self.dmk_server_deploy_new_pwd = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_deploy_new_pwd", self.region)
        self.vm_server_ssh_user = params.get_value_from_cloud_param(
            self.project_id, "VHA", "server_business_user", self.region)
        self.vm_server_ssh_pwd = params.get_value_from_cloud_param(
            self.project_id, "VHA", "server_business_user_pwd", self.region)
        self.vm_server_ssh_sudo_pwd = params.get_value_from_cloud_param(
            self.project_id, "VHA", "server_root_pwd", self.region)

    def create_server_user(self, __dmkObj__):
        # 登录DMK
        __dmkObj__.login_dmk(self.dmk_float_ip, self.dmk_sys_user,
                             self.dmk_sys_user_pwd, "8443")

        # 登录成功后再创建DMK账户
        logger.debug("start create dmk account[%s], group[%s]" % (
            self.dmk_server_depoly_user, self.dmk_server_depoly_group))
        (team_id, user_id) = __dmkObj__.create_dmk_user(
            self.dmk_server_depoly_user, self.dmk_server_depoly_pwd,
            DMK_ROLE.GROUP_MANAGER, self.dmk_server_depoly_group)

        if user_id and team_id:
            chg_result = __dmkObj__.update_user_to_multi_team(
                user_id, DMK_ROLE.GROUP_MANAGER,
                ["OTD", self.dmk_server_depoly_group])
            if chg_result is False:
                logger.error("update user to OTD group failed.")
                raise Exception("update_user_to_multi_team return false")

            # 账户创建成功后修改账户密码
            __dmkObj__.login_dmk(self.dmk_float_ip, self.dmk_server_depoly_user,
                                 self.dmk_server_depoly_pwd, "8443")
            isSuccess = __dmkObj__.change_dmk_user_passwd(
                user_id,
                self.dmk_server_depoly_pwd,
                self.dmk_server_deploy_new_pwd)
            if isSuccess:
                logger.info("create user and update password successful")
                # 添加待安装软件节点的ssh账户信息到DMK账号仓库,用于DMK连接虚拟机安装软件
                logger.debug(
                    "start add vm ssh user to dmk, user[%s]" % self.vm_ssh_user)
                # 使用新密码重新登录一次，否则添加ssh账号接口会报错
                __dmkObj__.login_dmk(self.dmk_float_ip,
                                     self.dmk_server_depoly_user,
                                     self.dmk_server_deploy_new_pwd, "8443")

                __accountId__ = None
                try:
                    __accountId__ = __dmkObj__.get_dmk_account_id(self.dmk_server_depoly_user,
                                                                    self.vm_server_ssh_user)
                except FCUException:
                    # 说明没有该self.vm_server_ssh_user，那么之后就调用创建账号接口，否则调用更新接口
                    pass
                except Exception as e:
                    logger.error("execute error:%s" % str(e))
                    raise FCUException(665002, str(e))

                if not __accountId__:
                    __accountId__ = __dmkObj__.add_account_to_dmk(
                        self.vm_server_ssh_user, team_id,
                        self.vm_server_ssh_pwd,
                        self.vm_server_ssh_sudo_pwd)

                if __accountId__:
                    logger.info("add node account to dmk successfully")
                    chg_result = __dmkObj__.update_account_to_multi_team(
                        self.dmk_server_depoly_user,
                        self.vm_server_ssh_user,
                        ["OTD", self.dmk_server_depoly_group],
                        self.vm_server_ssh_pwd, self.vm_server_ssh_sudo_pwd)
                    if chg_result is False:
                        logger.error("update_account_to_multi_team failed.")
                        raise Exception(
                            "update_account_to_multi_team return false")
                    return Message(200)
                else:
                    logger.error("failed to add node user to dmk")
                    raise Exception("add_account_to_dmk return empty")

            else:
                logger.error("failed to update user password")
                raise Exception("change_dmk_user_passwd return false")
        else:
            logger.error("failed to create user")
            raise FCUException('665002', "")

    def create_console_user(self, __dmkObj__):
        # 登录DMK
        __dmkObj__.login_dmk(self.dmk_float_ip, self.dmk_sys_user,
                             self.dmk_sys_user_pwd, "8443")

        # 登录成功后再创建DMK账户
        logger.debug("start create dmk account[%s], group[%s]" % (
            self.dmk_depoly_user, self.dmk_depoly_group))
        (team_id, user_id) = __dmkObj__.create_dmk_user(
            self.dmk_depoly_user, self.dmk_depoly_pwd,
            DMK_ROLE.GROUP_MANAGER, self.dmk_depoly_group)

        if user_id and team_id:
            chg_result = __dmkObj__.update_user_to_multi_team(
                user_id, DMK_ROLE.GROUP_MANAGER,
                ["OTD", self.dmk_depoly_group])
            if chg_result is False:
                logger.error("update user to OTD group failed.")
                raise Exception("update_user_to_multi_team return false")

            # 账户创建成功后修改账户密码
            __dmkObj__.login_dmk(self.dmk_float_ip, self.dmk_depoly_user,
                                 self.dmk_depoly_pwd, "8443")
            isSuccess = __dmkObj__.change_dmk_user_passwd(
                user_id, self.dmk_depoly_pwd, self.dmk_deploy_new_pwd)
            if isSuccess:
                logger.info("create user and update password successful")
                # 添加待安装软件节点的ssh账户信息到DMK账号仓库,用于DMK连接虚拟机安装软件
                logger.debug(
                    "start add vm ssh user to dmk, user[%s]" % self.vm_ssh_user)
                # 使用新密码重新登录一次，否则添加ssh账号接口会报错
                __dmkObj__.login_dmk(self.dmk_float_ip, self.dmk_depoly_user,
                                     self.dmk_deploy_new_pwd, "8443")

                __accountId__ = None
                try:
                    __accountId__ = __dmkObj__.get_dmk_account_id(self.dmk_depoly_user,
                                                                    self.vm_ssh_user)
                except FCUException:
                    # 说明没有该vm_ssh_user，那么之后就调用创建账号接口，否则调用更新接口
                    pass
                except Exception as e:
                    logger.error("execute error:%s" % str(e))
                    raise FCUException(665002, str(e))

                if not __accountId__:
                    __accountId__ = __dmkObj__.add_account_to_dmk(
                        self.vm_ssh_user, team_id,
                        self.vm_ssh_pwd, self.vm_ssh_sudo_pwd)

                if __accountId__:
                    logger.info("add node account to dmk successfully")
                    chg_result = __dmkObj__.update_account_to_multi_team(
                        self.dmk_depoly_user, self.vm_ssh_user,
                        ["OTD", self.dmk_depoly_group],
                        self.vm_ssh_pwd, self.vm_ssh_sudo_pwd)
                    if chg_result is False:
                        logger.error("update_account_to_multi_team failed.")
                        raise Exception(
                            "update_account_to_multi_team return false")
                    return Message(200)
                else:
                    logger.error("failed to add node user to dmk")
                    raise Exception("add_account_to_dmk return empty")
            else:
                logger.error("failed to update user password")
                raise Exception("change_dmk_user_passwd return false")
        else:
            logger.error("failed to create user")
            raise FCUException('665002', "")

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        for i in range(1, 4):
            try:
                logger.info("Start init dmk user for the %s time." % str(i))
                # 初始化参数
                __dmkObj__ = DmkApi()
                self.init_params()

                # 检查环境连通性
                self.pre_check(self.project_id, self.pod_id, regionid_list)

                self.create_server_user(__dmkObj__)
                self.create_console_user(__dmkObj__)
                return Message(200)
            except FCUException as e1:
                logger.error(
                    "init dmk failed for the %s time, errMsg=%s" % (i, str(e1)))
                if i != 3:
                    continue
                return Message(500, e1)
            except Exception as e:
                logger.error(
                    "init dmk user failed for the %s time, errmsg=%s" % (
                        i, str(e)))
                if i != 3:
                    continue
                return Message(500, FCUException('665002', str(e)))

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        logger.info("start retry init dmk user")
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

