# -*- coding:utf-8 -*-
import plugins.CSDR_CSHA_VHA.common.CommonUtil as commutil
import utils.common.log as logger
import time
from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCUException
from utils.common.ssh_util import Ssh

logger.init("VHA")


class WatchDog(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.VHA_SERVICE_TYPE

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def init_params(self):

        server_params = commutil.get_server_params(
            self.project_id, self.region, self.service_name)
        self.server_ip1 = server_params["server_ip1"]
        self.server_business_user = server_params["server_business_user"]
        self.server_business_user_pwd = \
            server_params["server_business_user_pwd"]
        self.server_root_pwd = server_params["server_root_pwd"]

        console_params = commutil.get_console_params(
            self.project_id, self.region, self.service_name)
        self.console_ip1 = console_params["console_ip1"]
        self.console_ip2 = console_params["console_ip2"]
        self.console_business_user = console_params["console_business_user"]
        self.console_business_user_pwd = \
            console_params["console_business_user_pwd"]
        self.console_root_pwd = console_params["console_root_pwd"]
        logger.info("init params successfully")

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        try:
            logger.info("start install WatchDog.")

            # 初始化参数信息
            self.init_params()


            # 获取所有的eReplication Server虚拟机IP
            all_ips = commutil.get_all_server_nodes(
                self.server_ip1,
                self.server_business_user,
                self.server_business_user_pwd,
                self.server_root_pwd)
            if all_ips.__len__() < 1 or all_ips.__len__() > 2 \
                    or all_ips.__contains__(self.server_ip1) is False:
                logger.error(
                    "query eReplication ip from %s failed" % self.server_ip1)
                raise Exception(
                    "Querying the peer eReplication node failed from %s"
                    % self.server_ip1)

            logger.info("start iterate eReplication server")
            for server_ip in all_ips:
                # 登录eReplication Server
                ssh_client = Ssh.ssh_create_client(
                    server_ip, self.server_business_user,
                    self.server_business_user_pwd)
                Ssh.ssh_send_command(ssh_client, "su", "Password", 20)
                Ssh.ssh_send_command(ssh_client, self.server_root_pwd, "#", 20)

                logger.info("login %s successfully" % server_ip)
                try:
                    # 判断etc/fstab opt分区是否设置了errors=panic，
                    # 如果已经设置了，表示该虚拟机已经增加了看门狗
                    cmd = "cat /etc/fstab | grep errors=panic"
                    result = Ssh.ssh_send_command(ssh_client, cmd,
                                              "errors=panic", 60)
                    for res in result:
                        if res.__contains__("/opt"):
                            logger.info("eReplication server %s has configured watch dog"
                                        % server_ip)
                            return Message(200)
                except Exception as e:
                    logger.info("eReplication server %s has not configured watch dog" % server_ip)


                logger.info("start execute configWatchDog.sh on eReplication server")
                # 通过执行configWatchDog.sh，在/etc/fstab /opt 分区设置 errors=panic
                cmd = "cd /var/eReplication/Runtime/bin;dos2unix configWatchDog.sh;" \
                      "sh configWatchDog.sh"
                result = Ssh.ssh_send_command(ssh_client, cmd,
                                              "config watchdog successfully", 60)
                is_ok = False
                for res in result:
                    if res.__contains__("config watchdog successfully"):
                        logger.info('config watchdog on %s successfully'
                                    % server_ip)
                        is_ok = True
                        break
                if not is_ok:
                    raise FCUException("675013",
                                       "config watchdog %s failed, result is %s"
                                       % (server_ip, result))
                # 重启虚拟机
                try:
                    Ssh.ssh_send_command(ssh_client, "reboot", "#", 20)
                except Exception as e:
                    logger.info("The result of reboot vm is %s" % str(e))


            # 检查虚拟机是否重启OK
            for ip in all_ips:
                result = False
                for i in range(0, 20):
                    try:
                        ssh_client_reboot = Ssh.ssh_create_client(
                            ip, self.server_business_user,
                            self.server_business_user_pwd)
                        logger.info("restart vm successfuuly ip = %s" % ip)
                        result = True
                        try:
                            Ssh.ssh_close(ssh_client_reboot)
                        except Exception as e:
                            logger.error("Close ssh client failed, errMsg is %s" % str(e))
                        break
                    except Exception as e:
                        logger.error("Restart vm failed ,errMsg is %s" % str(e))
                        time.sleep(10)

                if not result:
                    logger.error("restart vm failed ip=%s" % ip)
                    raise FCUException('675013', "restart vm failed, ip = %s" % ip)

            logger.info("config all host watchdog successfully!")
        except FCUException as fe:
            logger.error("config host watchdog failed, errMsg=%s" % str(fe))
            return Message(500, fe)
        except Exception as e:
            logger.error("config host watchdog failed, errMsg=%s" % str(e))
            return Message(500, FCUException('675013', "Config watchdog failed."))
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

