# -*- coding:utf-8 -*-
import plugins.CSDR_CSHA_VHA.common.CommonUtil as commutil
import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from .OpenWatchDog import WatchDog
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCUException
from plugins.CSDR_CSHA_VHA.common.ServerProcessor import UpgradeProcess

logger.init("VHA")


class UpgradeBackService(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.VHA_SERVICE_TYPE

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def init_params(self):
        server_params = commutil.get_server_params(self.project_id,
                                            self.region,
                                            self.service_name)
        self.server_ip1 = server_params["server_ip1"]
        self.server_ip2 = server_params["server_ip2"]
        self.server_business_user = server_params["server_business_user"]
        self.server_business_user_pwd = server_params["server_business_user_pwd"]
        self.server_root_pwd = server_params["server_root_pwd"]

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        try:
            logger.info("upgrade eReplication service process.")
            # 初始化参数信息
            self.init_params()

            all_ips = commutil.get_all_server_nodes(
                self.server_ip1,
                self.server_business_user,
                self.server_business_user_pwd,
                self.server_root_pwd)
            process = UpgradeProcess(self.pod_id, self.project_id, self.region,
                                     "VHA")
            process.upgrade_service(all_ips, project_id)

            logger.info("upgrade eReplication successfully in all nodes.")

            message = WatchDog(project_id, pod_id, regionid_list).execute(
                project_id, pod_id, regionid_list)

            return message
        except FCUException as fe:
            logger.error("upgrade eReplication failed, errMsg=%s" % str(fe))
            return Message(500, fe)
        except Exception as e:
            logger.error("upgrade eReplication failed, errMsg=%s" % str(e))
            return Message(500, FCUException('665002', str(e)))


    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass
