# -*- coding:utf-8 -*-
import os
import plugins.CSDR_CSHA_VHA.common.CommonUtil as commutil
import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.CommonDefine import PATH_VALUE
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.business.param_util import ParamUtil
from utils.common.exception import FCUException
from utils.business.dmk_util import DmkApi
from plugins.CSDR_CSHA_VHA.common.ConsoleProcessor import ConsoleProcessor

logger.init("VHA")


class UpgradeConsole(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_name = PATH_VALUE.VHA_SERVICE_TYPE

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def init_params(self):
        params = ParamUtil()
        self.region = self.regionid_list[0]
        self.dmk_float_ip = params.get_value_from_cloud_param(
            self.project_id, "DMK_public_params", "dmk_floatIp", self.region)
        self.dmk_sys_user = params.get_value_from_cloud_param(
            self.project_id, "DMK_public_params", "dmk_ui_username",
            self.region)
        self.dmk_sys_user_pwd = params.get_value_from_cloud_param(
            self.project_id, "DMK_public_params", "dmk_ui_password",
            self.region)
        self.dmk_depoly_user = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_deploy_user", self.region)
        self.dmk_depoly_group = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_deploy_group", self.region)
        self.dmk_deploy_new_pwd = params.get_value_from_cloud_param(
            self.project_id, "VHA", "dmk_deploy_new_pwd", self.region)
        console_params = commutil.get_console_params(self.project_id,
                                                     self.region,
                                                     self.service_name)
        self.console_ip1 = console_params["console_ip1"]
        self.console_ip2 = console_params["console_ip2"]
        self.console_business_user = console_params["console_business_user"]
        self.console_business_user_pwd = \
            console_params["console_business_user_pwd"]
        self.console_root_pwd = console_params["console_root_pwd"]

    def getConfigContent(self, file_path):
        file_object = commutil.open_file_upgrade(file_path)
        content = ""
        try:
            for line in file_object:
                content = "{0}{1}".format(content, line)
        except Exception as e:
            logger.error("getConfigContent failed, errMsg=%s" % str(e))
        finally:
            file_object.close()
        return content

    def install_console(self, dmkobj):
        logger.info("start install eReplication console.")

        # 构造节点信息
        host_info = self.getConfigContent(
            os.path.realpath(__file__ + '/../../../conf/console_hosts'))
        host_info = host_info.format(self.console_ip1, self.console_ip2)

        # 构造安装配置信息
        config_info = self.getConfigContent(
            os.path.realpath(__file__ + '/../../../conf/console_config.yml'))
        config_info = config_info.format(
            self.pkg_version, self.console_business_user, self.console_ip1,
            self.console_ip2, self.sc_info)
        logger.debug("host_info:[%s]" % host_info)
        logger.debug("config_info:[%s]" % config_info)

        # 下发安装命令
        __result__ = dmkobj.excute_dmk_deployment("CSDR", True,
                                                  self.pkg_version, "Install",
                                                  host_info, config_info,
                                                  self.account_id)
        if not __result__:
            logger.error("excute console install failed.")
            raise Exception("excute_dmk_deployment return false")

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        try:
            logger.info("upgrade console service process.")
            # 初始化参数信息
            self.init_params()

            __dmkObj__ = DmkApi()

            # Step1: 获取部署帐户ID
            __dmkObj__.login_dmk(self.dmk_float_ip, self.dmk_depoly_user,
                                 self.dmk_deploy_new_pwd, "8443")
            self.account_id = __dmkObj__.get_dmk_account_id(
                self.dmk_depoly_user, self.console_business_user)
            if commutil.check_value_null(self.account_id):
                raise Exception("get_dmk_account_id return false")

            # Step2: 获取目标版本
            self.pkg_version = commutil.get_console_pkg_version(project_id)

            # Step3: console的升级是重装,因此先卸载console
            processor1 = ConsoleProcessor(self.console_ip1,
                                          self.console_business_user,
                                          self.console_business_user_pwd,
                                          self.console_root_pwd)
            # 卸载前先从其中一节点查询出原环境的SC信息
            self.sc_info = processor1.query_console_config()["SC_HOST"]
            processor1.uninstall_console()
            processor2 = ConsoleProcessor(self.console_ip2,
                                          self.console_business_user,
                                          self.console_business_user_pwd,
                                          self.console_root_pwd)
            processor2.uninstall_console()

            # Step4: 下发安装Console命令
            self.install_console(__dmkObj__)

            # 重装完成后要恢复一下IAM证书
            processor1 = ConsoleProcessor(self.console_ip1,
                                          self.console_business_user,
                                          self.console_business_user_pwd,
                                          self.console_root_pwd)
            processor1.recopy_iam_cert()
            processor2 = ConsoleProcessor(self.console_ip2,
                                          self.console_business_user,
                                          self.console_business_user_pwd,
                                          self.console_root_pwd)
            processor2.recopy_iam_cert()

            logger.info("upgrade console successfully in all nodes.")
        except FCUException as fe:
            logger.error("upgrade console failed, errMsg=%s" % str(fe))
            return Message(500, fe)
        except Exception as e:
            logger.error("upgrade console failed, errMsg=%s" % str(e))
            return Message(500, FCUException('665002', str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return:
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass
