# --*-- coding: utf-8 --*--

from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.CSDR_CSHA_VHA.common.CSDRTestBase import *
from utils.common.exception import FCUException
import utils.common.log as logger

logger.init("CSDR")


class ConfigDrService(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的参数预检查和获取，
        该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行测试
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            logger.info("start config dr config...")
            sc_opt = SCBase(project_id, regionid_list[0], VHA_SERVICE_TYPE)
            sc_opt.login_sc()
            data = sc_opt.get_dr_params()
            request_api = RequestApi(project_id, regionid_list[0],
                                     VHA_SERVICE_TYPE)
            request_api.config_dr(data)

            logger.info("config dr successfully!!!!")
            return Message(200)
        except FCUException as e:
            logger.error("plan motion test case failed, errMsg=%s" % str(e))
            return Message(500, e)
        except Exception as e:
            logger.error("plan motion test case failed, errMsg=%s" % str(e))
            return Message(500, "配置云服务失败[%s]" % str(e),
                           "Failed to config cloud service[%s]" % str(e),
                           "请检查", "Please check.")

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
