# --*-- coding: utf-8 --*--
from utils.common.message import Message
import sys
import importlib

importlib.reload(sys)  # Python2.5 初始化后会删除 sys.setdefaultencoding 这个方法，我们需要重新载入
from platforms.param.ParamManager import ParamService
from plugins.AcceptanceTest.basic_mo_test.common.login_sc import LoginSC
from utils.business.param_util import ParamUtil
from urllib.parse import quote
import requests
import utils.common.log as logger
import json
import time
from . import CommonUtil

CSDR_SERVICE_TYPE = "csdr"
CSHA_SERVICE_TYPE = "csha"
VHA_SERVICE_TYPE = "vha"
OPT_TYPE_ON = "start"
OPT_TYPE_OFF = "stop"
SC_TENANT_USER_KEY = "SC_TENANT_USER_KEY"
SC_TENANT_USER_PWD_KEY = "SC_TENANT_USER_PWD_KEY"
SC_TENANT_USER_OLD_PWD = "SC_TENANT_USER_OLD_PWD"
PRIMARY_VDC_NAME = "SC_VDC_A_KEY"
STANDBY_VDC_NAME = "SC_VDC_S_KEY"
SC_MANAG_USER_KEY = "SC_MANAG_USER_KEY"
SC_MANAG_USER_PWD = "SC_MANAG_USER_PWD"
PRODUCT_VM_NAME = "PRODUCT_VM_NAME"
DR_VM_NAME = "DR_VM_NAME"
PRIMARY_AZ_NAME = "PRIMARY_AZ_NAME"
STANDBY_AZ_NAME = "STANDBY_AZ_NAME"
PRIMARY_REGION_NAME = "PRIMARY_REGION_NAME"
STANDBY_REGION_NAME = "STANDBY_REGION_NAME"
PRIMARY_VOL_TYPE = "PRIMARY_VOL_TYPE"
STANDBY_VOL_TYPE = "STANDBY_VOL_TYPE"
PRIMARY_PROJECT_NAME = "SC_TENANT_PROJECT_A_KEY"
STANDBY_PROJECT_NAME = "SC_TENANT_PROJECT_S_KEY"

MANAGE_CONSOLE_HOST = "MANAGE_CONSOLE_HOST"
MANAGE_IAM_HOST = "MANAGE_IAM_HOST"
TENANT_CONSOLE_HOST = "TENANT_CONSOLE_HOST"
TENANT_IAM_HOST = "TENANT_IAM_HOST"

EXTERNAL_VPC_NETWORK = "EXTERNAL_VPC_NETWORK"
EXTERNAL_EIP_NETWORK = "EXTERNAL_EIP_NETWORK"

FIRST_REGION_TYPE = "FIRST_REGION_TYPE"


class SCBase:
    def __init__(self, tool_project_id, tool_region_id, service_type):
        if not [CSDR_SERVICE_TYPE, CSHA_SERVICE_TYPE,
                VHA_SERVICE_TYPE].__contains__(service_type):
            logger.error(
                "the service type is error, service type is %s" % service_type)
            raise Exception(
                "the service type is error, service type is %s" % service_type)

        self.tool_project_id = tool_project_id
        self.tool_region_id = tool_region_id
        self.region_type = get_project_type(self.tool_project_id).lower()
        self.service_type = service_type.lower()
        self.add_volume_name = "FCU_AUTO_VOL_" + self.service_type
        self.auth_port = "443"
        self.project_id = ""
        self.primary_region_id = ""
        self.standby_region_id = ""
        self.primary_az_id = ""
        self.standby_az_id = ""
        self.dr_project_id = ""
        self.common_params = get_common_params(tool_project_id, tool_region_id,
                                               self.service_type)

        params = ParamUtil()
        self.primary_vol_type = self.common_params[PRIMARY_VOL_TYPE]
        self.server1_name = self.common_params[PRODUCT_VM_NAME]
        self.add_server1_name = self.server1_name + "_01"
        self.standby_vol_type = self.common_params[STANDBY_VOL_TYPE]
        if self.service_type == CSDR_SERVICE_TYPE \
                or self.service_type == CSHA_SERVICE_TYPE:
            self.server2_name = self.common_params[DR_VM_NAME]
            self.add_server2_name = self.server2_name + "_01"
        self.iam_ip = self.common_params[TENANT_IAM_HOST]
        self.host_url = "https://" + self.iam_ip
        self.console_host = self.common_params[TENANT_CONSOLE_HOST]
        self.userName = self.common_params[SC_TENANT_USER_KEY]
        self.userPwd = self.common_params[SC_TENANT_USER_PWD_KEY]
        self.primary_region_name = self.common_params[PRIMARY_REGION_NAME]
        self.standby_region_name = self.common_params[STANDBY_REGION_NAME]
        self.primary_az_name = self.common_params[PRIMARY_AZ_NAME]
        self.standby_az_name = self.common_params[STANDBY_AZ_NAME]
        self.project_name = self.common_params[PRIMARY_PROJECT_NAME]
        self.standby_project_name = self.common_params[STANDBY_PROJECT_NAME]

        # 待创建用于调测的服务实例名称
        self.instance_name = get_instance_name(self.service_type)
        self.console_sc_headers = {
            "Accept": "*/*",
            "Accept-Encoding": "gzip, deflate, br",
            "Accept-Language": "zh-CN,zh;q=0.8",
            "AgencyId": None,
            "cftk": None,
            "Connection": "keep-alive",
            "Content-Type": "application/json; charset=UTF-8",
            "Cookie": None,
            "Host": self.console_host,
            "ProjectName": None,
            "Referer": None,
            "region": None,
            "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/"
                          "537.36 (KHTML, like Gecko) "
                          "Chrome/59.0.3071.104 Safari/537.36",
            "X-Language": "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3",
            "X-Requested-With": "XMLHttpRequest"
        }
        self.sc_session = requests.session()

    def get_dr_params(self):
        """
        返回容灾eReplication后台服务依赖的参数
        必须在登录SC后才能调用
        :return:
        """
        data = {"az1": self.primary_az_id, "region1": self.primary_region_id,
                "volume1": self.primary_vol_type,
                "volume2": self.standby_vol_type}
        if self.service_type.lower() == CSHA_SERVICE_TYPE:
            data.update({"az2": self.standby_az_id})
        elif self.service_type.lower() == CSDR_SERVICE_TYPE:
            data.update(
                {"az2": self.standby_az_id, "region2": self.standby_region_id})
        return data

    def get_product_id_by_service_type(self, product_type):
        """
        :param region_name:
        :return:
        """
        logger.info("start get product id, type is %s" % product_type)

        url = "https://%s/moproductwebsite/goku/rest/product/v3.0/products?" \
              "service_type=%s&limit=8&start=1&region_id=%s&project_id=%s" \
              % (self.console_host, product_type.lower(),
                 self.current_region_id, self.project_id)
        ret = self.sc_session.get(url=url, headers=self.console_sc_headers,
                                  verify=False)
        if ret.status_code != 200:
            logger.error(
                "Failed to get product info, status code[%s], response[%s]" % (
                    ret.status_code, str(ret.text)))
            raise Exception(
                "Failed to get product info, status code[%s], response[%s]" % (
                    ret.status_code, str(ret.text)))
        logger.info("response product info is %s" % ret.text)
        res = json.loads(ret.text)

        total = res["total"]
        product_list = res["products"]
        for n in range(0, total):
            region_id_value = product_list[n]["region_id"]
            is_need_approval = product_list[n]["approval"]
            is_online = product_list[n]["online_status"]

            # 选择不需要审批的产品
            if region_id_value == self.current_region_id \
                    and is_need_approval == False\
                    and is_online == "online":
                logger.info(
                    "get product id successfully, product name=%s, id=%s" % (
                        product_list[n]["name"],
                        product_list[n]["product_id"]))
                return product_list[n]["product_id"]
        else:
            logger.error("%s product is not exist, product_list: %s" %
                        (product_type.lower(), product_list))
            raise Exception("%s product is not exist" % product_type.lower())

    def show_product_info(self):
        """

        :return:
        """
        # 查询已经注册的产品信息(产品列表)
        url = "https://%s/motenantconsolehomewebsite/rest/silvan/rest/v1.0/" \
              "products?start=0&limit=0&region=%s" % (
                  self.console_host, self.current_region_id)
        ret = self.sc_session.get(url=url, headers=self.console_sc_headers,
                                  verify=False)
        if ret.status_code != 200:
            logger.error(
                "Failed to get product info, status code[%s], response[%s]" % (
                    ret.status_code, str(ret.text)))
            raise Exception(
                "Failed to get product info, status code[%s], response[%s]" % (
                    ret.status_code, str(ret.text)))
        res = json.loads(ret.text)
        return ret.status_code, res

    def login_sc(self):
        """通过console登录sc,主要用于处理headers

        :return:
        """
        logger.info("start login sc.")
        self.user_id, self.project_id, self.current_region_id, \
        self.bak_global_headers, self.console_sc_headers = \
            sc_tenant_api(self.tool_project_id, self.tool_region_id,
                          self.service_type).login_sc_on_web(
                self.console_host, self.iam_ip, self.userName, self.userPwd,
                self.primary_region_name)

        self.product_id = self.get_product_id_by_service_type(self.service_type)

        # 查询RegionID信息
        self.query_region_id_by_name()

        # 查询主Region下AZID信息
        self.primary_az_id = self.get_az_id_by_name(self.current_region_id,
                                                    self.primary_az_name)

        # 查询出预置数据中预置的生产虚拟机的ID
        self.console_sc_headers.__setitem__("region", self.primary_region_id)
        self.console_sc_headers.__setitem__("ProjectName", self.project_name)
        self.product_vm_id = self.get_vm_id_by_name(self.server1_name)
        self.add_server1_id = self.get_vm_id_by_name(self.add_server1_name)
        self.vmname_list = [self.server1_name, self.add_server1_name]
        if self.service_type == CSDR_SERVICE_TYPE:
            # 对于CSDR有两个AZ
            self.standby_az_id = self.get_az_id_by_name(self.standby_region_id,
                                                        self.standby_az_name)
            # CSDR场景下获取容灾端Project_id信息
            self.dr_project_id = self.get_project_id_by_name(
                self.standby_project_name, self.standby_region_id)
            # 获取容灾端虚拟机ID
            logger.info("start query dr vm from %s" % self.standby_region_id)
            self.console_sc_headers.__setitem__("region",
                                                self.standby_region_id)
            self.console_sc_headers.__setitem__("ProjectName",
                                                self.standby_project_name)
            self.dr_vm_id = self.get_vm_id_by_name(self.server2_name)
            self.add_server2_id = self.get_vm_id_by_name(self.add_server2_name)
            self.vmname_list.append(self.server2_name)
            self.vmname_list.append(self.add_server2_name)

        if self.service_type == CSHA_SERVICE_TYPE:
            # 对于CSHA场景也有两个AZ, 但只有一个Region
            self.standby_az_id = self.get_az_id_by_name(self.current_region_id,
                                                        self.standby_az_name)
            # 获取容灾端虚拟机ID
            self.dr_vm_id = self.get_vm_id_by_name(self.server2_name)
            self.add_server2_id = self.get_vm_id_by_name(self.add_server2_name)
            self.vmname_list.append(self.server2_name)
            self.vmname_list.append(self.add_server2_name)
            # 本端与远端使用同一个project_id
            self.dr_project_id = self.project_id
            # CSHA场景下对端regionID与主端一致
            self.standby_region_id = self.primary_region_id

        # 通过console向eReplication发送请求时,必须在header里面加上region_id,
        # 当前eReplication的endpoint信息是注册到Region中的
        self.console_sc_headers.__setitem__("ProjectName", self.project_name)
        self.console_sc_headers.__setitem__("region", self.primary_region_id)

    def check_instance_status(self):
        """
        检查服务实例复制状态是否能做计划性迁移等
        :return:
        """
        status = self.get_instance_status()
        logger.info("the instance status is %s" % status)
        if status == "copying":
            raise Exception(
                "Synchronizing data, please wait for data sync to "
                "complete and try again")

    def get_instance_status(self):
        """
        获取服务实例的复制状态
        :return:
        """
        iTmp = 0
        rep_status = ""
        # 重试5次, 如果连续5次发送请求失败,则认为失败
        while iTmp < 5:
            try:
                instance = self.query_dest_service_instance(self.instance_name)
                if instance is None:
                    logger.error(
                        "get instance status failed, can not "
                        "find the instance.")
                    raise Exception(
                        "Can not find the dest instance, instance name is %s"
                        % self.instance_name)
                rep_status = instance["replication_status"]
                if rep_status == "copying":
                    pro_url = "https://%s/%s/rest/ws/bcs/%s/instances/%s/" \
                              "progress" % (self.console_host,
                                            self.service_type,
                                            self.project_id,
                                            instance['id'])
                    response = self.sc_session.get(
                        url=pro_url,
                        headers=self.console_sc_headers)
                    progress_data = ""
                    if response.status_code != 200:
                        logger.error("failed to get progress, status_code[%s], "
                                     "resp[%s]" % (response.status_code,
                                                   response.text))
                    else:
                        resp = json.loads(response.text)
                        progress_data = resp["progress"]
                    logger.info("Synchronizing data, Current progress: "
                                "%s percent" % progress_data)
                break
            except Exception as e:
                logger.error(
                    "get instance status failed, retry after 10s[%s]" % str(e))
                time.sleep(10)
                iTmp += 1
        if rep_status == "":
            raise Exception("Failed to get instance replication status")
        return rep_status

    def apply_service_instance(self):
        """
        申请服务实例
        :return:
        """
        try:
            logger.info("start apply csdr service instance")
            # 先检查服务实例是否已经存在， 如果已存在则不再申请,
            # 因为当前每个测试用例是独立的, 即创建实例用例里面包含删除
            # 如果前面是删除失败，然后重试，此时有可能服务实例已创建完成了
            instance = self.query_dest_service_instance(self.instance_name)
            if CommonUtil.check_value_null(instance) is False:
                logger.info(
                    "the instance already exists, no need apply, start check re"
                    "plication status, instance name: %s" % self.instance_name)
                while True:
                    status = self.get_instance_status()
                    if status == "copying":
                        logger.info(
                            "replication status is copying, "
                            "retry check after 60 seconds")
                        time.sleep(60)
                        continue
                    break
                return True

            # 根据用户填写的信息来检查eReplication上的AZ与Region配对信息是否正确
            self.check_eReplication_config(self.service_type)

            # 申请前需要下电虚拟机
            for vm_name in self.vmname_list:
                if '_dr_' in vm_name:
                    self.console_sc_headers.__setitem__("region",
                                                        self.standby_region_id)
                # self.operate_cloud_server(OPT_TYPE_OFF, vm_name)
                self.console_sc_headers.__setitem__("region",
                                                    self.primary_region_id)

            # 检查用户配置的生产与容灾虚拟机能否通过eReplication正常查询出来
            self.check_vms_info()

            # 下发服务实例创建请求,并返回申请ID
            order_id = self.send_apply_instance_cmd()

            # 监控订单状态
            self.monitor_order_status(order_id)

            # 订单状态成功后, 检查服务实例是否已同步完成,
            # 直到实例状态不为同步中了, 结束监控
            logger.info("start check instance status.....")
            time.sleep(30)
            while True:
                status = self.get_instance_status()
                if status == "copying":
                    logger.info("replication status is copying, "
                                "retry check after 60 seconds")
                    time.sleep(60)
                    continue
                break
            logger.info("end apply service instance.")
        except Exception as e:
            logger.error("apply service instance failed, errMsg: %s" % str(e))
            raise Exception("Failed to apply service instance[%s]" % str(e))

    def delete_service_instance(self):
        """
        删除服务实例
        :return:
        """
        logger.error(
            "start delete service instance... name is %s" % self.instance_name)

        # 查询目标服务实例名称
        instance = self.query_dest_service_instance(self.instance_name)
        if instance is None:
            logger.info("the instance not found, no need delete...")
            return True

        inst_id = instance['id']
        if CommonUtil.check_value_null(inst_id):
            logger.error("failed to get dest instance, instance name: %s"
                         % self.instance_name)
            raise Exception("Failed to delete instance, can not find the dest "
                            "instance, instance name is %s"
                            % self.instance_name)

        # 开始删除服务实例
        display = [
            {"label": "name", "type": "string", "value": self.instance_name},
            {"label": "Region", "type": "string",
             "value": self.primary_region_id},
            {"label": "AZ", "type": "string", "value": self.primary_az_id},
            {"label": "ECS Quantity", "type": "string", "value": "1"},
            {"label": "Volume Capacity", "type": "string", "value": "40GB"}]
        ids = [{'id': inst_id, 'service_type': self.service_type}]
        rd_param = {'count': 1, 'action': 'del_instance',
                    'instance_id': inst_id, 'display': display, 'ids': ids}
        __body__ = {'subscriptions': [
            {'operate_type': 'delete', 'product_id': self.product_id,
             'project_id': self.project_id, 'region_id': self.primary_region_id,
             'service_type': self.service_type,
             'params': json.dumps(rd_param)}]}
        url = "https://%s/%s/rest/subscription/v3.0/subscriptions" % (
            self.console_host, self.service_type)
        response = self.sc_session.request(method="post", url=url,
                                           headers=self.console_sc_headers,
                                           data=json.dumps(__body__))
        if response.status_code != 200:
            logger.error(
                "send instance delete cmd failed, status_code=%s, response=%s"
                % (response.status_code, str(response.text)))
            raise Exception("Failed to delete service instance, "
                            "status_code[%s], response[%s]" % (
                                response.status_code, str(response.text)))
        resp = json.loads(response.text)
        sub_id = resp['purchases'][0]['subscription_id']
        logger.info("send delete instance cmd successfully, sub_id=%s" % sub_id)
        # 监控删除订单状态
        try:
            self.monitor_order_status(sub_id)
        except Exception as e:
            logger.error("failed to monitor order status. errMsg=%s" % str(e))
            raise Exception("Failed to delete instance[%s]" % str(e))

    def add_cloud_server(self):
        """
        向已有的云服务实例中添加云服务器
        :return:
        """
        # 获取目标服务实例
        instance = self.query_dest_service_instance(self.instance_name)
        if instance is None:
            logger.error(
                "add cloud server failed, can not find the dest instance: %s"
                % self.instance_name)
            raise Exception(
                "The target instance is not found, instance name is %s"
                % self.instance_name)

        if instance["servers"].__contains__(self.add_server1_id):
            # 在等待添加或添加成功后检查实例同步状态失败，此时重试, 增加此检查，
            # 如果服务实例中已有添加的虚拟机，则检查同步状态, 不再下发添加云服务器操作
            logger.info("the add server is already in instance. "
                        "no need add again. start check instance status.")
            while True:
                status = self.get_instance_status()
                if status == "copying":
                    logger.info("replication status is copying,"
                                " retry check after 60 seconds")
                    time.sleep(60)
                    continue
                break
            logger.info("the replication copy is complete.")
            return True

        # 查询待添加的生产虚拟机信息
        volumes = self.get_volume_info(self.add_server1_id)

        if self.service_type == CSDR_SERVICE_TYPE \
                or self.service_type == CSHA_SERVICE_TYPE:

            # 查询生产虚拟机对应的占位虚拟机信息
            self.console_sc_headers.__setitem__("ProjectName",
                                                self.standby_project_name)
            self.console_sc_headers.__setitem__("region",
                                                self.standby_region_id)
            self.console_sc_headers.__setitem__("ProjectName",
                                                self.project_name)
            self.console_sc_headers.__setitem__("region",
                                                self.primary_region_id)
            servers = [{"server_id": self.add_server1_id,
                        "occupied_vm_id": self.add_server2_id, "vols": volumes}]
        elif self.service_type == VHA_SERVICE_TYPE:
            servers = [{"server_id": self.add_server1_id, "vols": volumes}]
        else:
            raise Exception(
                "The service instance type is not support, type is %s"
                % self.service_type)

        rd_body = {
            "action": "add_servers", "count": 1,
            "instance_id": instance['id'],
            "servers": servers,
            "ids": [{"id": instance['id'], "service_type": self.service_type}]
        }

        __body__ = {'subscriptions': [
            {'operate_type': 'modify', 'product_id': self.product_id,
             'tenancy': 0,
             'project_id': self.project_id, 'region_id': self.primary_region_id,
             'service_type': self.service_type, 'params': json.dumps(rd_body)}]}
        self.console_sc_headers.__setitem__("Content-Length", "1020")
        self.console_sc_headers.__setitem__("Accept-Language",
                                            "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3")
        self.console_sc_headers.__setitem__("X-Language", "zh-cn")

        url = "https://%s/%s/rest/subscription/v3.0/subscriptions" % (
            self.console_host, self.service_type)
        response = self.sc_session.request(method="post", url=url,
                                           headers=self.console_sc_headers,
                                           data=json.dumps(__body__))
        if response.status_code != 200:
            logger.error("send add cloud server cmd failed, "
                         "status_code=%s, response=%s" % (response.status_code,
                                                          str(response.text)))
            raise Exception(
                "Failed to add cloud servers, status_code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        resp = json.loads(response.text)
        sub_id = resp['purchases'][0]['subscription_id']
        logger.info("send command successfully, order id=%s" % sub_id)

        # 监控订单状态
        self.monitor_order_status(sub_id)

        # 订单状态成功后, 检查服务实例是否已同步完成, 直到实例状态不为同步中了,结束监控
        logger.info("start check instance status.....")
        time.sleep(30)
        while True:
            status = self.get_instance_status()
            if status == "copying":
                logger.info("replication status is copying, "
                            "retry check after 60 seconds")
                time.sleep(60)
                continue
            break
        logger.info("end add cloud servers.")

    def remove_cloud_server(self):
        """
        从云服务实例中移除云服务器
        :return:
        """
        # 获取目标服务实例
        instance = self.query_dest_service_instance(self.instance_name)
        if instance is None:
            logger.error(
                "add cloud server failed, can not find the dest instance: %s"
                % self.instance_name)
            raise Exception(
                "The target instance is not found, instance name is %s"
                % self.instance_name)

        # 查询待添加的生产虚拟机信息
        add_server_id = self.get_vm_id_by_name(self.server1_name + "_01")
        rd_body = {
            "action": "del_servers",
            "instance_id": instance['id'],
            "server_ids": [add_server_id],
            "ids": [{"id": instance['id'], "service_type": self.service_type}]
        }
        __body__ = {'subscriptions': [{'tenancy': 0, 'operate_type': 'modify',
                                       'product_id': self.product_id,
                                       'project_id': self.project_id,
                                       'region_id': self.primary_region_id,
                                       'service_type': self.service_type,
                                       'params': json.dumps(rd_body)}]}
        self.console_sc_headers.__setitem__("Content-Length", "1020")
        self.console_sc_headers.__setitem__(
            "Accept-Language",
            "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3")
        self.console_sc_headers.__setitem__("X-Language", "zh-cn")

        url = "https://%s/%s/rest/subscription/v3.0/subscriptions" % (
            self.console_host, self.service_type)
        response = self.sc_session.request(method="post", url=url,
                                           headers=self.console_sc_headers,
                                           data=json.dumps(__body__))
        if response.status_code != 200:
            logger.error("send delete cloud server cmd failed, "
                         "status_code=%s, response=%s" % (
                             response.status_code, str(response.text)))
            raise Exception("Failed to remove cloud servers, "
                            "status_code[%s], response[%s]" % (
                                response.status_code, str(response.text)))

        resp = json.loads(response.text)
        sub_id = resp['purchases'][0]['subscription_id']
        logger.info("send command successfully, order id=%s" % sub_id)

        # 监控订单状态
        self.monitor_order_status(sub_id)
        logger.info("end remove cloud servers.")

    def get_volume_info_by_volume_name(self, volume_name):
        """
        通过卷名称获取对应的卷ID
        :return:
        """
        get_url = "https://%s/ecm/rest/v2/detail/%s/volumes/detail?limit=10" \
                  "&offset=0&name=%s&with_snapshot=true" \
                  "&snapshot_metadata=__snapshot_from_instance" \
                  % (self.console_host, self.project_id, self.add_volume_name)
        response = self.sc_session.get(url=get_url,
                                       headers=self.console_sc_headers)
        if response.status_code != 200:
            logger.error("get volume by name failed, name: %s. "
                         "status code: %s, error message: %s"
                         % (self.add_volume_name, response.status_code,
                            str(response.text)))
            raise Exception("Failed to get volume id by name. "
                            "volume name: %s, status code: %s,"
                            " error message: %s"
                            % (self.add_volume_name, response.status_code,
                               str(response.text)))
        resp = json.loads(response.text)
        for vol in resp['volumes']:
            if vol['name'] == volume_name:
                logger.info("get volume: %s successfully, id=%s" % (
                    volume_name, vol['id']))
                return vol
        logger.error("Failed to get volume id by name:  %s, response: %s" % (
            volume_name, str(resp)))
        return None

    def delete_cloud_disk(self, volume_id, volume_name):
        """
        删除一个云硬盘
        :return:
        """
        logger.info("start delete cloud_disk: is=%s, name=%s" % (
            volume_id, volume_name))
        disk_body = {
            "action": "delete_volume",
            "ids": [
                {"id": volume_id, "service_type": "evs", "name": volume_name}],
            "volumes": [
                {"backup_id": None, "source_volid": None, "snapshot_id": None,
                 "count": 1,
                 "availability_zone": self.primary_az_id, "description": "",
                 "size": 1,
                 "name": self.add_volume_name, "imageRef": None,
                 "volume_type": self.primary_vol_type,
                 "metadata": {"hw:passthrough": True},
                 "bootable": False, "multiattach": 0,
                 "OS-SCH-HNT:scheduler_hints": {}}],
            "region_id": self.primary_region_id,
            "display": []
        }
        __body__ = {'subscriptions': [{'operate_type': 'delete',
                                       'project_id': self.project_id,
                                       'region_id': self.primary_region_id,
                                       'service_type': 'evs',
                                       'params': json.dumps(disk_body)}]}
        self.console_sc_headers.__setitem__("Content-Length", "1020")
        self.console_sc_headers.__setitem__(
            "Accept-Language",
            "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3")
        self.console_sc_headers.__setitem__("X-Language", "zh-cn")

        url = "https://%s/ecm/rest/subscription/v3.0/subscriptions" % (
            self.console_host)
        response = self.sc_session.request(method="post", url=url,
                                           headers=self.console_sc_headers,
                                           data=json.dumps(__body__))
        if response.status_code != 200:
            logger.error(
                "send apply cloud disk cmd failed, status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to apply cloud disks, status_code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        resp = json.loads(response.text)
        sub_id = resp['purchases'][0]['subscription_id']
        logger.info("send command successfully, order id=%s" % sub_id)

        # 监控订单状态
        self.monitor_order_status(sub_id)

    def mount_disk_to_vm(self, volume_info, product_vm_id):
        """
        将卷挂载给云主机
        :return:
        """
        logger.info("start mount disk to vm.")
        # 挂载磁盘给虚拟机前先检查磁盘是否已挂载给指定的虚拟机,防止重试调测任务时重复下发挂载操作导致失败
        for server in volume_info["attachments"]:
            if product_vm_id == server["server_id"]:
                logger.info(
                    "the volume already be mounted to %s" % product_vm_id)
                return True

        # 订单成功后将云硬盘绑定给虚拟机
        mount_url = "https://%s/ecm/rest/v1/%s/cloudservers/%s/attachvolume" % (
            self.console_host, self.project_id, product_vm_id)
        mount_data = {
            "volumeAttachment": {"volumeId": volume_info['id'],
                                 "device": "/dev/vdd"}
        }
        response = self.sc_session.request(method="post", url=mount_url,
                                           headers=self.console_sc_headers,
                                           data=json.dumps(mount_data))
        if response.status_code != 200:
            logger.error(
                "send mount cloud disk cmd failed, status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to mount cloud disks, status_code[%s], response[%s]" % (
                    response.status_code, str(response.text)))
        logger.info("send mount disk cmd successfully, job_id: %s" %
                    json.loads(response.text)['job_id'])

        # 挂载命令下发后检查挂载结果,每隔30秒检查一次
        while True:
            time.sleep(30)
            vol_info = self.get_volume_info_by_volume_name(self.add_volume_name)
            if vol_info is None:
                raise Exception(
                    "Failed to query volume info by name. volume name is %s" % self.add_volume_name)
            if vol_info['status'] == "attaching":
                logger.info(
                    "the volume status is attaching, retry check after 30s.")
                continue
            if vol_info['status'] == "in-use":
                logger.info("mount volume successfully.")
                break
            logger.error("mount volume failed, volume status is: %s" % vol_info[
                'status'])
            raise Exception(
                "Failed to mount disk, volume status is %s" % vol_info[
                    'status'])

    def apply_cloud_disk(self):
        """
        申请一个云硬盘,并将云硬盘挂载给目标虚拟机
        :return:
        """
        logger.info(
            "start apply cloud disk. volume name is %s" % self.add_volume_name)
        vol_info = self.get_volume_info_by_volume_name(self.add_volume_name)
        if vol_info is not None:
            logger.info("the volume already exists. no need apply again.")
            if vol_info['status'] != "available":
                # 如果不是available,检查是否是已挂载给目标主机，如果是则认为是成功
                for server in vol_info["attachments"]:
                    if self.product_vm_id == server["server_id"]:
                        logger.info("the volume %s already be mounted to %s" % (
                            self.add_volume_name, self.product_vm_id))
                        return vol_info
                logger.error("The volume status is not available")
                raise Exception(
                    "The volume status is not available, volume name is %s" % self.add_volume_name)
            return vol_info
        evs_id = self.get_product_id_by_service_type("evs")
        disk_body = {
            "action": "create_volume",
            "count": 1,
            "volumes": [
                {"backup_id": None, "source_volid": None, "snapshot_id": None,
                 "count": 1,
                 "availability_zone": self.primary_az_id, "description": "",
                 "size": 1,
                 "name": self.add_volume_name, "imageRef": None,
                 "volume_type": self.primary_vol_type,
                 "metadata": {"hw:passthrough": True},
                 "bootable": False, "multiattach": 0,
                 "OS-SCH-HNT:scheduler_hints": {}}],
            "region_id": self.primary_region_id,
            "display": []
        }
        __body__ = {'subscriptions': [
            {'operate_type': 'apply', 'product_id': evs_id, "comments": "",
             "tenancy": "0",
             'project_id': self.project_id, 'region_id': self.primary_region_id,
             "time_zone": "GMT+08:00",
             'service_type': 'evs', 'params': json.dumps(disk_body)}]}
        self.console_sc_headers.__setitem__("Content-Length", "1020")
        self.console_sc_headers.__setitem__("Accept-Language",
                                            "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3")
        self.console_sc_headers.__setitem__("X-Language", "zh-cn")

        url = "https://%s/ecm/rest/subscription/v3.0/subscriptions" % (
            self.console_host)
        response = self.sc_session.request(method="post", url=url,
                                           headers=self.console_sc_headers,
                                           data=json.dumps(__body__))
        if response.status_code != 200:
            logger.error(
                "send apply cloud disk cmd failed, status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to apply cloud disks, status_code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        resp = json.loads(response.text)
        sub_id = resp['purchases'][0]['subscription_id']
        logger.info("send command successfully, order id=%s" % sub_id)

        # 监控订单状态
        self.monitor_order_status(sub_id)

        # 获取新挂载卷的ID
        volume_info = self.get_volume_info_by_volume_name(self.add_volume_name)
        if volume_info is None:
            raise Exception(
                "Failed to get volume info by name, volume name is %s" % self.add_volume_name)
        if volume_info['status'] != "available":
            logger.error("The volume status is not available")
            raise Exception(
                "The volume status is not available, volume name is %s" % self.add_volume_name)
        return volume_info

    def refresh_instance(self, instance_id):
        """
        刷新指定的云服务实例
        :return:
        """
        refresh_url = "https://%s/%s/rest/ws/bcs/%s/instances/%s/action/check" % (
            self.console_host, self.service_type, self.project_id, instance_id)
        logger.info("start refresh instance, url is: %s" % refresh_url)
        self.console_sc_headers.__setitem__("Content-Length", "0")
        self.console_sc_headers.__setitem__("Accept-Language",
                                            "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3")
        self.console_sc_headers.__setitem__("X-Language", "zh-cn")
        response = self.sc_session.request(method="post", url=refresh_url,
                                           headers=self.console_sc_headers,
                                           data=None)
        if response.status_code != 202:
            logger.error(
                "refresh instance failed., status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to refresh instance, status_code[%s], response[%s]" % (
                    response.status_code, str(response.text)))
        logger.info("send refresh cmd successfully.")
        self.console_sc_headers.__setitem__("Content-Length", "1020")
        while True:
            time.sleep(30)
            instance = self.query_dest_service_instance(self.instance_name)
            if instance['status'] == "locked":
                logger.info(
                    "the instance status is locked, retry check after 30s...")
                continue
            if instance["status"] == "normal":
                logger.info("refresh instance successfully.")
                break
            logger.error(
                "refresh instance failed, status is %s" % instance['status'])
            raise Exception(
                "Failed to refresh instance, instance status is %s" % instance[
                    'status'])

    def add_cloud_disk(self):
        """
        向云服务器添加云硬盘
        :return:
        """
        # 申请一个云硬盘
        volume_info = self.apply_cloud_disk()

        # 将云硬盘挂载给主机
        self.mount_disk_to_vm(volume_info, self.product_vm_id)

        # 获取目标服务实例
        instance = self.query_dest_service_instance(self.instance_name)
        if instance is None:
            logger.error(
                "add cloud disks failed, can not find the dest instance: %s" % self.instance_name)
            raise Exception(
                "The target instance is not found, instance name is %s" % self.instance_name)

        # 挂载云硬盘过后需要刷新一次服务实例
        self.refresh_instance(instance["id"])

        rd_body = {
            "action": "add_volumes",
            "instance_id": instance['id'],
            "server_id": self.product_vm_id,
            "add_vols": [{"vol_type": volume_info['volume_type'],
                          "vol_id": volume_info['id']}],
            "ids": [{"id": instance['id'], "service_type": self.service_type}]
        }

        __body__ = {'subscriptions': [
            {'operate_type': 'modify', 'product_id': self.product_id,
             "tenancy": 0,
             'project_id': self.project_id, 'region_id': self.primary_region_id,
             'service_type': self.service_type, 'params': json.dumps(rd_body)}]}
        self.console_sc_headers.__setitem__("Content-Length", "1020")
        self.console_sc_headers.__setitem__("Accept-Language",
                                            "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3")
        self.console_sc_headers.__setitem__("X-Language", "zh-cn")

        url = "https://%s/%s/rest/subscription/v3.0/subscriptions" % (
            self.console_host, self.service_type)
        response = self.sc_session.request(method="post", url=url,
                                           headers=self.console_sc_headers,
                                           data=json.dumps(__body__))
        if response.status_code != 200:
            logger.error(
                "send add cloud volumes cmd failed, status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to add cloud disks, status_code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        resp = json.loads(response.text)
        sub_id = resp['purchases'][0]['subscription_id']
        logger.info("send command successfully, order id=%s" % sub_id)

        # 监控订单状态
        self.monitor_order_status(sub_id)

    def operate_cloud_server(self, opt_type, vm_name):
        """
        对指定的云服务器上电或下电
        :return:
        """
        opt_url = "https://%s/ecm/rest/v1/%s/cloudservers/action" % (
            self.console_host, self.project_id)
        logger.info(" %s cloud server is start, vm name is %s, url is %s" % (
            opt_type, vm_name, opt_url))
        vm_state = self.get_vm_info(vm_name)
        vm_id = vm_state['id']
        if opt_type == OPT_TYPE_OFF:
            if vm_state['status'] == "SHUTOFF":
                logger.info(
                    "the server status is already SHUTOFF, no need stop again.")
                return True
            opt_body = {"os-stop": {"type": "HARD", "servers": [{"id": vm_id}]}}
        elif opt_type == OPT_TYPE_ON:
            if vm_state['status'] == "ACTIVE":
                logger.info(
                    "the server status is already ACTIVE, no need start again.")
                return True
            opt_body = {"os-start": {"servers": [{"id": vm_id}]}}
        else:
            raise Exception(
                "Failed to operate cloud server, operation type is error[%s]" % opt_type)

        response = self.sc_session.request(method="post", url=opt_url,
                                           headers=self.console_sc_headers,
                                           data=json.dumps(opt_body))
        if response.status_code != 200:
            logger.error(
                "send %s cloud server cmd failed, status_code=%s, response=%s" % (
                    opt_type, response.status_code, str(response.text)))
            raise Exception(
                "Failed to %s cloud server, status_code[%s], response[%s]" % (
                    opt_type, response.status_code, str(response.text)))
        logger.info(
            "send %s cloud server cmd successfully. start check server status after 10s" % opt_type)
        while True:
            time.sleep(10)
            vmInfo = self.get_vm_info(vm_name)
            if opt_type == OPT_TYPE_OFF:
                if vmInfo['status'] == "SHUTOFF":
                    logger.info("%s cloud server successfully." % opt_type)
                    return True
                if vmInfo['OS-EXT-STS:task_state'] == "powering-off":
                    logger.info(
                        "the cloud server is powering-off, retry check after 10s")
                    continue
                logger.error(
                    "%s cloud server failed., vm status is %s, task_state is %s" % (
                        opt_type, vmInfo['status'],
                        vmInfo['OS-EXT-STS:task_state']))
                raise Exception(
                    "Failed to %s cloud server, server status is %s, task state is %s" % (
                        opt_type, vmInfo['status'],
                        vmInfo['OS-EXT-STS:task_state']))
            if opt_type == OPT_TYPE_ON:
                if vmInfo['status'] == "ACTIVE":
                    logger.info("%s cloud server successfully." % opt_type)
                    return True
                if vmInfo['OS-EXT-STS:task_state'] == "powering-on":
                    logger.info(
                        "the cloud server is powering-on, retry check after 10s")
                    continue
                logger.error(
                    "%s cloud server failed., vm status is %s, task_state is %s" % (
                        opt_type, vmInfo['status'],
                        vmInfo['OS-EXT-STS:task_state']))
                raise Exception(
                    "Failed to %s cloud server, server status is %s, "
                    "task state is %s" % (opt_type, vmInfo['status'],
                                          vmInfo['OS-EXT-STS:task_state']))

    def umount_cloud_disk(self, vm_id, volume_name, volume_id):
        """
        在弹性云硬盘中将指定硬盘从指定虚拟机中卸载掉
        :return:
        """
        logger.info(
            "start umount cloud disk, vm id is %s, volume name is %s" % (
                vm_id, volume_name))
        opt_url = "https://%s/ecm/rest/v1/%s/cloudservers/%s/detachvolume/%s" % (
            self.console_host, self.project_id, vm_id, volume_id)
        response = self.sc_session.delete(url=opt_url,
                                          headers=self.console_sc_headers)
        if response.status_code != 200:
            logger.error(
                "umount cloud disk failed, status code is %s, response[%s]" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to umount cloud disk, status code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        logger.info(
            "send umount cloud disk successfully. check umount process.")
        while True:
            time.sleep(10)
            vol_info = self.get_volume_info_by_volume_name(volume_name)
            if vol_info is None:
                raise Exception(
                    "Failed to get volume info by volume name. volume name is %s" % volume_name)
            if vol_info['status'] == "detaching":
                logger.info(
                    "the volume status is detaching, retry check after 10s.")
                continue
            if vol_info['status'] == "available":
                logger.info("umount volume successfully.")
                break
            logger.error(
                "umount volume failed, volume status is: %s" % vol_info[
                    'status'])
            raise Exception(
                "Failed to umount disk, volume status is %s" % vol_info[
                    'status'])

    def remove_cloud_disk(self):
        """
        移除云服务器中的云硬盘
        :return:
        """
        logger.info("start remove cloud disk.")

        # 获取目标服务实例
        instance = self.query_dest_service_instance(self.instance_name)
        if instance is None:
            logger.error(
                "remove cloud disks failed, can not find the dest instance: %s" % self.instance_name)
            raise Exception(
                "The target instance is not found, instance name is %s" % self.instance_name)

        # 第一步, 先停止云服务器
        self.operate_cloud_server(OPT_TYPE_OFF, self.server1_name)

        # 第二步, 在弹性云硬盘中卸载卷
        vol_info = self.get_volume_info_by_volume_name(self.add_volume_name)
        if vol_info is None:
            raise Exception(
                "Failed to get volume info by volume name, name is %s" % self.add_volume_name)
        self.umount_cloud_disk(self.product_vm_id, self.add_volume_name,
                               vol_info['id'])

        # 第三步, 刷新容灾服务实例
        self.refresh_instance(instance['id'])

        # 第四步, 去除容灾服务实例中云服务器的卷
        rd_body = {
            "action": "del_volumes",
            "instance_id": instance['id'],
            "server_id": self.product_vm_id,
            "del_vols": [vol_info['id']],
            "ids": [{"id": instance['id'], "service_type": self.service_type}]
        }

        __body__ = {'subscriptions': [
            {'operate_type': 'modify', 'product_id': self.product_id,
             "tenancy": 0,
             'project_id': self.project_id, 'region_id': self.primary_region_id,
             'service_type': self.service_type, 'params': json.dumps(rd_body)}]}
        self.console_sc_headers.__setitem__("Content-Length", "1020")
        self.console_sc_headers.__setitem__("Accept-Language",
                                            "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3")
        self.console_sc_headers.__setitem__("X-Language", "zh-cn")

        url = "https://%s/%s/rest/subscription/v3.0/subscriptions" % (
            self.console_host, self.service_type)
        response = self.sc_session.request(method="post", url=url,
                                           headers=self.console_sc_headers,
                                           data=json.dumps(__body__))
        if response.status_code != 200:
            logger.error(
                "send remove cloud volumes cmd failed, status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to remove cloud disks, status_code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        resp = json.loads(response.text)
        sub_id = resp['purchases'][0]['subscription_id']
        logger.info(
            "send remove cloud volumes successfully, order id=%s" % sub_id)

        # 监控订单状态
        self.monitor_order_status(sub_id)

        try:
            logger.info("start clean cloud disk..")
            self.delete_cloud_disk(vol_info['id'], self.add_volume_name)
        except Exception as e:
            logger.error("delete cloud disk failed, name=%s, id=%s" % (
                self.add_volume_name, vol_info['id']))

    def query_dest_service_instance(self, instance_name):
        """
        获取目标服务实例,如果找到了目标实例则返回ID
        :return:
        """
        content_leng = None
        if self.console_sc_headers.__contains__('Content-Length'):
            content_leng = self.console_sc_headers.__getitem__('Content-Length')
            self.console_sc_headers.__delitem__('Content-Length')
        url = "https://%s/%s/rest/ws/bcs/%s/instances?sort_key=create_time&sort_type=desc&marker=1&limit=10&instance_type=%s" \
              % (self.console_host, self.service_type, self.project_id,
                 self.service_type)
        response = self.sc_session.get(url=url, headers=self.console_sc_headers)
        if response.status_code != 200:
            logger.error(
                "failed to get instance list, status_code[%s], resp[%s]" % (
                    response.status_code, response.text))
            raise Exception(
                "Failed to query service instance, status code[%s], response[%s]" % (
                    response.status_code, response.text))
        if content_leng is not None:
            self.console_sc_headers.__setitem__('Content-Length', content_leng)
        resp = json.loads(response.text)
        for inst in resp['instances']:
            if inst['name'] == instance_name:
                logger.info(
                    "find the dest instance, instance name: %s" % instance_name)
                return inst
        logger.error(
            "can not find the service instance, name is %s" % instance_name)
        return None

    def monitor_order_status(self, order_id):
        """
        监控申请与删除订单的状态
        :param order_id:
        :return:
        """
        logger.info("start monitor order status, order_id: %s" % order_id)
        url = "https://%s/motenantconsolehomewebsite/goku/rest/order/v3.0/orders/%s" % (
            self.console_host, order_id)
        # 申请服务实例时必须设置该headers, 但检查状态必须删除该headers
        if self.console_sc_headers.__contains__("Content-Length"):
            self.console_sc_headers.__delitem__("Content-Length")
        retry_times = 0
        while True:
            response = self.sc_session.get(url=url,
                                           headers=self.console_sc_headers)
            if response.status_code != 200:
                # 如果请求失败, 连续重试6次
                logger.error(
                    "query sub status failed, times[%s], retry after 10s, id[%s], status_code=[%s], resp=[%s]"
                    % (
                        retry_times, order_id, response.status_code,
                        response.text))
                if retry_times == 5:
                    logger.error("retry times out.")
                    raise Exception(
                        "Failed to get order status information, order id[%s], status code[%s], "
                        "response[%s]" % (
                            order_id, response.status_code, response.text))
                time.sleep(5)
                retry_times = retry_times + 1
                continue
            resp = json.loads(response.text)
            if resp['status'] == "successed":
                logger.info(
                    "the order status is successed. operation successfylly.")
                return True
            if resp['status'] == "failed":
                detail = self.query_order_detail(order_id)
                logger.error(
                    "the order status is failed, defailt_info=%s" % detail)
                raise Exception(
                    "Failed to get order status information. order id[%s], detail[%s]" % (
                        order_id, detail))
            logger.info(
                "order status is %s, retry check after 20s" % resp['status'])
            time.sleep(20)

    def query_order_detail(self, order_id):
        """
        查询订单资源详情信息
        :return:
        """
        try:
            url = "https://%s/motenantconsolehomewebsite/goku/rest/order/v3.0/orders/%s/resources" \
                  % (self.console_host, order_id)
            response = self.sc_session.get(url=url,
                                           headers=self.console_sc_headers)
            if response.status_code != 200:
                logger.error(
                    "query failed information failed, status_code=%s, resp[%s]" % (
                        response.status_code, response.text))
                raise Exception(
                    "Failed to query order detail info, status code: %s, response: %s" % (
                        response.status_code, response.text))
            resp = json.loads(response.text)
            return str(resp[0]['message'])
        except Exception as e:
            logger.error("query order detail failed, errMsg=%s" % str(e))
        return ""

    def get_volume_info(self, vm_id):
        """
        根据虚拟机ID查询虚拟机的卷信息, 包括卷ID与卷类型
        :return:
        """
        volume_list = []
        logger.info("start get volume info by vm id: %s" % vm_id)
        url = "https://%s/%s/rest/v2.1/%s/servers/%s" % (
            self.console_host, self.service_type, self.project_id, vm_id)
        response = self.sc_session.get(url=url, headers=self.console_sc_headers)
        if response.status_code != 200:
            logger.error("Failed to get vm info, status code=%s, res=%s" % (
                response.status_code, response.text))
            raise Exception(
                "Failed to query vm info, vm id: %s, status code: %s, response: %s" % (
                    vm_id, response.status_code, response.text))

        resp = json.loads(response.text)
        volume_ids = resp['server']['os-extended-volumes:volumes_attached']
        for volume in volume_ids:
            tmp_dic = dict()
            tmp_dic['vol_id'] = volume['id']
            vol_url = "https://%s/%s/rest/v2/%s/volumes/%s" % (
                self.console_host, self.service_type, self.project_id,
                tmp_dic['vol_id'])
            response = self.sc_session.get(url=vol_url,
                                           headers=self.console_sc_headers)
            if response.status_code != 200:
                logger.error(
                    "Failed to get volume info, status code=%s, res=%s" % (
                        response.status_code, response.text))
                raise Exception(
                    "Failed to query volume info, volume id: %s, status code: %s, response: %s"
                    % (tmp_dic['vol_id'], response.status_code, response.text))
            resp = json.loads(response.text)
            tmp_dic['vol_type'] = resp['volume']['volume_type']
            tmp_dic['vol_name'] = resp['volume']['name']
            tmp_dic['vol_size'] = resp['volume']['size']
            volume_list.append(tmp_dic)
        logger.info("get vm volume info successfully: %s" % str(volume_list))
        return volume_list

    def send_apply_instance_cmd(self):
        """
        下发服务实例创建请求
        :return:
        """
        logger.info("start send apply instance cmd.")
        display = [
            {"label": "name", "type": "string", "value": self.instance_name},
            {"label": "Region", "type": "string",
             "value": self.primary_region_id},
            {"label": "AZ", "type": "string", "value": self.primary_az_id},
            {"label": "ECS Quantity", "type": "string", "value": "1"},
            {"label": "Volume Capacity", "type": "string", "value": "40GB"}]

        # 查询虚拟机使用的所有的卷的信息, 只会用到生产虚拟机的卷信息, 因此只查生产端
        volumes = self.get_volume_info(self.product_vm_id)
        if volumes.__len__() == 0:
            logger.error("the volume is empty.")
            raise Exception("Failed to apply instance, the volume is empty.")

        if self.service_type == CSDR_SERVICE_TYPE:
            policy = {"period_type": "minute", "period_interval": "15",
                      "time_point": ""}
            servers = [{"server_id": self.product_vm_id,
                        "occupied_vm_id": self.dr_vm_id, "vols": volumes}]
            display.append({"label": "DR Project", "type": "string",
                            "value": self.dr_project_id})
            display.append({"label": "Replication Policy", "type": "string",
                            "value": "replication"})
            display.append({"label": "Sync Period", "type": "string",
                            "value": "15 minutes"})
            rd_param = {
                "count": 1, "action": "add_instance", "instance_type": "csdr",
                "instance": {
                    "type": "csdr",
                    "description": "FCU auto test",
                    "name": self.instance_name,
                    "region": self.primary_region_id,
                    "remote_region": self.standby_region_id,
                    "available_zone": self.primary_az_id,
                    "remote_available_zone": self.standby_az_id,
                    "remote_project_id": self.dr_project_id,
                    "replication_type": "asynchronize",
                    "policy": policy,
                    "servers": servers
                },
                "display": display
            }
        elif self.service_type == CSHA_SERVICE_TYPE:
            servers = [{"server_id": self.product_vm_id,
                        "occupied_vm_id": self.dr_vm_id, "vols": volumes}]
            rd_param = {
                "count": 1, "action": "add_instance", "instance_type": "csha",
                "instance": {
                    "type": "csha",
                    "description": "FCU auto test",
                    "name": self.instance_name,
                    "region": self.primary_region_id,
                    "available_zone": self.primary_az_id,
                    "remote_available_zone": self.standby_az_id,
                    "servers": servers
                },
                "display": display
            }
        elif self.service_type == VHA_SERVICE_TYPE:
            servers = [{"server_id": self.product_vm_id, "vols": volumes}]
            rd_param = {
                "count": 1, "action": "add_instance", "instance_type": "vha",
                "instance": {
                    "type": "vha",
                    "description": "FCU auto test",
                    "name": self.instance_name,
                    "region": self.primary_region_id,
                    "available_zone": self.primary_az_id,
                    "servers": servers
                },
                "display": display
            }
        else:
            raise Exception("The service type is error:%s" % self.service_type)

        rate_params = [{
            "params": [{
                "region_id": self.primary_region_id,
                "az_id": self.primary_az_id,
                "extend_params": 0
            }],
            "unit": {
                "zh_CN": "小时",
                "en_US": "Hour"
            },
            "price": 0.00
        }]
        __body__ = {
            "subscriptions": [
                {
                    "tenancy": 0,
                    "operate_type": "apply",
                    "product_id": self.product_id,
                    "project_id": self.project_id,
                    "region_id": self.primary_region_id,
                    "service_type": self.service_type,
                    "params": json.dumps(rd_param),
                    "rate_params": json.dumps(rate_params)
                }
            ]
        }

        self.console_sc_headers.__setitem__("Content-Length", "1020")
        self.console_sc_headers.__setitem__("Accept-Language",
                                            "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3")
        self.console_sc_headers.__setitem__("X-Language", "zh-cn")

        url = "https://%s/%s/rest/subscription/v3.0/subscriptions" % (
            self.console_host, self.service_type)
        response = self.sc_session.request(method="post", url=url,
                                           headers=self.console_sc_headers,
                                           data=json.dumps(__body__))
        if response.status_code != 200:
            logger.error(
                "send instance create cmd failed, status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to apply service instance, status_code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        resp = json.loads(response.text)
        sub_id = resp['purchases'][0]['subscription_id']
        logger.info("send apply command successfully, apply_id=%s" % sub_id)
        return sub_id

    def check_vms_info(self):
        """
        检查能否正常从eReplicatoin上查询出生产虚拟机与占位虚拟机
        :return:
        """
        # 查询生产虚拟机
        query_product_vm_url = "https://%s/%s/rest/ws/bcs/%s/protectable-servers?region=%s&available_zone=%s&instance_type=%s" \
                               % (self.console_host, self.service_type,
                                  self.project_id, self.primary_region_id,
                                  self.primary_az_id, self.service_type)
        logger.info("start query product vm, url=%s" % query_product_vm_url)
        response = self.sc_session.get(url=query_product_vm_url,
                                       headers=self.console_sc_headers)
        if response.status_code != 200:
            logger.error("get product vm failed, status_code=%s, context=%s" % (
                response.status_code, str(response.text)))
            raise Exception(
                "Failed to get production VM information from eReplication. status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
        vms = json.loads(response.text)
        logger.info("product vms: %s" % str(vms))
        product_vm_id = ""
        for vm in vms['servers']:
            if vm['server_id'] == self.product_vm_id:
                product_vm_id = vm['server_id']
                break
        if CommonUtil.check_value_null(product_vm_id):
            logger.error(
                "can not find the production vm from eReplication interface, product vm id=%s" % self.product_vm_id)
            raise Exception(
                "Failed to get production VM information from eReplication, VM id=%s" % self.product_vm_id)

        if self.service_type == VHA_SERVICE_TYPE:
            # VHA只有一个虚拟机,在此返回
            return True

        # 根据生产虚拟机查询占位虚拟机
        query_place_vm_url = "https://%s/%s/rest/ws/bcs/%s/servers/%s/os-placeholder-servers?region=%s&instance_type=%s&remote_region=%s&remote_project_id=%s&remote_available_zone=%s" \
                             % (self.console_host, self.service_type,
                                self.project_id, self.product_vm_id,
                                self.primary_region_id, self.service_type,
                                self.standby_region_id, self.dr_project_id,
                                self.standby_az_id)
        logger.info("start query replace vm, query url=%s" % query_place_vm_url)
        response = self.sc_session.get(url=query_place_vm_url,
                                       headers=self.console_sc_headers)
        if response.status_code != 200:
            logger.error(
                "get placeholder vm failed, status_code=%s, context=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to get placeholder VM information from eReplication. status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
        vms = json.loads(response.text)
        logger.info("os-placeholder vms: %s" % str(vms))
        for vm in vms['servers']:
            if vm['server_id'] == self.dr_vm_id:
                logger.info("get placeholder vm successfully.")
                return True

        raise Exception(
            "Failed to get placeholder VM information from eReplication, DR VM id=%s" % self.dr_vm_id)

    def check_eReplication_config(self, service_type):
        """
        从eReplication查询出AZ与Region配对关系, 检查与当前调测的用户外部转入的参数配置是否一致
        保证用户在eReplication上配置了正确的AZ与Region配对关系
        :return:
        """
        query_region_url = "https://%s/%s/rest/ws/bcs/config/az/pairs?region=%s&instance_type=%s" \
                           % (self.console_host, self.service_type,
                              self.primary_region_id, self.service_type)
        logger.info("start query region map info, url: %s" % query_region_url)
        response = self.sc_session.get(url=query_region_url,
                                       headers=self.console_sc_headers)
        if response.status_code != 200:
            logger.error(
                "get az pairs info failed, status_code=%s, context=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to get available zone. status_code=%s, context=%s" % (
                    response.status_code, str(response.text)))
        resp = json.loads(response.text)
        if service_type == VHA_SERVICE_TYPE:
            for az in resp['az_pairs']:
                primary_az_id = az['primary_az']['az_id']
                if primary_az_id == self.primary_az_id:
                    return True
            raise Exception(
                "Log in to the eReplication portal interface, then find OpenStack in the Resources menu and check that the Region and AZ configuration information is correct.")
        for info in resp['region_pairs']:
            primary_region_id = info['primary_region']['region_id']
            standby_region_id = info['second_region']['region_id']
            for az in info['az_pairs']:
                primary_az_id = az['primary_az']['az_id']
                standby_az_id = az['second_az']['az_id']
                if service_type == CSHA_SERVICE_TYPE:
                    if primary_region_id == self.primary_region_id \
                            and primary_az_id == self.primary_az_id and standby_az_id == self.standby_az_id:
                        logger.info("find the region and az in eReplcation")
                        return True
                    # 当前主Region是随机指定一个首Region，eReplication上返回的数据可能恰恰相反, 因此再反向检查一下是否满足要求
                    if primary_region_id == self.primary_region_id \
                            and primary_az_id == self.standby_az_id and standby_az_id == self.primary_az_id:
                        logger.info(
                            "find the reverse region and az in eReplcation")
                        return True
                elif service_type == CSDR_SERVICE_TYPE:
                    if primary_region_id == self.primary_region_id and standby_region_id == self.standby_region_id \
                            and primary_az_id == self.primary_az_id and standby_az_id == self.standby_az_id:
                        logger.info("find the region and az in eReplcation")
                        return True
                    # 当前主Region是随机指定一个首Region，eReplication上返回的数据可能恰恰相反, 因此再反向检查一下是否满足要求
                    if primary_region_id == self.standby_region_id and standby_region_id == self.primary_region_id \
                            and primary_az_id == self.standby_az_id and standby_az_id == self.primary_az_id:
                        logger.info(
                            "find the reverse region and az in eReplcation")
                        return True
        logger.error(
            "check eReplication config failed, response: %s" % response.text)
        raise Exception(
            "Log in to the eReplication portal interface, then find OpenStack in the Resources menu and check that the Region and AZ configuration information is correct.")

    def get_project_id_by_name(self, project_name, region_id):
        """
        通过project名称与region ID查询project ID
        :return:
        """
        query_project_url = "https://%s/%s/rest/vdc/v3.1/users/%s/projects" \
                            % (
                                self.console_host, self.service_type,
                                self.user_id)
        logger.info("start query project info, url: %s" % query_project_url)
        response = self.sc_session.get(url=query_project_url,
                                       headers=self.console_sc_headers)
        if response.status_code != 200:
            logger.error(
                "get project info failed, status_code=%s, context=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to get project info. status_code=%s, context=%s" % (
                    response.status_code, str(response.text)))
        resp = json.loads(response.text)
        for project in resp['projects']:
            if project['name'] == project_name:
                for region in project['regions']:
                    if region['region_id'] == region_id:
                        logger.info(
                            'get project id successfully, id=%s' % project[
                                'id'])
                        return project['id']
        raise Exception(
            "Failed to get project id, DR region id=%s, response: %s" % (
                self.standby_region_id, resp))

    def get_vm_id_by_name(self, vm_name):
        """根据虚拟机名字，获取虚拟机ID

        :return: server_id
        """
        try:
            logger.info("start get vm info, vm_name=%s" % vm_name)
            service_list_info = self.get_service_list()
            logger.info("get all vm info successfully")
        except Exception as e:
            logger.error("failed to get vm list, errMsg=%s" % str(e))
            raise Exception("Failed to get vm info, errMsg=%s" % str(e))
        server_id = None
        for server_info in service_list_info["servers"]:
            if server_info["name"] == vm_name:
                server_id = server_info["id"]
        if CommonUtil.check_value_null(server_id):
            logger.error("get vm id failed, server_id is [%s]" % server_id)
            raise Exception("Failed to get vm by vm name, name=%s" % vm_name)
        logger.info("get vm id by name succcessfully, id=%s" % server_id)
        return server_id

    def get_vm_info(self, vm_name):
        """
        根据虚拟机名称获取虚拟机信息
        :param vm_name:
        :return:
        """
        try:
            logger.info("start get vm info, vm_name=%s" % vm_name)
            service_list_info = self.get_service_list()
            logger.info("get all vm info successfully")
        except Exception as e:
            logger.error("failed to get vm list, errMsg=%s" % str(e))
            raise Exception("Failed to get vm info, errMsg=%s" % str(e))
        for server_info in service_list_info["servers"]:
            if server_info["name"] == vm_name:
                logger.info(
                    "get vm info successfully, vm name is %s, id is %s" % (
                        vm_name, server_info["id"]))
                return server_info

        logger.error("get vm info failed, vm name is [%s]" % vm_name)
        raise Exception("Failed to get vm info by vm name, name=%s" % vm_name)

    def get_service_list(self):
        """获取该租户下所有虚拟机信息
        :return:
        """
        try:
            url = "https://{console_url}/ecm/rest/v1.0/servers?limit=10&offset=1&not-tags=__type_baremetal".format(
                console_url=self.console_host)
            res = self.sc_session.get(url=url, headers=self.console_sc_headers)
            if res.status_code != 200:
                logger.error(
                    "failed to get vm list, status_code=%s, content=%s" % (
                        res.status_code, res.text))
                raise Exception(
                    "status_code=%s, content=%s" % (res.status_code, res.text))
            return json.loads(res.text)
        except Exception as e:
            logger.error("failed to get vm list, errMsg=%s" % str(e))
            raise Exception("Failed to get mv list[%s]" % str(e))

    def query_region_id_by_name(self):
        """
        :param region_name:
        :return:
        """
        code, res = self.show_region_list()
        total = res["total"]
        regions_list = res["regions"]
        self.primary_region_id = ""
        self.standby_region_id = ""
        logger.info("primary region name: %s, standby region name: %s" % (
            self.primary_region_name, self.standby_region_name))
        for n in range(0, total):
            if regions_list[n]["name"] == self.primary_region_name:
                logger.info(
                    "get primary region id by region_name successfully, region_name=%s, region_id=%s"
                    % (self.primary_region_name, regions_list[n]["id"]))
                self.primary_region_id = regions_list[n]["id"]
            # CSDR场景下才会涉及到多Region
            if self.service_type == CSDR_SERVICE_TYPE and regions_list[n][
                "name"] == self.standby_region_name:
                logger.info(
                    "get standby region id by region_name successfully, region_name=%s, region_id=%s"
                    % (self.standby_region_name, regions_list[n]["id"]))
                self.standby_region_id = regions_list[n]["id"]

        if CommonUtil.check_value_null(self.primary_region_id):
            logger.info("%s region not exist" % self.primary_region_name)
            raise Exception("%s region not exist" % self.primary_region_name)
        if self.service_type == CSDR_SERVICE_TYPE and CommonUtil.check_value_null(
                self.standby_region_id):
            logger.info("%s region not exist" % self.standby_region_name)
            raise Exception("%s region not exist" % self.standby_region_name)

    def show_region_list(self):
        try:
            # 查询所有的region。——不需要token权限，base_set即可
            url = "https://%s/motenantconsolehomewebsite/rest/silvan/rest/v1.0/regions?start=0&limit=0" % self.console_host
            ret = self.sc_session.get(url=url, headers=self.console_sc_headers,
                                      verify=False)
            if ret.status_code != 200:
                raise Exception("status_code: %s, content: %s" % (
                    ret.status_code, ret.content))
            logger.info("get region list result: %s" % ret.status_code)
            res = json.loads(ret.text)
            return ret.status_code, res
        except Exception as e:
            logger.error("get region list failed, errMsg=%s" % str(e))
            raise Exception("Failed to get region info[%s]" % str(e))

    def get_az_id_by_name(self, region_id, az_name):
        """
        :param token:
        :param region_id:
        :param azoneName:
        :return:
        """
        # 根据AZ名称获取AZ的ID
        logger.info(
            "get az id by name, regionId=%s, az_name=%s" % (region_id, az_name))
        host_url = "https://" + self.common_params[MANAGE_CONSOLE_HOST]

        url = "%s/%s/rest/serviceaccess/v3.0/available-zones?cloud_infra_id=FUSION_CLOUD_%s" % (
            host_url, self.service_type, region_id)
        ret = self.sc_session.get(url=url, headers=self.console_sc_headers,
                                   verify=False)
        logger.info("query available az info, status=%s, result=%s" % (
             ret.status_code, str(ret.text)))
        if ret.status_code != 200:
             raise Exception(
                 "Failed to get az id by name, name is %s, status code[%s], response[%s]" % (
                     az_name, ret.status_code, str(ret.text)))
        res = json.loads(ret.text)
        total = res["total"]
        azone_list = res["records"]
        az_id = ""
        for n in range(0, total):
            if azone_list[n]["name"] == az_name:
                az_id = azone_list[n]["az_id"]
        if CommonUtil.check_value_null(az_id):
            logger.error(
                "get az id by az name failed, az_name=%s, context=%s" % (
                    az_name, (res)))
            raise Exception("%s azone not exist." % az_name)
        logger.info("get az id successfully, az_id=%s" % az_id)
        return az_id


    def close(self):
        try:
            self.sc_session.close()
        except Exception as e:
            logger.error("colse sc session failed, errMsg=%s" % str(e))

    def __exit__(self, *args):
        self.close()


class RequestApi():
    def __init__(self, tool_project_id, tool_region_id, service_type):
        if not [CSDR_SERVICE_TYPE, CSHA_SERVICE_TYPE,
                VHA_SERVICE_TYPE].__contains__(service_type):
            logger.error(
                "the service type is error, service type is %s" % service_type)
            raise Exception(
                "The service type is error, service type is %s" % service_type)

        params = ParamUtil()
        self.user = "SyncAdmin"
        self.pwd = params.get_value_from_cloud_param(tool_project_id,
                                                     service_type.upper(),
                                                     'sync_admin_pwd',
                                                     tool_region_id)
        server_params = CommonUtil.get_server_params(tool_project_id,
                                                     tool_region_id,
                                                     service_type.upper())
        server_ip = server_params["server_ip1"]
        business_user_pwd = server_params["server_business_user_pwd"]
        sudo_user_pwd = server_params["server_root_pwd"]
        self.port = "9443"
        node_ip, self.ip = CommonUtil.get_server_node(server_ip, "DRManager",
                                                      business_user_pwd,
                                                      sudo_user_pwd)
        self.instance_name = get_instance_name(service_type)
        self.url = "https://%s:%s/" % (self.ip, self.port)
        self.header = self.buildHeader()
        self.service_type = service_type

    def buildHeader(self):
        __header__ = dict()
        __header__.__setitem__("Content-Type", "application/json;charset=utf-8")
        __header__.__setitem__("Accept",
                               "application/json;version=1.0;charset=UTF-8")
        __header__.__setitem__("Accept-Language", "zh_CN")
        __header__.__setitem__("x-auth-user", self.user)
        __header__.__setitem__("x-auth-key", self.pwd)
        return __header__

    def get_resp_data(self, resp):
        if resp is not None and resp != 'None' \
                and resp != 'null' and resp:
            return json.loads(resp)
        return None

    def sendPostRequest(self, body, path):
        if isinstance(body, dict) or isinstance(body, list):
            body = json.dumps(body)
        resp = requests.post(self.url + path, headers=self.header, data=body,
                             verify=False)
        return resp.status_code, self.get_resp_data(resp.content)

    def sendGetRequest(self, path):
        resp = requests.get(self.url + path, headers=self.header, data=None,
                            verify=False)
        return resp.status_code, self.get_resp_data(resp.content)

    def sendPutRequest(self, body, path):
        if isinstance(body, dict) or isinstance(body, list):
            body = json.dumps(body)
        resp = requests.put(self.url + path, headers=self.header, data=body,
                            verify=False)
        return resp.status_code, self.get_resp_data(resp.content)

    def refresh_device(self, ops_uuid):
        # 调用刷新时, 需要对设备UUID进行Base64编码
        import base64

        refresh_url = "ws/fusionsphere/%s/action/refresh" % base64.b64encode(ops_uuid.encode(encoding='utf-8')).decode(encoding='utf-8')
        logger.info("refresh_url : %s" % refresh_url)
        try:
            # 该PUT请求未返回后台任务,无法获取请求的执行结果,因此只发送一次, 检查状态是否OK
            __state__, __body__ = self.sendPutRequest(None, refresh_url)
            if __state__ != 200:
                if dict(__body__).__contains__('errorCode') and (str(
                        dict(__body__).__getitem__('errorCode')) == "1073947428"
                                                                 or str(
                            dict(__body__).__getitem__('errorCode')) == "606"):
                    # 正在刷新中
                    logger.info(
                        "the device is being refresh, no need refress again.")
                    time.sleep(20)
                    return True
                raise Exception('Failed to refresh device[%s]' % str(__body__))
            logger.info("refresh_device cmd send successfully.")
            time.sleep(30)
        except Exception as e:
            logger.error("refresh device failed, errMsg=%s" % str(e))
            raise Exception('Failed to refresh device[%s]' % str(e))

    def get_device_id(self):
        """
        获取设备ID
        :return:
        """
        __state__, __body__ = self.sendGetRequest("ws/drmservers")
        if __state__ != 200:
            logger.error(
                "get drm server info failed, status=%s, response=%s" % (
                    __state__, str(__body__)))
            raise Exception(
                "get drm server info failed, status=%s, response=%s" % (
                    __state__, str(__body__)))
        server_id = dict(__body__[0]).get('uuid')
        logger.info("drm server uuid is [%s]" % server_id)

        __state__, __body__ = self.sendGetRequest(
            "ws/sites?serverUuid=%s" % server_id)
        logger.info("get siteid result[%s]" % str(__body__))
        if __state__ != 200:
            logger.error("get dr site info failed, status=%s, response=%s" % (
                __state__, str(__body__)))
            raise Exception(
                "Failed to get dr site info, status=%s, response=%s" % (
                    __state__, str(__body__)))
        for siteinfo in __body__:
            __id__ = dict(siteinfo).get("siteId")
            __state__, __body__ = self.sendGetRequest(
                "ws/fusionsphere?siteId=%s&cloudType=" % __id__)
            if __state__ != 200:
                logger.error(
                    "get dr site info failed, status=%s, response=%s" % (
                        __state__, str(__body__)))
                raise Exception(
                    "Failed to get openstack info, status=%s, response=%s" % (
                        __state__, str(__body__)))
            logger.info("get device info result[%s]" % str(__body__))
            for fsp_info in __body__:
                return dict(fsp_info).get("deviceSn")
        raise Exception(
            "Failed to get openstack info in eReplication[ip: %s], get more messages from log." % self.ip)

    def config_dr(self, az_volume_map):
        """
        配置容灾卷映射和AZ映射,以及Region
        :return:
        """
        ops_uuid = self.get_device_id()
        logger.info("get openstack uuid successfully. [%s]" % ops_uuid)

        # 刷新设备
        self.refresh_device(ops_uuid)

        logger.info("start config az mapping...")
        data = {"primary_az": az_volume_map["az1"],
                "primary_az_id": az_volume_map["az1"],
                "primary_region": az_volume_map["region1"],
                "primary_region_id": az_volume_map["region1"],
                "type": self.service_type.lower()}
        volume_data = {"primary_volType": az_volume_map["volume1"],
                       "type": self.service_type.lower(),
                       "second_volType": az_volume_map["volume2"]}
        if self.service_type.lower() == CSHA_SERVICE_TYPE:
            data.update({"second_az": az_volume_map["az2"],
                         "second_az_id": az_volume_map["az2"]})
            volume_data.update({"primary_az_id": az_volume_map["az1"],
                                "second_az_id": az_volume_map["az2"]})
        elif self.service_type.lower() == CSDR_SERVICE_TYPE:
            data.update({"second_az": az_volume_map["az2"],
                         "second_az_id": az_volume_map["az2"],
                         "second_region": az_volume_map["region2"],
                         "second_region_id": az_volume_map["region2"]})
            volume_data.update({"primary_az_id": az_volume_map["az1"],
                                "second_az_id": az_volume_map["az2"]})

        __state__, __body__ = self.sendPostRequest(data,
                                                   "ws/openstack/%s/azpairs/action/create" % ops_uuid)
        if __state__ != 200:
            errCode = dict(__body__).__getitem__("errorCode")
            if str(errCode) == "1073948128":
                logger.info("az map already exists: %s" % str(data))
            else:
                logger.error(
                    "Failed to config az map, status code[%s], errmsg=[%s]" % (
                        __state__, str(__body__)))
                raise Exception(
                    "Failed to config az map, status code[%s], errmsg=[%s]" % (
                        __state__, str(__body__)))

        logger.info("start config volume type mapping, volume_data: %s" % str(
            volume_data))
        __state__, __body__ = self.sendPostRequest([volume_data],
                                                   "ws/openstack/%s/voltypepairs/action/create" % ops_uuid)
        if __state__ != 200:
            errCode = dict(__body__).__getitem__("errorCode")
            if str(errCode) == "1073948123":
                logger.info("volume already exists: %s" % str(volume_data))
            else:
                logger.error(
                    "Failed to config volume type map, status code[%s], errmsg=[%s]" % (
                        __state__, str(__body__)))
                raise Exception(
                    "Failed to config volume type map, status code[%s], errmsg=[%s]" % (
                        __state__, str(__body__)))

        logger.info("config volume type and az map successfully.")
        return True

    def get_dest_recovery_plan(self):
        """
        获取目标恢复计划
        :return:
        """
        # 获取所有的恢复计划
        logger.info("start get dest recoveryplan")
        url = "ws/recoveryplans?startPage=0&pageSize=10&planType=0&Rp.name=%s"\
              % self.instance_name
        logger.info("get dest recoveryplan url is %s" % url)
        status_code, body = self.sendGetRequest(url)
        if status_code != 200:
            logger.error("get dest recovery plan failed, code=%s, body=%s" % (
                status_code, str(body)))
            return None, Message(500, "获取服务实例的恢复计划信息失败[%s]" % str(body),
                                 "Failed to get service instance recovery plan information[%s]" % str(
                                     body),
                                 "请检查", "Please check")
        replan_list = list(dict(body).__getitem__("records"))
        if replan_list.__len__() == 0:
            logger.error("query recovery plan list is empty.")
            return None, Message(500, "未找到待测试实例的恢复计划",
                                 "Recovery plan for the instance to be tested not found",
                                 "请登录eReplication Server检查服务实例的保护组与恢复计划是否已创建",
                                 "Log in to the eReplication Server to check if the protection group and recovery plan of the service instance have been created.")
        recovery_plan = None
        for replan in replan_list:
            if dict(replan).__getitem__("name") == self.instance_name:
                recovery_plan = dict(replan)
                logger.info(
                    "get recovery plan successfully, recovery plan: %s" % str(
                        recovery_plan))
                break
        if recovery_plan is None:
            logger.error("get dest recovery plan failed.")
            return None, Message(500, "未找到待测试实例的恢复计划",
                                 "Recovery plan for the instance to be tested not found",
                                 "请登录eReplication Server检查服务实例的保护组与恢复计划是否已创建",
                                 "Log in to the eReplication Server to check if the protection group and recovery plan of the service instance have been created.")
        logger.info("get dest recovery plan successfully.")
        return recovery_plan, Message(200)

    def recoveryplan_drRecovery_test(self, uuid):
        """
        对指定的恢复计划执行故障恢复
        :param request_api:
        :param uuid:
        :return:
        """
        status_code, body = self.sendPutRequest({},
                                                "ws/recoveryplans/%s/action/diasterRecovery" % uuid)
        if status_code != 200:
            logger.error("drRecovery test failed, status_code: %s, body: %s" % (
                status_code, str(body)))
            return Message(500, "对%s下发灾难恢复请求失败[%s]" % (
                self.instance_name, str(body)),
                           "Failed to issue a scheduled disactory recovery request to %s[%s]" % (
                               self.instance_name, str(body)),
                           self.get_suggestion_msg(), self.get_suggestion_msg())

        # 检查灾难恢复是否完成
        while True:
            time.sleep(20)
            status_code, body = self.sendGetRequest(
                "ws/recoveryplans/%s/action/abstractInfo" % uuid)
            if status_code != 200:
                logger.error(
                    "check plan reprotect failed, status_code: %s, data: %s" % (
                        status_code, body))
                continue
            planStatus = str(dict(body).__getitem__("planStatus"))
            if planStatus == "10":
                # 如果正在进行灾难恢复, 等待20秒后再进行下一次检查
                logger.info(
                    "the plan status is reprotecting, retry check after 20s.")
                continue
            elif planStatus == "11":
                logger.info("the plan reprotect status is successfully.")
                return Message(200)
            # 如果既不是灾难恢复中,也不是恢复完成, 直接返回错误
            logger.error(
                "recovery plan status is error, status=%s" % planStatus)
            return Message(500, "执行灾难恢复失败",
                           "Performing a disactor recovery failed",
                           "使用浏览器访问https://%s:%s/src/login/view/login.html，登录成功后，在“恢复”中查询名称为%s的恢复计划执行历史，找到失败原因" % (
                               self.ip, self.port, self.instance_name),
                           "Use the browser to access https://%s:%s/src/login/view/login.html. After the login is successful, query the recovery plan execution history named %s in \"Recovery\" and find the reason for the failure." % (
                               self.ip, self.port, self.instance_name))

    def recoveryplan_reprotect(self, uuid):
        """
        对指定的恢复计划执行重保护
        :param request_api:
        :param uuid:
        :return:
        """
        data = {"isReserved": True}
        status_code, body = self.sendPutRequest(data,
                                                "ws/recoveryplans/%s/action/reprotect" % uuid)
        if status_code != 200:
            logger.error("reprotect failed, status code: %s, body: %s" % (
                status_code, str(body)))
            return Message(500,
                           "对%s下发重保护请求失败[%s]" % (self.instance_name, str(body)),
                           "Failed to issue a scheduled reprotect request to %s[%s]" % (
                               self.instance_name, str(body)),
                           self.get_suggestion_msg(), self.get_suggestion_msg())
        # 检查重保护是否完成
        while True:
            time.sleep(20)
            status_code, body = self.sendGetRequest(
                "ws/recoveryplans/%s/action/abstractInfo" % uuid)
            if status_code != 200:
                logger.error(
                    "check plan reprotect failed, status_code: %s, data: %s" % (
                        status_code, body))
                continue
            planStatus = str(dict(body).__getitem__("planStatus"))
            if planStatus == "17":
                # 如果正在进行重保护, 等待20秒后再进行下一次检查
                logger.info(
                    "the plan reprotect status is running, retry check after 20s.")
                continue
            elif planStatus == "20":
                logger.info("the plan reprotect status is successfully.")
                return Message(200)
            # 如果既不是计划性迁移中,也不是迁移完成, 直接返回错误
            logger.error(
                "recovery plan reprotect status is error, status=%s" % planStatus)
            return Message(500, "执行重保护失败",
                           "Performing a reprotect failed",
                           "使用浏览器访问https://%s:%s/src/login/view/login.html，登录成功后，在“恢复”中查询名称为%s的恢复计划执行历史，找到失败原因" % (
                               self.ip, self.port, self.instance_name),
                           "Use the browser to access https://%s:%s/src/login/view/login.html. After the login is successful, query the recovery plan execution history named %s in \"Recovery\" and find the reason for the failure." % (
                               self.ip, self.port, self.instance_name))

    def recoveryplan_motion_test(self, uuid, service_type):
        """
        对指定的恢复计划执行计划性迁移
        :param request_api:
        :param uuid:
        :return:
        """
        logger.info(
            "start recoveryplan motion test, service type: %s" % service_type)
        status_code, body = self.sendPutRequest({},
                                                "ws/recoveryplans/%s/action/plannedMigration" % uuid)
        if status_code != 200:
            logger.error(
                "recoveryplan motion test failed, status_code: %s, body: %s" % (
                    status_code, str(body)))
            return Message(500, "对%s下发计划性迁移请求失败[%s]" % (
                self.instance_name, str(body)),
                           "Failed to issue a scheduled migration request to %s[%s]" % (
                               self.instance_name, str(body)),
                           self.get_suggestion_msg(), self.get_suggestion_msg())

        # 计划性迁移成功的状态为2, 因此默认设置为2, 但对于CSHA场景, 计划性迁移会自动做重保护, 因此CSHA场景迁移完成后状态是20
        dest_status = "2"
        if service_type == CSHA_SERVICE_TYPE:
            dest_status = "20"

        # 检查计划性迁移是否完成
        while True:
            # 检查计划性迁移状态
            time.sleep(20)
            status_code, body = self.sendGetRequest(
                "ws/recoveryplans/%s/action/abstractInfo" % uuid)
            if status_code != 200:
                logger.error(
                    "check plan motion failed, status_code: %s, data: %s" % (
                        status_code, body))
                continue
            planStatus = str(dict(body).__getitem__("planStatus"))
            if planStatus == "1":
                # 如果正在进行计划性迁移, 等待20秒后再进行下一次检查
                logger.info(
                    "the plan motion status is motioning, retry check after 20s.")
                continue
            elif planStatus == dest_status:
                logger.info("the plan motion status is successfully.")
                return Message(200)
            # 如果既不是计划性迁移中,也不是迁移完成, 直接返回错误
            logger.error(
                "recovery plan status is error, status=%s" % planStatus)
            return Message(500, "执行计划性迁移失败",
                           "Performing a planned migration failed",
                           "使用浏览器访问https://%s:%s/src/login/view/login.html，登录成功后，在“恢复”中查询名称为%s的恢复计划执行历史，找到失败原因" % (
                               self.ip, self.port, self.instance_name),
                           "Use the browser to access https://%s:%s/src/login/view/login.html. After the login is successful, query the recovery plan execution history named %s in \"Recovery\" and find the reason for the failure." % (
                               self.ip, self.port, self.instance_name))

    def get_suggestion_msg(self):
        """
        建议用户到eReplication去看执行失败的原因
        :return:
        """
        return "Log in to the eReplcation portal by entering 'https://%s:%s/src/login/view/login.html' " \
               "in the browser address bar. Find the reason for the failure in " \
               "'Settings -> Log Management -> System Operation Log'." % (
                   self.ip, self.port)


class sc_tenant_api():
    """
    提供SC租户侧操作接口
    """

    def __init__(self, tool_project_id, tool_region_id, service_type):
        """
        租户侧操作API
        :param tool_project_id: 工程project id
        :param tool_region_id: 工程region id
        :param service_type: 服务类型csdr/csha/vha
        """
        self.tool_project_id = tool_project_id
        self.tool_region_id = tool_region_id
        self.current_region_type = get_project_type(
            self.tool_project_id).lower()
        self.service_type = service_type.lower()
        params = ParamUtil()
        self.parmas_dict = get_common_params(tool_project_id, tool_region_id,
                                             self.service_type)
        self.console_host = self.parmas_dict[TENANT_CONSOLE_HOST]
        self.iam_host = self.parmas_dict[TENANT_IAM_HOST]
        self.vpc_name = "FCU_VPC_" + self.service_type
        self.key_pair_name = "FCU_" + self.service_type.lower()
        self.image_name = params.get_value_from_cloud_param(tool_project_id,
                                                            'Basic_FS_Test',
                                                            '%s_vm_template_kvm' % self.current_region_type,
                                                            tool_region_id)
        self.flavor_name = params.get_value_from_cloud_param(tool_project_id,
                                                             'Basic_FS_Test',
                                                             '%s_kvm_flavor_name1' % self.current_region_type,
                                                             tool_region_id)
        self.tenant_user_pwd = self.parmas_dict[SC_TENANT_USER_PWD_KEY]
        self.tenant_user = self.parmas_dict[SC_TENANT_USER_KEY]
        self.primary_region_name = self.parmas_dict[PRIMARY_REGION_NAME]
        self.standby_region_name = self.parmas_dict[STANDBY_REGION_NAME]

        self.vdc1 = self.parmas_dict[PRIMARY_VDC_NAME]
        self.project1 = self.parmas_dict[PRIMARY_PROJECT_NAME]
        self.session = requests.session()

        # SC首页的headers，包括cftk,agencid,jsessionid等，在登录过程中更新
        self.bak_global_headers = {"Accept": "*/*",
                                   "X-Language": "zh-cn",
                                   "X-Requested-With": "XMLHttpRequest",
                                   "Connection": "keep-alive",
                                   "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.104 Safari/537.36",
                                   "Content-Type": "application/json; charset=UTF-8"
                                   }
        # VPC服务的headers，包括cftk,agencid,jsessionid等，在登录过程中更新
        self.global_headers = {
            "Accept": "*/*",
            "X-Language": "zh-cn",
            "X-Requested-With": "XMLHttpRequest",
            "Connection": "keep-alive",
            "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.104 Safari/537.36",
            "Content-Type": "application/json; charset=UTF-8"
        }

    def get_az_id_by_name(self, az_name):
        """
        :param token:
        :param region_id:
        :param azoneName:
        :return:
        """
        # 根据AZ名称获取AZ的ID
        logger.info("get az id by name, regionId=%s, az_name=%s" % (
            self.region_id, az_name))
        host_url = "https://" + self.parmas_dict[MANAGE_CONSOLE_HOST]
        url = "%s/%s/rest/serviceaccess/v3.0/available-zones?cloud_infra_id=FUSION_CLOUD_%s" % (
            host_url, self.service_type, self.region_id)
        ret = self.session.get(url=url, headers=self.global_headers,
                               verify=False)
        logger.info("query available az info, status=%s, result=%s" % (
            ret.status_code, str(ret.text)))
        if ret.status_code != 200:
            raise Exception(
                "Failed to get az id by name, name is %s, status code[%s], response[%s]" % (
                    az_name, ret.status_code, str(ret.text)))
        res = json.loads(ret.text)
        total = res["total"]
        azone_list = res["records"]
        az_id = ""
        for n in range(0, total):
            if azone_list[n]["name"] == az_name:
                az_id = azone_list[n]["az_id"]
        if CommonUtil.check_value_null(az_id):
            logger.error(
                "get az id by az name failed, az_name=%s, context=%s" % (
                    az_name, (res)))
            raise Exception("%s azone not exist." % az_name)
        logger.info("get az id successfully, az_id=%s" % az_id)
        return az_id

    def get_all_image_info(self, region_id=None):
        """
        查询指定Region下的所有可用镜像
        :return:
        """
        if region_id is None:
            region_id = self.region_id
        tmp_region_id = self.global_headers["region"]
        self.global_headers["region"] = region_id
        try:
            url = "https://%s/ecm/rest/v2/ims/combine/images?__support_kvm=true&__imagetype=gold&status=active&sort_key=name&sort_dir=asc"
            result = self.session.get(url=url % self.console_host,
                                      headers=self.global_headers, verify=False)
            if result.status_code != 200:
                raise Exception(
                    "Failed to get image info, status code[%s], response[%s]" % (
                        result.status_code, str(result.text)))
        except Exception as e:
            raise e
        finally:
            self.global_headers["region"] = tmp_region_id
        return json.loads(result.text)["images"]

    def get_image_info_by_name(self, image_name):
        """
        get_image_info
        :return:
        """
        logger.info("start get image info by image name: %s" % image_name)
        for image in self.get_all_image_info():
            logger.info("check image... [%s]" % image["name"])
            if image_name == image["name"]:
                logger.info("find the image, id=%s" % image["id"])
                return image
        logger.error("can not find the image, get image info failed.")
        raise Exception(
            "Failed to get image info, image name is %s" % image_name)

    def get_all_falvor_info(self, region_id=None):
        if region_id is None:
            region_id = self.region_id
        tmp_region_id = self.global_headers["region"]
        self.global_headers["region"] = region_id
        try:
            url = "https://%s/ecm/rest/v1/%s/cloudservers/flavors" % (
                self.console_host, self.project_id)
            result = self.session.get(url=url, headers=self.global_headers,
                                      verify=False)
            if result.status_code != 200:
                raise Exception(
                    "Failed to get flavor info, status code[%s], response[%s]" % (
                        result.status_code, str(result.text)))
        except Exception as e:
            raise e
        finally:
            self.global_headers["region"] = tmp_region_id

        return json.loads(result.text)["flavors"]

    def get_flavor_info_by_name(self, flavor_name):
        """
        get_flavor_info_by_name
        :param flavor_name:
        :return:
        """
        logger.info(
            "start get flavor info by flavor name, name is %s" % flavor_name)
        for flavor in self.get_all_falvor_info():
            logger.info("check flavor... [%s]" % flavor["name"])
            if flavor_name == flavor["name"]:
                logger.info("find the flavor, id=%s" % flavor["id"])
                return flavor
        logger.error("can not find the flavor, get flavor info failed.")
        raise Exception(
            "Failed to get flavor info, flavor name is %s" % flavor_name)

    def get_vpc_info_by_name(self, vpc_name):
        """
        get_vpc_info_by_name
        :param vpc_name:
        :return:
        """
        logger.info("start get vpc info by vpc name, name is %s" % vpc_name)
        url = "https://%s/vpc/rest/v1/%s/vpcs?regionId=%s" % (
            self.console_host, self.project_id, self.region_id)
        result = self.session.get(url=url, headers=self.global_headers,
                                  verify=False)
        if result.status_code != 200:
            raise Exception(
                "Failed to get vpc info, status code[%s], response[%s]" % (
                    result.status_code, str(result.text)))
        for vpc in json.loads(result.text)["vpcs"]:
            logger.info("check vpc... [%s]" % vpc["name"])
            if vpc_name == vpc["name"]:
                logger.info("find the vpc. id=%s" % vpc["id"])
                return vpc
        logger.error("can not find the vpc, get vpc info failed.")
        return None

    def create_vpc(self, region_type=None):
        """
        在指定的Region创建VPC
        :param region_type:
        :return:
        """
        if region_type is None:
            region_type = self.current_region_type
        logger.info("start apply vpc, vpc name is %s, region type is %s" % (
            self.vpc_name, region_type))

        current_vpc_id = self.get_vpc_info_by_name(self.vpc_name)
        if current_vpc_id is not None:
            logger.info(
                "vpc already exists, no need create, vpc id=%s" % current_vpc_id)
            return True

        product_id = self.get_product_id_by_service_type("vpc")
        display = {
            "en_US": [
                {"label": "Region", "value": self.region_id, "type": "string"},
                {"label": "VPC Name", "value": self.vpc_name, "type": "string"},
                {"label": "External Network", "value": "", "type": "string"}],
            "zh_CN": [
                {"label": "Region", "value": self.region_id, "type": "string"},
                {"label": "VPC Name", "value": self.vpc_name, "type": "string"},
                {"label": "External Network", "value": "", "type": "string"}]
        }
        if region_type != "type3":
            params = {"regionId": self.region_id, "tenant_id": self.project_id,
                      "vpc": {"name": self.vpc_name, "external_gateway_info": {
                          "network_id": self.get_external_network()["id"]}},
                      "subnet": {"regionId": self.region_id,
                                 "tenantId": self.project_id,
                                 "availableZoneId": "",
                                 "name": self.vpc_name, "dhcpEnable": True,
                                 "cidr": "192.168.0.0/24",
                                 "gatewayIp": "192.168.0.1",
                                 "dnsList": []}, "display": display
                      }
        else:
            params = {"regionId": self.region_id, "tenant_id": self.project_id,
                      "vpc": {"name": self.vpc_name},
                      "subnet": {"regionId": self.region_id,
                                 "tenantId": self.project_id,
                                 "availableZoneId": "",
                                 "name": self.vpc_name, "dhcpEnable": True,
                                 "cidr": "192.168.0.0/24",
                                 "gatewayIp": "192.168.0.1",
                                 "physicalNetwork": "physnet1",
                                 "segmentationId": "", "routed": False,
                                 "dnsList": []}, "display": display
                      }

        body_data = {"subscriptions": [{
            "operate_type": "apply", "product_id": product_id,
            "project_id": self.project_id,
            "region_id": self.region_id, "service_type": "vpc", "tenancy": 0,
            "params": json.dumps(params)
        }]}
        length = None
        if self.global_headers.__contains__("Content-Length"):
            length = self.global_headers["Content-Length"]
        self.global_headers.__setitem__("Content-Length", "1145")
        response = self.session.request(method="post",
                                        url="https://%s/vpc/rest/subscription/v3.0/subscriptions" % self.console_host,
                                        headers=self.global_headers,
                                        data=json.dumps(body_data),
                                        verify=False)
        if length is None:
            self.global_headers.__delitem__("Content-Length")
        else:
            self.global_headers.__setitem__("Content-Length", length)
        if response.status_code != 200:
            logger.error(
                "send apply vpc cmd failed, status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to apply vpc, status_code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        resp = json.loads(response.text)
        sub_id = resp['purchases'][0]['subscription_id']
        logger.info("send command successfully, order id=%s" % sub_id)
        self.monitor_order_status(sub_id)

    def get_external_network(self):
        """
        获取外部网络
        :return:
        """
        logger.info("start get external network.")
        url = "https://%s/vpc/rest/v2/%s/vpc_external_networks" % (
            self.console_host, self.project_id)
        result = self.session.get(url=url, headers=self.global_headers,
                                  verify=False)
        if result.status_code != 200:
            logger.error(
                "Failed to get external network, status code[%s], response[%s]" % (
                    result.status_code, str(result.text)))
            raise Exception(
                "Failed to get external network, status code[%s], response[%s]" % (
                    result.status_code, str(result.text)))
        default_net = ""
        for net in json.loads(result.text)["vpc_external_networks"]:
            logger.info("return external network , id=%s" % net["id"])
            default_net = net
            if net["name"] == "dummy_external_network":
                return net
        # if the environment doesn't have "dummy_external_netword", then return a net
        if len(json.loads(result.text)["vpc_external_networks"]) > 0:
            return default_net

        logger.error(
            "can not find the external_network, get external_network info failed.")
        raise Exception(
            "Failed to get external network, external network not exists")

    def get_subnet_info_by_name(self, subnet_name, vpc_id, region_type=None):
        """
        根据名称获取指定project下subnet
        :return:
        """
        if region_type is None:
            region_type = self.current_region_type
        logger.info(
            "start get subnet info by name, name is %s, region_type is %s" % (
                subnet_name, region_type))
        url = "https://%s/vpc/rest/v1.5/subnets?regionId=%s&vpcId=%s" % (
            self.console_host, self.region_id, vpc_id)
        if region_type == "type3":
            url = "https://%s/vpc/rest/v1.5/subnets?regionId=%s&vpcId=%s&routed=false" % (
                self.console_host, self.region_id, vpc_id)
        result = self.session.get(url=url, headers=self.global_headers,
                                  verify=False)
        if result.status_code != 200:
            raise Exception(
                "Failed to get subnet info, status code[%s], response[%s]" % (
                    result.status_code, str(result.text)))
        for subnet in json.loads(result.text)["subnets"]:
            logger.info("check subnet... [%s]" % subnet["name"])
            if subnet_name == subnet["name"]:
                logger.info("find the subnet....")
                return subnet
        logger.error("can not find the subnet, get subnet info failed.")
        return None

    def get_product_id_by_service_type(self, product_type):
        """
        :param region_name:
        :return:
        """
        logger.info("start get product id, type is %s" % product_type)
        url = "https://%s/moproductwebsite/goku/rest/product/v3.0/products?" \
              "service_type=%s&limit=8&start=1&region_id=%s&project_id=%s" \
              % (self.console_host, product_type.lower(), self.region_id,
                 self.project_id)
        ret = self.session.get(url=url, headers=self.global_headers,
                               verify=False)
        if ret.status_code != 200:
            logger.error("Failed to get product info, status code[%s], "
                         "response[%s]" % (ret.status_code, str(ret.text)))
            raise Exception("Failed to get product info, status code[%s],"
                            " response[%s]" % (ret.status_code, str(ret.text)))
        logger.info("response product info is %s" % ret.text)
        res = json.loads(ret.text)


        total = res["total"]
        product_list = res["products"]
        for n in range(0, total):
            region_id_value = product_list[n]["region_id"]
            is_need_approval = product_list[n]["approval"]
            is_online = product_list[n]["online_status"]

            # 选择不需要审批的产品
            if region_id_value == self.region_id \
                    and is_need_approval == False\
                    and is_online == "online":
                logger.info("get product id successfully, product name=%s, "
                            "id=%s" % (product_list[n]["name"],
                                       product_list[n]["product_id"]))
                return product_list[n]["product_id"]
        else:
            logger.error("%s product is not exist, product_list: %s" %
                        (product_type.lower(), product_list))
            raise Exception("%s product is not exist" % product_type.lower())

    def show_product_info(self):
        """

        :return:
        """
        # 查询已经注册的产品信息(产品列表)
        url = "https://%s/motenantconsolehomewebsite/rest/silvan/rest/v1.0/products?start=0&limit=0&region=%s" % (
            self.console_host, self.region_id)
        ret = self.session.get(url=url, headers=self.global_headers,
                               verify=False)
        if ret.status_code != 200:
            logger.error(
                "Failed to get product info, status code[%s], response[%s]" % (
                    ret.status_code, str(ret.text)))
            raise Exception(
                "Failed to get product info, status code[%s], response[%s]" % (
                    ret.status_code, str(ret.text)))
        res = json.loads(ret.text)
        return ret.status_code, res

    def get_security_group_id(self):
        """
        获取安全组ID
        :return:
        """
        logger.info("start get security group id.")
        url = "https://%s/ecm/rest/network/v1/securitygroup" % self.console_host
        result = self.session.get(url=url, headers=self.global_headers,
                                  verify=False)
        if result.status_code != 200:
            raise Exception(
                "Failed to get security, status code[%s], response[%s]" % (
                    result.status_code, str(result.text)))
        for group in json.loads(result.text)["security_groups"]:
            logger.info("find a random security, id=%s" % group["id"])
            return group["id"]
        logger.error("can not find the security group.")
        raise Exception("Failed to get security group info")

    def create_tenant(self, first_region_type=None):
        """
        创建租户
        :param first_region_type:  首Region的type类型,CSDR场景下需要传首Region类型
        :return:
        """
        try:
            self.fcu_create_tenant(self.vdc1, self.tenant_user, self.project1,
                                   first_region_type)
        except Exception as e:
            logger.error("create_tenant failed, errMsg=%s" + str(e))
            raise Exception("Failed to create tenant user.[%s]" % str(e))

    def delete_tenant(self):
        """
        删除租户
        :return:
        """
        try:
            self.fcu_delete_vdc_and_user(self.vdc1, self.tenant_user)
        except Exception as e:
            logger.error("delete_tenant failed, errMsg=%s" % str(e))
            raise Exception("Failed to delete tenant user.[%s]" % str(e))

    def create_vm(self, region_name, vm_list, region_type=None):
        """
        创建测试虚拟机
        :return:
        """
        # 默认使用当前Region type类型, 创建CSDR的生产虚拟机时需要传入首Region虚拟机的Type类型
        if region_type is None:
            region_type = self.current_region_type

        logger.info("start create vm in region[%s]" % region_name)
        self.user_id, self.project_id, self.region_id, self.bak_global_headers, self.global_headers = \
            self.login_sc_on_web(self.console_host, self.iam_host,
                                 self.tenant_user, self.tenant_user_pwd,
                                 region_name)
        self.create_vpc(region_type)
        self.create_key_pair()
        order_id_list = []
        created_vm_list = []
        for vm_info in vm_list:
            logger.info("start create vm which named %s" % vm_info["name"])
            vminfo = self.get_vm_info(vm_info["name"])
            if vminfo is not None:
                logger.info("the vm already exists, no need create it.")
                if vminfo["status"].upper() != "SHUTOFF":
                    self.operate_cloud_server(OPT_TYPE_OFF, vm_info["name"])
                continue
            body_data = self.get_create_vm_data(vm_info["az_name"],
                                                vm_info["name"],
                                                vm_info["vol_type"],
                                                region_name, region_type)
            response = self.session.request(method="post",
                                            url="https://%s/ecm/rest/subscription/v3.0/subscriptions" % self.console_host,
                                            headers=self.global_headers,
                                            data=json.dumps(body_data),
                                            verify=False)
            if response.status_code != 200:
                logger.error(
                    "send apply vm cmd failed, status_code=%s, response=%s" % (
                        response.status_code, str(response.text)))
                raise Exception(
                    "Failed to create vm, status_code[%s], response[%s]" % (
                        response.status_code, str(response.text)))

            resp = json.loads(response.text)
            sub_id = resp['purchases'][0]['subscription_id']
            logger.info("send command successfully, order id=%s" % sub_id)
            order_id_list.append(sub_id)
            created_vm_list.append(vm_info["name"])
        # 监控订单状态
        for id in order_id_list:
            self.monitor_order_status(id)

        for vm_name in created_vm_list:
            self.operate_cloud_server(OPT_TYPE_OFF, vm_name)

    def delete_vpc(self, region_type=None):
        """
        delete_vpc
        :return:
        """
        if region_type is None:
            region_type = self.current_region_type
        logger.info("start delete vpc, vpc name is %s, region type is %s" % (
            self.vpc_name, region_type))
        current_vpc = self.get_vpc_info_by_name(self.vpc_name)
        if current_vpc is None:
            logger.info("vpc not exists, no need delete")
            return True

        subnet = self.get_subnet_info_by_name(self.vpc_name, current_vpc["id"],
                                              region_type)
        if subnet is not None:
            logger.info("start delete subnet. id=%s" % subnet["id"])
            url = "https://%s/vpc/rest/v2/%s/subnets/%s?regionId=%s" % (
                self.console_host, self.project_id, subnet["id"],
                self.region_id)
            response = self.session.delete(url=url, headers=self.global_headers,
                                           verify=False)
            if response.status_code >= 400:
                logger.error(
                    "delete subnet failed. status code[%s], response[%s]" % (
                        response.status_code, str(response.text)))
                raise Exception(
                    "delete subnet failed. status code[%s], response[%s]" % (
                        response.status_code, str(response.text)))
        time.sleep(5)
        logger.info("start delete vpc. id=%s" % current_vpc["id"])
        params = {"vpcId": current_vpc["id"], "tenant_id": self.project_id,
                  "regionId": self.region_id, "display": [],
                  "ids": [{"id": current_vpc["id"], "service_type": "vpc"}]}
        send_data = {"subscriptions": [
            {"operate_type": "delete", "project_id": self.project_id,
             "region_id": self.region_id, "service_type": "vpc",
             "params": json.dumps(params)}]}
        response = self.session.request(method="post",
                                        url="https://%s/vpc/rest/subscription/v3.0/subscriptions" % self.console_host,
                                        headers=self.global_headers,
                                        data=json.dumps(send_data),
                                        verify=False)
        if response.status_code != 200:
            logger.error(
                "send delete vpc cmd failed, status_code=%s, response=%s" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "Failed to delte vpc, status_code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        resp = json.loads(response.text)
        sub_id = resp['purchases'][0]['subscription_id']
        logger.info("send command successfully, order id=%s" % sub_id)
        self.monitor_order_status(sub_id)

    def create_key_pair(self):
        """
        create_key_pair
        :return:
        """
        logger.info("start create key pair.")
        url = "https://%s/ecm/rest/v2/%s/os-keypairs" % (
            self.console_host, self.project_id)
        resp = self.session.get(url=url, headers=self.global_headers,
                                verify=False)
        if resp.status_code != 200:
            raise Exception(
                "Failed to get security, status code[%s], response[%s]" % (
                    resp.status_code, str(resp.text)))
        for pair in json.loads(resp.text)["keypairs"]:
            if pair["keypair"]["name"] == self.key_pair_name:
                logger.info("key pair already exists. no need create.")
                return True

        data = {"keypair": {
            "name": self.key_pair_name,
            "tenantId": self.project_id
        }}
        response = self.session.request(method="post", url=url,
                                        headers=self.global_headers,
                                        data=json.dumps(data))
        if response.status_code >= 400:
            logger.error(
                "create key pair failed, status code[%s], response[%s]" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "create key pair failed, status code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        logger.info("create key pair successfully.")

    def create_project(self, project_name, region_name):
        """
        在指定的region中创建project，目前CSDR上的从Region中的project需要自己创建
        :return:
        """
        logger.info(
            "start create project in region [%s], project name is %s" % (
                region_name, project_name))
        user_id, project_id, region_id, bak_global_headers, global_headers = \
            self.login_sc_on_web(self.console_host, self.iam_host,
                                 self.tenant_user, self.tenant_user_pwd,
                                 region_name)

        url = "https://%s/movdcwebsite/goku/rest/vdc/v3.1/projects" % self.console_host
        data = {"description": "FCU test project", "name": project_name,
                "quotas": [],
                "tenant_id": project_id, "regions": [{"region_id": region_id}]}
        response = self.session.request(method="post", url=url,
                                        headers=global_headers,
                                        data=json.dumps(data), verify=False)
        if response.status_code >= 400:
            logger.error(
                "create project failed, status code[%s], response[%s]" % (
                    response.status_code, str(response.text)))
            raise Exception(
                "create project failed, status code[%s], response[%s]" % (
                    response.status_code, str(response.text)))

        logger.info("create project successfully.")

    def delete_vm(self, region_name, vm_list):
        """
        删除测试虚拟机
        :return:
        """
        logger.info("start delete vm in region[%s], vm list[%s]" % (
            region_name, vm_list))
        self.user_id, self.project_id, self.region_id, self.bak_global_headers, \
        self.global_headers = self.login_sc_on_web(self.console_host,
                                                   self.iam_host,
                                                   self.tenant_user,
                                                   self.tenant_user_pwd,
                                                   region_name)
        order_list = []
        for vm_info in vm_list:
            logger.info("start delete vm which named %s" % vm_info["name"])
            vminfo = self.get_vm_info(vm_info["name"])
            if vminfo is None:
                continue

            params = {"count": 1, "display": [], "ids": [{"id": vminfo["id"]}],
                      "delete_publicip": True,
                      "delete_volume": True, "delete_snapshot": True}
            send_data = {"subscriptions": [
                {"operate_type": "delete", "project_id": self.project_id,
                 "region_id": self.region_id, "service_type": "ecs",
                 "secret_params": "",
                 "params": json.dumps(params)}]}
            response = self.session.request(method="post",
                                            url="https://%s/ecm/rest/subscription/v3.0/subscriptions" % self.console_host,
                                            headers=self.global_headers,
                                            data=json.dumps(send_data),
                                            verify=False)
            if response.status_code != 200:
                logger.error(
                    "send delete vm cmd failed, status_code=%s, response=%s" % (
                        response.status_code, str(response.text)))
                raise Exception(
                    "Failed to delte vm, status_code[%s], response[%s]" % (
                        response.status_code, str(response.text)))

            resp = json.loads(response.text)
            sub_id = resp['purchases'][0]['subscription_id']
            logger.info("send command successfully, order id=%s" % sub_id)
            order_list.append(sub_id)

        for id in order_list:
            self.monitor_order_status(id)

    def get_region_info(self):
        url = "https://%s/motenantconsolehomewebsite/rest/silvan/rest/v1.0/regions?start=0&limit=0" % self.console_host
        response = self.session.get(url=url, headers=self.global_headers,
                                    verify=False)
        if response.status_code != 200:
            logger.error(
                "Failed to query region info, status code=%s, resp[%s]" % (
                    response.status_code, response.text))
            raise Exception(
                "Failed to query order detail info, status code: %s, response: %s" % (
                    response.status_code, response.text))
        return json.loads(response.text)["regions"]

    def filter_image(self):
        """
        匹配出主备端合适的镜像，只有CSDR场景下能调用
        :return:
        """
        region_list = self.get_region_info()
        primary_region_id = None
        standby_region_id = None
        for region in region_list:
            if region["name"] == self.primary_region_name:
                primary_region_id = region["id"]
            elif region["name"] == self.standby_region_name:
                standby_region_id = region["id"]
        if primary_region_id is None or standby_region_id is None:
            raise Exception(
                "Failed to get primary and standby region info. [%s]" % str(
                    region_list))

        primary_image_list = self.get_all_image_info(primary_region_id)
        standby_image_list = self.get_all_image_info(standby_region_id)
        logger.info("primary image list: %s" % str(primary_image_list))
        logger.info("standby image list: %s" % str(standby_image_list))
        filter_list = []
        # 先将磁盘总线类型匹配的进行归类
        for p_image in primary_image_list:
            s_list = []
            for s_image in standby_image_list:
                if "hw_disk_bus" not in list(p_image.keys()) \
                        or "hw_disk_bus" not in list(s_image.keys()):
                    continue
                if p_image["hw_disk_bus"] != s_image["hw_disk_bus"]:
                    continue
                s_list.append(s_image)
            if len(s_list) != 0:
                filter_list.append(
                    {"id": p_image["id"], "min_ram": int(p_image["min_ram"]),
                     "min_disk": int(p_image["min_disk"]), "name": p_image["name"],
                     "s_image_list": s_list})
        if len(filter_list) == 0:
            raise Exception("Unable to find matching image.")

        primary_image = filter_list[0]
        min_disk = filter_list[0]["min_disk"]
        for image in filter_list:
            if "min_ram" not in list(image.keys()):
                continue
            if image["min_disk"] < min_disk:
                min_disk = image["min_disk"]
                primary_image = image

        # 再在从Region中找出一个最小规格的image与主配套
        standby_image = primary_image["s_image_list"][0]
        min_disk = int(standby_image["min_disk"])
        for s_image in primary_image["s_image_list"]:
            if "min_ram" not in list(s_image.keys()):
                continue
            if int(s_image["min_disk"]) < min_disk:
                min_disk = int(s_image["min_disk"])
                standby_image = s_image

        logger.info("the primary image is %s, standby image is %s" % (
            primary_image["name"], standby_image["name"]))
        return primary_image, standby_image

    def filter_flavor(self, image_info):
        """
        过滤出满足要求的规格,只用于CSDR场景
        :param min_disk: 镜像最小磁盘
        :param min_raw: 镜像最小内存
        :return:
        """
        region_list = self.get_region_info()
        primary_region_id = None
        standby_region_id = None
        for region in region_list:
            if region["name"] == self.primary_region_name:
                primary_region_id = region["id"]
            elif region["name"] == self.standby_region_name:
                standby_region_id = region["id"]
        if primary_region_id is None or standby_region_id is None:
            raise Exception(
                "Failed to get primary and standby region info. [%s]" % str(
                    region_list))

        primary_flavor_list = self.get_all_falvor_info(primary_region_id)
        standby_flavor_list = self.get_all_falvor_info(standby_region_id)
        logger.info("primary flavor list: %s" % str(primary_flavor_list))
        logger.info("standby flavor list: %s" % str(standby_flavor_list))

        if len(primary_flavor_list) == 0 or len(standby_flavor_list) == 0:
            logger.error("Unable to find matching flavors.")
            raise Exception("Unable to find matching flavors.")

        primary_flavor = primary_flavor_list[0]
        min_size = primary_flavor_list[0]["disk"]
        for flavor in primary_flavor_list:
            # 从首region规格列表里，选取不支持本地磁盘的规格，
            # 因为type1不支持本地磁盘，并且过滤内存不符合镜像文件要求的规格
            if int(flavor["disk"]) <= int(min_size) and flavor["os_extra_specs"][
                "huawei:extBootType"] != "LocalDisk" \
                    and int(flavor["ram"]) >= int(image_info["min_ram"]):
                min_size = int(flavor["disk"])
                primary_flavor = flavor

        standby_flavor = standby_flavor_list[0]
        min_size = standby_flavor_list[0]["disk"]
        for flavor in standby_flavor_list:
            # 从备region规格列表里，选取不支持本地磁盘的规格，
            # 因为type1不支持本地磁盘，并且过滤内存不符合镜像文件要求的规格
            if int(flavor["disk"]) <= int(min_size) and flavor["os_extra_specs"][
                "huawei:extBootType"] != "LocalDisk" \
                    and int(flavor["ram"]) >= int(image_info["min_ram"]):
                min_size = int(flavor["disk"])
                standby_flavor = flavor

        logger.info("the primary flavor is %s, standby flavor is %s" % (
            primary_flavor["name"], standby_flavor["name"]))
        return primary_flavor, standby_flavor

    def get_create_vm_data(self, az_name, vm_name, vol_type, region_name,
                           region_type=None):
        if region_type is None:
            region_type = self.current_region_type
        az_id = self.get_az_id_by_name(az_name)
        vpc_info = self.get_vpc_info_by_name(self.vpc_name)
        system_volume_size = 30
        if vpc_info is None:
            raise Exception(
                "Failed to get vpc info by name, the name is %s" % self.vpc_name)
        subnet_id = self.get_subnet_info_by_name(self.vpc_name, vpc_info["id"],
                                                 region_type)["id"]
        if subnet_id is None:
            raise Exception(
                "Failed to get subnet info, name is %s" % self.vpc_name)
        if self.service_type.upper() == CSDR_SERVICE_TYPE.upper():
            if region_name == self.primary_region_name:
                image_id = self.get_image_info_by_name(self.image_name)["id"]
                flavor_id = self.get_flavor_info_by_name(self.flavor_name+"_csdr")["id"]
            else:
                image_id = self.get_image_info_by_name(self.image_name)["id"]
                flavor_id = self.get_flavor_info_by_name(self.flavor_name)["id"]
        else:
            image_id = self.get_image_info_by_name(self.image_name)["id"]
            flavor_id = self.get_flavor_info_by_name(self.flavor_name)["id"]
        security_group_id = self.get_security_group_id()
        product_id = self.get_product_id_by_service_type("ecs")
        nics = [{"subnet_id": subnet_id, "ip_address": "", "ip_address_v6": "",
                 "nictype": "", "physical_network": "", "extra_dhcp_opts": [],
                 "binding:profile": {"disable_security_groups": False,
                                     "availability_zone": az_id}}]

        params = {"tenantId": self.project_id, "availability_zone": az_id,
                  "name": vm_name, "imageRef": image_id, "flavorRef": flavor_id,
                  "root_volume": {"volumetype": vol_type, "size": system_volume_size,
                                  "extendparam": {"resourceSpecCode": "",
                                                  "resourceType": ""}},
                  "data_volumes": [],
                  "vpcid": vpc_info["id"],
                  "nics": nics, "security_groups": [{"id": security_group_id}],
                  "personality": [], "count": 1,
                  "extendparam": {"chargingMode": 0,
                                  "regionID": self.region_id},
                  "metadata": {
                      "op_svc_userid": self.global_headers["AgencyId"],
                      "__instance_vwatchdog": "false",
                      "_ha_policy_type": "remote_rebuild"
                  },
                  "tags": ["__single_storage"],
                  "display": [],
                  "extra": {"devices": [{"device_type": "csrom"}]}
                  }

        rate_params = [{
            "params": [{
                "region_id": self.region_id,
                "az_id": az_id,
                "cloud_service_type_code": "hws.service.type.ebs",
                "resource_type_code": "hws.resource.type.volume",
                "extend_params": 0
            }],
            "unit": {
                "zh_CN": "小时",
                "en_US": "Hour"
            },
            "price": 0.00
        }]
        secret_params = {"metadata": {}, "key_name": self.key_pair_name}
        send_data = {"subscriptions": [
            {"operate_type": "apply", "project_id": self.project_id,
             "product_id": product_id,
             "region_id": self.region_id, "service_type": "ecs", "tenancy": "0",
             "params": json.dumps(params),
             "rate_params": json.dumps(rate_params),
             "time_zone": "GMT+08:00",
             "secret_params": json.dumps(secret_params)}]}
        logger.info("create_vm_send_data is " % send_data)
        return send_data

    def monitor_order_status(self, order_id):
        """
        监控申请与删除订单的状态
        :param order_id:
        :return:
        """
        logger.info("start monitor order status, order_id: %s" % order_id)
        url = "https://%s/motenantconsolehomewebsite/goku/rest/order/v3.0/orders/%s" % (
            self.console_host, order_id)
        # 申请服务实例时必须设置该headers, 但检查状态必须删除该headers
        if self.global_headers.__contains__("Content-Length"):
            self.global_headers.__delitem__("Content-Length")
        retry_times = 0
        while True:
            response = self.session.get(url=url, headers=self.global_headers,
                                        verify=False)
            if response.status_code != 200:
                # 如果请求失败, 连续重试6次
                logger.error(
                    "query sub status failed, times[%s], retry after 10s, id[%s], status_code=[%s], resp=[%s]"
                    % (
                        retry_times, order_id, response.status_code,
                        response.text))
                if retry_times == 5:
                    logger.error("retry times out.")
                    raise Exception(
                        "Failed to get order status information, order id[%s], status code[%s], "
                        "response[%s]" % (
                            order_id, response.status_code, response.text))
                time.sleep(5)
                retry_times = retry_times + 1
                continue
            logger.info("monitor order response text is %s" % response.text)
            resp = json.loads(response.text)
            if resp['status'] == "successed":
                logger.info(
                    "the order status is successed. operation successfylly.")
                return True
            if resp['status'] == "failed":
                detail = self.query_order_detail(order_id)
                logger.error(
                    "the order status is failed, defailt_info=%s" % detail)
                raise Exception(
                    "Failed to get order status information. order id[%s], detail[%s]" % (
                        order_id, detail))
            logger.info(
                "order status is %s, retry check after 20s" % resp['status'])
            time.sleep(20)

    def query_order_detail(self, order_id):
        """
        查询订单资源详情信息
        :return:
        """
        try:
            url = "https://%s/motenantconsolehomewebsite/goku/rest/order/v3.0/orders/%s/resources" \
                  % (self.console_host, order_id)
            response = self.session.get(url=url, headers=self.global_headers,
                                        verify=False)
            if response.status_code != 200:
                logger.error(
                    "query failed information failed, status_code=%s, resp[%s]" % (
                        response.status_code, response.text))
                raise Exception(
                    "Failed to query order detail info, status code: %s, response: %s" % (
                        response.status_code, response.text))
            resp = json.loads(response.text)
            return str(resp[0]['message'])
        except Exception as e:
            logger.error("query order detail failed, errMsg=%s" % str(e))
        return ""

    def get_vm_info(self, vm_name):
        """
        根据虚拟机名称获取虚拟机信息
        :param vm_name:
        :return:
        """
        try:
            logger.info("start get vm info, vm_name=%s" % vm_name)
            url = "https://{console_url}/ecm/rest/v1.0/servers?limit=10&offset=1&not-tags=__type_baremetal&detail=3".format(
                console_url=self.console_host)
            res = self.session.get(url=url, headers=self.global_headers,
                                   verify=False)
            if res.status_code != 200:
                logger.error(
                    "failed to get vm list, status_code=%s, content=%s" % (
                        res.status_code, res.text))
                raise Exception(
                    "Query vm info by name failed, vm name is %s, status_code[%s], response[%s]"
                    % (vm_name, res.status_code, res.text))
            service_list_info = json.loads(res.text)
            logger.info("get all vm info successfully")
        except Exception as e:
            logger.error("failed to get vm list, errMsg=%s" % str(e))
            raise Exception("Failed to get vm info, errMsg=%s" % str(e))
        for server_info in service_list_info["servers"]:
            if server_info["name"] == vm_name:
                logger.info(
                    "get vm info successfully, vm name is %s, id is %s" % (
                        vm_name, server_info["id"]))
                return server_info

        logger.error("can not find the vm, vm name is [%s]" % vm_name)
        return None

    def operate_cloud_server(self, opt_type, vm_name):
        """
        对指定的云服务器上电或下电
        :return:
        """
        opt_url = "https://%s/ecm/rest/v1/%s/cloudservers/action" % (
            self.console_host, self.project_id)
        logger.info(" %s cloud server is start, vm name is %s, url is %s" % (
            opt_type, vm_name, opt_url))
        vm_state = self.get_vm_info(vm_name)
        vm_id = vm_state['id']
        if opt_type == OPT_TYPE_OFF:
            if vm_state['status'] == "SHUTOFF":
                logger.info(
                    "the server status is already SHUTOFF, no need stop again.")
                return True
            opt_body = {"os-stop": {"type": "HARD", "servers": [{"id": vm_id}]}}
        elif opt_type == OPT_TYPE_ON:
            if vm_state['status'] == "ACTIVE":
                logger.info(
                    "the server status is already ACTIVE, no need start again.")
                return True
            opt_body = {"os-start": {"servers": [{"id": vm_id}]}}
        else:
            raise Exception(
                "Failed to operate cloud server, operation type is error[%s]" % opt_type)

        response = self.session.request(method="post", url=opt_url,
                                        headers=self.global_headers,
                                        data=json.dumps(opt_body))
        if response.status_code != 200:
            logger.error(
                "send %s cloud server cmd failed, status_code=%s, response=%s" % (
                    opt_type, response.status_code, str(response.text)))
            raise Exception(
                "Failed to %s cloud server, status_code[%s], response[%s]" % (
                    opt_type, response.status_code, str(response.text)))
        logger.info(
            "send %s cloud server cmd successfully. start check server status after 10s" % opt_type)
        while True:
            time.sleep(10)
            vmInfo = self.get_vm_info(vm_name)
            if opt_type == OPT_TYPE_OFF:
                if vmInfo['status'] == "SHUTOFF":
                    logger.info("%s cloud server successfully." % opt_type)
                    return True
                if vmInfo['OS-EXT-STS:task_state'] == "powering-off":
                    logger.info(
                        "the cloud server is powering-off, retry check after 10s")
                    continue
                logger.error("%s cloud server failed., vm status is %s, "
                             "task_state is %s"
                             % (opt_type, vmInfo['status'],
                                vmInfo['OS-EXT-STS:task_state']))
                raise Exception("Failed to %s cloud server, server status "
                                "is %s, task state is %s"
                                % (opt_type, vmInfo['status'],
                                   vmInfo['OS-EXT-STS:task_state']))
            if opt_type == OPT_TYPE_ON:
                if vmInfo['status'] == "ACTIVE":
                    logger.info("%s cloud server successfully." % opt_type)
                    return True
                if vmInfo['OS-EXT-STS:task_state'] == "powering-on":
                    logger.info(
                        "the cloud server is powering-on, retry check after 10s")
                    continue
                logger.error(
                    "%s cloud server failed., vm status is %s, task_state is %s" % (
                        opt_type, vmInfo['status'],
                        vmInfo['OS-EXT-STS:task_state']))
                raise Exception(
                    "Failed to %s cloud server, server status is %s, task state is %s" % (
                        opt_type, vmInfo['status'],
                        vmInfo['OS-EXT-STS:task_state']))

    def get_all_service(self, region_id):
        # 管理员获取某个region下的所有云服务,返回的是控制台底下的所有云服务
        try:
            url = "https://{host}/{access_url}/rest/silvan/rest/v1.0/endpoints?start=0&limit=0&region={region_id}".format(
                host=self.parmas_dict[MANAGE_CONSOLE_HOST],
                access_url=self.access_url, region_id=region_id)
            resp = requests.get(url, verify=False, allow_redirects=False,
                                headers=self.bak_global_headers)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                endpoints = response_body.get("endpoints")
                service_list = []
                for product in endpoints:
                    service_id = product["id"]
                    service_list.append(service_id)
                return service_list
            else:
                raise Exception(
                    "get cloud service list failed! response is %s" % response_body)
        except Exception as e:
            raise e

    def dict_quotas(self, region_id):
        # 构建创建VDC的配额参数,目前缺少ADS服务配额信息
        try:
            service_list = self.get_all_service(region_id)
            vpn_dict = {"resource": "vpn", "local_limit": -1, "other_limit": -1}
            publicIp_dict = {"resource": "publicIp", "local_limit": -1,
                             "other_limit": -1}
            firewall_dict = {"resource": "firewall", "local_limit": -1,
                             "other_limit": -1}
            loadbalancer_dict = {"resource": "loadbalancer", "local_limit": -1,
                                 "other_limit": -1}
            vpc_inner_dict = {"resource": "vpc", "local_limit": -1,
                              "other_limit": -1}
            vpc_list = []
            vpc_list.append(vpc_inner_dict)
            if 'eip' in service_list:
                vpc_list.append(publicIp_dict)
            if 'vfw' in service_list:
                vpc_list.append(firewall_dict)
            if 'elb' in service_list:
                vpc_list.append(loadbalancer_dict)
            if 'vpn' in service_list:
                vpc_list.append(vpn_dict)
            vpc_quatos = {"service_id": "vpc", "resources": vpc_list}
            ims_dict = {"service_id": "ims", "resources": [
                {"resource": "image", "local_limit": -1, "other_limit": -1}]}
            vbs_dict = {"service_id": "vbs",
                        "resources": [{"resource": "volume_backup_capacity",
                                       "local_limit": -1, "other_limit": -1},
                                      {"resource": "volume_copy_capacity",
                                       "local_limit": -1, "other_limit": -1}]}
            csbs_dict = {"service_id": "csbs",
                         "resources": [
                             {"resource": "backup_capacity", "local_limit": -1,
                              "other_limit": -1},
                             {"resource": "copy_capacity", "local_limit": -1,
                              "other_limit": -1}]}
            csha_dict = {"service_id": "csha",
                         "resources": [
                             {"resource": "csha.vol.num", "local_limit": -1,
                              "other_limit": -1},
                             {"resource": "csha.vol.size", "local_limit": -1,
                              "other_limit": -1},
                             {"resource": "csha.instance.num",
                              "local_limit": -1, "other_limit": -1}]}
            csdr_dict = {"service_id": "csdr",
                         "resources": [
                             {"resource": "csdr.vol.num", "local_limit": -1,
                              "other_limit": -1},
                             {"resource": "csdr.vol.size", "local_limit": -1,
                              "other_limit": -1},
                             {"resource": "csdr.instance.num",
                              "local_limit": -1, "other_limit": -1}]}
            vha_dict = {"service_id": "vha",
                        "resources": [
                            {"resource": "vha.vol.num", "local_limit": -1,
                             "other_limit": -1},
                            {"resource": "vha.vol.size", "local_limit": -1,
                             "other_limit": -1},
                            {"resource": "vha.instance.num", "local_limit": -1,
                             "other_limit": -1}]}
            obs_dict = {"service_id": "obs",
                        "resources": [
                            {"resource": "storageQuota", "local_limit": 100,
                             "other_limit": 0}]}
            ars_dict = {"service_id": "ars", "resources": [
                {"resource": "total", "local_limit": -1, "other_limit": -1}]}
            dbss_dict = {"service_id": "dbss",
                         "resources": [
                             {"resource": "instance", "local_limit": -1,
                              "other_limit": -1},
                             {"resource": "proxy", "local_limit": -1,
                              "other_limit": -1}]}
            rds_dict = {"service_id": "rds",
                        "resources": [
                            {"resource": "instance_num", "local_limit": -1,
                             "other_limit": -1}]}
            ods_dict = {"service_id": "ods", "resources": [
                {"resource": "pdb", "local_limit": -1, "other_limit": -1}]}
            hds_dict = {"service_id": "hds",
                        "resources": [
                            {"resource": "yarn.cpu.private", "local_limit": -1,
                             "other_limit": -1},
                            {"resource": "yarn.mem.private", "local_limit": -1,
                             "other_limit": -1},
                            {"resource": "yarn.cpu.share", "local_limit": -1,
                             "other_limit": -1},
                            {"resource": "yarn.mem.share", "local_limit": -1,
                             "other_limit": -1},
                            {"resource": "hdfs.capacity", "local_limit": -1,
                             "other_limit": -1}]}
            service_dict_dict = {"ims": ims_dict, "vbs": vbs_dict,
                                 "csbs": csbs_dict, "csha": csha_dict,
                                 "csdr": csdr_dict, "vha": vha_dict,
                                 "obs": obs_dict,
                                 "dbss": dbss_dict, "rds": rds_dict,
                                 "ods": ods_dict, "hds": hds_dict}
            cloud_infra_quotas_list = []
            cloud_infra_quotas_list.append(vpc_quatos)
            for key in service_dict_dict:
                if key in service_list:
                    cloud_infra_quotas_list.append(service_dict_dict[key])
            logger.info(cloud_infra_quotas_list)
            ecs_dict = {"service_id": "ecs", "resources": [
                {"resource": "cores", "local_limit": -1, "other_limit": -1},
                {"resource": "ram", "local_limit": -1, "other_limit": -1},
                {"resource": "gpu_instances", "local_limit": -1,
                 "other_limit": -1},
                {"resource": "instances", "local_limit": -1,
                 "other_limit": -1}, {
                    "resource": "instance_snapshot",
                    "local_limit": -1,
                    "other_limit": -1
                }]}
            evs_dict = {"service_id": "evs",
                        "resources": [
                            {"resource": "gigabytes", "local_limit": -1,
                             "other_limit": -1},
                            {"resource": "volumes", "local_limit": -1,
                             "other_limit": -1}]}
            bms_dict = {"service_id": "bms", "resources": [
                {"resource": "cores", "local_limit": -1, "other_limit": -1},
                {"resource": "ram", "local_limit": -1, "other_limit": -1},
                {"resource": "instances", "local_limit": -1,
                 "other_limit": -1}]}
            az_dict_list = []
            if 'ecs' in service_list:
                az_dict_list.append(ecs_dict)
            if 'evs' in service_list:
                az_dict_list.append(evs_dict)
            if 'bms' in service_list:
                az_dict_list.append(bms_dict)
            logger.info(az_dict_list)
            return cloud_infra_quotas_list, az_dict_list
        except Exception as e:
            raise e

    def region_quatos_dict(self, vdc_name, project_name, region_name="ALL",
                           az_name="ALL"):
        # 组装region配额，若region_name传入ALL，则组装所有region的配额，传入单个region，则组装单个region的配额
        # az_name传入ALL，则组装所有az的配额，传入单个az，则组装单个az的配额
        logger.info(
            "start get quotas data info. vdc name: %s, project_name: %s" % (
                vdc_name, project_name))
        try:
            # 获取cloudinfra信息
            cloud_infras_info = self.get_cloud_infra_and_regionid_by_regionname(
                self.parmas_dict[MANAGE_CONSOLE_HOST], region_name)
            regions_quato_list = []
            for cloud_infras_index in cloud_infras_info:
                region_id = cloud_infras_index[0]
                infra_id = cloud_infras_index[1]
                region_dict = self.dict_quotas(region_id)
                az_quotas = region_dict[1]
                cloud_infra_quotas = region_dict[0]
                # 获取可用分区Id
                az_ids = self.get_available_zoneid(region_id, infra_id, az_name)
                az_quotas_list = []
                for az_id in az_ids:
                    az_quotas_list.append({"az_id": az_id, "quotas": az_quotas})
                cloud_infras_quatos = [{"cloud_infra_id": "{}".format(infra_id),
                                        "quotas": cloud_infra_quotas,
                                        "available_zones": az_quotas_list}]
                region_quato = {"region_id": "{}".format(region_id),
                                "action": "bind",
                                "cloud_infras": cloud_infras_quatos}
                regions_quato_list.append(region_quato)
            vdc_param = {
                "vdc": {"upper_vdc_id": "0", "regions": regions_quato_list,
                        "name": "{}".format(vdc_name),
                        "description": "",
                        "default_project": "1",
                        "default_project_name": "{}".format(project_name),
                        "mfa_status": False,
                        "all_quotas": "1"}}
            vdc_param = json.dumps(vdc_param)
            return vdc_param
        except Exception as e:
            raise e

    def get_available_zoneid(self, region_id, cloud_infra_id, az_name='ALL'):
        # 管理员获取一个region下的所有可用分区，可根据名称az_name筛选返回,返回值可为list，可为string
        try:
            url = "https://{host}/{access_url}/goku/rest/serviceaccess/v3.0/available-zones?region_id={region_id}&cloud_infra_id={cloud_infra_id}".format(
                host=self.parmas_dict[MANAGE_CONSOLE_HOST],
                access_url=self.access_url, region_id=region_id,
                cloud_infra_id=cloud_infra_id)
            resp = requests.get(url, verify=False, allow_redirects=False,
                                headers=self.bak_global_headers)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                records = response_body.get("records")
                az_id_list = []
                for az_info in records:
                    if az_name != "ALL":
                        if az_name == az_info["name"]:
                            az_id_list.append(az_info["az_id"])
                            return az_id_list
                    elif az_name == 'ALL':
                        az_id = az_info["az_id"]
                        az_id_list.append(az_id)
                return az_id_list
            else:
                raise Exception("get available zone id failed! response is %s"
                                % response_body)
        except Exception as e:
            raise e

    def search_vdc_by_name(self, vdc_name):
        # 根据VDC名称查询VDC
        try:
            url = "https://{host}/moserviceaccesswebsite/goku/rest/vdc/v3.0/vdcs?start=0&limit=10&name={vdc_name}&upper_vdc_id=0&sort_key=create_at&sort_dir=desc".format(
                host=self.parmas_dict[MANAGE_CONSOLE_HOST], vdc_name=vdc_name)
            resp = requests.get(url, verify=False, allow_redirects=False,
                                headers=self.global_headers)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                vdcs = response_body.get("vdcs")
                for vdc in vdcs:
                    VdcName = vdc["name"]
                    if VdcName == vdc_name:
                        return vdc["id"]
                else:
                    return None
            else:
                raise Exception(
                    "get vdc id by name failed! response is %s" % response_body)
        except Exception as e:
            raise e

    def create_vdc(self, vdc_param, vdc_name):
        """
        创建vdc
        :param vdc_param:
        :param vdc_name:
        :return:
        """
        # 创建VDC,先查询VDC是否存在，不存在则创建
        logger.info("start create vdc, vdc is %s" % vdc_name)
        vdcexist = self.search_vdc_by_name(vdc_name)
        if vdcexist == None:
            try:
                url = "https://{host}/moserviceaccesswebsite/goku/rest/vdc/v3.1/vdcs".format(
                    host=self.parmas_dict[MANAGE_CONSOLE_HOST])
                resp = requests.post(url, data=vdc_param, verify=False,
                                     headers=self.global_headers)
                statu_code = resp.status_code
                response_body = json.loads(resp.content)
                if statu_code == 201:
                    vdc = response_body.get("vdc")
                    return vdc["id"]
                else:
                    raise Exception(
                        "create vdc failed! response is %s" % response_body)
            except Exception as e:
                raise e
        else:
            return vdcexist

    def distribute_external_networks(self, tenant_id, cloud_infra_id):
        # 管理侧分配外部网络,若已分配后再次分配，会返回400，代码里已做校验
        logger.info("start distribute external networks. cloud infra id is %s"
                    % cloud_infra_id)
        net_list = []
        try:
            url = "https://{host}/moserviceaccesswebsite/goku/rest/serviceaccess/v3.0/external-networks?cloud_infra_id={cloud_infra_id}".format(
                host=self.parmas_dict[MANAGE_CONSOLE_HOST],
                cloud_infra_id=cloud_infra_id)
            resp = requests.get(url, verify=False, allow_redirects=False,
                                headers=self.global_headers)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                external_networks = response_body.get("external_networks")
                for external_network in external_networks:
                    net_list.append({"name": external_network["name"],
                                     "id": external_network["id"]})
                logger.info("get external network list: %s" % str(net_list))
            else:
                raise Exception("get external networks id failed! status code "
                                "is %s, response is %s"
                                % (statu_code, str(response_body)))
        except Exception as e:
            logger.error(
                "distribute external network failed, errMsg=%s" % str(e))
            raise e

        for net_info in net_list:
            try:
                time.sleep(5)
                url = "https://{host}/moserviceaccesswebsite/goku/rest/vdc/v3.0/vdcs/external-networks/{network_id}".format(
                    host=self.parmas_dict[MANAGE_CONSOLE_HOST],
                    network_id=net_info["id"])
                request_body = {"resource_id": "{}".format(tenant_id),
                                "cloudInfraId": "{}".format(cloud_infra_id),
                                "associateAction": True,
                                "networkName": "{}".format(net_info["name"])}
                request_body = json.dumps(request_body)
                resp = requests.put(url, data=request_body, verify=False,
                                    allow_redirects=False,
                                    headers=self.global_headers)
                statu_code = resp.status_code
                if statu_code == 400:
                    response_body = json.loads(resp.content)
                    if response_body["exceptionId"] != "movdc-01945":
                        raise Exception(
                            "distribute external networks failed! response is %s" % response_body)
                    continue
                if statu_code != 204 and statu_code != 200:
                    raise Exception(
                        "distribute external networks failed! status code is %s" % (
                            statu_code))
            except Exception as e:
                logger.error("distribute network failed. errMsg=%s" % str(e))
                raise e

    def delete_vdc_user(self, tenantid, user_name):
        logger.info("start delete vdc user.")
        # 管理侧删除VDC下的用户，先查询，存在则删除
        vdcuser_exist = self.search_vdcuser_by_name(tenantid, user_name)
        if vdcuser_exist != None:
            try:
                url = "https://{host}/moserviceaccesswebsite/goku/rest/vdc/v3.0/users/{user_id}".format(
                    host=self.parmas_dict[MANAGE_CONSOLE_HOST],
                    user_id=vdcuser_exist)
                resp = requests.delete(url, data=None, verify=False,
                                       allow_redirects=False,
                                       headers=self.global_headers)
                statu_code = resp.status_code
                if statu_code != 200:
                    raise Exception(
                        "delete vdc user fail,statu_code is %s ,expect 200,response is %s" % (
                            statu_code, resp.content))
            except Exception as e:
                raise e

    def delete_vdc_tenant(self, vdc_name):
        logger.info("start delete vdc tenant. vdc is %s" % vdc_name)
        # 管理侧删除VDC租户，先查询，存在则删除
        vdcexist = self.search_vdc_by_name(vdc_name)
        if vdcexist != None:
            logger.info("find vdc tenant, start delete.")
            url = "https://{host}/moserviceaccesswebsite/goku/rest/vdc/v3.0/vdcs/{vdc_id}".format(
                host=self.parmas_dict[MANAGE_CONSOLE_HOST], vdc_id=vdcexist)
            resp = requests.delete(url, data=None, verify=False,
                                   allow_redirects=False,
                                   headers=self.global_headers)
            statu_code = resp.status_code
            if statu_code != 204 and statu_code != 200:
                logger.info(
                    "delete vdc tenant failed, response: %s" % resp.content)
                return resp.content
            return True

    def fcu_delete_vdc_and_user(self, vdc_name, user_name):
        # 管理侧删除VDC租户，先查询，存在则删除
        # sys_admin_user:系统管理员
        # vdc_name：租户名称
        # user_name：租户管理员名称
        try:
            # 管理员登录SC
            # 默认的登录Region，默认登录首Region删除,与创建的保持一致
            self.login_sc_on_web(self.parmas_dict[MANAGE_CONSOLE_HOST],
                                 self.parmas_dict[MANAGE_IAM_HOST],
                                 self.parmas_dict[SC_MANAG_USER_KEY],
                                 self.parmas_dict[SC_MANAG_USER_PWD],
                                 self.parmas_dict[PRIMARY_REGION_NAME])

            vdcexist = self.search_vdc_by_name(vdc_name)
            logger.info("search vdc result: %s " % vdcexist)
            if vdcexist != None:
                self.delete_vdc_user(vdcexist, user_name)
                time.sleep(20)

                result = self.delete_vdc_tenant(vdc_name)
                if result == True:
                    logger.info("***** delete vdc and user success!*****")
                else:
                    logger.info(
                        "***** delete vdc falied,start to create vdc user *****")
                    userid = self.create_vdc_user_and_init(vdcexist, user_name,
                                                           self.parmas_dict[
                                                               SC_TENANT_USER_OLD_PWD])
                    logger.info(
                        "***** create vdc user success, userid: %s *****" % userid)
                    logger.info(
                        "***** delete vdc falied,recreate vdc user success！ *****")
                    raise Exception("delete vdc tenant falied: %s" % result)
        except Exception as e:
            raise e

    def fcu_create_tenant(self, tenant_name, tenant_user_name, project_name,
                          first_region_type):
        # 创建租户和租户管理员并修改密码
        # sys_admin_user:系统管理员
        # tenant_name：要创建的租户名称
        # tenant_user_name：租户管理员名称
        # project_name：project名称
        try:
            # 管理员登录SC
            # 默认的登录Region，默认登录首Region创建租户,与删除的保持一致
            self.login_sc_on_web(self.parmas_dict[MANAGE_CONSOLE_HOST],
                                 self.parmas_dict[MANAGE_IAM_HOST],
                                 self.parmas_dict[SC_MANAG_USER_KEY],
                                 self.parmas_dict[SC_MANAG_USER_PWD],
                                 self.parmas_dict[PRIMARY_REGION_NAME])

            # 组装配额
            quatos = self.region_quatos_dict(tenant_name, project_name)

            # 创建租户
            vdcid = self.create_vdc(quatos, tenant_name)
            time.sleep(10)

            # 分配首Region外部网络, 针对CSDR场景,
            # CSDR场景下才会有first_region_type, 该参数由用户外部输入
            if self.service_type.lower() == CSDR_SERVICE_TYPE.lower():
                if first_region_type in ["type1", "type2"]:
                    default_region_cloudinfra = self.get_cloud_infra_and_regionid_by_regionname(
                        self.parmas_dict[MANAGE_CONSOLE_HOST],
                        self.parmas_dict[PRIMARY_REGION_NAME])
                    self.distribute_external_networks(vdcid,
                                                      default_region_cloudinfra[
                                                          0][1])
                if self.current_region_type in ["type1", "type2"]:
                    second_region_cloudinfra = self.get_cloud_infra_and_regionid_by_regionname(
                        self.parmas_dict[MANAGE_CONSOLE_HOST],
                        self.parmas_dict[STANDBY_REGION_NAME])
                    self.distribute_external_networks(
                        vdcid, second_region_cloudinfra[0][1])
            elif self.current_region_type in ["type1", "type2"]:
                # CSHA和VHA场景下分配外部网络
                second_region_cloudinfra = self.get_cloud_infra_and_regionid_by_regionname(
                    self.parmas_dict[MANAGE_CONSOLE_HOST],
                    self.parmas_dict[PRIMARY_REGION_NAME])
                self.distribute_external_networks(
                    vdcid, second_region_cloudinfra[0][1])

            # 创建租户管理员
            userid = self.create_vdc_user_and_init(vdcid, tenant_user_name,
                                                   self.parmas_dict[
                                                       SC_TENANT_USER_OLD_PWD])
            return vdcid, userid
        except Exception as e:
            raise e

    def search_vdcuser_by_name(self, tenantid, user_name):
        # 根据VDC管理员名称查询vdc user id,若无此用户,返回None
        try:
            url = "https://{host}/moserviceaccesswebsite/goku/rest/vdc/v3.0/vdcs/{tenantid}/users?start=0&limit=10&level=1&name={username}".format(
                host=self.parmas_dict[MANAGE_CONSOLE_HOST], tenantid=tenantid,
                username=user_name)
            resp = requests.get(url, verify=False, allow_redirects=False,
                                headers=self.global_headers)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                users = response_body.get("users")
                for user in users:
                    name = user["name"]
                    if name == user_name:
                        user_id = user["id"]
                        return user_id
                else:
                    return None
            else:
                raise Exception(
                    "search vdc user failed! response is %s" % response_body)
        except Exception as e:
            raise e

    def change_password(self, console_host, iam_host, user_name, init_password,
                        new_password):
        # 修改密码，首次登录
        if init_password != new_password:
            try:
                url = "https://{host}/rest/mologin/v3.0/tenantAuth".format(
                    host=iam_host)
                self.global_headers.update({
                    "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8"})
                request_body1 = "userName={username}&password={password}&verifyCode=&locale=zh-cn&service=https://{console_host}/motenantconsolehomewebsite/".format(
                    username=user_name, password=init_password,
                    console_host=console_host)
                resp = requests.post(url, data=request_body1, verify=False,
                                     allow_redirects=False,
                                     headers=self.global_headers)
                statu_code = resp.status_code
                response_body = json.loads(resp.content)
                if statu_code == 200:
                    key = response_body.get("key")
                else:
                    raise Exception(
                        "before change password get key request statu_code incorrect,statu_code is %s ,expect 200" % (
                            statu_code))
                request_body2 = "userName={username}&sessionId={key}&oldPwd={password}&newPwd={new_password}&verifyCode=&locale=zh-cn&service=https://{console_host}/motenantconsolehomewebsite/".format(
                    username=user_name, key=key, password=init_password,
                    new_password=new_password,
                    console_host=console_host)
                url2 = "https://{host}/rest/mologin/v3.0/modifyPwd".format(
                    host=iam_host)
                resp = requests.post(url2, data=request_body2, verify=False,
                                     allow_redirects=False,
                                     headers=self.global_headers)
                statu_code = resp.status_code
                response_body = json.loads(resp.content)
                if statu_code != 200 or response_body == "":
                    logger.error(
                        "change password failed. status code is %s, response is %s" % (
                            statu_code, str(response_body)))
                    raise Exception(
                        "First login change password failed!Please check password modification rules")
            except Exception as e:
                raise e

    def create_vdc_user_and_init(self, tenantid, user_name, init_password):
        # 创建VDC管理员,先查询VDC user是否存在，不存在则创建
        logger.info("start create vdc user and init. user is %s" % user_name)
        vdcuser_exist = self.search_vdcuser_by_name(tenantid, user_name)
        if vdcuser_exist == None:
            try:
                url = "https://{host}/moserviceaccesswebsite/goku/rest/vdc/v3.0/users".format(
                    host=self.parmas_dict[MANAGE_CONSOLE_HOST])
                vdc_user_param = {"tenant_id": tenantid,
                                  "user": {"enabled": "true", "name": user_name,
                                           "password": init_password,
                                           "roles": [
                                               "00000000-0000-0000-0000-000000000001"],
                                           "description": ""},
                                  "limit_access": "false"}
                vdc_user_param = json.dumps(vdc_user_param)
                resp = requests.post(url, data=vdc_user_param, verify=False,
                                     allow_redirects=False,
                                     headers=self.global_headers)
                statu_code = resp.status_code
                response_body = json.loads(resp.content)
                if statu_code == 200:
                    users = response_body.get("user")
                    # 修改密码，修改过的用户，初始密码和期望密码填写一致
                    logger.info("***** start to init vdc user *****")
                    self.change_password(self.parmas_dict[TENANT_CONSOLE_HOST],
                                         self.parmas_dict[TENANT_IAM_HOST],
                                         user_name,
                                         self.parmas_dict[
                                             SC_TENANT_USER_OLD_PWD],
                                         self.parmas_dict[
                                             SC_TENANT_USER_PWD_KEY])
                    logger.info("***** init vdc user success*****")
                    time.sleep(5)
                    logger.info("***** create tenant vdc success！ *****")
                    return users["id"]
                else:
                    raise Exception(
                        "create vdc user failed! response is %s" % response_body)
            except Exception as e:
                raise e
        else:
            return vdcuser_exist

    def login_sc_on_web(self, console_host, iam_host, user, pwd, region_name):
        # 登录SC侧，返回user_id , project_id ,region_id ,self.bak_global_headers,self.global_headers
        # 其中返回self.bak_global_headers,self.global_headers供RF脚本调用
        # RF脚本中可将self.bak_global_headers,self.global_headers设置为全局变量
        # 等同于原来RF登录时的${bak_global_headers}和${global_headers}
        logger.info(
            "start login sc by user: %s, region is %s" % (user, region_name))
        try:
            if self.parmas_dict[MANAGE_CONSOLE_HOST] != self.parmas_dict[
                TENANT_CONSOLE_HOST] and "bss_admin" in user:
                logger.info("B2B login.")
                self.access_url = 'moserviceaccesswebsite'
                user_id, project_id, region_id, self.bak_global_headers, self.global_headers = self.b2bAdmin_login_sc_on_web(
                    console_host, iam_host, user, pwd, region_name)
            else:
                self.access_url = 'motenantconsolehomewebsite'
                user_id, project_id, region_id, self.bak_global_headers, self.global_headers = self.nonb2b_login_sc_on_web(
                    console_host, iam_host, user, pwd, region_name)
            return user_id, project_id, region_id, self.bak_global_headers, self.global_headers
        except Exception as e:
            raise e

    def b2bAdmin_login_sc_on_web(self, console_host, iam_host, user, pwd,
                                 region_name):
        # 登录SC侧，返回user_id , project_id ,region_id ,self.bak_global_headers,self.global_headers
        # 其中返回self.bak_global_headers,self.global_headers供RF脚本调用
        # RF脚本中可将self.bak_global_headers,self.global_headers设置为全局变量
        # 等同于原来RF登录时的${bak_global_headers}和${global_headers}
        try:
            # tenantAuth接口
            tenantAuth_url = "https://{host}/rest/mologin/v3.0/tenantAuth".format(
                host=iam_host)
            basic_header = {
                "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
                "Accept": "*/*"
            }
            quote_pwd = quote(pwd)
            request_body = "userName={username}&password={password}&verifyCode=&locale=zh-cn&service=https%253A%252F%252F{host}%252Fmoserviceaccesswebsite%252F".format(
                username=user, password=quote_pwd, host=console_host)
            resp = requests.post(tenantAuth_url, data=request_body,
                                 verify=False, headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                user = response_body.get("user")
                logger.info(user)
                id = user.get("id")
                logger.info(id)
                thirdLoginurl = response_body.get("url")
                logger.info(thirdLoginurl)
            else:
                raise Exception("login sc failed, /tenantAuth/ response is %s"
                                % response_body)
            logger.info("***** /tenantAuth/ finish *****")
            # thirdLoginurl接口
            basic_header.update({"Accept": "text/html,application/xhtml+xml,"
                                           "application/xml;q=0.9,"
                                           "image/webp,*/*;q=0.8"})
            resp = requests.get(thirdLoginurl, verify=False,
                                allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                thirdLogin_setcookie = resp.headers.get('set-cookie')
                ticket_location = resp.headers.get('Location')
            else:
                raise Exception("login sc failed, /thirdLoginurl/ statu_code is"
                                " %s ,expect 302" % (statu_code))
            logger.info("***** /thirdLoginurl/ finish *****")
            # ticket接口
            resp = requests.get(ticket_location, verify=False,
                                allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                ticket_setcookie = resp.headers.get('set-cookie')
                aggencyID_temp1 = ticket_setcookie.split('agencyID=')
                aggencyID_temp2 = aggencyID_temp1[1].split(
                    ';Path=/;Secure, J_SESSION_ID=')
                aggencyID = aggencyID_temp2[0]
                J_SESSION_ID_temp1 = aggencyID_temp2[1].split(
                    ';Path=/;Secure;HttpOnly')
                J_SESSION_ID = J_SESSION_ID_temp1[0]
            else:
                raise Exception(
                    "login sc failed,/ticket/ statu_code is %s ,expect 302" % (
                        statu_code))
            logger.info("***** /ticket/ finish *****")
            # console me接口
            basic_header.update({
                "Cookie": "theme=default; SID=Set2; agencyID={agencyid}; J_SESSION_ID={j_session_id}; locale=zh-cn; browserCheckResult=A".format(
                    agencyid=aggencyID, j_session_id=J_SESSION_ID),
                "Accept": "*/*",
                "X-Language": "zh-cn",
                "X-Requested-With": "XMLHttpRequest",
                "Connection": "keep-alive",
                "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.104 Safari/537.36",
            })
            me_url = "https://{host}/moserviceaccesswebsite/rest/me?salt=0.4070987459363351".format(
                host=console_host)
            resp = requests.get(me_url, verify=False, allow_redirects=False,
                                headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                me_cftk = response_body.get('cftk')
                project_id = response_body.get('projectId')
                user_id = response_body.get('userId')
                region = response_body.get('region')
            else:
                raise Exception(
                    "login sc failed,/rest/me response is %s" % response_body)
            logger.info("***** /rest/me finish *****")
            basic_header.update({"cftk": me_cftk})
            self.bak_global_headers[
                "Cookie"] = "theme=default; SID=Set2; agencyID={agencyid}; J_SESSION_ID={j_session_id}; locale=zh-cn; browserCheckResult=A".format(
                agencyid=aggencyID, j_session_id=J_SESSION_ID)
            self.bak_global_headers["cftk"] = me_cftk
            self.bak_global_headers["AgencyId"] = aggencyID
            self.bak_global_headers["ProjectName"] = region
            cloud_infras = self.get_cloud_infra_and_regionid_by_regionname(
                console_host, region_name)
            logger.info(cloud_infras)
            self.bak_global_headers["region"] = cloud_infras[0][0]
            region_id = cloud_infras[0][0]
            # vpc login接口：
            vpc_login_url = "https://{host1}/authui/login?service=https%3A%2F%2F{host}%2Fvpc%2F%3FagencyId%3D{agencyid}%26region%3D{Region}%26locale%3Dzh-cn%26selectRegionId%3D{regionid}%26cloud_route_state%3D%2Fvpc%2FcreateProduct%3FserviceType%3Dvpc".format(
                host1=iam_host, host=console_host, agencyid=aggencyID,
                Region=region, regionid=region_id)
            basic_header.update({"Cookie": thirdLogin_setcookie})
            resp = requests.get(vpc_login_url, verify=False,
                                allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                vpc_location = resp.headers.get('Location')
            else:
                raise Exception("login sc failed,/vpc authui/login/ statu_code "
                                "is %s ,expect 302" % (statu_code))
            logger.info("***** /vpc authui/login/ finish *****")
            # vpc_Jsession获取
            resp = requests.get(vpc_location, verify=False,
                                allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                vpc_setcookie = resp.headers.get('set-cookie')
                vpc_J_SESSION_ID_temp1 = vpc_setcookie.split(
                    'Path=/; Secure, J_SESSION_ID="')
                vpc_J_SESSION_ID_temp2 = vpc_J_SESSION_ID_temp1[1].split(
                    ';Path=/;Secure;HttpOnly')
                vpc_J_SESSION_ID = vpc_J_SESSION_ID_temp2[0]
            else:
                logger.error("login sc failed, /vpc_Jsession/ statu_code is %s,"
                             " response is %s" % (statu_code, str(resp.text)))
                raise Exception(
                    "login sc failed,/vpc_Jsession/ statu_code is %s ,expect 302" % (
                        statu_code))
            logger.info("***** /vpc_Jsession/ finish *****")
            # vpc me接口
            # vpc 接口的jsessionid需要加双引号
            vpc_J_SESSION_ID_format = '"' + vpc_J_SESSION_ID + '"'
            basic_header.update({
                "Cookie": "theme=default; SID=Set2; agencyID={agencyid}; J_SESSION_ID={j_session_id}; locale=zh-cn; browserCheckResult=A".format(
                    agencyid=aggencyID, j_session_id=vpc_J_SESSION_ID_format),
                "AgencyId": aggencyID})
            vpc_me_url = "https://{host}/vpc/rest/me?salt=0.8809960674639905".format(
                host=console_host)
            resp = requests.get(vpc_me_url, verify=False, allow_redirects=False,
                                headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                vpc_me_cftk = response_body.get('cftk')
            else:
                raise Exception(
                    "login sc failed,/vpc/rest/me response is %s" % response_body)
            logger.info("***** /vpc/rest/me finish *****")
            self.global_headers["Cookie"] = \
                "theme=default; SID=Set2; agencyID={agencyid}; " \
                "J_SESSION_ID={j_session_id}; locale=zh-cn; " \
                "browserCheckResult=A".format(
                    agencyid=aggencyID,
                    j_session_id=vpc_J_SESSION_ID_format)
            self.global_headers["cftk"] = vpc_me_cftk
            self.global_headers["AgencyId"] = aggencyID
            self.global_headers["ProjectName"] = region
            self.global_headers["region"] = region_id
            logger.info("***** login sc finish *****")
            return user_id, project_id, region_id, \
                   self.bak_global_headers, self.global_headers
        except Exception as e:
            raise e

    def nonb2b_login_sc_on_web(self, console_host, iam_host, user, pwd,
                               region_name):
        # 登录SC侧，返回user_id , project_id ,region_id ,self.bak_global_headers,self.global_headers
        # 其中返回self.bak_global_headers,self.global_headers供RF脚本调用
        # RF脚本中可将self.bak_global_headers,self.global_headers设置为全局变量
        # 等同于原来RF登录时的${bak_global_headers}和${global_headers}
        try:
            # tenantAuth接口
            tenantAuth_url = "https://{host}/rest/mologin/v3.0/tenantAuth".format(
                host=iam_host)
            basic_header = {
                "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
                "Accept": "*/*"
            }
            quote_pwd = quote(pwd)
            request_body = "userName={username}&password={password}&verifyCode=&locale=zh-cn&service=https%253A%252F%252F{host}%252Fmotenantconsolehomewebsite%252F".format(
                username=user, password=quote_pwd, host=console_host)
            resp = requests.post(tenantAuth_url, data=request_body,
                                 verify=False, headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                user = response_body.get("user")
                id = user.get("id")
                thirdLoginurl = response_body.get("url")
            else:
                logger.error(
                    "login sc failed,/tenantAuth/ status code is %s, response "
                    "is %s" % (statu_code, str(response_body)))
                raise Exception(
                    "login sc failed,/tenantAuth/ response is %s" % response_body)
            logger.info("***** /tenantAuth/ finish *****")
            # thirdLoginurl接口
            basic_header.update({"Accept": "text/html,application/xhtml+xml,"
                                           "application/xml;q=0.9,image/webp,"
                                           "*/*;q=0.8"})
            resp = requests.get(thirdLoginurl, verify=False,
                                allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                thirdLogin_setcookie = resp.headers.get('set-cookie')
                ticket_location = resp.headers.get('Location')
            else:
                raise Exception("login sc failed,/thirdLoginurl/ statu_code"
                                " is %s ,expect 302" % (statu_code))
            logger.info("***** /thirdLoginurl/ finish *****")
            # ticket接口
            resp = requests.get(ticket_location, verify=False,
                                allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                ticket_setcookie = resp.headers.get('set-cookie')
            else:
                raise Exception(
                    "login sc failed,/ticket/ statu_code is %s ,expect 302" % (
                        statu_code))
            logger.info("***** /ticket/ finish *****")
            # motenantconsolehomewebsite接口
            basic_header.update({"Cookie": ticket_setcookie})
            motenantconsolehomewebsite = \
                "https://{host}/motenantconsolehomewebsite/".format(
                    host=console_host)
            resp = requests.get(motenantconsolehomewebsite, verify=False,
                                allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code != 200:
                raise Exception("login sc failed,/motenantconsolehomewebsite/ "
                                "statu_code is %s ,expect 200" % (statu_code))
            # console me接口
            basic_header.update({
                "Cookie": ticket_setcookie,
                "Accept": "*/*",
                "X-Language": "zh-cn",
                "X-Requested-With": "XMLHttpRequest",
                "Content-Type": "application/json; charset=UTF-8",
                "Connection": "keep-alive",
                "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) "
                              "AppleWebKit/537.36 (KHTML, like Gecko) "
                              "Chrome/59.0.3071.104 Safari/537.36",
            })
            me_url = "https://{host}/motenantconsolehomewebsite/rest/me?salt=0.4070987459363351".format(
                host=console_host)
            resp = requests.get(me_url, verify=False, allow_redirects=False,
                                headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                me_cftk = response_body.get('cftk')
                project_id = response_body.get('projectId')
                user_id = response_body.get('userId')
                region = response_body.get('region')
                aggencyID = response_body.get('id')
            else:
                raise Exception(
                    "login sc failed,/rest/me response is %s" % response_body)
            logger.info("***** /rest/me finish *****")
            basic_header.update({"cftk": me_cftk})
            self.bak_global_headers[
                "Cookie"] = ticket_setcookie
            self.bak_global_headers["cftk"] = me_cftk
            self.bak_global_headers["ProjectName"] = region
            cloud_infras = self.get_cloud_infra_and_regionid_by_regionname(
                console_host, region_name)
            logger.info(cloud_infras)
            self.bak_global_headers["region"] = cloud_infras[0][0]
            region_id = cloud_infras[0][0]
            # project CSDR切换project
            projects_url = "https://{host}/motenantconsolehomewebsite/rest/vdc/v3.1/users/{agencyid}/projects?start=0&limit=100&rel_projects=true".format(
                host=console_host, agencyid=aggencyID)
            resp = requests.get(projects_url, verify=False,
                                allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 200 and resp.content:
                response_body = json.loads(resp.content)
                projects = response_body.get('projects')
                for project in projects:
                    region_temp = project.get('regions')
                    region_temp_id = region_temp[0].get('region_id')
                    if region_temp_id == region_id:
                        project_id = project.get('id')
                        region = project.get('name')
                        logger.info(
                            "***** reset project_id and project_name success")
            # vpc login接口：
            vpc_login_url = "https://{host1}/authui/login?service=https%3A%2F%2F{host}%2Fvpc%2F%3FagencyId%3D{agencyid}%26region%3D{Region}%26locale%3Dzh-cn".format(
                host1=iam_host, host=console_host, agencyid=aggencyID,
                Region=region)
            basic_header.update({"Cookie": thirdLogin_setcookie})
            resp = requests.get(vpc_login_url, verify=False,
                                allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                vpc_location = resp.headers.get('Location')
            else:
                raise Exception(
                    "login sc failed,/vpc authui/login/ statu_code is %s ,expect 302" % (
                        statu_code))
            logger.info("***** /vpc authui/login/ finish *****")
            # vpc_Jsession获取
            basic_header.update({"Cookie": ticket_setcookie})
            resp = requests.get(vpc_location, verify=False,
                                allow_redirects=False, headers=basic_header)
            statu_code = resp.status_code
            if statu_code == 302:
                vpc_setcookie = resp.headers.get('set-cookie')
                vpc_J_SESSION_ID_temp1 = vpc_setcookie.split('J_SESSION_ID=')
                vpc_J_SESSION_ID_temp2 = vpc_J_SESSION_ID_temp1[1].split(
                    '; Version=1; Path=/; Secure;')
                vpc_J_SESSION_ID = vpc_J_SESSION_ID_temp2[0]
            else:
                logger.error("login sc failed, /vpc_Jsession/ status code "
                             "is %s, response is %s"
                             % (statu_code, str(resp.text)))
                raise Exception(
                    "login sc failed,/vpc_Jsession/ statu_code is %s, "
                    "expect 302" % (statu_code))
            logger.info("***** /vpc_Jsession/ finish *****")
            # vpc me接口
            vpc_me_cookie = ticket_setcookie + ';J_SESSION_ID=' + vpc_J_SESSION_ID
            basic_header.update({
                "Cookie": vpc_me_cookie,
                "AgencyId": aggencyID})
            vpc_me_url = "https://{host}/vpc/rest/me?salt=0.8809960674639905".format(
                host=console_host)
            resp = requests.get(vpc_me_url, verify=False, allow_redirects=False,
                                headers=basic_header)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                vpc_me_cftk = response_body.get('cftk')
            else:
                raise Exception("login sc failed,/vpc/rest/me response is %s"
                                % response_body)

            self.global_headers["Cookie"] = vpc_me_cookie
            self.global_headers["cftk"] = vpc_me_cftk
            self.global_headers["AgencyId"] = aggencyID
            self.global_headers["ProjectName"] = region
            self.global_headers["region"] = region_id
            logger.info("login sc finish")
            return user_id, project_id, region_id, \
                   self.bak_global_headers, self.global_headers
        except Exception as e:
            raise e

    def get_cloud_infra_and_regionid_by_regionname(self, console_host,
                                                   region_name="ALL"):
        # 根据region名称获取region_id,cloud_infra_id,cloud_infra_name
        logger.info("start get cloud infra info. region name=%s" % region_name)
        try:
            region_name_filed = "" if region_name == "ALL" else region_name
            url = "https://{host}/{access_url}/goku/rest/serviceaccess/v3.0/regions?name={region}".format(
                host=console_host, access_url=self.access_url,
                region=region_name_filed)
            if self.bak_global_headers.__contains__("region"):
                self.bak_global_headers.__delitem__("region")
            if self.bak_global_headers.__contains__("AgencyId"):
                self.bak_global_headers.__delitem__("AgencyId")
            resp = requests.get(url, verify=False, allow_redirects=False,
                                headers=self.bak_global_headers)
            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            if statu_code == 200:
                records = response_body.get("records")
                cloud_infra_list = []
                for region_info in records:
                    name = region_info["name"]
                    if region_name == name:
                        cloud_infras = region_info["cloud_infras"]
                        for cloud_infra in cloud_infras:
                            cloud_infra_temp = []
                            if cloud_infra["type"] == "FUSION_CLOUD":
                                region_id = cloud_infra["region_id"]
                                cloud_infra_id = cloud_infra["id"]
                                cloud_infra_name = cloud_infra["name"]
                                cloud_infra_temp.append(region_id)
                                cloud_infra_temp.append(cloud_infra_id)
                                cloud_infra_temp.append(cloud_infra_name)
                                cloud_infra_list.append(cloud_infra_temp)
                                logger.info(
                                    "get cloud infra successfully. %s" % str(
                                        cloud_infra_list))
                                return cloud_infra_list
                        else:
                            return None
                    elif region_name == "ALL":
                        cloud_infras = region_info["cloud_infras"]
                        for cloud_infra in cloud_infras:
                            cloud_infra_temp = []
                            if cloud_infra["type"] == "FUSION_CLOUD":
                                region_id = cloud_infra["region_id"]
                                cloud_infra_id = cloud_infra["id"]
                                cloud_infra_name = cloud_infra["name"]
                                cloud_infra_temp.append(region_id)
                                cloud_infra_temp.append(cloud_infra_id)
                                cloud_infra_temp.append(cloud_infra_name)
                                cloud_infra_list.append(cloud_infra_temp)
                logger.info(
                    "get cloud infra successfully. %s" % str(cloud_infra_list))
                return cloud_infra_list
            else:
                raise Exception("get cloud infra list failed! response is %s"
                                % response_body)
        except Exception as e:
            raise e


def get_common_params(tool_project_id, tool_region_id, service_type):
    """
    获取租户相关的参数
    :param pod_id:
    :param service_type:
    :return:
    """
    param_dit = {}
    params = ParamUtil()
    region_type = get_project_type(tool_project_id).lower()
    primary_az_name = params.get_value_from_cloud_param(
        tool_project_id,
        service_type.upper(),
        'tc_%s_first_az_display_name' % service_type.lower(),
        tool_region_id)
    standby_az_name = params.get_value_from_cloud_param(
        tool_project_id,
        service_type.upper(),
        'tc_%s_second_az_display_name' % service_type.lower(),
        tool_region_id)
    param_dit.update(
        {PRIMARY_AZ_NAME: primary_az_name, STANDBY_AZ_NAME: standby_az_name})

    manage_user = params.get_value_from_cloud_param(
        tool_project_id,
        'Basic_MO_Test',
        '%s_sc_sys_username' % region_type,
        tool_region_id)
    manager_user_pwd = params.get_value_from_cloud_param(
        tool_project_id,
        'Basic_MO_Test',
        '%s_sc_sys_password' % region_type,
        tool_region_id)
    tenant_user = "FCU_" + service_type.lower()
    tenant_user_pwd = params.get_value_from_cloud_param(
        tool_project_id,
        'Basic_MO_Test',
        '%s_sc_user_new_password' % region_type,
        tool_region_id)
    tenant_user_old_pwd = params.get_value_from_cloud_param(
        tool_project_id,
        'Basic_MO_Test',
        '%s_sc_user_old_password' % region_type,
        tool_region_id)
    param_dit.update({SC_TENANT_USER_PWD_KEY: tenant_user_pwd,
                      SC_TENANT_USER_KEY: tenant_user,
                      SC_MANAG_USER_KEY: manage_user,
                      SC_TENANT_USER_OLD_PWD: tenant_user_old_pwd,
                      SC_MANAG_USER_PWD: manager_user_pwd})

    primary_region_name = params.get_value_from_cloud_param(
        tool_project_id,
        service_type.upper(),
        'tc_%s_first_region_name' % service_type.lower(),
        tool_region_id)
    standby_region_name = params.get_value_from_cloud_param(
        tool_project_id,
        service_type.upper(),
        'tc_%s_second_region_name' % service_type.lower(),
        tool_region_id)
    param_dit.update({PRIMARY_REGION_NAME: primary_region_name,
                      STANDBY_REGION_NAME: standby_region_name})

    vol1_type = "tc_%s_first_volume_type" % service_type.lower()
    vol2_type = "tc_%s_second_volume_type" % service_type.lower()

    primary_vol_type = params.get_value_from_cloud_param(tool_project_id,
                                                         service_type.upper(),
                                                         vol1_type,
                                                         tool_region_id)
    standby_vol_type = params.get_value_from_cloud_param(tool_project_id,
                                                         service_type.upper(),
                                                         vol2_type,
                                                         tool_region_id)
    param_dit.update({PRIMARY_VOL_TYPE: primary_vol_type,
                      STANDBY_VOL_TYPE: standby_vol_type})

    vdc1_name = "FCU_vdc1_" + service_type.lower()
    vdc2_name = "FCU_vdc2_" + service_type.lower()
    param_dit.update({PRIMARY_VDC_NAME: vdc1_name, STANDBY_VDC_NAME: vdc2_name})

    project_one = "FCU_project_" + service_type.lower()
    project_two = "FCU_project_" + service_type.lower()
    param_dit.update(
        {PRIMARY_PROJECT_NAME: project_one, STANDBY_PROJECT_NAME: project_two})

    product_vm_name = "fcu_product_" + service_type.lower()
    replace_vm_name = "fcu_dr_" + service_type.lower()
    param_dit.update(
        {PRODUCT_VM_NAME: product_vm_name, DR_VM_NAME: replace_vm_name})

    manage_console_host = params.get_value_from_cloud_param(
        tool_project_id,
        'Basic_MO_Test',
        '%s_manage_console_host' % region_type,
        tool_region_id)
    manage_iam_host = params.get_value_from_cloud_param(
        tool_project_id,
        'Basic_MO_Test',
        '%s_manage_iam_host' % region_type,
        tool_region_id)
    tenant_iam_host = params.get_value_from_cloud_param(
        tool_project_id,
        'Basic_MO_Test',
        '%s_iam_host' % region_type,
        tool_region_id)
    tenant_console_host = params.get_value_from_cloud_param(
        tool_project_id,
        'Basic_MO_Test',
        '%s_console_host' % region_type,
        tool_region_id)
    param_dit.update({MANAGE_CONSOLE_HOST: manage_console_host,
                      MANAGE_IAM_HOST: manage_iam_host,
                      TENANT_CONSOLE_HOST: tenant_console_host,
                      TENANT_IAM_HOST: tenant_iam_host})

    external_eip_net = params.get_value_from_cloud_param(
        tool_project_id,
        'Basic_FS_Test',
        '%s_external_network_eip' % region_type,
        tool_region_id)
    external_vpc_net = params.get_value_from_cloud_param(
        tool_project_id,
        'Basic_FS_Test',
        '%s_external_network_vpc' % region_type,
        tool_region_id)
    param_dit.update({EXTERNAL_EIP_NETWORK: external_eip_net,
                      EXTERNAL_VPC_NETWORK: external_vpc_net})

    first_region_type = params.get_value_from_cloud_param(
        tool_project_id,
        'CSDR',
        'tc_first_region_type',
        tool_region_id)
    param_dit.update({FIRST_REGION_TYPE: first_region_type})
    return param_dit


def get_instance_name(service_type):
    return "FCU_AUTO_TEST_" + service_type.upper()


def get_project_type(tool_project_id):
    from platforms.param.param_service import ParamService
    project_info = ParamService().get_project_info(tool_project_id)
    return project_info.get('region_type')
