# -*- coding:utf-8 -*-

from utils.common.message import Message
from utils.business.param_util import ParamUtil
from .RequestUtil import RequestApi
import utils.common.log as logger
from . import CommonUtil
import time
import base64

logger.init("ConfigEndPoint")


class ConfigEndpoint:
    def __init__(self, tool_project_id, region_id, service_type):
        self.project_id = tool_project_id
        self.region_id = region_id
        self.service_type = service_type.upper()

    def init_params(self):
        self.paramsutil = ParamUtil()
        server_params = CommonUtil.get_server_params(self.project_id,
                                                     self.region_id,
                                                     self.service_type)
        self.new_rd_ip = server_params["server_ip1"]
        self.new_os_user = self.paramsutil.get_value_from_cloud_param(
            self.project_id, self.service_type, "server_business_user",
            self.region_id)
        self.new_os_passwd = self.paramsutil.get_value_from_cloud_param(
            self.project_id, self.service_type, "server_business_user_pwd",
            self.region_id)
        self.new_root_pwd = self.paramsutil.get_value_from_cloud_param(
            self.project_id, self.service_type, "server_root_pwd",
            self.region_id)

        self.new_rd_port = "9443"
        self.old_admin_pwd = self.paramsutil.get_value_from_cloud_param(
            self.project_id, self.service_type, "sync_admin_pwd",
            self.region_id)
        self.admin_user = self.paramsutil.get_value_from_cloud_param(
            self.project_id, self.service_type, "sync_admin_name",
            self.region_id)

    def get_openstack_uuid(self, request):
        try:
            logger.info("start create rd site.")
            # 先从server服务器查询容灾站点的UUID, 循环查询15次,
            # 每次间隔20秒, fsp环境上服务可能存在无法访问情况
            # 要等待一会儿才行.
            __uuid__ = ""
            err_msg = ""
            for count in range(0, 5):
                try:
                    __state__, __body__ = request.sendGetRequest(
                        "ws/drmservers")
                    __uuid__ = dict(__body__[0]).get('uuid')
                    logger.info("drm server uuid is [%s]" % __uuid__)
                    if not CommonUtil.check_value_null(__uuid__):
                        break
                except Exception as e:
                    logger.error(
                        "query drmservers info failed, errMsg=%s" % str(e))
                    err_msg = str(e)
                    # 此处加个continue, 否则直接就退出了?
                    time.sleep(5)
                    continue
                logger.error(
                    "get drmservers info failed, retry %s, errMsg=%s, %s" % (
                        count, __state__, __body__))
                time.sleep(5)
                continue
            if CommonUtil.check_value_null(__uuid__):
                logger.error("get uuid failed.")
                raise Exception(err_msg)
            logger.info("get server uuid successfully, uuid=%s" % __uuid__)

            __state__, __body__ = request.sendGetRequest(
                "ws/sites?serverUuid=%s" % __uuid__)
            for siteinfo in __body__:
                __id__ = dict(siteinfo).get("siteId")
                __state__, __body__ = request.sendGetRequest(
                    "ws/fusionsphere?siteId=%s&cloudType=" % __id__)
                for fsp_info in __body__:
                    __address__ = dict(fsp_info).get("ipAddress")
                    __devsn__ = dict(fsp_info).get("deviceSn")
                    # 当前一个server上只能发现一套IAM,
                    # 因此，如果address不为空,此时也直接返回
                    if CommonUtil.check_value_null(__address__) is False:
                        logger.info(
                            "get dest device id successfully, address[%s], "
                            "devsn[%s]" % (__address__, __devsn__))
                        return __address__, __devsn__
            logger.error("get openstack uuid failed: %s" % str(__body__))
            raise Exception("Failed to get openstack uuid[%s]" % str(__body__))
        except Exception as e:
            logger.error("create site failed, errMsg=%s" % str(e))
            raise Exception("get openstack uuid failed: %s" % str(e))

    def refresh_device(self, request, ops_uuid):
        # 调用刷新时, 需要对设备UUID进行Base64编码
        refresh_url = "ws/fusionsphere/%s/action/refresh" % base64.b64encode(
            ops_uuid.encode(encoding='utf-8')).decode(encoding='utf-8')
        logger.info("refresh_url : %s" % refresh_url)
        try:
            # 该PUT请求未返回后台任务,无法获取请求的执行结果,
            # 因此只发送一次, 检查状态是否OK
            __state__, __body__ = request.sendPutRequest(None, refresh_url)
            if __state__ != 200:
                raise Exception('Failed to refresh device[%s]' % str(__body__))
            logger.info("refresh_device cmd send successfully.")
            time.sleep(30)
        except Exception as e:
            logger.error("refresh device failed, errMsg=%s" % str(e))
            raise Exception('Failed to refresh device[%s]' % str(e))

    def execute(self):
        """
        标准调用接口：执行安装&配置
        :return:
        """
        logger.info("start config endpoint.")
        try:
            self.init_params()

            # 因为这一步依赖于系统正常运行，而上一步是启动系统，之前偶现过系统还未正常导致
            # 这一步报错，所以这里增加一个延时60秒
            time.sleep(60)
            # 主备部署模式不能确定主备节点,因此登录到环境后获取当前主节点
            node_ip, listen_ip = CommonUtil.get_server_node(self.new_rd_ip,
                                                            self.new_os_user,
                                                            self.new_os_passwd,
                                                            self.new_root_pwd)

            __requestApi__ = RequestApi(listen_ip, self.new_rd_port,
                                        self.admin_user, self.old_admin_pwd)
            iam_address, ops_uuid = self.get_openstack_uuid(__requestApi__)
            __resturi__ = "ws/openstack/%s/regions" % ops_uuid
            global_domain_name = iam_address.replace(' ', '').replace(
                'iam-cache-proxy.', '')

            # 在配置Region前,应该先刷新OpenStack,
            # 因为如果Region ID不在数据库时,此时无法配置endpoint
            self.refresh_device(__requestApi__, ops_uuid)

            # 查询出eReplication所有已配置的Region信息
            __state__, __body__ = __requestApi__.sendGetRequest(__resturi__)
            if __state__ != 200:
                logger.error(
                    "Failed to query endpoint info, status code[%s], "
                    "response[%s]" % (__state__, str(__body__)))
                raise Exception(
                    "Failed to query endpoint info, status code[%s], "
                    "response[%s]" % (__state__, str(__body__)))

            for ep in __body__:
                logger.info("start config endpoint ,data: %s" % str(ep))
                region_id = ep["regionId"]
                if str(region_id).__contains__(":"):
                    region_id = str(region_id).split(":")[1]
                endpoint_list = ep["services"]
                apicom_url = "https://apicom-api." + region_id + "." + \
                             global_domain_name + ":7443/v1/"
                need_update = False
                find_apicom = False
                for endp in endpoint_list:
                    # 如果存在apicom服务,且URL为空,则将Url进行更新
                    if endp["serviceType"] == "apicom":
                        find_apicom = True
                        if CommonUtil.check_value_null(endp["serviceUrl"]):
                            need_update = True
                            endp.update({"serviceUrl": apicom_url})
                if find_apicom and need_update is False:
                    logger.info(
                        "apicom url is not empty in %s. no need update." %
                        region_id)
                    continue

                if find_apicom is False:
                    endpoint_list.append(
                        {"serviceType": "apicom", "serviceUrl": apicom_url})
                send_data = {"regionId": region_id, "services": endpoint_list}
                __state__, response = __requestApi__.sendPostRequest(
                    [send_data], __resturi__)
                if __state__ != 200:
                    logger.error(
                        "add region info failed, state:%s, body: %s" % (
                            __state__, str(response)))
                    raise Exception(
                        "Failed to config endpoint[%s]" % str(response))
            return Message(200)
        except Exception as e:
            logger.error("config endpoint failed, errMsg=%s" % str(e))
            return Message(500, "配置Endpoint失败[%s]" % str(e),
                           "Failed to config endpoint[%s]" % str(e),
                           "请检查",
                           "Please check.")
