# -*- coding:utf-8 -*-
from utils.business.param_util import ParamUtil
from utils.common.ssh_util import Ssh
from .ConfigEndpoint import ConfigEndpoint
from utils.DBAdapter.DBConnector import BaseOps
from .RequestUtil import RequestApi
from . import CommonUtil
import requests
import json
import utils.common.log as logger

LISTEN_IP_KEY = "LISTEN_IP_KEY"
LISTEN_PORT_KEY = "LISTEN_PORT_KEY"
NODE_IP_KEY = "NODE_IP_KEY"
CONFIG_DICT = {}


class DnsAndEndPoint:
    """
    处理endpoint与DNS
    """

    def __init__(self, pod_id, tool_region_id, project_id, service_type):
        self.pod_id = pod_id
        param_util = ParamUtil()
        self.service_name = service_type.upper()
        self.project_id = project_id
        self.tool_region_id = tool_region_id

        server_params = CommonUtil.get_server_params(project_id, tool_region_id,
                                                     self.service_name)
        self.new_rd_ip = server_params["server_ip1"]

        self.new_os_user = param_util.get_value_from_cloud_param(
            project_id,
            self.service_name,
            "server_business_user",
            tool_region_id)
        self.new_os_passwd = param_util.get_value_from_cloud_param(
            project_id,
            self.service_name,
            "server_business_user_pwd",
            tool_region_id)
        self.new_root_pwd = param_util.get_value_from_cloud_param(
            project_id,
            self.service_name,
            "server_root_pwd",
            tool_region_id)
        self.old_admin_pwd = param_util.get_value_from_cloud_param(
            project_id,
            self.service_name,
            "sync_admin_pwd",
            tool_region_id)
        self.admin_user = param_util.get_value_from_cloud_param(
            project_id,
            self.service_name,
            "sync_admin_name",
            tool_region_id)

        logger.info("start get tenant and vdc info.")
        all_oc_params = param_util.get_service_cloud_param(project_id, "OC",
                                                           tool_region_id)
        self.tenant_ip = all_oc_params["oc_node_ip"]
        self.vdc_user = all_oc_params["oc_common_account"]
        self.vdc_pwd = all_oc_params["oc_common_pwd"]
        self.tenant_address = self.tenant_ip + ":31943"
        logger.info("get tenant address is %s" % self.tenant_address)

    def config(self):
        """
        配置DNS与endpoint
        :return:
        """
        logger.info("start config endpoint.")

        region_list = BaseOps().get_regionId_by_projectId(self.project_id)
        # 根据服务节点查询当前正在提供服务的IP地址
        self.query_config_info()

        # 当前条件限制，从eReplicatoin服务中查询出IAM的域名,然后从IAM域名中解析全局域名
        request = RequestApi(CONFIG_DICT[LISTEN_IP_KEY],
                             CONFIG_DICT[LISTEN_PORT_KEY], self.admin_user,
                             self.old_admin_pwd)
        address, dev_sn = ConfigEndpoint(
            self.project_id, self.tool_region_id,
            self.service_name).get_openstack_uuid(request)
        global_domain_name = address.replace(' ', '').replace(
            'iam-cache-proxy.', '')

        # 开始注册容灾服务endpoint
        logger.info("start register eReplication endpoint.")
        self.register_endpoint_info("cdrs", region_list[0],
                                    self.service_name.lower() + "." +
                                    global_domain_name,
                                    CONFIG_DICT[LISTEN_PORT_KEY])
        logger.info("all register is completed.")

    def query_config_info(self):
        """
        查询依赖的配置信息
        :return:
        """
        listen_port = "9443"
        all_ips = CommonUtil.get_all_server_nodes(self.new_rd_ip,
                                                  self.new_os_user,
                                                  self.new_os_passwd,
                                                  self.new_root_pwd)
        for ip in all_ips:
            ssh_client = None
            try:
                logger.info("start query config in %s" % ip)
                ssh_client = Ssh.ssh_create_client(ip, self.new_os_user,
                                                   self.new_os_passwd, port=22,
                                                   timeout=30)
                Ssh.ssh_send_command(ssh_client, "su - root", "Password", 10)
                Ssh.ssh_send_command(ssh_client, self.new_root_pwd, '#', 10)
                result = Ssh.ssh_exec_command_return(
                    ssh_client,
                    "ps -ef | grep java | grep -w ^Tomcat | grep BCManager "
                    "&>/dev/null;echo CMD_RESULT=$? LISTEN_IP=`cat "
                    "/opt/BCManager/Runtime/Tomcat6/conf/server.xml | "
                    "grep keystorePass | grep -w address | "
                    "awk -F 'address=\\\\\"' '{print $2}'  | "
                    "awk -F '\\\\\"' '{print $1}'`=")
                # 从CMD_RESULT=x LISTEN_IP=x.x.x.x=中解析服务监听IP
                for res in result:
                    if not res.__contains__("CMD_RESULT=0"):
                        continue
                    listen_ip = res.split("=")[2]
                    query_result = Ssh.ssh_exec_command_return(
                        ssh_client,
                        "echo PORT_VALUE=`cat /opt/BCManager/Runtime/Tomcat6/"
                        "conf/server.xml  | grep -w port | grep keystoreFile | "
                        "awk -F 'port=\\\\\"' '{print $2}' | awk -F '\\\\\"' "
                        "'{print $1}' | sed -n 1p`=")
                    for resp in query_result:
                        if not resp.startswith("PORT_VALUE"):
                            continue
                        listen_port = resp.split("=")[1]
                    logger.info("get info successfully.[%s, %s]" % (
                        listen_ip, listen_port))
                    CONFIG_DICT.update(
                        {LISTEN_IP_KEY: listen_ip, NODE_IP_KEY: ip,
                         LISTEN_PORT_KEY: listen_port})
                    return True
            except Exception as e:
                logger.error("get primary server node failed.: %s" % str(e))
                raise Exception("Failed to query service address.[%s]" % str(e))
            finally:
                try:
                    if ssh_client is not None:
                        Ssh.ssh_close(ssh_client)
                except Exception as e:
                    logger.error("close ssh client failed: %s" % str(e))
        raise Exception("Please check if eReplication service is running.")

    def get_token(self):
        # 获取机机账号的token
        url_token_get = "https://%s/v3/auth/tokens" % self.tenant_address
        token_param = '{"auth":{"identity":{"methods":["password"], ' \
                      '"password":{"user": {"name":"' + self.vdc_user + \
                      '", "password":"' + self.vdc_pwd + \
                      '","domain":{"name":"op_service"}}}},' \
                      '"scope":{"domain":{"name":"op_service"}}}}'
        HEADERS = {'User-Agent': 'python-cinderclient',
                   'Content-Type': 'application/json',
                   'Accept': 'application/json;charset=utf8'}
        content = requests.post(url_token_get, headers=HEADERS,
                                data=token_param, verify=False)
        return content.headers.get('X-Subject-Token')

    def register_endpoint_info(self, endpoint_id, region_id, address, port):
        # 注意：当前框架提供的该接口在NFVI场景下存在问题，框架提供的接口中会获取
        # ManageOne_global_domain_name参数, 但在NFVI场景下未提供该参数
        # 导致接口调用失败，确认当前也只有容灾服务在NFVI场景下使用,
        # 因此由容灾自己实现，其中的租户IP、vdc_admin与密码都从框架界面上获取
        # 后续如果框架变动也需要一起修改
        logger.info("start register endpoint.")
        token = self.get_token()
        headers = {
            'User-Agent': 'python-cinderclient',
            'Content-Type': 'application/json;',
            'Accept': 'application/json;charset=utf8',
            'X-Auth-Token': token
        }

        get_url = "https://%s/silvan/rest/v1.0/endpoints/%s/regions" % (
            self.tenant_address, endpoint_id)
        try:
            resp = requests.request(method="get", url=get_url, headers=headers,
                                    verify=False)
            response = json.loads(resp.content)
            for endp in response["regionEndpoints"]:
                if endp["endpointId"] == endpoint_id and \
                        endp["regionId"] == region_id:
                    logger.info("the endpoint already exists. no need "
                                "register again.")
                    return True
        except Exception as e:
            logger.error("Failed to get endpoint info: %s", e)
            raise Exception("Failed to get endpoint info. errMsg=%s" % str(e))

        region_to_endpoint_item = '{"address":"' + address + '","port":"' + \
                                  port + '"}'
        regist_url = "https://%s/silvan/rest/v1.0/endpoints/%s/regions/%s" % (
            self.tenant_address, endpoint_id, region_id)
        logger.info("start register endpoint to sc. endpoint: %s" % str(
            region_to_endpoint_item))
        try:
            resp = requests.request(method="post", url=regist_url,
                                    headers=headers,
                                    data=region_to_endpoint_item, verify=False)
            if resp.status_code > 400:
                logger.error(
                    "register endpoint failed. status code is %s, "
                    "response is %s" % (resp.status_code, str(resp.content)))
                raise Exception(
                    "Failed to register endpoint. status code is %s,"
                    " response is %s" % (resp.status_code, str(resp.content)))
        except Exception as ex:
            logger.error("Failed to register endpoint errMsg=%s" % str(ex))
            raise Exception(str(ex))
