# -*- coding:utf-8 -*-

import utils.common.log as logger
import requests
import json

logger.init("Request")


class RequestApi:
    def __init__(self, ip, port, user, pwd):
        if ip is None or port is None or user is None or pwd is None:
            logger.error("Request failed, ip is %s, port is %s, user is %s." % (
            ip, port, user))
            raise Exception("Request failed, IP[%s], Port[%s], user[%s]." % (
            ip, port, user))
        self.user = user
        self.pwd = pwd
        self.ip = ip
        self.port = port
        self.url = "https://%s:%s/" % (ip, port)
        self.header = self.buildHeader()

    def buildHeader(self):
        __header__ = dict()
        __header__.__setitem__("Content-Type", "application/json;charset=utf-8")
        __header__.__setitem__("Accept",
                               "application/json;version=1.0;charset=UTF-8")
        __header__.__setitem__("Accept-Language", "zh_CN")
        __header__.__setitem__("x-auth-user", self.user)
        __header__.__setitem__("x-auth-key", self.pwd)
        return __header__

    def get_resp_data(self, resp):
        if resp is not None and resp != 'None' \
                and resp != 'null' and resp:
            return json.loads(resp)
        return None

    def sendPostRequest(self, body, path):
        if isinstance(body, dict) or isinstance(body, list):
            body = json.dumps(body)
        resp = requests.post(self.url + path, headers=self.header, data=body,
                             verify=False)
        return resp.status_code, self.get_resp_data(resp.content)

    def sendGetRequest(self, path):
        resp = requests.get(self.url + path, headers=self.header, data=None,
                            verify=False)
        return resp.status_code, self.get_resp_data(resp.content)

    def sendPutRequest(self, body, path):
        if isinstance(body, dict) or isinstance(body, list):
            body = json.dumps(body)
        resp = requests.put(self.url + path, headers=self.header, data=body,
                            verify=False)
        return resp.status_code, self.get_resp_data(resp.content)
