import requests
import utils.common.log as logger
from platforms.param.ParamManager import ParamService
from plugins.AcceptanceTest.basic_mo_test.common.login_sc import LoginSC
from plugins.AcceptanceTest.basic_fs_test.common.basic_login_serviceom import LoginServiceOm
from plugins.CSDR_CSHA_VHA.common.CSDRTestBase import *
from utils.common.exception import FCUException
from plugins.AcceptanceTest.basic_mo_test.common.preconfig_constant import CloudType

def fcu_create_tenant(loginsc, tenant_name, tenant_user_name,
                      tenant_user_pwd, project_name):
    """
    创建资源租户
    :param tenant_name:  租户名称
    :param tenant_user_name:  租户管理员名称
    :param project_name:     默认project名称
    :return:
    """
    try:
        # 管理员登录SC
        loginsc.login_sc()

        # 创建租户
        vdcid = create_vdc(loginsc, tenant_name, project_name)
        logger.info("vdcid is %s" % vdcid)
        region_records = loginsc._get_region_records()
        logger.info("region_records is %s" % region_records)
        records = []
        region_ids = []
        for region_record in region_records:
            region_id, cloud_infra_id, cloud_infra_name = get_cloud_info(region_record)
            if region_id is None or cloud_infra_id is None:
                continue
            region_ids.append(region_id)

            # 获取可用分区Id
            az_ids = loginsc.get_available_zoneid(region_id, cloud_infra_id, "ALL")
            record = {"region_id":region_id, "infra_id":cloud_infra_id, "az_ids":az_ids}
            records.append(record)
        # 绑定region:
        logger.info("start to region bind tenant")

        region_bind_tanent(loginsc, vdcid, records)
        logger.info("region bind tenant successful")

        # 创建project:
        logger.info('start to create project')

        project_id = create_project(loginsc, vdcid, region_ids,
                                            project_name)

        logger.info(
            'create project successful,project_id is %s' % project_id)

        # 创建租户管理员
        logger.info('start to create user')
        userid = loginsc.create_vdc_user(vdcid, tenant_user_name,
                                         loginsc.sc_user_old_password)
        logger.info('create user successful')
        # 修改密码，修改过的用户，初始密码和期望密码填写一致
        logger.info('start to change password')
        loginsc.change_password(tenant_user_name, loginsc.sc_user_old_password,
                                tenant_user_pwd)
        logger.info('change user loging password successful')

        return vdcid, userid, project_id
    except Exception as error:
        logger.error(error)
        raise error


def create_project(self, vdcid, region_ids, project_name):
    """
    :param vdcid:
    :param region_ids:
    :param project_name:
    :return:
    """
    regions = []
    for region_id in region_ids:
        regions.append({"region_id": region_id})

    try:
        url = "https://{host}/moserviceaccesswebsite/goku/rest/vdc/v3.1/projects".format(
            host=self.manage_console_host)
        logger.info("create_project url is :%s" % url)
        request_body = {
            "project": {
                "tenant_id": vdcid,
                "name": project_name,
                "regions": regions,
                "quotas": []
            }
        }
        request_body = json.dumps(request_body)
        resp = requests.post(url, data=request_body, verify=False,
                             headers=self.bak_global_headers)
        statu_code = resp.status_code
        response_body = json.loads(resp.content)
        logger.info("create project status_code is: %s,resp_msg is: %s" % (
        statu_code, response_body))
        if statu_code == 201:
            project_id = response_body.get("project").get("id")
            return project_id
        elif statu_code == 400:
            logger.info("project is exists")
            return True
        else:
            raise FCUException(40036, statu_code)
    except Exception as error:
        logger.info(str(error))
        raise error


def region_bind_tanent(self, vdcid, records):
    """
    :param vdcid:
    :param records:
    :return:
    """

    try:
        url = "https://{host}/moserviceaccesswebsite/goku/rest/vdc/v3.1/vdcs/{vdcid}/regions".format(
            host=self.manage_console_host, vdcid=vdcid)
        logger.info("region_blind_tanent url is :%s" % url)
        regions = []
        for record in records:
            available_zones = []
            for az_id in record["az_ids"]:
                available_zones.append({"az_id": az_id, "action": "bind"})
            region = {
                "region_id": record["region_id"],
                "action": "bind",
                "cloud_infras": [
                    {
                        "cloud_infra_id": record["infra_id"],
                        "action": "bind",
                        "available_zones": available_zones,
                    }
                ]
            }
            regions.append(region)
        request_body = {
            "regions": regions
        }
        request_body = json.dumps(request_body)
        resp = requests.put(url, data=request_body, verify=False,
                            headers=self.bak_global_headers)
        statu_code = resp.status_code
        logger.info("region bind tanent status_code is:%s" % statu_code)
        if statu_code != 204:
            raise FCUException(40034, statu_code)
    except Exception as error:
        logger.info(str(error))
        raise FCUException(40035)

def get_cloud_info(region_info):
    """
    :param records:
    :return:
    """
    try:

        cloud_infras = region_info["cloud_infras"]
        for cloud_infra in cloud_infras:
            if cloud_infra.get("type") in CloudType.FUSION_CLOUD_INFRA:
                cloud_infra_id = cloud_infra["id"]
                cloud_infra_name = cloud_infra["name"]
                logger.info("region_id is:%s, cloud_infra_id is:%s, "
                            "cloud_infra_name is:%s" % (
                                region_info["id"],
                                cloud_infra_id, cloud_infra_name))
                return region_info["id"], cloud_infra_id, cloud_infra_name
        # 没有以下这一行，当没有匹配到任何Region的时候，调用
        # region_id, cloud_infra_id, cloud_infra_name = get_cloud_info(region_record)
        # 会产生non-iterable NontType object的报错
        return None, None, None
    except Exception as error:
        logger.error("error_message is %s" % error)
        logger.trace()
        raise error

def create_vdc(self, vdc_name, project_name):
    """
    :param vdc_name:
    :param project_name:
    :return:
    """
    vdc_exist = self.search_vdc_by_name(vdc_name)
    if not vdc_exist:
        try:
            vdc_param = {"vdc": {"upper_vdc_id": "0", "name": vdc_name,
                                 "mfa_status": False, "enterprise_id": "",
                                 "status": False, "cloud_federation_rate": "-1",
                                 "other_cloud_federation_rate": "-1",
                                 "tag": "vdc",
                                 "default_project_name": "{}".format(project_name)}}
            vdc_param = json.dumps(vdc_param)
            logger.info(vdc_param)
            url = "https://{host}/moserviceaccesswebsite/goku/rest/vdc/v3.1/vdcs".format(
                host=self.manage_console_host)
            resp = requests.post(url, data=vdc_param, verify=False,
                                 headers=self.bak_global_headers)

            statu_code = resp.status_code
            response_body = json.loads(resp.content)
            logger.info(response_body)
        except Exception as error:
            raise error
        if statu_code == 201:
            vdc = response_body.get("vdc")
            return vdc["id"]
        else:
            raise Exception(response_body)
    else:
        return vdc_exist

def create_csdr_flavor(flavor_name, project_id):
    try:
        db_obj = ParamService()
        project_info = db_obj.get_project_info(project_id)
        region_id = project_info.get('region_id')
        region_type = project_info.get('region_type')
        obj = LoginServiceOm(project_id)
        logger.info("start to get az id")
        az_id = LoginSC(project_id, region_id, region_type).get_az_id()
        logger.info("get az id is [%s]" % az_id)
        if not obj.is_x86_az(az_id):
            raise FCUException(40073, az_id)

        # 判断主机组标签是否是通用型
        res = obj.get_hostgroups_tags(az_id)
        flavor_id = obj.query_flavor(flavor_name)
        if not flavor_id:
            flavor_id = obj.create_flavor(flavor_name,
                                          '2',
                                          '2048',
                                          az_id)
        logger.info('Preconfig create flavor1 successfully')

        flavor_ids = [flavor_id]
        for flavor_id in flavor_ids:
            tag_is_exist = obj.query_flavor_tag(flavor_id)
            if tag_is_exist:
                continue
            elif res:
                obj.edit_flavor_Label(flavor_id)
            else:
                raise FCUException(40025, az_id)
        return Message(200)
    except FCUException as error:
        return Message(500, error)
    except Exception as error:
        logger.error(error)
        return Message(500, FCUException(40066, error))
